/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

public class MassPerTimeUnit
{
  private MassPerTimeUnit(string v) { Value = v; }
  protected string Value { get; }

  public new string ToString() { return Value; }

  public static MassPerTimeUnit g_Per_s = new MassPerTimeUnit("g/s");
  public static MassPerTimeUnit g_Per_min = new MassPerTimeUnit("g/min");
  public static MassPerTimeUnit g_Per_day = new MassPerTimeUnit("g/day");
  public static MassPerTimeUnit mg_Per_s = new MassPerTimeUnit("mg/s");
  public static MassPerTimeUnit mg_Per_min = new MassPerTimeUnit("mg/min");
  public static MassPerTimeUnit ug_Per_s = new MassPerTimeUnit("ug/s");
  public static MassPerTimeUnit kg_Per_s = new MassPerTimeUnit("kg/s");
  public static MassPerTimeUnit ug_Per_min = new MassPerTimeUnit("ug/min");

}

public class SEScalarMassPerTime : SEScalar
{
  protected MassPerTimeUnit unit;

  public SEScalarMassPerTime() : base()
  {

  }

  public SEScalarMassPerTime(SEScalarMassPerTime from)
  {
    Set(from);
  }

  public SEScalarMassPerTime(double value, MassPerTimeUnit unit)
  {
    SetValue(value, unit);
  }

  public void Set(SEScalarMassPerTime from)
  {
    if (from == null)
    {
      Invalidate();
      return;
    }
    SetValue(from.value, from.unit);
  }

  public new void SetValue(double value)
  {
    throw new System.NotSupportedException("You must provide a unit");
  }

  public void SetValue(double value, MassPerTimeUnit unit)
  {
    this.value = value;
    this.unit = unit;
  }

  public double GetValue(MassPerTimeUnit unit)
  {
    throw new System.NotImplementedException();
  }

  public MassPerTimeUnit GetUnit()
  {
    return unit;
  }
}
