# Nothing here yet

INCLUDE (${CMAKE_ROOT}/Modules/CheckSizeOf.cmake)
CHECK_TYPE_SIZE(int      CMAKE_SIZEOF_INT)
CHECK_TYPE_SIZE(long     CMAKE_SIZEOF_LONG)
CHECK_TYPE_SIZE("void*"  CMAKE_SIZEOF_VOID_P)
CHECK_TYPE_SIZE(char     CMAKE_SIZEOF_CHAR)
CHECK_TYPE_SIZE(short    CMAKE_SIZEOF_SHORT)
CHECK_TYPE_SIZE(float    CMAKE_SIZEOF_FLOAT)
CHECK_TYPE_SIZE(double   CMAKE_SIZEOF_DOUBLE)

INCLUDE (${CMAKE_ROOT}/Modules/CheckFunctionExists.cmake)
CHECK_FUNCTION_EXISTS(connect       CMAKE_HAVE_CONNECT)
CHECK_FUNCTION_EXISTS(remove        CMAKE_HAVE_REMOVE)

INCLUDE (${CMAKE_ROOT}/Modules/CheckLibraryExists.cmake)
CHECK_LIBRARY_EXISTS("ipc" "shmat" "" CMAKE_HAVE_GETHOSTBYNAME)

INCLUDE (${CMAKE_ROOT}/Modules/CheckIncludeFile.cmake)
CHECK_INCLUDE_FILE("limits.h"       CMAKE_HAVE_LIMITS_H)
CHECK_INCLUDE_FILE("unistd.h"       CMAKE_HAVE_UNISTD_H)
CHECK_INCLUDE_FILE("sys/prctl.h"    CMAKE_HAVE_SYS_PRCTL_H)
CHECK_INCLUDE_FILE("pthread.h"      CMAKE_HAVE_PTHREAD_H)

INCLUDE (${CMAKE_ROOT}/Modules/TestBigEndian.cmake)
TEST_BIG_ENDIAN(CMAKE_WORDS_BIGENDIAN)
INCLUDE (${CMAKE_ROOT}/Modules/FindX11.cmake)
INCLUDE (${CMAKE_ROOT}/Modules/FindThreads.cmake)

SET (CMAKE_THREAD_LIBS        "${CMAKE_THREAD_LIBS_INIT}" CACHE STRING 
    "Thread library used.")

SET (CMAKE_USE_PTHREADS       "${CMAKE_USE_PTHREADS_INIT}" CACHE BOOL
     "Use the pthreads library.")

SET (CMAKE_USE_WIN32_THREADS  "${CMAKE_USE_WIN32_THREADS_INIT}" CACHE BOOL
       "Use the win32 thread library.")

SET (CMAKE_HP_PTHREADS        ${CMAKE_HP_PTHREADS_INIT} CACHE BOOL
     "Use HP pthreads.")

SET (CMAKE_USE_SPROC          ${CMAKE_USE_SPROC_INIT} CACHE BOOL 
     "Use sproc libs.")

MARK_AS_ADVANCED(
CMAKE_THREAD_LIBS
CMAKE_USE_PTHREADS
CMAKE_USE_WIN32_THREADS
CMAKE_USE_SPROC
CMAKE_HP_PTHREADS)

