include(Compiler/ROCMClang)
__compiler_rocmclang(HIP)

set(_CMAKE_COMPILE_AS_HIP_FLAG "-x hip")
set(_CMAKE_HIP_RDC_FLAG "-fgpu-rdc")
set(_CMAKE_HIP_HSA_FLAG "--cuda-device-only")

if(NOT "x${CMAKE_${lang}_SIMULATE_ID}" STREQUAL "xMSVC")
  set(CMAKE_HIP_COMPILE_OPTIONS_VISIBILITY_INLINES_HIDDEN "-fvisibility-inlines-hidden")

  string(APPEND CMAKE_HIP_FLAGS_DEBUG_INIT " -O")
endif()


if(NOT CMAKE_HIP_COMPILER_VERSION VERSION_LESS 1.0)
  set(CMAKE_HIP98_STANDARD_COMPILE_OPTION "-std=c++98")
  set(CMAKE_HIP98_EXTENSION_COMPILE_OPTION "-std=gnu++98")
  set(CMAKE_HIP98_STANDARD__HAS_FULL_SUPPORT ON)

  set(CMAKE_HIP11_STANDARD_COMPILE_OPTION "-std=c++11")
  set(CMAKE_HIP11_EXTENSION_COMPILE_OPTION "-std=gnu++11")
  set(CMAKE_HIP11_STANDARD__HAS_FULL_SUPPORT ON)

  set(CMAKE_HIP14_STANDARD_COMPILE_OPTION "-std=c++14")
  set(CMAKE_HIP14_EXTENSION_COMPILE_OPTION "-std=gnu++14")
  set(CMAKE_HIP14_STANDARD__HAS_FULL_SUPPORT ON)

  set(CMAKE_HIP17_STANDARD_COMPILE_OPTION "-std=c++17")
  set(CMAKE_HIP17_EXTENSION_COMPILE_OPTION "-std=gnu++17")
  set(CMAKE_HIP17_STANDARD__HAS_FULL_SUPPORT ON)

  set(CMAKE_HIP20_STANDARD_COMPILE_OPTION "-std=c++20")
  set(CMAKE_HIP20_EXTENSION_COMPILE_OPTION "-std=gnu++20")

endif()

set(CMAKE_HIP_RUNTIME_LIBRARY_DEFAULT "SHARED")
set(CMAKE_HIP_RUNTIME_LIBRARY_LINK_OPTIONS_STATIC  "")
set(CMAKE_HIP_RUNTIME_LIBRARY_LINK_OPTIONS_SHARED  "")

# Populated by CMakeHIPRuntime.cmake
set(CMAKE_HIP_RUNTIME_LIBRARIES_STATIC "")
set(CMAKE_HIP_RUNTIME_LIBRARIES_SHARED "")

__compiler_check_default_language_standard(HIP 3.5 11)
