#this will only modify the cppflags for netcdf as the next project in the tree
#moab will unset the cppflags back to the original values
if (build-projects)
  set (pre_netcdf_cpp_flags ${cppflags})
  set (pre_netcdf_c_flags ${cflags})

  set (cppflags "-I${install_location}/include ${cppflags}")
  set (cflags "-I${install_location}/include ${cflags}")
endif()

set(netcdf_libdir)
if (UNIX AND NOT APPLE)
  set(netcdf_libdir
    -DCMAKE_INSTALL_LIBDIR:BOOL=lib)
endif ()

add_external_project(netcdf
  DEPENDS hdf5

  CMAKE_ARGS
    -DBUILD_SHARED_LIBS:BOOL=ON
    -DBUILD_TESTING:BOOL=OFF
    -DBUILD_UTILITIES:BOOL=OFF
    -DUSE_SZIP:BOOL=ON
    -DENABLE_DAP:BOOL=OFF
    ${netcdf_libdir}
)

if(APPLE)
#special mac only script to fixup boost plugin install-names so that developers
#can use the superbuild properly from other projects
add_external_project_step(install_name_fixup
  COMMENT "Fixing netcdf library install_names."
  COMMAND  ${CMAKE_COMMAND}
    -Dinstall_location:PATH=${install_location}
    -Dlib_name:STRING="netcdf"
    -P ${CMAKE_CURRENT_LIST_DIR}/apple/fixup_library_rpath.cmake
  DEPENDEES install)
endif()

#-------------------------------------------------------
# We've changed the API from upstream in VTK commits 6223f230 and
# 64cb89e3 to use size_t* instead of long* for (some) overloads of
# methods like NcVar::get. This patch adds a define to signal users
# that they should use size_t for these methods.
add_external_project_step(patch_netcdf_cxxheader
  COMMAND ${CMAKE_COMMAND} -E copy_if_different
          "${SuperBuild_PROJECTS_DIR}/patches/netcdf.cxx.netcdfcpp.h"
          "<SOURCE_DIR>/cxx/netcdfcpp.h"
  DEPENDEES update # do after update
  DEPENDERS patch  # do before patch
)
