
include(GNUInstallDirs)

if (UNIX) #Apple should never happen
  set (SHARED_LIBRARY_SUFFIX "so")
  set (PYTHON_SITE "lib/python2.7/site-packages")
  set (PYTHON_INSTALL "lib/paraview-${pv_version}/site-packages")
  set (LIB_SHIBOKEN_PY "lib/libshiboken-python2.7.so.1.2")
  if( NOT EXISTS ${SMTK_BIN_DIR}/${LIB_SHIBOKEN_PY} )
     set (LIB_SHIBOKEN_PY "lib/libshiboken-python2.7-dbg.so.1.2")
     if( NOT EXISTS ${SMTK_BIN_DIR}/${LIB_SHIBOKEN_PY} )
        message( SEND_ERROR "could not create smtk python package.  libshiboken is missing" )
        return()
     endif()
  endif()
elseif (WIN32)
  set (SHARED_LIBRARY_SUFFIX "pyd")
  set (PYTHON_SITE "bin/Lib/site-packages")
  set (PYTHON_INSTALL ${PYTHON_SITE})
  set (LIB_SHIBOKEN_PY "bin/shiboken-python2.7.dll")
endif()

file(REMOVE_RECURSE "${TMP_DIR}/SMTKPlugin")
file(MAKE_DIRECTORY "${TMP_DIR}/SMTKPlugin")

set(plugin_install_dir ${SMTK_BIN_DIR}/${PYTHON_INSTALL}/smtk)
file(MAKE_DIRECTORY "${plugin_install_dir}")

if (UNIX)
  set(PYTHON_COPY_SOURCE_LOC lib/python2.7/site-packages)
elseif (WIN32)
  set(PYTHON_COPY_SOURCE_LOC bin/Lib/site-packages)
endif()

set(py_files_libs ${SMTK_BIN_DIR}/${PYTHON_SITE}/smtk/smtkCorePython.${SHARED_LIBRARY_SUFFIX}
                  ${SMTK_BIN_DIR}/${LIB_SHIBOKEN_PY}
                  ${SMTK_BIN_DIR}/${PYTHON_SITE}/shiboken.${SHARED_LIBRARY_SUFFIX}
                  ${SMTK_BIN_DIR}/${PYTHON_COPY_SOURCE_LOC}/smtk/simple.py)
foreach(lib IN LISTS py_files_libs)
  configure_file("${lib}" "${TMP_DIR}/SMTKPlugin" COPYONLY)
endforeach()

#okay the plugin is fixed up, now we need to install it into paraviews bundle
file(GLOB fixedUpLibs "${TMP_DIR}/SMTKPlugin/*")
foreach(lib IN LISTS fixedUpLibs)
  configure_file("${lib}" "${plugin_install_dir}" COPYONLY)
endforeach()

# For linux, also copy smtk libs where standalone export app can find them
if (UNIX)
  set(STANDALONE_EXPORT_DIR ${SMTK_BIN_DIR}/${PYTHON_SITE}/smtk)
  file(MAKE_DIRECTORY "${STANDALONE_EXPORT_DIR}")
  foreach(lib IN LISTS fixedUpLibs)
    configure_file("${lib}" "${STANDALONE_EXPORT_DIR}" COPYONLY)
  endforeach()
endif()
