# Consolidates platform independent stub for cmb.bundle.cmake files.

include(cmb_version)
include(paraview_version)

set(CPACK_PACKAGE_VENDOR "Kitware, Inc.")
set(CPACK_RESOURCE_FILE_LICENSE
    "${CMBSuperBuild_SOURCE_DIR}/License.txt")
set(CPACK_PACKAGE_VERSION_MAJOR ${cmb_version_major})
set(CPACK_PACKAGE_VERSION_MINOR ${cmb_version_minor})
if (cmb_version_suffix)
  set(CPACK_PACKAGE_VERSION_PATCH ${cmb_version_patch}-${cmb_version_suffix})
else()
  set(CPACK_PACKAGE_VERSION_PATCH ${cmb_version_patch})
endif()

SET(CPACK_PACKAGE_INSTALL_DIRECTORY
  "${cmb_package_name} ${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}")
set(CPACK_SOURCE_PACKAGE_FILE_NAME
  "${cmb_package_name}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}")

if(NOT DEFINED CPACK_SYSTEM_NAME)
  set(CPACK_SYSTEM_NAME ${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_PROCESSOR})
endif()
if(${CPACK_SYSTEM_NAME} MATCHES Windows)
  if(CMAKE_CL_64)
    set(CPACK_SYSTEM_NAME win64)
  else(CMAKE_CL_64)
    set(CPACK_SYSTEM_NAME win32)
  endif()
endif()
if(NOT DEFINED CPACK_PACKAGE_FILE_NAME)
  set(CPACK_PACKAGE_FILE_NAME
    "${CPACK_SOURCE_PACKAGE_FILE_NAME}-${CPACK_SYSTEM_NAME}")
endif()
