//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef pqPipelinePreviewer_h
#define pqPipelinePreviewer_h

#include <QWidget>

class pqPipelineBrowserWidget;
class pqPropertiesPanel;
class pqRenderView;

/// pqPipelinePreviewer is the widget for the pipeline  browser.
class pqPipelinePreviewer : public QWidget
{
  Q_OBJECT
  typedef QWidget Superclass;
public:
  pqPipelinePreviewer(QWidget* parent=0);
  virtual ~pqPipelinePreviewer();

  void preview(pqRenderView* view,
               const QString &fileName,
               const QString &modeFileDir = QString());

protected:
  pqPipelineBrowserWidget* m_pipelineBrowser;
  pqPropertiesPanel* m_propertiesPanel;

private:
  Q_DISABLE_COPY(pqPipelinePreviewer)
};

#endif


