//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#include "pqPipelinePreviewer.h"

#include "pqActiveObjects.h"
#include "pqApplicationCore.h"
#include "pqFileDialog.h"
#include "pqObjectBuilder.h"
#include "pqPipelineBrowserWidget.h"
#include "pqPropertiesPanel.h"
#include "pqOutputPort.h"
#include "pqPipelineSource.h"
#include "pqServer.h"
#include "pqServerManagerModel.h"
#include "vtkNew.h"
#include "vtkSMPropertyHelper.h"
#include "vtkSMPVRepresentationProxy.h"
#include "vtkSMViewProxy.h"

#include "pqRenderView.h"

#include <QDir>
#include <QVBoxLayout>

#include <assert.h>

//-----------------------------------------------------------------------------
pqPipelinePreviewer::pqPipelinePreviewer(QWidget* parentObject)
  : Superclass(parentObject)
{
  this->m_pipelineBrowser = new pqPipelineBrowserWidget(this);
  this->m_propertiesPanel = new pqPropertiesPanel(this);
  new QVBoxLayout(this);
  this->layout()->addWidget(this->m_pipelineBrowser);
  this->layout()->addWidget(this->m_propertiesPanel);
}

//-----------------------------------------------------------------------------
pqPipelinePreviewer::~pqPipelinePreviewer()
{
  delete this->m_pipelineBrowser;
  delete this->m_propertiesPanel;
}

//-----------------------------------------------------------------------------
void pqPipelinePreviewer::preview(pqRenderView* view,
 const QString &fileName, const QString &modeFileDir )
{
  this->m_pipelineBrowser->setActiveView(view);

  if(fileName.isEmpty())
    return;
  pqApplicationCore* core = pqApplicationCore::instance();
  pqObjectBuilder* builder = core->getObjectBuilder();

  pqPipelineSource* reader = builder->createSource("sources",
    "SLACReader", pqApplicationCore::instance()->getActiveServer());
  vtkSMPropertyHelper(reader->getProxy(), "MeshFileName").Set(
    fileName.toAscii().constData() );

  QStringList modFilter("*.mod");
  QStringList modFiles = QDir(modeFileDir).entryList(modFilter);
  if(modFiles.count() > 0)
    vtkSMPropertyHelper(reader->getProxy(), "ModeFileName").Set(
      modFiles[0].toAscii().constData() );
  reader->getProxy()->UpdateVTKObjects();
  // force read
//  vtkSMSourceProxy::SafeDownCast( reader->getProxy() )->UpdatePipeline();
//  reader->getProxy()->UpdatePropertyInformation();

  builder->createDataRepresentation(
            reader->getOutputPort(0), view);

  for(int i=0; i<reader->getNumberOfOutputPorts(); ++i)
    {
    pqPipelineSource* contour = builder->createFilter("filters",
      "Contour", reader, i);
    vtkSMSourceProxy::SafeDownCast( contour->getProxy() )->UpdatePipeline();
    contour->getProxy()->UpdatePropertyInformation();

    pqPipelineSource* slice = builder->createFilter("filters",
      "Cut", reader, i);
    vtkSMSourceProxy::SafeDownCast( slice->getProxy() )->UpdatePipeline();
    slice->getProxy()->UpdatePropertyInformation();
    if(i == 0)
      {
      pqPipelineSource* glyph = builder->createFilter("filters",
        "Glyph", reader, i);
      vtkSMSourceProxy::SafeDownCast( glyph->getProxy() )->UpdatePipeline();
      glyph->getProxy()->UpdatePropertyInformation();
      }
    }

  pqActiveObjects::instance().setActiveSource(reader);
}
