//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME vtkModelGeneratedGridRepresentation - Abstract class for a generated
//  CMBModel representation of an analysis grid.
// .SECTION Description
// An abstract class used to provide all of the information that a CMBModel needs
// to keep track of mapping grid objects from the geometry grid to the
// analysis grid. In this case the analysis grid isn't read in from a file
// but instead is generated by some code.

#ifndef __vtkModelGeneratedGridRepresentation_h
#define __vtkModelGeneratedGridRepresentation_h

#include "vtkDiscreteModelModule.h" // For export macro
#include "vtkModelGridRepresentation.h"
#include "cmbSystemConfig.h"
#include <vector>

class VTKDISCRETEMODEL_EXPORT vtkModelGeneratedGridRepresentation : public vtkModelGridRepresentation
{
public:
  vtkTypeMacro(vtkModelGeneratedGridRepresentation,vtkModelGridRepresentation);
  void PrintSelf(ostream& os, vtkIndent indent);

  virtual void WriteMeshToFile()=0;

  // Description:
  // Get cellIds or area given a group id of model entities.
  // Meant for 2D models with triangle meshes.
  virtual bool GetGroupFacetIds(vtkDiscreteModel* vtkNotUsed(model),int vtkNotUsed(groupId),
                                std::vector<int>& vtkNotUsed(cellIds)){return false;}
  virtual bool GetGroupFacetsArea(vtkDiscreteModel* vtkNotUsed(model),int vtkNotUsed(groupId),
                                  double& vtkNotUsed(area))
  {return false;}

  // Description:
  // Get cell and point information from the analysis grid.
  virtual bool GetCellPointIds(int vtkNotUsed(cellId), std::vector<int>& vtkNotUsed(pointIds))
  {return false;}
  virtual bool GetPointLocation(int vtkNotUsed(pointId), std::vector<double>& vtkNotUsed(coords))
  {return false;}

protected:
  vtkModelGeneratedGridRepresentation();
  virtual ~vtkModelGeneratedGridRepresentation();

private:
  vtkModelGeneratedGridRepresentation(const vtkModelGeneratedGridRepresentation&);  // Not implemented.
  void operator=(const vtkModelGeneratedGridRepresentation&);  // Not implemented.
};
#endif
