/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtScalarMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyavtScalarMetaData
//
// Purpose: 
//   Contains scalar metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtScalarMetaData.
//
struct avtScalarMetaDataObject
{
    PyObject_HEAD
    avtScalarMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtScalarMetaData(int);

std::string
PyavtScalarMetaData_ToString(const avtScalarMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtVarMetaData_ToString(atts, prefix);

    if(atts->treatAsASCII)
        SNPRINTF(tmpStr, 1000, "%streatAsASCII = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%streatAsASCII = 0\n", prefix);
    str += tmpStr;
    const char *enumerationType_names = "None, ByValue, ByRange, ByBitMask, ByNChooseR";
    switch (atts->GetEnumerationType())
    {
      case avtScalarMetaData::None:
          SNPRINTF(tmpStr, 1000, "%senumerationType = %sNone  # %s\n", prefix, prefix, enumerationType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::ByValue:
          SNPRINTF(tmpStr, 1000, "%senumerationType = %sByValue  # %s\n", prefix, prefix, enumerationType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::ByRange:
          SNPRINTF(tmpStr, 1000, "%senumerationType = %sByRange  # %s\n", prefix, prefix, enumerationType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::ByBitMask:
          SNPRINTF(tmpStr, 1000, "%senumerationType = %sByBitMask  # %s\n", prefix, prefix, enumerationType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::ByNChooseR:
          SNPRINTF(tmpStr, 1000, "%senumerationType = %sByNChooseR  # %s\n", prefix, prefix, enumerationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const stringVector &enumNames = atts->enumNames;
        SNPRINTF(tmpStr, 1000, "%senumNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < enumNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", enumNames[i].c_str());
            str += tmpStr;
            if(i < enumNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &enumRanges = atts->enumRanges;
        SNPRINTF(tmpStr, 1000, "%senumRanges = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < enumRanges.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", enumRanges[i]);
            str += tmpStr;
            if(i < enumRanges.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *enumAlwaysExclude = atts->enumAlwaysExclude;
        SNPRINTF(tmpStr, 1000, "%senumAlwaysExclude = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", enumAlwaysExclude[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *enumAlwaysInclude = atts->enumAlwaysInclude;
        SNPRINTF(tmpStr, 1000, "%senumAlwaysInclude = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", enumAlwaysInclude[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *enumPartialCellMode_names = "Include, Exclude, Dissect";
    switch (atts->GetEnumPartialCellMode())
    {
      case avtScalarMetaData::Include:
          SNPRINTF(tmpStr, 1000, "%senumPartialCellMode = %sInclude  # %s\n", prefix, prefix, enumPartialCellMode_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::Exclude:
          SNPRINTF(tmpStr, 1000, "%senumPartialCellMode = %sExclude  # %s\n", prefix, prefix, enumPartialCellMode_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::Dissect:
          SNPRINTF(tmpStr, 1000, "%senumPartialCellMode = %sDissect  # %s\n", prefix, prefix, enumPartialCellMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const intVector &enumGraphEdges = atts->enumGraphEdges;
        SNPRINTF(tmpStr, 1000, "%senumGraphEdges = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < enumGraphEdges.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", enumGraphEdges[i]);
            str += tmpStr;
            if(i < enumGraphEdges.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &enumGraphEdgeNames = atts->enumGraphEdgeNames;
        SNPRINTF(tmpStr, 1000, "%senumGraphEdgeNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < enumGraphEdgeNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", enumGraphEdgeNames[i].c_str());
            str += tmpStr;
            if(i < enumGraphEdgeNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &enumGraphEdgeNameIndexs = atts->enumGraphEdgeNameIndexs;
        SNPRINTF(tmpStr, 1000, "%senumGraphEdgeNameIndexs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < enumGraphEdgeNameIndexs.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", enumGraphEdgeNameIndexs[i]);
            str += tmpStr;
            if(i < enumGraphEdgeNameIndexs.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%senumNChooseRN = %d\n", prefix, atts->GetEnumNChooseRN());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%senumNChooseRMaxR = %d\n", prefix, atts->GetEnumNChooseRMaxR());
    str += tmpStr;
    const char *missingDataType_names = "MissingData_None, MissingData_Value, MissingData_Valid_Min, MissingData_Valid_Max, MissingData_Valid_Range";
    switch (atts->GetMissingDataType())
    {
      case avtScalarMetaData::MissingData_None:
          SNPRINTF(tmpStr, 1000, "%smissingDataType = %sMissingData_None  # %s\n", prefix, prefix, missingDataType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::MissingData_Value:
          SNPRINTF(tmpStr, 1000, "%smissingDataType = %sMissingData_Value  # %s\n", prefix, prefix, missingDataType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::MissingData_Valid_Min:
          SNPRINTF(tmpStr, 1000, "%smissingDataType = %sMissingData_Valid_Min  # %s\n", prefix, prefix, missingDataType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::MissingData_Valid_Max:
          SNPRINTF(tmpStr, 1000, "%smissingDataType = %sMissingData_Valid_Max  # %s\n", prefix, prefix, missingDataType_names);
          str += tmpStr;
          break;
      case avtScalarMetaData::MissingData_Valid_Range:
          SNPRINTF(tmpStr, 1000, "%smissingDataType = %sMissingData_Valid_Range  # %s\n", prefix, prefix, missingDataType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *missingData = atts->GetMissingData();
        SNPRINTF(tmpStr, 1000, "%smissingData = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", missingData[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
avtScalarMetaData_Notify(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_SetTreatAsASCII(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the treatAsASCII in the object.
    obj->data->treatAsASCII = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetTreatAsASCII(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->treatAsASCII?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumerationType(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enumerationType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetEnumerationType(avtScalarMetaData::EnumTypes(ival));
    else
    {
        fprintf(stderr, "An invalid enumerationType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "None, ByValue, ByRange, ByBitMask, ByNChooseR"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumerationType(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEnumerationType()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumNames(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    stringVector  &vec = obj->data->enumNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the enumNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumNames(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumNames.
    const stringVector &enumNames = obj->data->enumNames;
    PyObject *retval = PyTuple_New(enumNames.size());
    for(size_t i = 0; i < enumNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(enumNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumRanges(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    doubleVector  &vec = obj->data->enumRanges;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the enumRanges in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumRanges(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumRanges.
    const doubleVector &enumRanges = obj->data->enumRanges;
    PyObject *retval = PyTuple_New(enumRanges.size());
    for(size_t i = 0; i < enumRanges.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(enumRanges[i]));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumAlwaysExclude(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    double *dvals = obj->data->enumAlwaysExclude;
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the enumAlwaysExclude in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumAlwaysExclude(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumAlwaysExclude.
    PyObject *retval = PyTuple_New(2);
    const double *enumAlwaysExclude = obj->data->enumAlwaysExclude;
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(enumAlwaysExclude[i]));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumAlwaysInclude(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    double *dvals = obj->data->enumAlwaysInclude;
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the enumAlwaysInclude in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumAlwaysInclude(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumAlwaysInclude.
    PyObject *retval = PyTuple_New(2);
    const double *enumAlwaysInclude = obj->data->enumAlwaysInclude;
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(enumAlwaysInclude[i]));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumPartialCellMode(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enumPartialCellMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetEnumPartialCellMode(avtScalarMetaData::PartialCellModes(ival));
    else
    {
        fprintf(stderr, "An invalid enumPartialCellMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Include, Exclude, Dissect.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumPartialCellMode(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEnumPartialCellMode()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumGraphEdges(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    intVector  &vec = obj->data->enumGraphEdges;
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the enumGraphEdges in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumGraphEdges(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumGraphEdges.
    const intVector &enumGraphEdges = obj->data->enumGraphEdges;
    PyObject *retval = PyTuple_New(enumGraphEdges.size());
    for(size_t i = 0; i < enumGraphEdges.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(enumGraphEdges[i])));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumGraphEdgeNames(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    stringVector  &vec = obj->data->enumGraphEdgeNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the enumGraphEdgeNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumGraphEdgeNames(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumGraphEdgeNames.
    const stringVector &enumGraphEdgeNames = obj->data->enumGraphEdgeNames;
    PyObject *retval = PyTuple_New(enumGraphEdgeNames.size());
    for(size_t i = 0; i < enumGraphEdgeNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(enumGraphEdgeNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumGraphEdgeNameIndexs(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    intVector  &vec = obj->data->enumGraphEdgeNameIndexs;
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the enumGraphEdgeNameIndexs in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumGraphEdgeNameIndexs(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the enumGraphEdgeNameIndexs.
    const intVector &enumGraphEdgeNameIndexs = obj->data->enumGraphEdgeNameIndexs;
    PyObject *retval = PyTuple_New(enumGraphEdgeNameIndexs.size());
    for(size_t i = 0; i < enumGraphEdgeNameIndexs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(enumGraphEdgeNameIndexs[i])));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumNChooseRN(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enumNChooseRN in the object.
    obj->data->SetEnumNChooseRN((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumNChooseRN(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEnumNChooseRN()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetEnumNChooseRMaxR(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enumNChooseRMaxR in the object.
    obj->data->SetEnumNChooseRMaxR((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetEnumNChooseRMaxR(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEnumNChooseRMaxR()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetMissingDataType(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the missingDataType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetMissingDataType(avtScalarMetaData::MissingData(ival));
    else
    {
        fprintf(stderr, "An invalid missingDataType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "MissingData_None, MissingData_Value, MissingData_Valid_Min, MissingData_Valid_Max, MissingData_Valid_Range"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetMissingDataType(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMissingDataType()));
    return retval;
}

/*static*/ PyObject *
avtScalarMetaData_SetMissingData(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;

    double *dvals = obj->data->GetMissingData();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the missingData in the object as modified.
    obj->data->SelectMissingData();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtScalarMetaData_GetMissingData(PyObject *self, PyObject *args)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the missingData.
    PyObject *retval = PyTuple_New(2);
    const double *missingData = obj->data->GetMissingData();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(missingData[i]));
    return retval;
}



PyMethodDef PyavtScalarMetaData_methods[AVTSCALARMETADATA_NMETH] = {
    {"Notify", avtScalarMetaData_Notify, METH_VARARGS},
    {"SetTreatAsASCII", avtScalarMetaData_SetTreatAsASCII, METH_VARARGS},
    {"GetTreatAsASCII", avtScalarMetaData_GetTreatAsASCII, METH_VARARGS},
    {"SetEnumerationType", avtScalarMetaData_SetEnumerationType, METH_VARARGS},
    {"GetEnumerationType", avtScalarMetaData_GetEnumerationType, METH_VARARGS},
    {"SetEnumNames", avtScalarMetaData_SetEnumNames, METH_VARARGS},
    {"GetEnumNames", avtScalarMetaData_GetEnumNames, METH_VARARGS},
    {"SetEnumRanges", avtScalarMetaData_SetEnumRanges, METH_VARARGS},
    {"GetEnumRanges", avtScalarMetaData_GetEnumRanges, METH_VARARGS},
    {"SetEnumAlwaysExclude", avtScalarMetaData_SetEnumAlwaysExclude, METH_VARARGS},
    {"GetEnumAlwaysExclude", avtScalarMetaData_GetEnumAlwaysExclude, METH_VARARGS},
    {"SetEnumAlwaysInclude", avtScalarMetaData_SetEnumAlwaysInclude, METH_VARARGS},
    {"GetEnumAlwaysInclude", avtScalarMetaData_GetEnumAlwaysInclude, METH_VARARGS},
    {"SetEnumPartialCellMode", avtScalarMetaData_SetEnumPartialCellMode, METH_VARARGS},
    {"GetEnumPartialCellMode", avtScalarMetaData_GetEnumPartialCellMode, METH_VARARGS},
    {"SetEnumGraphEdges", avtScalarMetaData_SetEnumGraphEdges, METH_VARARGS},
    {"GetEnumGraphEdges", avtScalarMetaData_GetEnumGraphEdges, METH_VARARGS},
    {"SetEnumGraphEdgeNames", avtScalarMetaData_SetEnumGraphEdgeNames, METH_VARARGS},
    {"GetEnumGraphEdgeNames", avtScalarMetaData_GetEnumGraphEdgeNames, METH_VARARGS},
    {"SetEnumGraphEdgeNameIndexs", avtScalarMetaData_SetEnumGraphEdgeNameIndexs, METH_VARARGS},
    {"GetEnumGraphEdgeNameIndexs", avtScalarMetaData_GetEnumGraphEdgeNameIndexs, METH_VARARGS},
    {"SetEnumNChooseRN", avtScalarMetaData_SetEnumNChooseRN, METH_VARARGS},
    {"GetEnumNChooseRN", avtScalarMetaData_GetEnumNChooseRN, METH_VARARGS},
    {"SetEnumNChooseRMaxR", avtScalarMetaData_SetEnumNChooseRMaxR, METH_VARARGS},
    {"GetEnumNChooseRMaxR", avtScalarMetaData_GetEnumNChooseRMaxR, METH_VARARGS},
    {"SetMissingDataType", avtScalarMetaData_SetMissingDataType, METH_VARARGS},
    {"GetMissingDataType", avtScalarMetaData_GetMissingDataType, METH_VARARGS},
    {"SetMissingData", avtScalarMetaData_SetMissingData, METH_VARARGS},
    {"GetMissingData", avtScalarMetaData_GetMissingData, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtScalarMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtScalarMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtScalarMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtScalarMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtScalarMetaData_dealloc(PyObject *v)
{
   avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtScalarMetaData_compare(PyObject *v, PyObject *w)
{
    avtScalarMetaData *a = ((avtScalarMetaDataObject *)v)->data;
    avtScalarMetaData *b = ((avtScalarMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtScalarMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "treatAsASCII") == 0)
        return avtScalarMetaData_GetTreatAsASCII(self, NULL);
    if(strcmp(name, "enumerationType") == 0)
        return avtScalarMetaData_GetEnumerationType(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::None));
    if(strcmp(name, "ByValue") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::ByValue));
    if(strcmp(name, "ByRange") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::ByRange));
    if(strcmp(name, "ByBitMask") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::ByBitMask));
    if(strcmp(name, "ByNChooseR") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::ByNChooseR));

    if(strcmp(name, "enumNames") == 0)
        return avtScalarMetaData_GetEnumNames(self, NULL);
    if(strcmp(name, "enumRanges") == 0)
        return avtScalarMetaData_GetEnumRanges(self, NULL);
    if(strcmp(name, "enumAlwaysExclude") == 0)
        return avtScalarMetaData_GetEnumAlwaysExclude(self, NULL);
    if(strcmp(name, "enumAlwaysInclude") == 0)
        return avtScalarMetaData_GetEnumAlwaysInclude(self, NULL);
    if(strcmp(name, "enumPartialCellMode") == 0)
        return avtScalarMetaData_GetEnumPartialCellMode(self, NULL);
    if(strcmp(name, "Include") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::Include));
    if(strcmp(name, "Exclude") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::Exclude));
    if(strcmp(name, "Dissect") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::Dissect));

    if(strcmp(name, "enumGraphEdges") == 0)
        return avtScalarMetaData_GetEnumGraphEdges(self, NULL);
    if(strcmp(name, "enumGraphEdgeNames") == 0)
        return avtScalarMetaData_GetEnumGraphEdgeNames(self, NULL);
    if(strcmp(name, "enumGraphEdgeNameIndexs") == 0)
        return avtScalarMetaData_GetEnumGraphEdgeNameIndexs(self, NULL);
    if(strcmp(name, "enumNChooseRN") == 0)
        return avtScalarMetaData_GetEnumNChooseRN(self, NULL);
    if(strcmp(name, "enumNChooseRMaxR") == 0)
        return avtScalarMetaData_GetEnumNChooseRMaxR(self, NULL);
    if(strcmp(name, "missingDataType") == 0)
        return avtScalarMetaData_GetMissingDataType(self, NULL);
    if(strcmp(name, "MissingData_None") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::MissingData_None));
    if(strcmp(name, "MissingData_Value") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::MissingData_Value));
    if(strcmp(name, "MissingData_Valid_Min") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::MissingData_Valid_Min));
    if(strcmp(name, "MissingData_Valid_Max") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::MissingData_Valid_Max));
    if(strcmp(name, "MissingData_Valid_Range") == 0)
        return PyInt_FromLong(long(avtScalarMetaData::MissingData_Valid_Range));

    if(strcmp(name, "missingData") == 0)
        return avtScalarMetaData_GetMissingData(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtScalarMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtScalarMetaData_methods, self, name);
}

int
PyavtScalarMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "treatAsASCII") == 0)
        obj = avtScalarMetaData_SetTreatAsASCII(self, tuple);
    else if(strcmp(name, "enumerationType") == 0)
        obj = avtScalarMetaData_SetEnumerationType(self, tuple);
    else if(strcmp(name, "enumNames") == 0)
        obj = avtScalarMetaData_SetEnumNames(self, tuple);
    else if(strcmp(name, "enumRanges") == 0)
        obj = avtScalarMetaData_SetEnumRanges(self, tuple);
    else if(strcmp(name, "enumAlwaysExclude") == 0)
        obj = avtScalarMetaData_SetEnumAlwaysExclude(self, tuple);
    else if(strcmp(name, "enumAlwaysInclude") == 0)
        obj = avtScalarMetaData_SetEnumAlwaysInclude(self, tuple);
    else if(strcmp(name, "enumPartialCellMode") == 0)
        obj = avtScalarMetaData_SetEnumPartialCellMode(self, tuple);
    else if(strcmp(name, "enumGraphEdges") == 0)
        obj = avtScalarMetaData_SetEnumGraphEdges(self, tuple);
    else if(strcmp(name, "enumGraphEdgeNames") == 0)
        obj = avtScalarMetaData_SetEnumGraphEdgeNames(self, tuple);
    else if(strcmp(name, "enumGraphEdgeNameIndexs") == 0)
        obj = avtScalarMetaData_SetEnumGraphEdgeNameIndexs(self, tuple);
    else if(strcmp(name, "enumNChooseRN") == 0)
        obj = avtScalarMetaData_SetEnumNChooseRN(self, tuple);
    else if(strcmp(name, "enumNChooseRMaxR") == 0)
        obj = avtScalarMetaData_SetEnumNChooseRMaxR(self, tuple);
    else if(strcmp(name, "missingDataType") == 0)
        obj = avtScalarMetaData_SetMissingDataType(self, tuple);
    else if(strcmp(name, "missingData") == 0)
        obj = avtScalarMetaData_SetMissingData(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtScalarMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)v;
    fprintf(fp, "%s", PyavtScalarMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtScalarMetaData_str(PyObject *v)
{
    avtScalarMetaDataObject *obj = (avtScalarMetaDataObject *)v;
    return PyString_FromString(PyavtScalarMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtScalarMetaData_Purpose = "Contains scalar metadata attributes";
#else
static char *avtScalarMetaData_Purpose = "Contains scalar metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtScalarMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtScalarMetaData",                    // tp_name
    sizeof(avtScalarMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtScalarMetaData_dealloc,  // tp_dealloc
    (printfunc)avtScalarMetaData_print,     // tp_print
    (getattrfunc)PyavtScalarMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtScalarMetaData_setattr, // tp_setattr
    (cmpfunc)avtScalarMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtScalarMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtScalarMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtScalarMetaData *defaultAtts = 0;
static avtScalarMetaData *currentAtts = 0;

static PyObject *
NewavtScalarMetaData(int useCurrent)
{
    avtScalarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtScalarMetaDataObject, &avtScalarMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtScalarMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtScalarMetaData(*defaultAtts);
    else
        newObject->data = new avtScalarMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtScalarMetaData(const avtScalarMetaData *attr)
{
    avtScalarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtScalarMetaDataObject, &avtScalarMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtScalarMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtScalarMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtScalarMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtScalarMetaDataMethods[] = {
    {"avtScalarMetaData", avtScalarMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtScalarMetaDataObserver = 0;

std::string
PyavtScalarMetaData_GetLogString()
{
    std::string s("avtScalarMetaData = avtScalarMetaData()\n");
    if(currentAtts != 0)
        s += PyavtScalarMetaData_ToString(currentAtts, "avtScalarMetaData.");
    return s;
}

static void
PyavtScalarMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtScalarMetaData = avtScalarMetaData()\n");
        s += PyavtScalarMetaData_ToString(currentAtts, "avtScalarMetaData.");
        cb(s);
    }
}

void
PyavtScalarMetaData_StartUp(avtScalarMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtScalarMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtScalarMetaDataObserver == 0)
    {
        avtScalarMetaDataObserver = new ObserverToCallback(subj,
            PyavtScalarMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtScalarMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtScalarMetaDataObserver;
    avtScalarMetaDataObserver = 0;
}

PyMethodDef *
PyavtScalarMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtScalarMetaDataMethods;
}

bool
PyavtScalarMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtScalarMetaDataType);
}

avtScalarMetaData *
PyavtScalarMetaData_FromPyObject(PyObject *obj)
{
    avtScalarMetaDataObject *obj2 = (avtScalarMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtScalarMetaData_New()
{
    return NewavtScalarMetaData(0);
}

PyObject *
PyavtScalarMetaData_Wrap(const avtScalarMetaData *attr)
{
    return WrapavtScalarMetaData(attr);
}

void
PyavtScalarMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtScalarMetaDataObject *obj2 = (avtScalarMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtScalarMetaData_SetDefaults(const avtScalarMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtScalarMetaData(*atts);
}

