/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ActionGroupDescription.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Init utility for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ActionGroupDescription::Init()
{
    visible = true;

    ActionGroupDescription::SelectAll();
}

// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Copy utility for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ActionGroupDescription::Copy(const ActionGroupDescription &obj)
{
    name = obj.name;
    actions = obj.actions;
    visible = obj.visible;

    ActionGroupDescription::SelectAll();
}

// Type map format string
const char *ActionGroupDescription::TypeMapFormatString = ACTIONGROUPDESCRIPTION_TMFS;
const AttributeGroup::private_tmfs_t ActionGroupDescription::TmfsStruct = {ACTIONGROUPDESCRIPTION_TMFS};


// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Default constructor for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription::ActionGroupDescription() : 
    AttributeSubject(ActionGroupDescription::TypeMapFormatString)
{
    ActionGroupDescription::Init();
}

// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Constructor for the derived classes of ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription::ActionGroupDescription(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ActionGroupDescription::Init();
}

// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Copy constructor for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription::ActionGroupDescription(const ActionGroupDescription &obj) : 
    AttributeSubject(ActionGroupDescription::TypeMapFormatString)
{
    ActionGroupDescription::Copy(obj);
}

// ****************************************************************************
// Method: ActionGroupDescription::ActionGroupDescription
//
// Purpose: 
//   Copy constructor for derived classes of the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription::ActionGroupDescription(const ActionGroupDescription &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ActionGroupDescription::Copy(obj);
}

// ****************************************************************************
// Method: ActionGroupDescription::~ActionGroupDescription
//
// Purpose: 
//   Destructor for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription::~ActionGroupDescription()
{
    // nothing here
}

// ****************************************************************************
// Method: ActionGroupDescription::operator = 
//
// Purpose: 
//   Assignment operator for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription& 
ActionGroupDescription::operator = (const ActionGroupDescription &obj)
{
    if (this == &obj) return *this;

    ActionGroupDescription::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ActionGroupDescription::operator == 
//
// Purpose: 
//   Comparison operator == for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ActionGroupDescription::operator == (const ActionGroupDescription &obj) const
{
    // Create the return value
    return ((name == obj.name) &&
            (actions == obj.actions) &&
            (visible == obj.visible));
}

// ****************************************************************************
// Method: ActionGroupDescription::operator != 
//
// Purpose: 
//   Comparison operator != for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ActionGroupDescription::operator != (const ActionGroupDescription &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ActionGroupDescription::TypeName
//
// Purpose: 
//   Type name method for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ActionGroupDescription::TypeName() const
{
    return "ActionGroupDescription";
}

// ****************************************************************************
// Method: ActionGroupDescription::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ActionGroupDescription::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ActionGroupDescription *tmp = (const ActionGroupDescription *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ActionGroupDescription::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ActionGroupDescription::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ActionGroupDescription(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ActionGroupDescription::NewInstance
//
// Purpose: 
//   NewInstance method for the ActionGroupDescription class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ActionGroupDescription::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ActionGroupDescription(*this);
    else
        retval = new ActionGroupDescription;

    return retval;
}

// ****************************************************************************
// Method: ActionGroupDescription::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ActionGroupDescription::SelectAll()
{
    Select(ID_name,    (void *)&name);
    Select(ID_actions, (void *)&actions);
    Select(ID_visible, (void *)&visible);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ActionGroupDescription::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ActionGroupDescription::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ActionGroupDescription defaultObject;
    bool addToParent = false;
    // Create a node for ActionGroupDescription.
    DataNode *node = new DataNode("ActionGroupDescription");

    if(completeSave || !FieldsEqual(ID_name, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(ID_actions, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("actions", actions));
    }

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ActionGroupDescription::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ActionGroupDescription::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ActionGroupDescription");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsString());
    if((node = searchNode->GetNode("actions")) != 0)
        SetActions(node->AsStringVector());
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ActionGroupDescription::SetName(const std::string &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
ActionGroupDescription::SetActions(const stringVector &actions_)
{
    actions = actions_;
    Select(ID_actions, (void *)&actions);
}

void
ActionGroupDescription::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ActionGroupDescription::GetName() const
{
    return name;
}

std::string &
ActionGroupDescription::GetName()
{
    return name;
}

const stringVector &
ActionGroupDescription::GetActions() const
{
    return actions;
}

stringVector &
ActionGroupDescription::GetActions()
{
    return actions;
}

bool
ActionGroupDescription::GetVisible() const
{
    return visible;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ActionGroupDescription::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
ActionGroupDescription::SelectActions()
{
    Select(ID_actions, (void *)&actions);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ActionGroupDescription::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ActionGroupDescription::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_name:    return "name";
    case ID_actions: return "actions";
    case ID_visible: return "visible";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ActionGroupDescription::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ActionGroupDescription::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_name:    return FieldType_string;
    case ID_actions: return FieldType_stringVector;
    case ID_visible: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ActionGroupDescription::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ActionGroupDescription::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_name:    return "string";
    case ID_actions: return "stringVector";
    case ID_visible: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ActionGroupDescription::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ActionGroupDescription::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ActionGroupDescription &obj = *((const ActionGroupDescription*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_name:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case ID_actions:
        {  // new scope
        retval = (actions == obj.actions);
        }
        break;
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

ActionGroupDescription::ActionGroupDescription(const std::string &n) :
    AttributeSubject("ss*b"), name(n), actions()
{
    visible = true;
}

void
ActionGroupDescription::AddAction(ViewerRPC::ViewerRPCType t)
{
    actions.push_back(ViewerRPC::ViewerRPCType_ToString(t));
}

ViewerRPC::ViewerRPCType
ActionGroupDescription::GetAction(int index) const
{
    ViewerRPC::ViewerRPCType retval = ViewerRPC::MaxRPC;

    if(index >= 0 && index < (int)actions.size())
    {
        ViewerRPC::ViewerRPCType_FromString(actions[index], retval);
    }

    return retval;
}

