/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ExtractPointFunction2DAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Init utility for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ExtractPointFunction2DAttributes::Init()
{

    ExtractPointFunction2DAttributes::SelectAll();
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Copy utility for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ExtractPointFunction2DAttributes::Copy(const ExtractPointFunction2DAttributes &obj)
{
    I = obj.I;
    J = obj.J;

    ExtractPointFunction2DAttributes::SelectAll();
}

// Type map format string
const char *ExtractPointFunction2DAttributes::TypeMapFormatString = EXTRACTPOINTFUNCTION2DATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ExtractPointFunction2DAttributes::TmfsStruct = {EXTRACTPOINTFUNCTION2DATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Default constructor for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes() : 
    AttributeSubject(ExtractPointFunction2DAttributes::TypeMapFormatString)
{
    ExtractPointFunction2DAttributes::Init();
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Constructor for the derived classes of ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ExtractPointFunction2DAttributes::Init();
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Copy constructor for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes(const ExtractPointFunction2DAttributes &obj) : 
    AttributeSubject(ExtractPointFunction2DAttributes::TypeMapFormatString)
{
    ExtractPointFunction2DAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes::ExtractPointFunction2DAttributes(const ExtractPointFunction2DAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ExtractPointFunction2DAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::~ExtractPointFunction2DAttributes
//
// Purpose: 
//   Destructor for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes::~ExtractPointFunction2DAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtractPointFunction2DAttributes& 
ExtractPointFunction2DAttributes::operator = (const ExtractPointFunction2DAttributes &obj)
{
    if (this == &obj) return *this;

    ExtractPointFunction2DAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtractPointFunction2DAttributes::operator == (const ExtractPointFunction2DAttributes &obj) const
{
    // Create the return value
    return ((I == obj.I) &&
            (J == obj.J));
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtractPointFunction2DAttributes::operator != (const ExtractPointFunction2DAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::TypeName
//
// Purpose: 
//   Type name method for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ExtractPointFunction2DAttributes::TypeName() const
{
    return "ExtractPointFunction2DAttributes";
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtractPointFunction2DAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ExtractPointFunction2DAttributes *tmp = (const ExtractPointFunction2DAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ExtractPointFunction2DAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ExtractPointFunction2DAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ExtractPointFunction2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ExtractPointFunction2DAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ExtractPointFunction2DAttributes(*this);
    else
        retval = new ExtractPointFunction2DAttributes;

    return retval;
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ExtractPointFunction2DAttributes::SelectAll()
{
    Select(ID_I, (void *)&I);
    Select(ID_J, (void *)&J);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtractPointFunction2DAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ExtractPointFunction2DAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ExtractPointFunction2DAttributes.
    DataNode *node = new DataNode("ExtractPointFunction2DAttributes");

    if(completeSave || !FieldsEqual(ID_I, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("I", I));
    }

    if(completeSave || !FieldsEqual(ID_J, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("J", J));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ExtractPointFunction2DAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ExtractPointFunction2DAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("I")) != 0)
        SetI(node->AsIntVector());
    if((node = searchNode->GetNode("J")) != 0)
        SetJ(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ExtractPointFunction2DAttributes::SetI(const intVector &I_)
{
    I = I_;
    Select(ID_I, (void *)&I);
}

void
ExtractPointFunction2DAttributes::SetJ(const intVector &J_)
{
    J = J_;
    Select(ID_J, (void *)&J);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
ExtractPointFunction2DAttributes::GetI() const
{
    return I;
}

intVector &
ExtractPointFunction2DAttributes::GetI()
{
    return I;
}

const intVector &
ExtractPointFunction2DAttributes::GetJ() const
{
    return J;
}

intVector &
ExtractPointFunction2DAttributes::GetJ()
{
    return J;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ExtractPointFunction2DAttributes::SelectI()
{
    Select(ID_I, (void *)&I);
}

void
ExtractPointFunction2DAttributes::SelectJ()
{
    Select(ID_J, (void *)&J);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ExtractPointFunction2DAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_I: return "I";
    case ID_J: return "J";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ExtractPointFunction2DAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_I: return FieldType_intVector;
    case ID_J: return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ExtractPointFunction2DAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_I: return "intVector";
    case ID_J: return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExtractPointFunction2DAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtractPointFunction2DAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ExtractPointFunction2DAttributes &obj = *((const ExtractPointFunction2DAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_I:
        {  // new scope
        retval = (I == obj.I);
        }
        break;
    case ID_J:
        {  // new scope
        retval = (J == obj.J);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

