/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyEdgeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyEdgeAttributes
//
// Purpose: 
//   Attributes for the Edge operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a EdgeAttributes.
//
struct EdgeAttributesObject
{
    PyObject_HEAD
    EdgeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewEdgeAttributes(int);

std::string
PyEdgeAttributes_ToString(const EdgeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetDummy())
        SNPRINTF(tmpStr, 1000, "%sdummy = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdummy = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
EdgeAttributes_Notify(PyObject *self, PyObject *args)
{
    EdgeAttributesObject *obj = (EdgeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EdgeAttributes_SetDummy(PyObject *self, PyObject *args)
{
    EdgeAttributesObject *obj = (EdgeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dummy in the object.
    obj->data->SetDummy(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EdgeAttributes_GetDummy(PyObject *self, PyObject *args)
{
    EdgeAttributesObject *obj = (EdgeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDummy()?1L:0L);
    return retval;
}



PyMethodDef PyEdgeAttributes_methods[EDGEATTRIBUTES_NMETH] = {
    {"Notify", EdgeAttributes_Notify, METH_VARARGS},
    {"SetDummy", EdgeAttributes_SetDummy, METH_VARARGS},
    {"GetDummy", EdgeAttributes_GetDummy, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
EdgeAttributes_dealloc(PyObject *v)
{
   EdgeAttributesObject *obj = (EdgeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
EdgeAttributes_compare(PyObject *v, PyObject *w)
{
    EdgeAttributes *a = ((EdgeAttributesObject *)v)->data;
    EdgeAttributes *b = ((EdgeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyEdgeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "dummy") == 0)
        return EdgeAttributes_GetDummy(self, NULL);

    return Py_FindMethod(PyEdgeAttributes_methods, self, name);
}

int
PyEdgeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "dummy") == 0)
        obj = EdgeAttributes_SetDummy(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
EdgeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    EdgeAttributesObject *obj = (EdgeAttributesObject *)v;
    fprintf(fp, "%s", PyEdgeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
EdgeAttributes_str(PyObject *v)
{
    EdgeAttributesObject *obj = (EdgeAttributesObject *)v;
    return PyString_FromString(PyEdgeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *EdgeAttributes_Purpose = "Attributes for the Edge operator";
#else
static char *EdgeAttributes_Purpose = "Attributes for the Edge operator";
#endif

//
// The type description structure
//
static PyTypeObject EdgeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "EdgeAttributes",                    // tp_name
    sizeof(EdgeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)EdgeAttributes_dealloc,  // tp_dealloc
    (printfunc)EdgeAttributes_print,     // tp_print
    (getattrfunc)PyEdgeAttributes_getattr, // tp_getattr
    (setattrfunc)PyEdgeAttributes_setattr, // tp_setattr
    (cmpfunc)EdgeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)EdgeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    EdgeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static EdgeAttributes *defaultAtts = 0;
static EdgeAttributes *currentAtts = 0;

static PyObject *
NewEdgeAttributes(int useCurrent)
{
    EdgeAttributesObject *newObject;
    newObject = PyObject_NEW(EdgeAttributesObject, &EdgeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new EdgeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new EdgeAttributes(*defaultAtts);
    else
        newObject->data = new EdgeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapEdgeAttributes(const EdgeAttributes *attr)
{
    EdgeAttributesObject *newObject;
    newObject = PyObject_NEW(EdgeAttributesObject, &EdgeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (EdgeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
EdgeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewEdgeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef EdgeAttributesMethods[] = {
    {"EdgeAttributes", EdgeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *EdgeAttributesObserver = 0;

std::string
PyEdgeAttributes_GetLogString()
{
    std::string s("EdgeAtts = EdgeAttributes()\n");
    if(currentAtts != 0)
        s += PyEdgeAttributes_ToString(currentAtts, "EdgeAtts.");
    return s;
}

static void
PyEdgeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("EdgeAtts = EdgeAttributes()\n");
        s += PyEdgeAttributes_ToString(currentAtts, "EdgeAtts.");
        cb(s);
    }
}

void
PyEdgeAttributes_StartUp(EdgeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyEdgeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(EdgeAttributesObserver == 0)
    {
        EdgeAttributesObserver = new ObserverToCallback(subj,
            PyEdgeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyEdgeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete EdgeAttributesObserver;
    EdgeAttributesObserver = 0;
}

PyMethodDef *
PyEdgeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return EdgeAttributesMethods;
}

bool
PyEdgeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &EdgeAttributesType);
}

EdgeAttributes *
PyEdgeAttributes_FromPyObject(PyObject *obj)
{
    EdgeAttributesObject *obj2 = (EdgeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyEdgeAttributes_New()
{
    return NewEdgeAttributes(0);
}

PyObject *
PyEdgeAttributes_Wrap(const EdgeAttributes *attr)
{
    return WrapEdgeAttributes(attr);
}

void
PyEdgeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    EdgeAttributesObject *obj2 = (EdgeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyEdgeAttributes_SetDefaults(const EdgeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new EdgeAttributes(*atts);
}

