/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef CINEMAATTRIBUTES_H
#define CINEMAATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: CinemaAttributes
//
// Purpose:
//    This class contains the attributes used for saving Cinema
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class STATE_API CinemaAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    CinemaAttributes();
    CinemaAttributes(const CinemaAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    CinemaAttributes(private_tmfs_t tmfs);
    CinemaAttributes(const CinemaAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~CinemaAttributes();

    virtual CinemaAttributes& operator = (const CinemaAttributes &obj);
    virtual bool operator == (const CinemaAttributes &obj) const;
    virtual bool operator != (const CinemaAttributes &obj) const;
private:
    void Init();
    void Copy(const CinemaAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSpecification();
    void SelectFileName();
    void SelectCameraMode();
    void SelectFormat();

    // Property setting methods
    void SetSpecification(const std::string &specification_);
    void SetFileName(const std::string &fileName_);
    void SetCameraMode(const std::string &cameraMode_);
    void SetTheta(int theta_);
    void SetPhi(int phi_);
    void SetRoll(int roll_);
    void SetFormat(const std::string &format_);
    void SetComposite(bool composite_);
    void SetUseScreenCapture(bool useScreenCapture_);
    void SetWidth(int width_);
    void SetHeight(int height_);
    void SetFrameStart(int frameStart_);
    void SetFrameEnd(int frameEnd_);
    void SetFrameStride(int frameStride_);

    // Property getting methods
    const std::string &GetSpecification() const;
          std::string &GetSpecification();
    const std::string &GetFileName() const;
          std::string &GetFileName();
    const std::string &GetCameraMode() const;
          std::string &GetCameraMode();
    int               GetTheta() const;
    int               GetPhi() const;
    int               GetRoll() const;
    const std::string &GetFormat() const;
          std::string &GetFormat();
    bool              GetComposite() const;
    bool              GetUseScreenCapture() const;
    int               GetWidth() const;
    int               GetHeight() const;
    int               GetFrameStart() const;
    int               GetFrameEnd() const;
    int               GetFrameStride() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // IDs that can be used to identify fields in case statements
    enum {
        ID_specification = 0,
        ID_fileName,
        ID_cameraMode,
        ID_theta,
        ID_phi,
        ID_roll,
        ID_format,
        ID_composite,
        ID_useScreenCapture,
        ID_width,
        ID_height,
        ID_frameStart,
        ID_frameEnd,
        ID_frameStride,
        ID__LAST
    };

private:
    std::string specification;
    std::string fileName;
    std::string cameraMode;
    int         theta;
    int         phi;
    int         roll;
    std::string format;
    bool        composite;
    bool        useScreenCapture;
    int         width;
    int         height;
    int         frameStart;
    int         frameEnd;
    int         frameStride;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CINEMAATTRIBUTES_TMFS "sssiiisbbiiiii"

#endif
