/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtMergeFilter.C
// ************************************************************************* //

#include <avtMergeFilter.h>

#include <avtCompactTreeFilter.h>


// ****************************************************************************
//  Method: avtMergeFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

avtMergeFilter::avtMergeFilter()
{
    ctf = NULL;
}


// ****************************************************************************
//  Method: avtMergeFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
//  Modifications:
//
// ****************************************************************************

avtMergeFilter::~avtMergeFilter()
{
    if (ctf != NULL)
    {
        delete ctf;
        ctf = NULL;
    }
}


// ****************************************************************************
//  Method:  avtMergeFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

avtFilter *
avtMergeFilter::Create()
{
    return new avtMergeFilter();
}


// ****************************************************************************
//  Method:      avtMergeFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
//  Modifications:
//
//    Hank Childs, Wed Aug 24 15:57:48 PDT 2005
//    Tell the compact tree filter to merge points as well.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtMergeFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const MergeOperatorAttributes*)a;

    ctf = new avtCompactTreeFilter();
    ctf->SetToleranceWhenCleaningPolyData(atts.GetTolerance());
    ctf->SetParallelMerge(atts.GetParallelMerge());
    ctf->CreateCleanPolyData(true);
    ctf->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtMergeFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtMergeFilter with the given
//      parameters would result in an equivalent avtMergeFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
// ****************************************************************************

bool
avtMergeFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(MergeOperatorAttributes*)a);
}


// ****************************************************************************
//  Method: avtMergeFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   August 14, 2005
//
// ****************************************************************************

avtFilter *
avtMergeFilter::GetFacadedFilter(void)
{
    return ctf;
}


// ****************************************************************************
//  Method: avtMergeFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtMergeFilter::GetFacadedFilter(void) const
{
    return ctf;
}

// ****************************************************************************
// Method: avtMergeFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtMergeFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    outAtts.AddFilterMetaData("Merge");
}
