/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMeshManagementAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyMeshManagementAttributes
//
// Purpose: 
//   Global variables controlling reading and conversion of non-standard meshes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MeshManagementAttributes.
//
struct MeshManagementAttributesObject
{
    PyObject_HEAD
    MeshManagementAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMeshManagementAttributes(int);

std::string
PyMeshManagementAttributes_ToString(const MeshManagementAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const doubleVector &discretizationTolerance = atts->GetDiscretizationTolerance();
        SNPRINTF(tmpStr, 1000, "%sdiscretizationTolerance = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < discretizationTolerance.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", discretizationTolerance[i]);
            str += tmpStr;
            if(i < discretizationTolerance.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &discretizationToleranceX = atts->GetDiscretizationToleranceX();
        SNPRINTF(tmpStr, 1000, "%sdiscretizationToleranceX = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < discretizationToleranceX.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", discretizationToleranceX[i]);
            str += tmpStr;
            if(i < discretizationToleranceX.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &discretizationToleranceY = atts->GetDiscretizationToleranceY();
        SNPRINTF(tmpStr, 1000, "%sdiscretizationToleranceY = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < discretizationToleranceY.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", discretizationToleranceY[i]);
            str += tmpStr;
            if(i < discretizationToleranceY.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &discretizationToleranceZ = atts->GetDiscretizationToleranceZ();
        SNPRINTF(tmpStr, 1000, "%sdiscretizationToleranceZ = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < discretizationToleranceZ.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", discretizationToleranceZ[i]);
            str += tmpStr;
            if(i < discretizationToleranceZ.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *discretizationMode_names = "Uniform, Adaptive, MultiPass";
    switch (atts->GetDiscretizationMode())
    {
      case MeshManagementAttributes::Uniform:
          SNPRINTF(tmpStr, 1000, "%sdiscretizationMode = %sUniform  # %s\n", prefix, prefix, discretizationMode_names);
          str += tmpStr;
          break;
      case MeshManagementAttributes::Adaptive:
          SNPRINTF(tmpStr, 1000, "%sdiscretizationMode = %sAdaptive  # %s\n", prefix, prefix, discretizationMode_names);
          str += tmpStr;
          break;
      case MeshManagementAttributes::MultiPass:
          SNPRINTF(tmpStr, 1000, "%sdiscretizationMode = %sMultiPass  # %s\n", prefix, prefix, discretizationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetDiscretizeBoundaryOnly())
        SNPRINTF(tmpStr, 1000, "%sdiscretizeBoundaryOnly = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdiscretizeBoundaryOnly = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPassNativeCSG())
        SNPRINTF(tmpStr, 1000, "%spassNativeCSG = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spassNativeCSG = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
MeshManagementAttributes_Notify(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizationTolerance(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDiscretizationTolerance();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the discretizationTolerance in the object as modified.
    obj->data->SelectDiscretizationTolerance();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizationTolerance(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the discretizationTolerance.
    const doubleVector &discretizationTolerance = obj->data->GetDiscretizationTolerance();
    PyObject *retval = PyTuple_New(discretizationTolerance.size());
    for(size_t i = 0; i < discretizationTolerance.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(discretizationTolerance[i]));
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizationToleranceX(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDiscretizationToleranceX();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the discretizationToleranceX in the object as modified.
    obj->data->SelectDiscretizationToleranceX();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizationToleranceX(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the discretizationToleranceX.
    const doubleVector &discretizationToleranceX = obj->data->GetDiscretizationToleranceX();
    PyObject *retval = PyTuple_New(discretizationToleranceX.size());
    for(size_t i = 0; i < discretizationToleranceX.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(discretizationToleranceX[i]));
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizationToleranceY(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDiscretizationToleranceY();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the discretizationToleranceY in the object as modified.
    obj->data->SelectDiscretizationToleranceY();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizationToleranceY(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the discretizationToleranceY.
    const doubleVector &discretizationToleranceY = obj->data->GetDiscretizationToleranceY();
    PyObject *retval = PyTuple_New(discretizationToleranceY.size());
    for(size_t i = 0; i < discretizationToleranceY.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(discretizationToleranceY[i]));
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizationToleranceZ(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDiscretizationToleranceZ();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the discretizationToleranceZ in the object as modified.
    obj->data->SelectDiscretizationToleranceZ();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizationToleranceZ(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the discretizationToleranceZ.
    const doubleVector &discretizationToleranceZ = obj->data->GetDiscretizationToleranceZ();
    PyObject *retval = PyTuple_New(discretizationToleranceZ.size());
    for(size_t i = 0; i < discretizationToleranceZ.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(discretizationToleranceZ[i]));
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizationMode(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the discretizationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDiscretizationMode(MeshManagementAttributes::DiscretizationModes(ival));
    else
    {
        fprintf(stderr, "An invalid discretizationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Uniform, Adaptive, MultiPass.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizationMode(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDiscretizationMode()));
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetDiscretizeBoundaryOnly(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the discretizeBoundaryOnly in the object.
    obj->data->SetDiscretizeBoundaryOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetDiscretizeBoundaryOnly(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDiscretizeBoundaryOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MeshManagementAttributes_SetPassNativeCSG(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the passNativeCSG in the object.
    obj->data->SetPassNativeCSG(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshManagementAttributes_GetPassNativeCSG(PyObject *self, PyObject *args)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPassNativeCSG()?1L:0L);
    return retval;
}



PyMethodDef PyMeshManagementAttributes_methods[MESHMANAGEMENTATTRIBUTES_NMETH] = {
    {"Notify", MeshManagementAttributes_Notify, METH_VARARGS},
    {"SetDiscretizationTolerance", MeshManagementAttributes_SetDiscretizationTolerance, METH_VARARGS},
    {"GetDiscretizationTolerance", MeshManagementAttributes_GetDiscretizationTolerance, METH_VARARGS},
    {"SetDiscretizationToleranceX", MeshManagementAttributes_SetDiscretizationToleranceX, METH_VARARGS},
    {"GetDiscretizationToleranceX", MeshManagementAttributes_GetDiscretizationToleranceX, METH_VARARGS},
    {"SetDiscretizationToleranceY", MeshManagementAttributes_SetDiscretizationToleranceY, METH_VARARGS},
    {"GetDiscretizationToleranceY", MeshManagementAttributes_GetDiscretizationToleranceY, METH_VARARGS},
    {"SetDiscretizationToleranceZ", MeshManagementAttributes_SetDiscretizationToleranceZ, METH_VARARGS},
    {"GetDiscretizationToleranceZ", MeshManagementAttributes_GetDiscretizationToleranceZ, METH_VARARGS},
    {"SetDiscretizationMode", MeshManagementAttributes_SetDiscretizationMode, METH_VARARGS},
    {"GetDiscretizationMode", MeshManagementAttributes_GetDiscretizationMode, METH_VARARGS},
    {"SetDiscretizeBoundaryOnly", MeshManagementAttributes_SetDiscretizeBoundaryOnly, METH_VARARGS},
    {"GetDiscretizeBoundaryOnly", MeshManagementAttributes_GetDiscretizeBoundaryOnly, METH_VARARGS},
    {"SetPassNativeCSG", MeshManagementAttributes_SetPassNativeCSG, METH_VARARGS},
    {"GetPassNativeCSG", MeshManagementAttributes_GetPassNativeCSG, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MeshManagementAttributes_dealloc(PyObject *v)
{
   MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MeshManagementAttributes_compare(PyObject *v, PyObject *w)
{
    MeshManagementAttributes *a = ((MeshManagementAttributesObject *)v)->data;
    MeshManagementAttributes *b = ((MeshManagementAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMeshManagementAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "discretizationTolerance") == 0)
        return MeshManagementAttributes_GetDiscretizationTolerance(self, NULL);
    if(strcmp(name, "discretizationToleranceX") == 0)
        return MeshManagementAttributes_GetDiscretizationToleranceX(self, NULL);
    if(strcmp(name, "discretizationToleranceY") == 0)
        return MeshManagementAttributes_GetDiscretizationToleranceY(self, NULL);
    if(strcmp(name, "discretizationToleranceZ") == 0)
        return MeshManagementAttributes_GetDiscretizationToleranceZ(self, NULL);
    if(strcmp(name, "discretizationMode") == 0)
        return MeshManagementAttributes_GetDiscretizationMode(self, NULL);
    if(strcmp(name, "Uniform") == 0)
        return PyInt_FromLong(long(MeshManagementAttributes::Uniform));
    if(strcmp(name, "Adaptive") == 0)
        return PyInt_FromLong(long(MeshManagementAttributes::Adaptive));
    if(strcmp(name, "MultiPass") == 0)
        return PyInt_FromLong(long(MeshManagementAttributes::MultiPass));

    if(strcmp(name, "discretizeBoundaryOnly") == 0)
        return MeshManagementAttributes_GetDiscretizeBoundaryOnly(self, NULL);
    if(strcmp(name, "passNativeCSG") == 0)
        return MeshManagementAttributes_GetPassNativeCSG(self, NULL);

    return Py_FindMethod(PyMeshManagementAttributes_methods, self, name);
}

int
PyMeshManagementAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "discretizationTolerance") == 0)
        obj = MeshManagementAttributes_SetDiscretizationTolerance(self, tuple);
    else if(strcmp(name, "discretizationToleranceX") == 0)
        obj = MeshManagementAttributes_SetDiscretizationToleranceX(self, tuple);
    else if(strcmp(name, "discretizationToleranceY") == 0)
        obj = MeshManagementAttributes_SetDiscretizationToleranceY(self, tuple);
    else if(strcmp(name, "discretizationToleranceZ") == 0)
        obj = MeshManagementAttributes_SetDiscretizationToleranceZ(self, tuple);
    else if(strcmp(name, "discretizationMode") == 0)
        obj = MeshManagementAttributes_SetDiscretizationMode(self, tuple);
    else if(strcmp(name, "discretizeBoundaryOnly") == 0)
        obj = MeshManagementAttributes_SetDiscretizeBoundaryOnly(self, tuple);
    else if(strcmp(name, "passNativeCSG") == 0)
        obj = MeshManagementAttributes_SetPassNativeCSG(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MeshManagementAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)v;
    fprintf(fp, "%s", PyMeshManagementAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MeshManagementAttributes_str(PyObject *v)
{
    MeshManagementAttributesObject *obj = (MeshManagementAttributesObject *)v;
    return PyString_FromString(PyMeshManagementAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MeshManagementAttributes_Purpose = "Global variables controlling reading and conversion of non-standard meshes";
#else
static char *MeshManagementAttributes_Purpose = "Global variables controlling reading and conversion of non-standard meshes";
#endif

//
// The type description structure
//
static PyTypeObject MeshManagementAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MeshManagementAttributes",                    // tp_name
    sizeof(MeshManagementAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MeshManagementAttributes_dealloc,  // tp_dealloc
    (printfunc)MeshManagementAttributes_print,     // tp_print
    (getattrfunc)PyMeshManagementAttributes_getattr, // tp_getattr
    (setattrfunc)PyMeshManagementAttributes_setattr, // tp_setattr
    (cmpfunc)MeshManagementAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MeshManagementAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MeshManagementAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MeshManagementAttributes *defaultAtts = 0;
static MeshManagementAttributes *currentAtts = 0;

static PyObject *
NewMeshManagementAttributes(int useCurrent)
{
    MeshManagementAttributesObject *newObject;
    newObject = PyObject_NEW(MeshManagementAttributesObject, &MeshManagementAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MeshManagementAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MeshManagementAttributes(*defaultAtts);
    else
        newObject->data = new MeshManagementAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMeshManagementAttributes(const MeshManagementAttributes *attr)
{
    MeshManagementAttributesObject *newObject;
    newObject = PyObject_NEW(MeshManagementAttributesObject, &MeshManagementAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MeshManagementAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MeshManagementAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMeshManagementAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MeshManagementAttributesMethods[] = {
    {"MeshManagementAttributes", MeshManagementAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MeshManagementAttributesObserver = 0;

std::string
PyMeshManagementAttributes_GetLogString()
{
    std::string s("MeshManagementAtts = MeshManagementAttributes()\n");
    if(currentAtts != 0)
        s += PyMeshManagementAttributes_ToString(currentAtts, "MeshManagementAtts.");
    return s;
}

static void
PyMeshManagementAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MeshManagementAtts = MeshManagementAttributes()\n");
        s += PyMeshManagementAttributes_ToString(currentAtts, "MeshManagementAtts.");
        cb(s);
    }
}

void
PyMeshManagementAttributes_StartUp(MeshManagementAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMeshManagementAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MeshManagementAttributesObserver == 0)
    {
        MeshManagementAttributesObserver = new ObserverToCallback(subj,
            PyMeshManagementAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMeshManagementAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MeshManagementAttributesObserver;
    MeshManagementAttributesObserver = 0;
}

PyMethodDef *
PyMeshManagementAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MeshManagementAttributesMethods;
}

bool
PyMeshManagementAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MeshManagementAttributesType);
}

MeshManagementAttributes *
PyMeshManagementAttributes_FromPyObject(PyObject *obj)
{
    MeshManagementAttributesObject *obj2 = (MeshManagementAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMeshManagementAttributes_New()
{
    return NewMeshManagementAttributes(0);
}

PyObject *
PyMeshManagementAttributes_Wrap(const MeshManagementAttributes *attr)
{
    return WrapMeshManagementAttributes(attr);
}

void
PyMeshManagementAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MeshManagementAttributesObject *obj2 = (MeshManagementAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMeshManagementAttributes_SetDefaults(const MeshManagementAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MeshManagementAttributes(*atts);
}

