/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMaterialAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyMaterialAttributes
//
// Purpose: 
//   Attributes to control material interface reconstruction
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MaterialAttributes.
//
struct MaterialAttributesObject
{
    PyObject_HEAD
    MaterialAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMaterialAttributes(int);

std::string
PyMaterialAttributes_ToString(const MaterialAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetSmoothing())
        SNPRINTF(tmpStr, 1000, "%ssmoothing = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssmoothing = 0\n", prefix);
    str += tmpStr;
    if(atts->GetForceMIR())
        SNPRINTF(tmpStr, 1000, "%sforceMIR = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sforceMIR = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCleanZonesOnly())
        SNPRINTF(tmpStr, 1000, "%scleanZonesOnly = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scleanZonesOnly = 0\n", prefix);
    str += tmpStr;
    if(atts->GetNeedValidConnectivity())
        SNPRINTF(tmpStr, 1000, "%sneedValidConnectivity = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sneedValidConnectivity = 0\n", prefix);
    str += tmpStr;
    const char *algorithm_names = "EquiT, EquiZ, Isovolume, PLIC, Discrete";
    switch (atts->GetAlgorithm())
    {
      case MaterialAttributes::EquiT:
          SNPRINTF(tmpStr, 1000, "%salgorithm = %sEquiT  # %s\n", prefix, prefix, algorithm_names);
          str += tmpStr;
          break;
      case MaterialAttributes::EquiZ:
          SNPRINTF(tmpStr, 1000, "%salgorithm = %sEquiZ  # %s\n", prefix, prefix, algorithm_names);
          str += tmpStr;
          break;
      case MaterialAttributes::Isovolume:
          SNPRINTF(tmpStr, 1000, "%salgorithm = %sIsovolume  # %s\n", prefix, prefix, algorithm_names);
          str += tmpStr;
          break;
      case MaterialAttributes::PLIC:
          SNPRINTF(tmpStr, 1000, "%salgorithm = %sPLIC  # %s\n", prefix, prefix, algorithm_names);
          str += tmpStr;
          break;
      case MaterialAttributes::Discrete:
          SNPRINTF(tmpStr, 1000, "%salgorithm = %sDiscrete  # %s\n", prefix, prefix, algorithm_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetIterationEnabled())
        SNPRINTF(tmpStr, 1000, "%siterationEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%siterationEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumIterations = %d\n", prefix, atts->GetNumIterations());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%siterationDamping = %g\n", prefix, atts->GetIterationDamping());
    str += tmpStr;
    if(atts->GetSimplifyHeavilyMixedZones())
        SNPRINTF(tmpStr, 1000, "%ssimplifyHeavilyMixedZones = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssimplifyHeavilyMixedZones = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxMaterialsPerZone = %d\n", prefix, atts->GetMaxMaterialsPerZone());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sisoVolumeFraction = %g\n", prefix, atts->GetIsoVolumeFraction());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sannealingTime = %d\n", prefix, atts->GetAnnealingTime());
    str += tmpStr;
    return str;
}

static PyObject *
MaterialAttributes_Notify(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_SetSmoothing(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothing in the object.
    obj->data->SetSmoothing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetSmoothing(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetForceMIR(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceMIR in the object.
    obj->data->SetForceMIR(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetForceMIR(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceMIR()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetCleanZonesOnly(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanZonesOnly in the object.
    obj->data->SetCleanZonesOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetCleanZonesOnly(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCleanZonesOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetNeedValidConnectivity(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the needValidConnectivity in the object.
    obj->data->SetNeedValidConnectivity(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetNeedValidConnectivity(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNeedValidConnectivity()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetAlgorithm(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the algorithm in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetAlgorithm(MaterialAttributes::Algorithm(ival));
    else
    {
        fprintf(stderr, "An invalid algorithm value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "EquiT, EquiZ, Isovolume, PLIC, Discrete"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetAlgorithm(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAlgorithm()));
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetIterationEnabled(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the iterationEnabled in the object.
    obj->data->SetIterationEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetIterationEnabled(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIterationEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetNumIterations(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numIterations in the object.
    obj->data->SetNumIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetNumIterations(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumIterations()));
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetIterationDamping(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the iterationDamping in the object.
    obj->data->SetIterationDamping(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetIterationDamping(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetIterationDamping()));
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetSimplifyHeavilyMixedZones(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the simplifyHeavilyMixedZones in the object.
    obj->data->SetSimplifyHeavilyMixedZones(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetSimplifyHeavilyMixedZones(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSimplifyHeavilyMixedZones()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetMaxMaterialsPerZone(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxMaterialsPerZone in the object.
    obj->data->SetMaxMaterialsPerZone((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetMaxMaterialsPerZone(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxMaterialsPerZone()));
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetIsoVolumeFraction(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the isoVolumeFraction in the object.
    obj->data->SetIsoVolumeFraction(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetIsoVolumeFraction(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetIsoVolumeFraction()));
    return retval;
}

/*static*/ PyObject *
MaterialAttributes_SetAnnealingTime(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the annealingTime in the object.
    obj->data->SetAnnealingTime((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MaterialAttributes_GetAnnealingTime(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnnealingTime()));
    return retval;
}



PyMethodDef PyMaterialAttributes_methods[MATERIALATTRIBUTES_NMETH] = {
    {"Notify", MaterialAttributes_Notify, METH_VARARGS},
    {"SetSmoothing", MaterialAttributes_SetSmoothing, METH_VARARGS},
    {"GetSmoothing", MaterialAttributes_GetSmoothing, METH_VARARGS},
    {"SetForceMIR", MaterialAttributes_SetForceMIR, METH_VARARGS},
    {"GetForceMIR", MaterialAttributes_GetForceMIR, METH_VARARGS},
    {"SetCleanZonesOnly", MaterialAttributes_SetCleanZonesOnly, METH_VARARGS},
    {"GetCleanZonesOnly", MaterialAttributes_GetCleanZonesOnly, METH_VARARGS},
    {"SetNeedValidConnectivity", MaterialAttributes_SetNeedValidConnectivity, METH_VARARGS},
    {"GetNeedValidConnectivity", MaterialAttributes_GetNeedValidConnectivity, METH_VARARGS},
    {"SetAlgorithm", MaterialAttributes_SetAlgorithm, METH_VARARGS},
    {"GetAlgorithm", MaterialAttributes_GetAlgorithm, METH_VARARGS},
    {"SetIterationEnabled", MaterialAttributes_SetIterationEnabled, METH_VARARGS},
    {"GetIterationEnabled", MaterialAttributes_GetIterationEnabled, METH_VARARGS},
    {"SetNumIterations", MaterialAttributes_SetNumIterations, METH_VARARGS},
    {"GetNumIterations", MaterialAttributes_GetNumIterations, METH_VARARGS},
    {"SetIterationDamping", MaterialAttributes_SetIterationDamping, METH_VARARGS},
    {"GetIterationDamping", MaterialAttributes_GetIterationDamping, METH_VARARGS},
    {"SetSimplifyHeavilyMixedZones", MaterialAttributes_SetSimplifyHeavilyMixedZones, METH_VARARGS},
    {"GetSimplifyHeavilyMixedZones", MaterialAttributes_GetSimplifyHeavilyMixedZones, METH_VARARGS},
    {"SetMaxMaterialsPerZone", MaterialAttributes_SetMaxMaterialsPerZone, METH_VARARGS},
    {"GetMaxMaterialsPerZone", MaterialAttributes_GetMaxMaterialsPerZone, METH_VARARGS},
    {"SetIsoVolumeFraction", MaterialAttributes_SetIsoVolumeFraction, METH_VARARGS},
    {"GetIsoVolumeFraction", MaterialAttributes_GetIsoVolumeFraction, METH_VARARGS},
    {"SetAnnealingTime", MaterialAttributes_SetAnnealingTime, METH_VARARGS},
    {"GetAnnealingTime", MaterialAttributes_GetAnnealingTime, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MaterialAttributes_dealloc(PyObject *v)
{
   MaterialAttributesObject *obj = (MaterialAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MaterialAttributes_compare(PyObject *v, PyObject *w)
{
    MaterialAttributes *a = ((MaterialAttributesObject *)v)->data;
    MaterialAttributes *b = ((MaterialAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMaterialAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "smoothing") == 0)
        return MaterialAttributes_GetSmoothing(self, NULL);
    if(strcmp(name, "forceMIR") == 0)
        return MaterialAttributes_GetForceMIR(self, NULL);
    if(strcmp(name, "cleanZonesOnly") == 0)
        return MaterialAttributes_GetCleanZonesOnly(self, NULL);
    if(strcmp(name, "needValidConnectivity") == 0)
        return MaterialAttributes_GetNeedValidConnectivity(self, NULL);
    if(strcmp(name, "algorithm") == 0)
        return MaterialAttributes_GetAlgorithm(self, NULL);
    if(strcmp(name, "EquiT") == 0)
        return PyInt_FromLong(long(MaterialAttributes::EquiT));
    if(strcmp(name, "EquiZ") == 0)
        return PyInt_FromLong(long(MaterialAttributes::EquiZ));
    if(strcmp(name, "Isovolume") == 0)
        return PyInt_FromLong(long(MaterialAttributes::Isovolume));
    if(strcmp(name, "PLIC") == 0)
        return PyInt_FromLong(long(MaterialAttributes::PLIC));
    if(strcmp(name, "Discrete") == 0)
        return PyInt_FromLong(long(MaterialAttributes::Discrete));

    if(strcmp(name, "iterationEnabled") == 0)
        return MaterialAttributes_GetIterationEnabled(self, NULL);
    if(strcmp(name, "numIterations") == 0)
        return MaterialAttributes_GetNumIterations(self, NULL);
    if(strcmp(name, "iterationDamping") == 0)
        return MaterialAttributes_GetIterationDamping(self, NULL);
    if(strcmp(name, "simplifyHeavilyMixedZones") == 0)
        return MaterialAttributes_GetSimplifyHeavilyMixedZones(self, NULL);
    if(strcmp(name, "maxMaterialsPerZone") == 0)
        return MaterialAttributes_GetMaxMaterialsPerZone(self, NULL);
    if(strcmp(name, "isoVolumeFraction") == 0)
        return MaterialAttributes_GetIsoVolumeFraction(self, NULL);
    if(strcmp(name, "annealingTime") == 0)
        return MaterialAttributes_GetAnnealingTime(self, NULL);

    return Py_FindMethod(PyMaterialAttributes_methods, self, name);
}

int
PyMaterialAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "smoothing") == 0)
        obj = MaterialAttributes_SetSmoothing(self, tuple);
    else if(strcmp(name, "forceMIR") == 0)
        obj = MaterialAttributes_SetForceMIR(self, tuple);
    else if(strcmp(name, "cleanZonesOnly") == 0)
        obj = MaterialAttributes_SetCleanZonesOnly(self, tuple);
    else if(strcmp(name, "needValidConnectivity") == 0)
        obj = MaterialAttributes_SetNeedValidConnectivity(self, tuple);
    else if(strcmp(name, "algorithm") == 0)
        obj = MaterialAttributes_SetAlgorithm(self, tuple);
    else if(strcmp(name, "iterationEnabled") == 0)
        obj = MaterialAttributes_SetIterationEnabled(self, tuple);
    else if(strcmp(name, "numIterations") == 0)
        obj = MaterialAttributes_SetNumIterations(self, tuple);
    else if(strcmp(name, "iterationDamping") == 0)
        obj = MaterialAttributes_SetIterationDamping(self, tuple);
    else if(strcmp(name, "simplifyHeavilyMixedZones") == 0)
        obj = MaterialAttributes_SetSimplifyHeavilyMixedZones(self, tuple);
    else if(strcmp(name, "maxMaterialsPerZone") == 0)
        obj = MaterialAttributes_SetMaxMaterialsPerZone(self, tuple);
    else if(strcmp(name, "isoVolumeFraction") == 0)
        obj = MaterialAttributes_SetIsoVolumeFraction(self, tuple);
    else if(strcmp(name, "annealingTime") == 0)
        obj = MaterialAttributes_SetAnnealingTime(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MaterialAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)v;
    fprintf(fp, "%s", PyMaterialAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MaterialAttributes_str(PyObject *v)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)v;
    return PyString_FromString(PyMaterialAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MaterialAttributes_Purpose = "Attributes to control material interface reconstruction";
#else
static char *MaterialAttributes_Purpose = "Attributes to control material interface reconstruction";
#endif

//
// The type description structure
//
static PyTypeObject MaterialAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MaterialAttributes",                    // tp_name
    sizeof(MaterialAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MaterialAttributes_dealloc,  // tp_dealloc
    (printfunc)MaterialAttributes_print,     // tp_print
    (getattrfunc)PyMaterialAttributes_getattr, // tp_getattr
    (setattrfunc)PyMaterialAttributes_setattr, // tp_setattr
    (cmpfunc)MaterialAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MaterialAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MaterialAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MaterialAttributes *defaultAtts = 0;
static MaterialAttributes *currentAtts = 0;

static PyObject *
NewMaterialAttributes(int useCurrent)
{
    MaterialAttributesObject *newObject;
    newObject = PyObject_NEW(MaterialAttributesObject, &MaterialAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MaterialAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MaterialAttributes(*defaultAtts);
    else
        newObject->data = new MaterialAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMaterialAttributes(const MaterialAttributes *attr)
{
    MaterialAttributesObject *newObject;
    newObject = PyObject_NEW(MaterialAttributesObject, &MaterialAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MaterialAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MaterialAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMaterialAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MaterialAttributesMethods[] = {
    {"MaterialAttributes", MaterialAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MaterialAttributesObserver = 0;

std::string
PyMaterialAttributes_GetLogString()
{
    std::string s("MaterialAtts = MaterialAttributes()\n");
    if(currentAtts != 0)
        s += PyMaterialAttributes_ToString(currentAtts, "MaterialAtts.");
    return s;
}

static void
PyMaterialAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MaterialAtts = MaterialAttributes()\n");
        s += PyMaterialAttributes_ToString(currentAtts, "MaterialAtts.");
        cb(s);
    }
}

void
PyMaterialAttributes_StartUp(MaterialAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMaterialAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MaterialAttributesObserver == 0)
    {
        MaterialAttributesObserver = new ObserverToCallback(subj,
            PyMaterialAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMaterialAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MaterialAttributesObserver;
    MaterialAttributesObserver = 0;
}

PyMethodDef *
PyMaterialAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MaterialAttributesMethods;
}

bool
PyMaterialAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MaterialAttributesType);
}

MaterialAttributes *
PyMaterialAttributes_FromPyObject(PyObject *obj)
{
    MaterialAttributesObject *obj2 = (MaterialAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMaterialAttributes_New()
{
    return NewMaterialAttributes(0);
}

PyObject *
PyMaterialAttributes_Wrap(const MaterialAttributes *attr)
{
    return WrapMaterialAttributes(attr);
}

void
PyMaterialAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MaterialAttributesObject *obj2 = (MaterialAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMaterialAttributes_SetDefaults(const MaterialAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MaterialAttributes(*atts);
}

