/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyGlobalAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyGlobalAttributes
//
// Purpose: 
//   This class contains attributes associated with the main window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a GlobalAttributes.
//
struct GlobalAttributesObject
{
    PyObject_HEAD
    GlobalAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewGlobalAttributes(int);

std::string
PyGlobalAttributes_ToString(const GlobalAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &sources = atts->GetSources();
        SNPRINTF(tmpStr, 1000, "%ssources = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < sources.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", sources[i].c_str());
            str += tmpStr;
            if(i < sources.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &windows = atts->GetWindows();
        SNPRINTF(tmpStr, 1000, "%swindows = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < windows.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", windows[i]);
            str += tmpStr;
            if(i < windows.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sactiveWindow = %d\n", prefix, atts->GetActiveWindow());
    str += tmpStr;
    if(atts->GetIconifiedFlag())
        SNPRINTF(tmpStr, 1000, "%siconifiedFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%siconifiedFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutoUpdateFlag())
        SNPRINTF(tmpStr, 1000, "%sautoUpdateFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sautoUpdateFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetReplacePlots())
        SNPRINTF(tmpStr, 1000, "%sreplacePlots = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sreplacePlots = 0\n", prefix);
    str += tmpStr;
    if(atts->GetApplyOperator())
        SNPRINTF(tmpStr, 1000, "%sapplyOperator = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sapplyOperator = 0\n", prefix);
    str += tmpStr;
    if(atts->GetApplySelection())
        SNPRINTF(tmpStr, 1000, "%sapplySelection = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sapplySelection = 0\n", prefix);
    str += tmpStr;
    if(atts->GetApplyWindow())
        SNPRINTF(tmpStr, 1000, "%sapplyWindow = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sapplyWindow = 0\n", prefix);
    str += tmpStr;
    if(atts->GetExecuting())
        SNPRINTF(tmpStr, 1000, "%sexecuting = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sexecuting = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowLayout = %d\n", prefix, atts->GetWindowLayout());
    str += tmpStr;
    if(atts->GetMakeDefaultConfirm())
        SNPRINTF(tmpStr, 1000, "%smakeDefaultConfirm = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smakeDefaultConfirm = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCloneWindowOnFirstRef())
        SNPRINTF(tmpStr, 1000, "%scloneWindowOnFirstRef = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scloneWindowOnFirstRef = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutomaticallyAddOperator())
        SNPRINTF(tmpStr, 1000, "%sautomaticallyAddOperator = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sautomaticallyAddOperator = 0\n", prefix);
    str += tmpStr;
    if(atts->GetTryHarderCyclesTimes())
        SNPRINTF(tmpStr, 1000, "%stryHarderCyclesTimes = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stryHarderCyclesTimes = 0\n", prefix);
    str += tmpStr;
    if(atts->GetTreatAllDBsAsTimeVarying())
        SNPRINTF(tmpStr, 1000, "%streatAllDBsAsTimeVarying = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%streatAllDBsAsTimeVarying = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCreateMeshQualityExpressions())
        SNPRINTF(tmpStr, 1000, "%screateMeshQualityExpressions = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateMeshQualityExpressions = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCreateTimeDerivativeExpressions())
        SNPRINTF(tmpStr, 1000, "%screateTimeDerivativeExpressions = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateTimeDerivativeExpressions = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCreateVectorMagnitudeExpressions())
        SNPRINTF(tmpStr, 1000, "%screateVectorMagnitudeExpressions = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateVectorMagnitudeExpressions = 0\n", prefix);
    str += tmpStr;
    if(atts->GetNewPlotsInheritSILRestriction())
        SNPRINTF(tmpStr, 1000, "%snewPlotsInheritSILRestriction = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snewPlotsInheritSILRestriction = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUserDirForSessionFiles())
        SNPRINTF(tmpStr, 1000, "%suserDirForSessionFiles = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suserDirForSessionFiles = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSaveCrashRecoveryFile())
        SNPRINTF(tmpStr, 1000, "%ssaveCrashRecoveryFile = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssaveCrashRecoveryFile = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIgnoreExtentsFromDbs())
        SNPRINTF(tmpStr, 1000, "%signoreExtentsFromDbs = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%signoreExtentsFromDbs = 0\n", prefix);
    str += tmpStr;
    if(atts->GetExpandNewPlots())
        SNPRINTF(tmpStr, 1000, "%sexpandNewPlots = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sexpandNewPlots = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUserRestoreSessionFile())
        SNPRINTF(tmpStr, 1000, "%suserRestoreSessionFile = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suserRestoreSessionFile = 0\n", prefix);
    str += tmpStr;
    const char *precisionType_names = "Float, Native, Double";
    switch (atts->GetPrecisionType())
    {
      case GlobalAttributes::Float:
          SNPRINTF(tmpStr, 1000, "%sprecisionType = %sFloat  # %s\n", prefix, prefix, precisionType_names);
          str += tmpStr;
          break;
      case GlobalAttributes::Native:
          SNPRINTF(tmpStr, 1000, "%sprecisionType = %sNative  # %s\n", prefix, prefix, precisionType_names);
          str += tmpStr;
          break;
      case GlobalAttributes::Double:
          SNPRINTF(tmpStr, 1000, "%sprecisionType = %sDouble  # %s\n", prefix, prefix, precisionType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *backendType_names = "VTK, EAVL, VTKM";
    switch (atts->GetBackendType())
    {
      case GlobalAttributes::VTK:
          SNPRINTF(tmpStr, 1000, "%sbackendType = %sVTK  # %s\n", prefix, prefix, backendType_names);
          str += tmpStr;
          break;
      case GlobalAttributes::EAVL:
          SNPRINTF(tmpStr, 1000, "%sbackendType = %sEAVL  # %s\n", prefix, prefix, backendType_names);
          str += tmpStr;
          break;
      case GlobalAttributes::VTKM:
          SNPRINTF(tmpStr, 1000, "%sbackendType = %sVTKM  # %s\n", prefix, prefix, backendType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetRemoveDuplicateNodes())
        SNPRINTF(tmpStr, 1000, "%sremoveDuplicateNodes = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sremoveDuplicateNodes = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
GlobalAttributes_Notify(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_SetSources(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    stringVector  &vec = obj->data->GetSources();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the sources in the object as modified.
    obj->data->SelectSources();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetSources(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sources.
    const stringVector &sources = obj->data->GetSources();
    PyObject *retval = PyTuple_New(sources.size());
    for(size_t i = 0; i < sources.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(sources[i].c_str()));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetWindows(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    intVector  &vec = obj->data->GetWindows();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the windows in the object as modified.
    obj->data->SelectWindows();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetWindows(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the windows.
    const intVector &windows = obj->data->GetWindows();
    PyObject *retval = PyTuple_New(windows.size());
    for(size_t i = 0; i < windows.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(windows[i])));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetActiveWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeWindow in the object.
    obj->data->SetActiveWindow((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetActiveWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveWindow()));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetIconifiedFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the iconifiedFlag in the object.
    obj->data->SetIconifiedFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetIconifiedFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIconifiedFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetAutoUpdateFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoUpdateFlag in the object.
    obj->data->SetAutoUpdateFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetAutoUpdateFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoUpdateFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetReplacePlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the replacePlots in the object.
    obj->data->SetReplacePlots(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetReplacePlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetReplacePlots()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetApplyOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the applyOperator in the object.
    obj->data->SetApplyOperator(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetApplyOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetApplyOperator()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetApplySelection(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the applySelection in the object.
    obj->data->SetApplySelection(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetApplySelection(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetApplySelection()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetApplyWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the applyWindow in the object.
    obj->data->SetApplyWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetApplyWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetApplyWindow()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetExecuting(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the executing in the object.
    obj->data->SetExecuting(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetExecuting(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExecuting()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetWindowLayout(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowLayout in the object.
    obj->data->SetWindowLayout((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetWindowLayout(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowLayout()));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetMakeDefaultConfirm(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the makeDefaultConfirm in the object.
    obj->data->SetMakeDefaultConfirm(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetMakeDefaultConfirm(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMakeDefaultConfirm()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetCloneWindowOnFirstRef(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cloneWindowOnFirstRef in the object.
    obj->data->SetCloneWindowOnFirstRef(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetCloneWindowOnFirstRef(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCloneWindowOnFirstRef()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetAutomaticallyAddOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the automaticallyAddOperator in the object.
    obj->data->SetAutomaticallyAddOperator(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetAutomaticallyAddOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutomaticallyAddOperator()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetTryHarderCyclesTimes(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tryHarderCyclesTimes in the object.
    obj->data->SetTryHarderCyclesTimes(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetTryHarderCyclesTimes(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTryHarderCyclesTimes()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetTreatAllDBsAsTimeVarying(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the treatAllDBsAsTimeVarying in the object.
    obj->data->SetTreatAllDBsAsTimeVarying(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetTreatAllDBsAsTimeVarying(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTreatAllDBsAsTimeVarying()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetCreateMeshQualityExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createMeshQualityExpressions in the object.
    obj->data->SetCreateMeshQualityExpressions(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetCreateMeshQualityExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateMeshQualityExpressions()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetCreateTimeDerivativeExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createTimeDerivativeExpressions in the object.
    obj->data->SetCreateTimeDerivativeExpressions(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetCreateTimeDerivativeExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateTimeDerivativeExpressions()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetCreateVectorMagnitudeExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createVectorMagnitudeExpressions in the object.
    obj->data->SetCreateVectorMagnitudeExpressions(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetCreateVectorMagnitudeExpressions(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateVectorMagnitudeExpressions()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetNewPlotsInheritSILRestriction(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newPlotsInheritSILRestriction in the object.
    obj->data->SetNewPlotsInheritSILRestriction(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetNewPlotsInheritSILRestriction(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNewPlotsInheritSILRestriction()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetUserDirForSessionFiles(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userDirForSessionFiles in the object.
    obj->data->SetUserDirForSessionFiles(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetUserDirForSessionFiles(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserDirForSessionFiles()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetSaveCrashRecoveryFile(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the saveCrashRecoveryFile in the object.
    obj->data->SetSaveCrashRecoveryFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetSaveCrashRecoveryFile(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSaveCrashRecoveryFile()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetIgnoreExtentsFromDbs(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ignoreExtentsFromDbs in the object.
    obj->data->SetIgnoreExtentsFromDbs(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetIgnoreExtentsFromDbs(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIgnoreExtentsFromDbs()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetExpandNewPlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the expandNewPlots in the object.
    obj->data->SetExpandNewPlots(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetExpandNewPlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExpandNewPlots()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetUserRestoreSessionFile(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userRestoreSessionFile in the object.
    obj->data->SetUserRestoreSessionFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetUserRestoreSessionFile(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserRestoreSessionFile()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetPrecisionType(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the precisionType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetPrecisionType(GlobalAttributes::PrecisionType(ival));
    else
    {
        fprintf(stderr, "An invalid precisionType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Float, Native, Double.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetPrecisionType(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPrecisionType()));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetBackendType(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the backendType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetBackendType(GlobalAttributes::BackendType(ival));
    else
    {
        fprintf(stderr, "An invalid backendType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "VTK, EAVL, VTKM.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetBackendType(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBackendType()));
    return retval;
}

/*static*/ PyObject *
GlobalAttributes_SetRemoveDuplicateNodes(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the removeDuplicateNodes in the object.
    obj->data->SetRemoveDuplicateNodes(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalAttributes_GetRemoveDuplicateNodes(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRemoveDuplicateNodes()?1L:0L);
    return retval;
}



PyMethodDef PyGlobalAttributes_methods[GLOBALATTRIBUTES_NMETH] = {
    {"Notify", GlobalAttributes_Notify, METH_VARARGS},
    {"SetSources", GlobalAttributes_SetSources, METH_VARARGS},
    {"GetSources", GlobalAttributes_GetSources, METH_VARARGS},
    {"SetWindows", GlobalAttributes_SetWindows, METH_VARARGS},
    {"GetWindows", GlobalAttributes_GetWindows, METH_VARARGS},
    {"SetActiveWindow", GlobalAttributes_SetActiveWindow, METH_VARARGS},
    {"GetActiveWindow", GlobalAttributes_GetActiveWindow, METH_VARARGS},
    {"SetIconifiedFlag", GlobalAttributes_SetIconifiedFlag, METH_VARARGS},
    {"GetIconifiedFlag", GlobalAttributes_GetIconifiedFlag, METH_VARARGS},
    {"SetAutoUpdateFlag", GlobalAttributes_SetAutoUpdateFlag, METH_VARARGS},
    {"GetAutoUpdateFlag", GlobalAttributes_GetAutoUpdateFlag, METH_VARARGS},
    {"SetReplacePlots", GlobalAttributes_SetReplacePlots, METH_VARARGS},
    {"GetReplacePlots", GlobalAttributes_GetReplacePlots, METH_VARARGS},
    {"SetApplyOperator", GlobalAttributes_SetApplyOperator, METH_VARARGS},
    {"GetApplyOperator", GlobalAttributes_GetApplyOperator, METH_VARARGS},
    {"SetApplySelection", GlobalAttributes_SetApplySelection, METH_VARARGS},
    {"GetApplySelection", GlobalAttributes_GetApplySelection, METH_VARARGS},
    {"SetApplyWindow", GlobalAttributes_SetApplyWindow, METH_VARARGS},
    {"GetApplyWindow", GlobalAttributes_GetApplyWindow, METH_VARARGS},
    {"SetExecuting", GlobalAttributes_SetExecuting, METH_VARARGS},
    {"GetExecuting", GlobalAttributes_GetExecuting, METH_VARARGS},
    {"SetWindowLayout", GlobalAttributes_SetWindowLayout, METH_VARARGS},
    {"GetWindowLayout", GlobalAttributes_GetWindowLayout, METH_VARARGS},
    {"SetMakeDefaultConfirm", GlobalAttributes_SetMakeDefaultConfirm, METH_VARARGS},
    {"GetMakeDefaultConfirm", GlobalAttributes_GetMakeDefaultConfirm, METH_VARARGS},
    {"SetCloneWindowOnFirstRef", GlobalAttributes_SetCloneWindowOnFirstRef, METH_VARARGS},
    {"GetCloneWindowOnFirstRef", GlobalAttributes_GetCloneWindowOnFirstRef, METH_VARARGS},
    {"SetAutomaticallyAddOperator", GlobalAttributes_SetAutomaticallyAddOperator, METH_VARARGS},
    {"GetAutomaticallyAddOperator", GlobalAttributes_GetAutomaticallyAddOperator, METH_VARARGS},
    {"SetTryHarderCyclesTimes", GlobalAttributes_SetTryHarderCyclesTimes, METH_VARARGS},
    {"GetTryHarderCyclesTimes", GlobalAttributes_GetTryHarderCyclesTimes, METH_VARARGS},
    {"SetTreatAllDBsAsTimeVarying", GlobalAttributes_SetTreatAllDBsAsTimeVarying, METH_VARARGS},
    {"GetTreatAllDBsAsTimeVarying", GlobalAttributes_GetTreatAllDBsAsTimeVarying, METH_VARARGS},
    {"SetCreateMeshQualityExpressions", GlobalAttributes_SetCreateMeshQualityExpressions, METH_VARARGS},
    {"GetCreateMeshQualityExpressions", GlobalAttributes_GetCreateMeshQualityExpressions, METH_VARARGS},
    {"SetCreateTimeDerivativeExpressions", GlobalAttributes_SetCreateTimeDerivativeExpressions, METH_VARARGS},
    {"GetCreateTimeDerivativeExpressions", GlobalAttributes_GetCreateTimeDerivativeExpressions, METH_VARARGS},
    {"SetCreateVectorMagnitudeExpressions", GlobalAttributes_SetCreateVectorMagnitudeExpressions, METH_VARARGS},
    {"GetCreateVectorMagnitudeExpressions", GlobalAttributes_GetCreateVectorMagnitudeExpressions, METH_VARARGS},
    {"SetNewPlotsInheritSILRestriction", GlobalAttributes_SetNewPlotsInheritSILRestriction, METH_VARARGS},
    {"GetNewPlotsInheritSILRestriction", GlobalAttributes_GetNewPlotsInheritSILRestriction, METH_VARARGS},
    {"SetUserDirForSessionFiles", GlobalAttributes_SetUserDirForSessionFiles, METH_VARARGS},
    {"GetUserDirForSessionFiles", GlobalAttributes_GetUserDirForSessionFiles, METH_VARARGS},
    {"SetSaveCrashRecoveryFile", GlobalAttributes_SetSaveCrashRecoveryFile, METH_VARARGS},
    {"GetSaveCrashRecoveryFile", GlobalAttributes_GetSaveCrashRecoveryFile, METH_VARARGS},
    {"SetIgnoreExtentsFromDbs", GlobalAttributes_SetIgnoreExtentsFromDbs, METH_VARARGS},
    {"GetIgnoreExtentsFromDbs", GlobalAttributes_GetIgnoreExtentsFromDbs, METH_VARARGS},
    {"SetExpandNewPlots", GlobalAttributes_SetExpandNewPlots, METH_VARARGS},
    {"GetExpandNewPlots", GlobalAttributes_GetExpandNewPlots, METH_VARARGS},
    {"SetUserRestoreSessionFile", GlobalAttributes_SetUserRestoreSessionFile, METH_VARARGS},
    {"GetUserRestoreSessionFile", GlobalAttributes_GetUserRestoreSessionFile, METH_VARARGS},
    {"SetPrecisionType", GlobalAttributes_SetPrecisionType, METH_VARARGS},
    {"GetPrecisionType", GlobalAttributes_GetPrecisionType, METH_VARARGS},
    {"SetBackendType", GlobalAttributes_SetBackendType, METH_VARARGS},
    {"GetBackendType", GlobalAttributes_GetBackendType, METH_VARARGS},
    {"SetRemoveDuplicateNodes", GlobalAttributes_SetRemoveDuplicateNodes, METH_VARARGS},
    {"GetRemoveDuplicateNodes", GlobalAttributes_GetRemoveDuplicateNodes, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GlobalAttributes_dealloc(PyObject *v)
{
   GlobalAttributesObject *obj = (GlobalAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
GlobalAttributes_compare(PyObject *v, PyObject *w)
{
    GlobalAttributes *a = ((GlobalAttributesObject *)v)->data;
    GlobalAttributes *b = ((GlobalAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyGlobalAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sources") == 0)
        return GlobalAttributes_GetSources(self, NULL);
    if(strcmp(name, "windows") == 0)
        return GlobalAttributes_GetWindows(self, NULL);
    if(strcmp(name, "activeWindow") == 0)
        return GlobalAttributes_GetActiveWindow(self, NULL);
    if(strcmp(name, "iconifiedFlag") == 0)
        return GlobalAttributes_GetIconifiedFlag(self, NULL);
    if(strcmp(name, "autoUpdateFlag") == 0)
        return GlobalAttributes_GetAutoUpdateFlag(self, NULL);
    if(strcmp(name, "replacePlots") == 0)
        return GlobalAttributes_GetReplacePlots(self, NULL);
    if(strcmp(name, "applyOperator") == 0)
        return GlobalAttributes_GetApplyOperator(self, NULL);
    if(strcmp(name, "applySelection") == 0)
        return GlobalAttributes_GetApplySelection(self, NULL);
    if(strcmp(name, "applyWindow") == 0)
        return GlobalAttributes_GetApplyWindow(self, NULL);
    if(strcmp(name, "executing") == 0)
        return GlobalAttributes_GetExecuting(self, NULL);
    if(strcmp(name, "windowLayout") == 0)
        return GlobalAttributes_GetWindowLayout(self, NULL);
    if(strcmp(name, "makeDefaultConfirm") == 0)
        return GlobalAttributes_GetMakeDefaultConfirm(self, NULL);
    if(strcmp(name, "cloneWindowOnFirstRef") == 0)
        return GlobalAttributes_GetCloneWindowOnFirstRef(self, NULL);
    if(strcmp(name, "automaticallyAddOperator") == 0)
        return GlobalAttributes_GetAutomaticallyAddOperator(self, NULL);
    if(strcmp(name, "tryHarderCyclesTimes") == 0)
        return GlobalAttributes_GetTryHarderCyclesTimes(self, NULL);
    if(strcmp(name, "treatAllDBsAsTimeVarying") == 0)
        return GlobalAttributes_GetTreatAllDBsAsTimeVarying(self, NULL);
    if(strcmp(name, "createMeshQualityExpressions") == 0)
        return GlobalAttributes_GetCreateMeshQualityExpressions(self, NULL);
    if(strcmp(name, "createTimeDerivativeExpressions") == 0)
        return GlobalAttributes_GetCreateTimeDerivativeExpressions(self, NULL);
    if(strcmp(name, "createVectorMagnitudeExpressions") == 0)
        return GlobalAttributes_GetCreateVectorMagnitudeExpressions(self, NULL);
    if(strcmp(name, "newPlotsInheritSILRestriction") == 0)
        return GlobalAttributes_GetNewPlotsInheritSILRestriction(self, NULL);
    if(strcmp(name, "userDirForSessionFiles") == 0)
        return GlobalAttributes_GetUserDirForSessionFiles(self, NULL);
    if(strcmp(name, "saveCrashRecoveryFile") == 0)
        return GlobalAttributes_GetSaveCrashRecoveryFile(self, NULL);
    if(strcmp(name, "ignoreExtentsFromDbs") == 0)
        return GlobalAttributes_GetIgnoreExtentsFromDbs(self, NULL);
    if(strcmp(name, "expandNewPlots") == 0)
        return GlobalAttributes_GetExpandNewPlots(self, NULL);
    if(strcmp(name, "userRestoreSessionFile") == 0)
        return GlobalAttributes_GetUserRestoreSessionFile(self, NULL);
    if(strcmp(name, "precisionType") == 0)
        return GlobalAttributes_GetPrecisionType(self, NULL);
    if(strcmp(name, "Float") == 0)
        return PyInt_FromLong(long(GlobalAttributes::Float));
    if(strcmp(name, "Native") == 0)
        return PyInt_FromLong(long(GlobalAttributes::Native));
    if(strcmp(name, "Double") == 0)
        return PyInt_FromLong(long(GlobalAttributes::Double));

    if(strcmp(name, "backendType") == 0)
        return GlobalAttributes_GetBackendType(self, NULL);
    if(strcmp(name, "VTK") == 0)
        return PyInt_FromLong(long(GlobalAttributes::VTK));
    if(strcmp(name, "EAVL") == 0)
        return PyInt_FromLong(long(GlobalAttributes::EAVL));
    if(strcmp(name, "VTKM") == 0)
        return PyInt_FromLong(long(GlobalAttributes::VTKM));

    if(strcmp(name, "removeDuplicateNodes") == 0)
        return GlobalAttributes_GetRemoveDuplicateNodes(self, NULL);

    return Py_FindMethod(PyGlobalAttributes_methods, self, name);
}

int
PyGlobalAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "sources") == 0)
        obj = GlobalAttributes_SetSources(self, tuple);
    else if(strcmp(name, "windows") == 0)
        obj = GlobalAttributes_SetWindows(self, tuple);
    else if(strcmp(name, "activeWindow") == 0)
        obj = GlobalAttributes_SetActiveWindow(self, tuple);
    else if(strcmp(name, "iconifiedFlag") == 0)
        obj = GlobalAttributes_SetIconifiedFlag(self, tuple);
    else if(strcmp(name, "autoUpdateFlag") == 0)
        obj = GlobalAttributes_SetAutoUpdateFlag(self, tuple);
    else if(strcmp(name, "replacePlots") == 0)
        obj = GlobalAttributes_SetReplacePlots(self, tuple);
    else if(strcmp(name, "applyOperator") == 0)
        obj = GlobalAttributes_SetApplyOperator(self, tuple);
    else if(strcmp(name, "applySelection") == 0)
        obj = GlobalAttributes_SetApplySelection(self, tuple);
    else if(strcmp(name, "applyWindow") == 0)
        obj = GlobalAttributes_SetApplyWindow(self, tuple);
    else if(strcmp(name, "executing") == 0)
        obj = GlobalAttributes_SetExecuting(self, tuple);
    else if(strcmp(name, "windowLayout") == 0)
        obj = GlobalAttributes_SetWindowLayout(self, tuple);
    else if(strcmp(name, "makeDefaultConfirm") == 0)
        obj = GlobalAttributes_SetMakeDefaultConfirm(self, tuple);
    else if(strcmp(name, "cloneWindowOnFirstRef") == 0)
        obj = GlobalAttributes_SetCloneWindowOnFirstRef(self, tuple);
    else if(strcmp(name, "automaticallyAddOperator") == 0)
        obj = GlobalAttributes_SetAutomaticallyAddOperator(self, tuple);
    else if(strcmp(name, "tryHarderCyclesTimes") == 0)
        obj = GlobalAttributes_SetTryHarderCyclesTimes(self, tuple);
    else if(strcmp(name, "treatAllDBsAsTimeVarying") == 0)
        obj = GlobalAttributes_SetTreatAllDBsAsTimeVarying(self, tuple);
    else if(strcmp(name, "createMeshQualityExpressions") == 0)
        obj = GlobalAttributes_SetCreateMeshQualityExpressions(self, tuple);
    else if(strcmp(name, "createTimeDerivativeExpressions") == 0)
        obj = GlobalAttributes_SetCreateTimeDerivativeExpressions(self, tuple);
    else if(strcmp(name, "createVectorMagnitudeExpressions") == 0)
        obj = GlobalAttributes_SetCreateVectorMagnitudeExpressions(self, tuple);
    else if(strcmp(name, "newPlotsInheritSILRestriction") == 0)
        obj = GlobalAttributes_SetNewPlotsInheritSILRestriction(self, tuple);
    else if(strcmp(name, "userDirForSessionFiles") == 0)
        obj = GlobalAttributes_SetUserDirForSessionFiles(self, tuple);
    else if(strcmp(name, "saveCrashRecoveryFile") == 0)
        obj = GlobalAttributes_SetSaveCrashRecoveryFile(self, tuple);
    else if(strcmp(name, "ignoreExtentsFromDbs") == 0)
        obj = GlobalAttributes_SetIgnoreExtentsFromDbs(self, tuple);
    else if(strcmp(name, "expandNewPlots") == 0)
        obj = GlobalAttributes_SetExpandNewPlots(self, tuple);
    else if(strcmp(name, "userRestoreSessionFile") == 0)
        obj = GlobalAttributes_SetUserRestoreSessionFile(self, tuple);
    else if(strcmp(name, "precisionType") == 0)
        obj = GlobalAttributes_SetPrecisionType(self, tuple);
    else if(strcmp(name, "backendType") == 0)
        obj = GlobalAttributes_SetBackendType(self, tuple);
    else if(strcmp(name, "removeDuplicateNodes") == 0)
        obj = GlobalAttributes_SetRemoveDuplicateNodes(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
GlobalAttributes_print(PyObject *v, FILE *fp, int flags)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)v;
    fprintf(fp, "%s", PyGlobalAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
GlobalAttributes_str(PyObject *v)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)v;
    return PyString_FromString(PyGlobalAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *GlobalAttributes_Purpose = "This class contains attributes associated with the main window.";
#else
static char *GlobalAttributes_Purpose = "This class contains attributes associated with the main window.";
#endif

//
// The type description structure
//
static PyTypeObject GlobalAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GlobalAttributes",                    // tp_name
    sizeof(GlobalAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GlobalAttributes_dealloc,  // tp_dealloc
    (printfunc)GlobalAttributes_print,     // tp_print
    (getattrfunc)PyGlobalAttributes_getattr, // tp_getattr
    (setattrfunc)PyGlobalAttributes_setattr, // tp_setattr
    (cmpfunc)GlobalAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GlobalAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GlobalAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GlobalAttributes *defaultAtts = 0;
static GlobalAttributes *currentAtts = 0;

static PyObject *
NewGlobalAttributes(int useCurrent)
{
    GlobalAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalAttributesObject, &GlobalAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new GlobalAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new GlobalAttributes(*defaultAtts);
    else
        newObject->data = new GlobalAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapGlobalAttributes(const GlobalAttributes *attr)
{
    GlobalAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalAttributesObject, &GlobalAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GlobalAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GlobalAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewGlobalAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GlobalAttributesMethods[] = {
    {"GlobalAttributes", GlobalAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GlobalAttributesObserver = 0;

std::string
PyGlobalAttributes_GetLogString()
{
    std::string s("GlobalAtts = GlobalAttributes()\n");
    if(currentAtts != 0)
        s += PyGlobalAttributes_ToString(currentAtts, "GlobalAtts.");
    return s;
}

static void
PyGlobalAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("GlobalAtts = GlobalAttributes()\n");
        s += PyGlobalAttributes_ToString(currentAtts, "GlobalAtts.");
        cb(s);
    }
}

void
PyGlobalAttributes_StartUp(GlobalAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyGlobalAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GlobalAttributesObserver == 0)
    {
        GlobalAttributesObserver = new ObserverToCallback(subj,
            PyGlobalAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyGlobalAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GlobalAttributesObserver;
    GlobalAttributesObserver = 0;
}

PyMethodDef *
PyGlobalAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GlobalAttributesMethods;
}

bool
PyGlobalAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &GlobalAttributesType);
}

GlobalAttributes *
PyGlobalAttributes_FromPyObject(PyObject *obj)
{
    GlobalAttributesObject *obj2 = (GlobalAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyGlobalAttributes_New()
{
    return NewGlobalAttributes(0);
}

PyObject *
PyGlobalAttributes_Wrap(const GlobalAttributes *attr)
{
    return WrapGlobalAttributes(attr);
}

void
PyGlobalAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    GlobalAttributesObject *obj2 = (GlobalAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyGlobalAttributes_SetDefaults(const GlobalAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GlobalAttributes(*atts);
}

