/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyVectorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyVectorAttributes
//
// Purpose: 
//   Attributes for the vector plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a VectorAttributes.
//
struct VectorAttributesObject
{
    PyObject_HEAD
    VectorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewVectorAttributes(int);

std::string
PyVectorAttributes_ToString(const VectorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *glyphLocation_names = "AdaptsToMeshResolution, UniformInSpace";
    switch (atts->GetGlyphLocation())
    {
      case VectorAttributes::AdaptsToMeshResolution:
          SNPRINTF(tmpStr, 1000, "%sglyphLocation = %sAdaptsToMeshResolution  # %s\n", prefix, prefix, glyphLocation_names);
          str += tmpStr;
          break;
      case VectorAttributes::UniformInSpace:
          SNPRINTF(tmpStr, 1000, "%sglyphLocation = %sUniformInSpace  # %s\n", prefix, prefix, glyphLocation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetUseStride())
        SNPRINTF(tmpStr, 1000, "%suseStride = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseStride = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snVectors = %d\n", prefix, atts->GetNVectors());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscale = %g\n", prefix, atts->GetScale());
    str += tmpStr;
    if(atts->GetScaleByMagnitude())
        SNPRINTF(tmpStr, 1000, "%sscaleByMagnitude = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sscaleByMagnitude = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutoScale())
        SNPRINTF(tmpStr, 1000, "%sautoScale = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sautoScale = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sheadSize = %g\n", prefix, atts->GetHeadSize());
    str += tmpStr;
    if(atts->GetHeadOn())
        SNPRINTF(tmpStr, 1000, "%sheadOn = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sheadOn = 0\n", prefix);
    str += tmpStr;
    if(atts->GetColorByMag())
        SNPRINTF(tmpStr, 1000, "%scolorByMag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scolorByMag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUseLegend())
        SNPRINTF(tmpStr, 1000, "%suseLegend = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseLegend = 0\n", prefix);
    str += tmpStr;
    const unsigned char *vectorColor = atts->GetVectorColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%svectorColor = (%d, %d, %d, %d)\n", prefix, int(vectorColor[0]), int(vectorColor[1]), int(vectorColor[2]), int(vectorColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    const char *vectorOrigin_names = "Head, Middle, Tail";
    switch (atts->GetVectorOrigin())
    {
      case VectorAttributes::Head:
          SNPRINTF(tmpStr, 1000, "%svectorOrigin = %sHead  # %s\n", prefix, prefix, vectorOrigin_names);
          str += tmpStr;
          break;
      case VectorAttributes::Middle:
          SNPRINTF(tmpStr, 1000, "%svectorOrigin = %sMiddle  # %s\n", prefix, prefix, vectorOrigin_names);
          str += tmpStr;
          break;
      case VectorAttributes::Tail:
          SNPRINTF(tmpStr, 1000, "%svectorOrigin = %sTail  # %s\n", prefix, prefix, vectorOrigin_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case VectorAttributes::OriginalData:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case VectorAttributes::CurrentPlot:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    const char *lineStem_names = "Cylinder, Line";
    switch (atts->GetLineStem())
    {
      case VectorAttributes::Cylinder:
          SNPRINTF(tmpStr, 1000, "%slineStem = %sCylinder  # %s\n", prefix, prefix, lineStem_names);
          str += tmpStr;
          break;
      case VectorAttributes::Line:
          SNPRINTF(tmpStr, 1000, "%slineStem = %sLine  # %s\n", prefix, prefix, lineStem_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *geometryQuality_names = "Fast, High";
    switch (atts->GetGeometryQuality())
    {
      case VectorAttributes::Fast:
          SNPRINTF(tmpStr, 1000, "%sgeometryQuality = %sFast  # %s\n", prefix, prefix, geometryQuality_names);
          str += tmpStr;
          break;
      case VectorAttributes::High:
          SNPRINTF(tmpStr, 1000, "%sgeometryQuality = %sHigh  # %s\n", prefix, prefix, geometryQuality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sstemWidth = %g\n", prefix, atts->GetStemWidth());
    str += tmpStr;
    if(atts->GetOrigOnly())
        SNPRINTF(tmpStr, 1000, "%sorigOnly = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sorigOnly = 0\n", prefix);
    str += tmpStr;
    const char *glyphType_names = "Arrow, Ellipsoid";
    switch (atts->GetGlyphType())
    {
      case VectorAttributes::Arrow:
          SNPRINTF(tmpStr, 1000, "%sglyphType = %sArrow  # %s\n", prefix, prefix, glyphType_names);
          str += tmpStr;
          break;
      case VectorAttributes::Ellipsoid:
          SNPRINTF(tmpStr, 1000, "%sglyphType = %sEllipsoid  # %s\n", prefix, prefix, glyphType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sanimationStep = %d\n", prefix, atts->GetAnimationStep());
    str += tmpStr;
    return str;
}

static PyObject *
VectorAttributes_Notify(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_SetGlyphLocation(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the glyphLocation in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGlyphLocation(VectorAttributes::GlyphLocation(ival));
    else
    {
        fprintf(stderr, "An invalid glyphLocation value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "AdaptsToMeshResolution, UniformInSpace.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetGlyphLocation(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGlyphLocation()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetUseStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useStride in the object.
    obj->data->SetUseStride(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetUseStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseStride()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetNVectors(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nVectors in the object.
    obj->data->SetNVectors((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetNVectors(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNVectors()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetScaleByMagnitude(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleByMagnitude in the object.
    obj->data->SetScaleByMagnitude(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetScaleByMagnitude(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleByMagnitude()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetAutoScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoScale in the object.
    obj->data->SetAutoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetAutoScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoScale()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetHeadSize(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the headSize in the object.
    obj->data->SetHeadSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetHeadSize(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHeadSize());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetHeadOn(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the headOn in the object.
    obj->data->SetHeadOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetHeadOn(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHeadOn()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetColorByMag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByMag in the object.
    obj->data->SetColorByMag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetColorByMag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByMag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetUseLegend(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useLegend in the object.
    obj->data->SetUseLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetUseLegend(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseLegend()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetVectorColor(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the vectorColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetVectorColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetVectorColor(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the vectorColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *vectorColor = obj->data->GetVectorColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(vectorColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(vectorColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(vectorColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(vectorColor[3])));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetVectorOrigin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the vectorOrigin in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVectorOrigin(VectorAttributes::OriginType(ival));
    else
    {
        fprintf(stderr, "An invalid vectorOrigin value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Head, Middle, Tail.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetVectorOrigin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVectorOrigin()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(VectorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetMin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetMin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetMax(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetMax(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetLineStem(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStem in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLineStem(VectorAttributes::LineStem(ival));
    else
    {
        fprintf(stderr, "An invalid lineStem value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Cylinder, Line.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetLineStem(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStem()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetGeometryQuality(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the geometryQuality in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGeometryQuality(VectorAttributes::Quality(ival));
    else
    {
        fprintf(stderr, "An invalid geometryQuality value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Fast, High.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetGeometryQuality(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGeometryQuality()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetStemWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the stemWidth in the object.
    obj->data->SetStemWidth(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetStemWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStemWidth());
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetOrigOnly(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the origOnly in the object.
    obj->data->SetOrigOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetOrigOnly(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOrigOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetGlyphType(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the glyphType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGlyphType(VectorAttributes::GlyphType(ival));
    else
    {
        fprintf(stderr, "An invalid glyphType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Arrow, Ellipsoid.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetGlyphType(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGlyphType()));
    return retval;
}

/*static*/ PyObject *
VectorAttributes_SetAnimationStep(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the animationStep in the object.
    obj->data->SetAnimationStep((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VectorAttributes_GetAnimationStep(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnimationStep()));
    return retval;
}



PyMethodDef PyVectorAttributes_methods[VECTORATTRIBUTES_NMETH] = {
    {"Notify", VectorAttributes_Notify, METH_VARARGS},
    {"SetGlyphLocation", VectorAttributes_SetGlyphLocation, METH_VARARGS},
    {"GetGlyphLocation", VectorAttributes_GetGlyphLocation, METH_VARARGS},
    {"SetUseStride", VectorAttributes_SetUseStride, METH_VARARGS},
    {"GetUseStride", VectorAttributes_GetUseStride, METH_VARARGS},
    {"SetStride", VectorAttributes_SetStride, METH_VARARGS},
    {"GetStride", VectorAttributes_GetStride, METH_VARARGS},
    {"SetNVectors", VectorAttributes_SetNVectors, METH_VARARGS},
    {"GetNVectors", VectorAttributes_GetNVectors, METH_VARARGS},
    {"SetLineWidth", VectorAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", VectorAttributes_GetLineWidth, METH_VARARGS},
    {"SetScale", VectorAttributes_SetScale, METH_VARARGS},
    {"GetScale", VectorAttributes_GetScale, METH_VARARGS},
    {"SetScaleByMagnitude", VectorAttributes_SetScaleByMagnitude, METH_VARARGS},
    {"GetScaleByMagnitude", VectorAttributes_GetScaleByMagnitude, METH_VARARGS},
    {"SetAutoScale", VectorAttributes_SetAutoScale, METH_VARARGS},
    {"GetAutoScale", VectorAttributes_GetAutoScale, METH_VARARGS},
    {"SetHeadSize", VectorAttributes_SetHeadSize, METH_VARARGS},
    {"GetHeadSize", VectorAttributes_GetHeadSize, METH_VARARGS},
    {"SetHeadOn", VectorAttributes_SetHeadOn, METH_VARARGS},
    {"GetHeadOn", VectorAttributes_GetHeadOn, METH_VARARGS},
    {"SetColorByMag", VectorAttributes_SetColorByMag, METH_VARARGS},
    {"GetColorByMag", VectorAttributes_GetColorByMag, METH_VARARGS},
    {"SetUseLegend", VectorAttributes_SetUseLegend, METH_VARARGS},
    {"GetUseLegend", VectorAttributes_GetUseLegend, METH_VARARGS},
    {"SetVectorColor", VectorAttributes_SetVectorColor, METH_VARARGS},
    {"GetVectorColor", VectorAttributes_GetVectorColor, METH_VARARGS},
    {"SetColorTableName", VectorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", VectorAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", VectorAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", VectorAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetVectorOrigin", VectorAttributes_SetVectorOrigin, METH_VARARGS},
    {"GetVectorOrigin", VectorAttributes_GetVectorOrigin, METH_VARARGS},
    {"SetMinFlag", VectorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", VectorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", VectorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", VectorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetLimitsMode", VectorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", VectorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMin", VectorAttributes_SetMin, METH_VARARGS},
    {"GetMin", VectorAttributes_GetMin, METH_VARARGS},
    {"SetMax", VectorAttributes_SetMax, METH_VARARGS},
    {"GetMax", VectorAttributes_GetMax, METH_VARARGS},
    {"SetLineStem", VectorAttributes_SetLineStem, METH_VARARGS},
    {"GetLineStem", VectorAttributes_GetLineStem, METH_VARARGS},
    {"SetGeometryQuality", VectorAttributes_SetGeometryQuality, METH_VARARGS},
    {"GetGeometryQuality", VectorAttributes_GetGeometryQuality, METH_VARARGS},
    {"SetStemWidth", VectorAttributes_SetStemWidth, METH_VARARGS},
    {"GetStemWidth", VectorAttributes_GetStemWidth, METH_VARARGS},
    {"SetOrigOnly", VectorAttributes_SetOrigOnly, METH_VARARGS},
    {"GetOrigOnly", VectorAttributes_GetOrigOnly, METH_VARARGS},
    {"SetGlyphType", VectorAttributes_SetGlyphType, METH_VARARGS},
    {"GetGlyphType", VectorAttributes_GetGlyphType, METH_VARARGS},
    {"SetAnimationStep", VectorAttributes_SetAnimationStep, METH_VARARGS},
    {"GetAnimationStep", VectorAttributes_GetAnimationStep, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
VectorAttributes_dealloc(PyObject *v)
{
   VectorAttributesObject *obj = (VectorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
VectorAttributes_compare(PyObject *v, PyObject *w)
{
    VectorAttributes *a = ((VectorAttributesObject *)v)->data;
    VectorAttributes *b = ((VectorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyVectorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "glyphLocation") == 0)
        return VectorAttributes_GetGlyphLocation(self, NULL);
    if(strcmp(name, "AdaptsToMeshResolution") == 0)
        return PyInt_FromLong(long(VectorAttributes::AdaptsToMeshResolution));
    if(strcmp(name, "UniformInSpace") == 0)
        return PyInt_FromLong(long(VectorAttributes::UniformInSpace));

    if(strcmp(name, "useStride") == 0)
        return VectorAttributes_GetUseStride(self, NULL);
    if(strcmp(name, "stride") == 0)
        return VectorAttributes_GetStride(self, NULL);
    if(strcmp(name, "nVectors") == 0)
        return VectorAttributes_GetNVectors(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return VectorAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "scale") == 0)
        return VectorAttributes_GetScale(self, NULL);
    if(strcmp(name, "scaleByMagnitude") == 0)
        return VectorAttributes_GetScaleByMagnitude(self, NULL);
    if(strcmp(name, "autoScale") == 0)
        return VectorAttributes_GetAutoScale(self, NULL);
    if(strcmp(name, "headSize") == 0)
        return VectorAttributes_GetHeadSize(self, NULL);
    if(strcmp(name, "headOn") == 0)
        return VectorAttributes_GetHeadOn(self, NULL);
    if(strcmp(name, "colorByMag") == 0)
        return VectorAttributes_GetColorByMag(self, NULL);
    if(strcmp(name, "useLegend") == 0)
        return VectorAttributes_GetUseLegend(self, NULL);
    if(strcmp(name, "vectorColor") == 0)
        return VectorAttributes_GetVectorColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return VectorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return VectorAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "vectorOrigin") == 0)
        return VectorAttributes_GetVectorOrigin(self, NULL);
    if(strcmp(name, "Head") == 0)
        return PyInt_FromLong(long(VectorAttributes::Head));
    if(strcmp(name, "Middle") == 0)
        return PyInt_FromLong(long(VectorAttributes::Middle));
    if(strcmp(name, "Tail") == 0)
        return PyInt_FromLong(long(VectorAttributes::Tail));

    if(strcmp(name, "minFlag") == 0)
        return VectorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return VectorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return VectorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(VectorAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(VectorAttributes::CurrentPlot));

    if(strcmp(name, "min") == 0)
        return VectorAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return VectorAttributes_GetMax(self, NULL);
    if(strcmp(name, "lineStem") == 0)
        return VectorAttributes_GetLineStem(self, NULL);
    if(strcmp(name, "Cylinder") == 0)
        return PyInt_FromLong(long(VectorAttributes::Cylinder));
    if(strcmp(name, "Line") == 0)
        return PyInt_FromLong(long(VectorAttributes::Line));

    if(strcmp(name, "geometryQuality") == 0)
        return VectorAttributes_GetGeometryQuality(self, NULL);
    if(strcmp(name, "Fast") == 0)
        return PyInt_FromLong(long(VectorAttributes::Fast));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(VectorAttributes::High));

    if(strcmp(name, "stemWidth") == 0)
        return VectorAttributes_GetStemWidth(self, NULL);
    if(strcmp(name, "origOnly") == 0)
        return VectorAttributes_GetOrigOnly(self, NULL);
    if(strcmp(name, "glyphType") == 0)
        return VectorAttributes_GetGlyphType(self, NULL);
    if(strcmp(name, "Arrow") == 0)
        return PyInt_FromLong(long(VectorAttributes::Arrow));
    if(strcmp(name, "Ellipsoid") == 0)
        return PyInt_FromLong(long(VectorAttributes::Ellipsoid));

    if(strcmp(name, "animationStep") == 0)
        return VectorAttributes_GetAnimationStep(self, NULL);

    // Try and handle legacy fields in VectorAttributes
    if(strcmp(name, "highQuality") == 0)
    {
        VectorAttributesObject *vectorObj = (VectorAttributesObject *)self;
        bool highQuality = vectorObj->data->GetGeometryQuality() == VectorAttributes::High;
        return PyInt_FromLong(highQuality?1L:0L);
    }

    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid Vector "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyVectorAttributes_methods, self, name);
}

int
PyVectorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "glyphLocation") == 0)
        obj = VectorAttributes_SetGlyphLocation(self, tuple);
    else if(strcmp(name, "useStride") == 0)
        obj = VectorAttributes_SetUseStride(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = VectorAttributes_SetStride(self, tuple);
    else if(strcmp(name, "nVectors") == 0)
        obj = VectorAttributes_SetNVectors(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = VectorAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "scale") == 0)
        obj = VectorAttributes_SetScale(self, tuple);
    else if(strcmp(name, "scaleByMagnitude") == 0)
        obj = VectorAttributes_SetScaleByMagnitude(self, tuple);
    else if(strcmp(name, "autoScale") == 0)
        obj = VectorAttributes_SetAutoScale(self, tuple);
    else if(strcmp(name, "headSize") == 0)
        obj = VectorAttributes_SetHeadSize(self, tuple);
    else if(strcmp(name, "headOn") == 0)
        obj = VectorAttributes_SetHeadOn(self, tuple);
    else if(strcmp(name, "colorByMag") == 0)
        obj = VectorAttributes_SetColorByMag(self, tuple);
    else if(strcmp(name, "useLegend") == 0)
        obj = VectorAttributes_SetUseLegend(self, tuple);
    else if(strcmp(name, "vectorColor") == 0)
        obj = VectorAttributes_SetVectorColor(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = VectorAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = VectorAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "vectorOrigin") == 0)
        obj = VectorAttributes_SetVectorOrigin(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = VectorAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = VectorAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = VectorAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = VectorAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = VectorAttributes_SetMax(self, tuple);
    else if(strcmp(name, "lineStem") == 0)
        obj = VectorAttributes_SetLineStem(self, tuple);
    else if(strcmp(name, "geometryQuality") == 0)
        obj = VectorAttributes_SetGeometryQuality(self, tuple);
    else if(strcmp(name, "stemWidth") == 0)
        obj = VectorAttributes_SetStemWidth(self, tuple);
    else if(strcmp(name, "origOnly") == 0)
        obj = VectorAttributes_SetOrigOnly(self, tuple);
    else if(strcmp(name, "glyphType") == 0)
        obj = VectorAttributes_SetGlyphType(self, tuple);
    else if(strcmp(name, "animationStep") == 0)
        obj = VectorAttributes_SetAnimationStep(self, tuple);

   // Try and handle legacy fields in VectorAttributes
    if(obj == NULL)
    {
        VectorAttributesObject *VectorObj = (VectorAttributesObject *)self;
        if(strcmp(name, "highQuality") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                VectorObj->data->SetGeometryQuality(VectorAttributes::Fast);
            else
                VectorObj->data->SetGeometryQuality(VectorAttributes::High);

            Py_INCREF(Py_None);
            obj = Py_None;
        }
        if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
VectorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)v;
    fprintf(fp, "%s", PyVectorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
VectorAttributes_str(PyObject *v)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)v;
    return PyString_FromString(PyVectorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *VectorAttributes_Purpose = "Attributes for the vector plot";
#else
static char *VectorAttributes_Purpose = "Attributes for the vector plot";
#endif

//
// The type description structure
//
static PyTypeObject VectorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "VectorAttributes",                    // tp_name
    sizeof(VectorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)VectorAttributes_dealloc,  // tp_dealloc
    (printfunc)VectorAttributes_print,     // tp_print
    (getattrfunc)PyVectorAttributes_getattr, // tp_getattr
    (setattrfunc)PyVectorAttributes_setattr, // tp_setattr
    (cmpfunc)VectorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)VectorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    VectorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static VectorAttributes *defaultAtts = 0;
static VectorAttributes *currentAtts = 0;

static PyObject *
NewVectorAttributes(int useCurrent)
{
    VectorAttributesObject *newObject;
    newObject = PyObject_NEW(VectorAttributesObject, &VectorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new VectorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new VectorAttributes(*defaultAtts);
    else
        newObject->data = new VectorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapVectorAttributes(const VectorAttributes *attr)
{
    VectorAttributesObject *newObject;
    newObject = PyObject_NEW(VectorAttributesObject, &VectorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (VectorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
VectorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewVectorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef VectorAttributesMethods[] = {
    {"VectorAttributes", VectorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *VectorAttributesObserver = 0;

std::string
PyVectorAttributes_GetLogString()
{
    std::string s("VectorAtts = VectorAttributes()\n");
    if(currentAtts != 0)
        s += PyVectorAttributes_ToString(currentAtts, "VectorAtts.");
    return s;
}

static void
PyVectorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("VectorAtts = VectorAttributes()\n");
        s += PyVectorAttributes_ToString(currentAtts, "VectorAtts.");
        cb(s);
    }
}

void
PyVectorAttributes_StartUp(VectorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyVectorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(VectorAttributesObserver == 0)
    {
        VectorAttributesObserver = new ObserverToCallback(subj,
            PyVectorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyVectorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete VectorAttributesObserver;
    VectorAttributesObserver = 0;
}

PyMethodDef *
PyVectorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return VectorAttributesMethods;
}

bool
PyVectorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &VectorAttributesType);
}

VectorAttributes *
PyVectorAttributes_FromPyObject(PyObject *obj)
{
    VectorAttributesObject *obj2 = (VectorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyVectorAttributes_New()
{
    return NewVectorAttributes(0);
}

PyObject *
PyVectorAttributes_Wrap(const VectorAttributes *attr)
{
    return WrapVectorAttributes(attr);
}

void
PyVectorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    VectorAttributesObject *obj2 = (VectorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyVectorAttributes_SetDefaults(const VectorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new VectorAttributes(*atts);
}

