/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: ModelFitCommonPluginInfo.C
// ************************************************************************* //

#include <ModelFitPluginInfo.h>
#include <ModelFitAtts.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>
#include <avtSubsetsMetaData.h>
#include <avtScalarMetaData.h>
#include <avtVectorMetaData.h>
#include <avtTensorMetaData.h>
#include <avtSymmetricTensorMetaData.h>
#include <avtArrayMetaData.h>
#include <avtMaterialMetaData.h>
#include <avtSpeciesMetaData.h>
#include <avtCurveMetaData.h>
#include <avtLabelMetaData.h>

// ****************************************************************************
//  Method: ModelFitCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ModelFitCommonPluginInfo::AllocAttributes()
{
    return new ModelFitAtts;
}

// ****************************************************************************
//  Method: ModelFitCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ModelFit attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void 
ModelFitCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ModelFitAtts *) to) = *((ModelFitAtts *) from);
}
// ****************************************************************************
// Method:  ModelFitCommonPluginInfo::GetCreatedExpressions
//
// Purpose:
//   Get the expressions this operator can generate.
//
// Arguments:
//   md         the metadata to create our expressions around
//
// Programmer:  Rob Sisneros
// Creation:    omitted
//
//  Modifications:
//   Jeremy Meredith, Thu Jan 12 13:28:49 EST 2012
//   Some files, like curves, don't have expressions.  Don't assume
//   we have any meshes in our file.
//   
// ****************************************************************************
#include <string.h>

ExpressionList *
ModelFitCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    int numMeshes = md->GetNumMeshes();
    if (numMeshes == 0)
        return NULL;

    Expression *e = new Expression();

    char mesh[1024];
    strcpy(mesh, md->GetMesh(0)->name.c_str());

    std::string varname = "operators/ModelFit/model"; //(";
    //varname += mesh;
    //varname += ")";
    e->SetName(varname);
    char defn[1024];
    sprintf(defn, "point_constant(<%s>, 0)", mesh);
    e->SetDefinition(defn);
    e->SetMeshName(std::string(mesh));
    e->SetType(Expression::ScalarMeshVar);
    e->SetFromOperator(true);
    e->SetOperatorName("ModelFit");
    ExpressionList *expressions = new ExpressionList;
    expressions->AddExpressions(*e);
    delete e;

    e = new Expression();

    varname = "operators/ModelFit/distance"; //(";
    //varname += mesh;
    //varname += ")";
    e->SetName(varname);
    sprintf(defn, "point_constant(<%s>, 0)", mesh);
    e->SetDefinition(defn);
    e->SetMeshName(std::string(mesh));
    e->SetType(Expression::ScalarMeshVar);
    e->SetFromOperator(true);
    e->SetOperatorName("ModelFit");
    expressions->AddExpressions(*e);
    delete e;
    return expressions;
}

