/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <MetricThresholdAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for MetricThresholdAttributes::Preset
//

static const char *Preset_strings[] = {
"None", "Aspect_Ratio", "Aspect_Gamma", 
"Skew", "Taper", "Volume", 
"Stretch", "Diagonal", "Dimension", 
"Oddy", "Condition", "Jacobian", 
"Scaled_Jacobian", "Shear", "Shape", 
"Relative_Size", "Shape_and_Size", "Area", 
"Warpage", "Smallest_Angle", "Largest_Angle"
};

std::string
MetricThresholdAttributes::Preset_ToString(MetricThresholdAttributes::Preset t)
{
    int index = int(t);
    if(index < 0 || index >= 21) index = 0;
    return Preset_strings[index];
}

std::string
MetricThresholdAttributes::Preset_ToString(int t)
{
    int index = (t < 0 || t >= 21) ? 0 : t;
    return Preset_strings[index];
}

bool
MetricThresholdAttributes::Preset_FromString(const std::string &s, MetricThresholdAttributes::Preset &val)
{
    val = MetricThresholdAttributes::None;
    for(int i = 0; i < 21; ++i)
    {
        if(s == Preset_strings[i])
        {
            val = (Preset)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Init utility for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MetricThresholdAttributes::Init()
{
    preset = None;
    Hexahedron = false;
    hex_lower = 0;
    hex_upper = 0;
    Tetrahedron = false;
    tet_lower = 0;
    tet_upper = 0;
    Wedge = false;
    wed_lower = 0;
    wed_upper = 0;
    Pyramid = false;
    pyr_lower = 0;
    pyr_upper = 0;
    Triangle = false;
    tri_lower = 0;
    tri_upper = 0;
    Quad = false;
    quad_lower = 0;
    quad_upper = 0;

    MetricThresholdAttributes::SelectAll();
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Copy utility for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MetricThresholdAttributes::Copy(const MetricThresholdAttributes &obj)
{
    preset = obj.preset;
    Hexahedron = obj.Hexahedron;
    hex_lower = obj.hex_lower;
    hex_upper = obj.hex_upper;
    Tetrahedron = obj.Tetrahedron;
    tet_lower = obj.tet_lower;
    tet_upper = obj.tet_upper;
    Wedge = obj.Wedge;
    wed_lower = obj.wed_lower;
    wed_upper = obj.wed_upper;
    Pyramid = obj.Pyramid;
    pyr_lower = obj.pyr_lower;
    pyr_upper = obj.pyr_upper;
    Triangle = obj.Triangle;
    tri_lower = obj.tri_lower;
    tri_upper = obj.tri_upper;
    Quad = obj.Quad;
    quad_lower = obj.quad_lower;
    quad_upper = obj.quad_upper;

    MetricThresholdAttributes::SelectAll();
}

// Type map format string
const char *MetricThresholdAttributes::TypeMapFormatString = METRICTHRESHOLDATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t MetricThresholdAttributes::TmfsStruct = {METRICTHRESHOLDATTRIBUTES_TMFS};


// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Default constructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes() : 
    AttributeSubject(MetricThresholdAttributes::TypeMapFormatString)
{
    MetricThresholdAttributes::Init();
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Constructor for the derived classes of MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    MetricThresholdAttributes::Init();
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Copy constructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes(const MetricThresholdAttributes &obj) : 
    AttributeSubject(MetricThresholdAttributes::TypeMapFormatString)
{
    MetricThresholdAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MetricThresholdAttributes::MetricThresholdAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::MetricThresholdAttributes(const MetricThresholdAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    MetricThresholdAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MetricThresholdAttributes::~MetricThresholdAttributes
//
// Purpose: 
//   Destructor for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes::~MetricThresholdAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MetricThresholdAttributes& 
MetricThresholdAttributes::operator = (const MetricThresholdAttributes &obj)
{
    if (this == &obj) return *this;

    MetricThresholdAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::operator == (const MetricThresholdAttributes &obj) const
{
    // Create the return value
    return ((preset == obj.preset) &&
            (Hexahedron == obj.Hexahedron) &&
            (hex_lower == obj.hex_lower) &&
            (hex_upper == obj.hex_upper) &&
            (Tetrahedron == obj.Tetrahedron) &&
            (tet_lower == obj.tet_lower) &&
            (tet_upper == obj.tet_upper) &&
            (Wedge == obj.Wedge) &&
            (wed_lower == obj.wed_lower) &&
            (wed_upper == obj.wed_upper) &&
            (Pyramid == obj.Pyramid) &&
            (pyr_lower == obj.pyr_lower) &&
            (pyr_upper == obj.pyr_upper) &&
            (Triangle == obj.Triangle) &&
            (tri_lower == obj.tri_lower) &&
            (tri_upper == obj.tri_upper) &&
            (Quad == obj.Quad) &&
            (quad_lower == obj.quad_lower) &&
            (quad_upper == obj.quad_upper));
}

// ****************************************************************************
// Method: MetricThresholdAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::operator != (const MetricThresholdAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MetricThresholdAttributes::TypeName
//
// Purpose: 
//   Type name method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
MetricThresholdAttributes::TypeName() const
{
    return "MetricThresholdAttributes";
}

// ****************************************************************************
// Method: MetricThresholdAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MetricThresholdAttributes *tmp = (const MetricThresholdAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MetricThresholdAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MetricThresholdAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MetricThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MetricThresholdAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MetricThresholdAttributes(*this);
    else
        retval = new MetricThresholdAttributes;

    return retval;
}

// ****************************************************************************
// Method: MetricThresholdAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MetricThresholdAttributes::SelectAll()
{
    Select(ID_preset,      (void *)&preset);
    Select(ID_Hexahedron,  (void *)&Hexahedron);
    Select(ID_hex_lower,   (void *)&hex_lower);
    Select(ID_hex_upper,   (void *)&hex_upper);
    Select(ID_Tetrahedron, (void *)&Tetrahedron);
    Select(ID_tet_lower,   (void *)&tet_lower);
    Select(ID_tet_upper,   (void *)&tet_upper);
    Select(ID_Wedge,       (void *)&Wedge);
    Select(ID_wed_lower,   (void *)&wed_lower);
    Select(ID_wed_upper,   (void *)&wed_upper);
    Select(ID_Pyramid,     (void *)&Pyramid);
    Select(ID_pyr_lower,   (void *)&pyr_lower);
    Select(ID_pyr_upper,   (void *)&pyr_upper);
    Select(ID_Triangle,    (void *)&Triangle);
    Select(ID_tri_lower,   (void *)&tri_lower);
    Select(ID_tri_upper,   (void *)&tri_upper);
    Select(ID_Quad,        (void *)&Quad);
    Select(ID_quad_lower,  (void *)&quad_lower);
    Select(ID_quad_upper,  (void *)&quad_upper);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MetricThresholdAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MetricThresholdAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MetricThresholdAttributes.
    DataNode *node = new DataNode("MetricThresholdAttributes");

    if(completeSave || !FieldsEqual(ID_preset, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("preset", Preset_ToString(preset)));
    }

    if(completeSave || !FieldsEqual(ID_Hexahedron, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Hexahedron", Hexahedron));
    }

    if(completeSave || !FieldsEqual(ID_hex_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hex_lower", hex_lower));
    }

    if(completeSave || !FieldsEqual(ID_hex_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hex_upper", hex_upper));
    }

    if(completeSave || !FieldsEqual(ID_Tetrahedron, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Tetrahedron", Tetrahedron));
    }

    if(completeSave || !FieldsEqual(ID_tet_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tet_lower", tet_lower));
    }

    if(completeSave || !FieldsEqual(ID_tet_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tet_upper", tet_upper));
    }

    if(completeSave || !FieldsEqual(ID_Wedge, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Wedge", Wedge));
    }

    if(completeSave || !FieldsEqual(ID_wed_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wed_lower", wed_lower));
    }

    if(completeSave || !FieldsEqual(ID_wed_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wed_upper", wed_upper));
    }

    if(completeSave || !FieldsEqual(ID_Pyramid, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Pyramid", Pyramid));
    }

    if(completeSave || !FieldsEqual(ID_pyr_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pyr_lower", pyr_lower));
    }

    if(completeSave || !FieldsEqual(ID_pyr_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pyr_upper", pyr_upper));
    }

    if(completeSave || !FieldsEqual(ID_Triangle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Triangle", Triangle));
    }

    if(completeSave || !FieldsEqual(ID_tri_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tri_lower", tri_lower));
    }

    if(completeSave || !FieldsEqual(ID_tri_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tri_upper", tri_upper));
    }

    if(completeSave || !FieldsEqual(ID_Quad, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("Quad", Quad));
    }

    if(completeSave || !FieldsEqual(ID_quad_lower, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("quad_lower", quad_lower));
    }

    if(completeSave || !FieldsEqual(ID_quad_upper, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("quad_upper", quad_upper));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MetricThresholdAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MetricThresholdAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MetricThresholdAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("preset")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 21)
                SetPreset(Preset(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Preset value;
            if(Preset_FromString(node->AsString(), value))
                SetPreset(value);
        }
    }
    if((node = searchNode->GetNode("Hexahedron")) != 0)
        SetHexahedron(node->AsBool());
    if((node = searchNode->GetNode("hex_lower")) != 0)
        SetHex_lower(node->AsDouble());
    if((node = searchNode->GetNode("hex_upper")) != 0)
        SetHex_upper(node->AsDouble());
    if((node = searchNode->GetNode("Tetrahedron")) != 0)
        SetTetrahedron(node->AsBool());
    if((node = searchNode->GetNode("tet_lower")) != 0)
        SetTet_lower(node->AsDouble());
    if((node = searchNode->GetNode("tet_upper")) != 0)
        SetTet_upper(node->AsDouble());
    if((node = searchNode->GetNode("Wedge")) != 0)
        SetWedge(node->AsBool());
    if((node = searchNode->GetNode("wed_lower")) != 0)
        SetWed_lower(node->AsDouble());
    if((node = searchNode->GetNode("wed_upper")) != 0)
        SetWed_upper(node->AsDouble());
    if((node = searchNode->GetNode("Pyramid")) != 0)
        SetPyramid(node->AsBool());
    if((node = searchNode->GetNode("pyr_lower")) != 0)
        SetPyr_lower(node->AsDouble());
    if((node = searchNode->GetNode("pyr_upper")) != 0)
        SetPyr_upper(node->AsDouble());
    if((node = searchNode->GetNode("Triangle")) != 0)
        SetTriangle(node->AsBool());
    if((node = searchNode->GetNode("tri_lower")) != 0)
        SetTri_lower(node->AsDouble());
    if((node = searchNode->GetNode("tri_upper")) != 0)
        SetTri_upper(node->AsDouble());
    if((node = searchNode->GetNode("Quad")) != 0)
        SetQuad(node->AsBool());
    if((node = searchNode->GetNode("quad_lower")) != 0)
        SetQuad_lower(node->AsDouble());
    if((node = searchNode->GetNode("quad_upper")) != 0)
        SetQuad_upper(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MetricThresholdAttributes::SetPreset(MetricThresholdAttributes::Preset preset_)
{
    preset = preset_;
    Select(ID_preset, (void *)&preset);
}

void
MetricThresholdAttributes::SetHexahedron(bool Hexahedron_)
{
    Hexahedron = Hexahedron_;
    Select(ID_Hexahedron, (void *)&Hexahedron);
}

void
MetricThresholdAttributes::SetHex_lower(double hex_lower_)
{
    hex_lower = hex_lower_;
    Select(ID_hex_lower, (void *)&hex_lower);
}

void
MetricThresholdAttributes::SetHex_upper(double hex_upper_)
{
    hex_upper = hex_upper_;
    Select(ID_hex_upper, (void *)&hex_upper);
}

void
MetricThresholdAttributes::SetTetrahedron(bool Tetrahedron_)
{
    Tetrahedron = Tetrahedron_;
    Select(ID_Tetrahedron, (void *)&Tetrahedron);
}

void
MetricThresholdAttributes::SetTet_lower(double tet_lower_)
{
    tet_lower = tet_lower_;
    Select(ID_tet_lower, (void *)&tet_lower);
}

void
MetricThresholdAttributes::SetTet_upper(double tet_upper_)
{
    tet_upper = tet_upper_;
    Select(ID_tet_upper, (void *)&tet_upper);
}

void
MetricThresholdAttributes::SetWedge(bool Wedge_)
{
    Wedge = Wedge_;
    Select(ID_Wedge, (void *)&Wedge);
}

void
MetricThresholdAttributes::SetWed_lower(double wed_lower_)
{
    wed_lower = wed_lower_;
    Select(ID_wed_lower, (void *)&wed_lower);
}

void
MetricThresholdAttributes::SetWed_upper(double wed_upper_)
{
    wed_upper = wed_upper_;
    Select(ID_wed_upper, (void *)&wed_upper);
}

void
MetricThresholdAttributes::SetPyramid(bool Pyramid_)
{
    Pyramid = Pyramid_;
    Select(ID_Pyramid, (void *)&Pyramid);
}

void
MetricThresholdAttributes::SetPyr_lower(double pyr_lower_)
{
    pyr_lower = pyr_lower_;
    Select(ID_pyr_lower, (void *)&pyr_lower);
}

void
MetricThresholdAttributes::SetPyr_upper(double pyr_upper_)
{
    pyr_upper = pyr_upper_;
    Select(ID_pyr_upper, (void *)&pyr_upper);
}

void
MetricThresholdAttributes::SetTriangle(bool Triangle_)
{
    Triangle = Triangle_;
    Select(ID_Triangle, (void *)&Triangle);
}

void
MetricThresholdAttributes::SetTri_lower(double tri_lower_)
{
    tri_lower = tri_lower_;
    Select(ID_tri_lower, (void *)&tri_lower);
}

void
MetricThresholdAttributes::SetTri_upper(double tri_upper_)
{
    tri_upper = tri_upper_;
    Select(ID_tri_upper, (void *)&tri_upper);
}

void
MetricThresholdAttributes::SetQuad(bool Quad_)
{
    Quad = Quad_;
    Select(ID_Quad, (void *)&Quad);
}

void
MetricThresholdAttributes::SetQuad_lower(double quad_lower_)
{
    quad_lower = quad_lower_;
    Select(ID_quad_lower, (void *)&quad_lower);
}

void
MetricThresholdAttributes::SetQuad_upper(double quad_upper_)
{
    quad_upper = quad_upper_;
    Select(ID_quad_upper, (void *)&quad_upper);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

MetricThresholdAttributes::Preset
MetricThresholdAttributes::GetPreset() const
{
    return Preset(preset);
}

bool
MetricThresholdAttributes::GetHexahedron() const
{
    return Hexahedron;
}

double
MetricThresholdAttributes::GetHex_lower() const
{
    return hex_lower;
}

double
MetricThresholdAttributes::GetHex_upper() const
{
    return hex_upper;
}

bool
MetricThresholdAttributes::GetTetrahedron() const
{
    return Tetrahedron;
}

double
MetricThresholdAttributes::GetTet_lower() const
{
    return tet_lower;
}

double
MetricThresholdAttributes::GetTet_upper() const
{
    return tet_upper;
}

bool
MetricThresholdAttributes::GetWedge() const
{
    return Wedge;
}

double
MetricThresholdAttributes::GetWed_lower() const
{
    return wed_lower;
}

double
MetricThresholdAttributes::GetWed_upper() const
{
    return wed_upper;
}

bool
MetricThresholdAttributes::GetPyramid() const
{
    return Pyramid;
}

double
MetricThresholdAttributes::GetPyr_lower() const
{
    return pyr_lower;
}

double
MetricThresholdAttributes::GetPyr_upper() const
{
    return pyr_upper;
}

bool
MetricThresholdAttributes::GetTriangle() const
{
    return Triangle;
}

double
MetricThresholdAttributes::GetTri_lower() const
{
    return tri_lower;
}

double
MetricThresholdAttributes::GetTri_upper() const
{
    return tri_upper;
}

bool
MetricThresholdAttributes::GetQuad() const
{
    return Quad;
}

double
MetricThresholdAttributes::GetQuad_lower() const
{
    return quad_lower;
}

double
MetricThresholdAttributes::GetQuad_upper() const
{
    return quad_upper;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MetricThresholdAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_preset:      return "preset";
    case ID_Hexahedron:  return "Hexahedron";
    case ID_hex_lower:   return "hex_lower";
    case ID_hex_upper:   return "hex_upper";
    case ID_Tetrahedron: return "Tetrahedron";
    case ID_tet_lower:   return "tet_lower";
    case ID_tet_upper:   return "tet_upper";
    case ID_Wedge:       return "Wedge";
    case ID_wed_lower:   return "wed_lower";
    case ID_wed_upper:   return "wed_upper";
    case ID_Pyramid:     return "Pyramid";
    case ID_pyr_lower:   return "pyr_lower";
    case ID_pyr_upper:   return "pyr_upper";
    case ID_Triangle:    return "Triangle";
    case ID_tri_lower:   return "tri_lower";
    case ID_tri_upper:   return "tri_upper";
    case ID_Quad:        return "Quad";
    case ID_quad_lower:  return "quad_lower";
    case ID_quad_upper:  return "quad_upper";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MetricThresholdAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_preset:      return FieldType_enum;
    case ID_Hexahedron:  return FieldType_bool;
    case ID_hex_lower:   return FieldType_double;
    case ID_hex_upper:   return FieldType_double;
    case ID_Tetrahedron: return FieldType_bool;
    case ID_tet_lower:   return FieldType_double;
    case ID_tet_upper:   return FieldType_double;
    case ID_Wedge:       return FieldType_bool;
    case ID_wed_lower:   return FieldType_double;
    case ID_wed_upper:   return FieldType_double;
    case ID_Pyramid:     return FieldType_bool;
    case ID_pyr_lower:   return FieldType_double;
    case ID_pyr_upper:   return FieldType_double;
    case ID_Triangle:    return FieldType_bool;
    case ID_tri_lower:   return FieldType_double;
    case ID_tri_upper:   return FieldType_double;
    case ID_Quad:        return FieldType_bool;
    case ID_quad_lower:  return FieldType_double;
    case ID_quad_upper:  return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MetricThresholdAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_preset:      return "enum";
    case ID_Hexahedron:  return "bool";
    case ID_hex_lower:   return "double";
    case ID_hex_upper:   return "double";
    case ID_Tetrahedron: return "bool";
    case ID_tet_lower:   return "double";
    case ID_tet_upper:   return "double";
    case ID_Wedge:       return "bool";
    case ID_wed_lower:   return "double";
    case ID_wed_upper:   return "double";
    case ID_Pyramid:     return "bool";
    case ID_pyr_lower:   return "double";
    case ID_pyr_upper:   return "double";
    case ID_Triangle:    return "bool";
    case ID_tri_lower:   return "double";
    case ID_tri_upper:   return "double";
    case ID_Quad:        return "bool";
    case ID_quad_lower:  return "double";
    case ID_quad_upper:  return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MetricThresholdAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MetricThresholdAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MetricThresholdAttributes &obj = *((const MetricThresholdAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_preset:
        {  // new scope
        retval = (preset == obj.preset);
        }
        break;
    case ID_Hexahedron:
        {  // new scope
        retval = (Hexahedron == obj.Hexahedron);
        }
        break;
    case ID_hex_lower:
        {  // new scope
        retval = (hex_lower == obj.hex_lower);
        }
        break;
    case ID_hex_upper:
        {  // new scope
        retval = (hex_upper == obj.hex_upper);
        }
        break;
    case ID_Tetrahedron:
        {  // new scope
        retval = (Tetrahedron == obj.Tetrahedron);
        }
        break;
    case ID_tet_lower:
        {  // new scope
        retval = (tet_lower == obj.tet_lower);
        }
        break;
    case ID_tet_upper:
        {  // new scope
        retval = (tet_upper == obj.tet_upper);
        }
        break;
    case ID_Wedge:
        {  // new scope
        retval = (Wedge == obj.Wedge);
        }
        break;
    case ID_wed_lower:
        {  // new scope
        retval = (wed_lower == obj.wed_lower);
        }
        break;
    case ID_wed_upper:
        {  // new scope
        retval = (wed_upper == obj.wed_upper);
        }
        break;
    case ID_Pyramid:
        {  // new scope
        retval = (Pyramid == obj.Pyramid);
        }
        break;
    case ID_pyr_lower:
        {  // new scope
        retval = (pyr_lower == obj.pyr_lower);
        }
        break;
    case ID_pyr_upper:
        {  // new scope
        retval = (pyr_upper == obj.pyr_upper);
        }
        break;
    case ID_Triangle:
        {  // new scope
        retval = (Triangle == obj.Triangle);
        }
        break;
    case ID_tri_lower:
        {  // new scope
        retval = (tri_lower == obj.tri_lower);
        }
        break;
    case ID_tri_upper:
        {  // new scope
        retval = (tri_upper == obj.tri_upper);
        }
        break;
    case ID_Quad:
        {  // new scope
        retval = (Quad == obj.Quad);
        }
        break;
    case ID_quad_lower:
        {  // new scope
        retval = (quad_lower == obj.quad_lower);
        }
        break;
    case ID_quad_upper:
        {  // new scope
        retval = (quad_upper == obj.quad_upper);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

