/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisCoordSwapWindow.h"

#include <CoordSwapAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisCoordSwapWindow::QvisCoordSwapWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCoordSwapWindow::QvisCoordSwapWindow(const int type,
                         CoordSwapAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisCoordSwapWindow::~QvisCoordSwapWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCoordSwapWindow::~QvisCoordSwapWindow()
{
}


// ****************************************************************************
// Method: QvisCoordSwapWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCoordSwapWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    newCoord1Label = new QLabel(tr("New Coordinate 1"), central);
    mainLayout->addWidget(newCoord1Label,0,0);
    newCoord1 = new QWidget(central);
    newCoord1ButtonGroup= new QButtonGroup(newCoord1);
    QHBoxLayout *newCoord1Layout = new QHBoxLayout(newCoord1);
    newCoord1Layout->setMargin(0);
    newCoord1Layout->setSpacing(10);
    QRadioButton *newCoord1CoordCoord1 = new QRadioButton(tr("Coord1"), newCoord1);
    newCoord1ButtonGroup->addButton(newCoord1CoordCoord1,0);
    newCoord1Layout->addWidget(newCoord1CoordCoord1);
    QRadioButton *newCoord1CoordCoord2 = new QRadioButton(tr("Coord2"), newCoord1);
    newCoord1ButtonGroup->addButton(newCoord1CoordCoord2,1);
    newCoord1Layout->addWidget(newCoord1CoordCoord2);
    QRadioButton *newCoord1CoordCoord3 = new QRadioButton(tr("Coord3"), newCoord1);
    newCoord1ButtonGroup->addButton(newCoord1CoordCoord3,2);
    newCoord1Layout->addWidget(newCoord1CoordCoord3);
    connect(newCoord1ButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(newCoord1Changed(int)));
    mainLayout->addWidget(newCoord1, 0,1);

    newCoord2Label = new QLabel(tr("New Coordinate 2"), central);
    mainLayout->addWidget(newCoord2Label,1,0);
    newCoord2 = new QWidget(central);
    newCoord2ButtonGroup= new QButtonGroup(newCoord2);
    QHBoxLayout *newCoord2Layout = new QHBoxLayout(newCoord2);
    newCoord2Layout->setMargin(0);
    newCoord2Layout->setSpacing(10);
    QRadioButton *newCoord2CoordCoord1 = new QRadioButton(tr("Coord1"), newCoord2);
    newCoord2ButtonGroup->addButton(newCoord2CoordCoord1,0);
    newCoord2Layout->addWidget(newCoord2CoordCoord1);
    QRadioButton *newCoord2CoordCoord2 = new QRadioButton(tr("Coord2"), newCoord2);
    newCoord2ButtonGroup->addButton(newCoord2CoordCoord2,1);
    newCoord2Layout->addWidget(newCoord2CoordCoord2);
    QRadioButton *newCoord2CoordCoord3 = new QRadioButton(tr("Coord3"), newCoord2);
    newCoord2ButtonGroup->addButton(newCoord2CoordCoord3,2);
    newCoord2Layout->addWidget(newCoord2CoordCoord3);
    connect(newCoord2ButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(newCoord2Changed(int)));
    mainLayout->addWidget(newCoord2, 1,1);

    newCoord3Label = new QLabel(tr("New Coordinate 3"), central);
    mainLayout->addWidget(newCoord3Label,2,0);
    newCoord3 = new QWidget(central);
    newCoord3ButtonGroup= new QButtonGroup(newCoord3);
    QHBoxLayout *newCoord3Layout = new QHBoxLayout(newCoord3);
    newCoord3Layout->setMargin(0);
    newCoord3Layout->setSpacing(10);
    QRadioButton *newCoord3CoordCoord1 = new QRadioButton(tr("Coord1"), newCoord3);
    newCoord3ButtonGroup->addButton(newCoord3CoordCoord1,0);
    newCoord3Layout->addWidget(newCoord3CoordCoord1);
    QRadioButton *newCoord3CoordCoord2 = new QRadioButton(tr("Coord2"), newCoord3);
    newCoord3ButtonGroup->addButton(newCoord3CoordCoord2,1);
    newCoord3Layout->addWidget(newCoord3CoordCoord2);
    QRadioButton *newCoord3CoordCoord3 = new QRadioButton(tr("Coord3"), newCoord3);
    newCoord3ButtonGroup->addButton(newCoord3CoordCoord3,2);
    newCoord3Layout->addWidget(newCoord3CoordCoord3);
    connect(newCoord3ButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(newCoord3Changed(int)));
    mainLayout->addWidget(newCoord3, 2,1);

}


// ****************************************************************************
// Method: QvisCoordSwapWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCoordSwapWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case CoordSwapAttributes::ID_newCoord1:
            newCoord1ButtonGroup->blockSignals(true);
            if(newCoord1ButtonGroup->button((int)atts->GetNewCoord1()) != 0)
                newCoord1ButtonGroup->button((int)atts->GetNewCoord1())->setChecked(true);
            newCoord1ButtonGroup->blockSignals(false);
            break;
          case CoordSwapAttributes::ID_newCoord2:
            newCoord2ButtonGroup->blockSignals(true);
            if(newCoord2ButtonGroup->button((int)atts->GetNewCoord2()) != 0)
                newCoord2ButtonGroup->button((int)atts->GetNewCoord2())->setChecked(true);
            newCoord2ButtonGroup->blockSignals(false);
            break;
          case CoordSwapAttributes::ID_newCoord3:
            newCoord3ButtonGroup->blockSignals(true);
            if(newCoord3ButtonGroup->button((int)atts->GetNewCoord3()) != 0)
                newCoord3ButtonGroup->button((int)atts->GetNewCoord3())->setChecked(true);
            newCoord3ButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisCoordSwapWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCoordSwapWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisCoordSwapWindow::newCoord1Changed(int val)
{
    if(val != atts->GetNewCoord1())
    {
        atts->SetNewCoord1(CoordSwapAttributes::Coord(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisCoordSwapWindow::newCoord2Changed(int val)
{
    if(val != atts->GetNewCoord2())
    {
        atts->SetNewCoord2(CoordSwapAttributes::Coord(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisCoordSwapWindow::newCoord3Changed(int val)
{
    if(val != atts->GetNewCoord3())
    {
        atts->SetNewCoord3(CoordSwapAttributes::Coord(val));
        SetUpdate(false);
        Apply();
    }
}


