/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <GaussianControlPoint.h>
#include <DataNode.h>

// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Init utility for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void GaussianControlPoint::Init()
{
    x = 0;
    height = 0;
    width = 0.001;
    xBias = 0;
    yBias = 0;

    GaussianControlPoint::SelectAll();
}

// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Copy utility for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void GaussianControlPoint::Copy(const GaussianControlPoint &obj)
{
    x = obj.x;
    height = obj.height;
    width = obj.width;
    xBias = obj.xBias;
    yBias = obj.yBias;

    GaussianControlPoint::SelectAll();
}

// Type map format string
const char *GaussianControlPoint::TypeMapFormatString = GAUSSIANCONTROLPOINT_TMFS;
const AttributeGroup::private_tmfs_t GaussianControlPoint::TmfsStruct = {GAUSSIANCONTROLPOINT_TMFS};


// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Default constructor for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint::GaussianControlPoint() : 
    AttributeSubject(GaussianControlPoint::TypeMapFormatString)
{
    GaussianControlPoint::Init();
}

// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Constructor for the derived classes of GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint::GaussianControlPoint(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    GaussianControlPoint::Init();
}

// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Copy constructor for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint::GaussianControlPoint(const GaussianControlPoint &obj) : 
    AttributeSubject(GaussianControlPoint::TypeMapFormatString)
{
    GaussianControlPoint::Copy(obj);
}

// ****************************************************************************
// Method: GaussianControlPoint::GaussianControlPoint
//
// Purpose: 
//   Copy constructor for derived classes of the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint::GaussianControlPoint(const GaussianControlPoint &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    GaussianControlPoint::Copy(obj);
}

// ****************************************************************************
// Method: GaussianControlPoint::~GaussianControlPoint
//
// Purpose: 
//   Destructor for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint::~GaussianControlPoint()
{
    // nothing here
}

// ****************************************************************************
// Method: GaussianControlPoint::operator = 
//
// Purpose: 
//   Assignment operator for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GaussianControlPoint& 
GaussianControlPoint::operator = (const GaussianControlPoint &obj)
{
    if (this == &obj) return *this;

    GaussianControlPoint::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: GaussianControlPoint::operator == 
//
// Purpose: 
//   Comparison operator == for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GaussianControlPoint::operator == (const GaussianControlPoint &obj) const
{
    // Create the return value
    return ((x == obj.x) &&
            (height == obj.height) &&
            (width == obj.width) &&
            (xBias == obj.xBias) &&
            (yBias == obj.yBias));
}

// ****************************************************************************
// Method: GaussianControlPoint::operator != 
//
// Purpose: 
//   Comparison operator != for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GaussianControlPoint::operator != (const GaussianControlPoint &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: GaussianControlPoint::TypeName
//
// Purpose: 
//   Type name method for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
GaussianControlPoint::TypeName() const
{
    return "GaussianControlPoint";
}

// ****************************************************************************
// Method: GaussianControlPoint::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GaussianControlPoint::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const GaussianControlPoint *tmp = (const GaussianControlPoint *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: GaussianControlPoint::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GaussianControlPoint::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new GaussianControlPoint(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: GaussianControlPoint::NewInstance
//
// Purpose: 
//   NewInstance method for the GaussianControlPoint class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GaussianControlPoint::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new GaussianControlPoint(*this);
    else
        retval = new GaussianControlPoint;

    return retval;
}

// ****************************************************************************
// Method: GaussianControlPoint::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
GaussianControlPoint::SelectAll()
{
    Select(ID_x,      (void *)&x);
    Select(ID_height, (void *)&height);
    Select(ID_width,  (void *)&width);
    Select(ID_xBias,  (void *)&xBias);
    Select(ID_yBias,  (void *)&yBias);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GaussianControlPoint::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GaussianControlPoint::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    GaussianControlPoint defaultObject;
    bool addToParent = false;
    // Create a node for GaussianControlPoint.
    DataNode *node = new DataNode("GaussianControlPoint");

    if(completeSave || !FieldsEqual(ID_x, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("x", x));
    }

    if(completeSave || !FieldsEqual(ID_height, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("height", height));
    }

    if(completeSave || !FieldsEqual(ID_width, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("width", width));
    }

    if(completeSave || !FieldsEqual(ID_xBias, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xBias", xBias));
    }

    if(completeSave || !FieldsEqual(ID_yBias, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yBias", yBias));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: GaussianControlPoint::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
GaussianControlPoint::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("GaussianControlPoint");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("x")) != 0)
        SetX(node->AsFloat());
    if((node = searchNode->GetNode("height")) != 0)
        SetHeight(node->AsFloat());
    if((node = searchNode->GetNode("width")) != 0)
        SetWidth(node->AsFloat());
    if((node = searchNode->GetNode("xBias")) != 0)
        SetXBias(node->AsFloat());
    if((node = searchNode->GetNode("yBias")) != 0)
        SetYBias(node->AsFloat());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
GaussianControlPoint::SetX(float x_)
{
    x = x_;
    Select(ID_x, (void *)&x);
}

void
GaussianControlPoint::SetHeight(float height_)
{
    height = height_;
    Select(ID_height, (void *)&height);
}

void
GaussianControlPoint::SetWidth(float width_)
{
    width = width_;
    Select(ID_width, (void *)&width);
}

void
GaussianControlPoint::SetXBias(float xBias_)
{
    xBias = xBias_;
    Select(ID_xBias, (void *)&xBias);
}

void
GaussianControlPoint::SetYBias(float yBias_)
{
    yBias = yBias_;
    Select(ID_yBias, (void *)&yBias);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

float
GaussianControlPoint::GetX() const
{
    return x;
}

float
GaussianControlPoint::GetHeight() const
{
    return height;
}

float
GaussianControlPoint::GetWidth() const
{
    return width;
}

float
GaussianControlPoint::GetXBias() const
{
    return xBias;
}

float
GaussianControlPoint::GetYBias() const
{
    return yBias;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GaussianControlPoint::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
GaussianControlPoint::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_x:      return "x";
    case ID_height: return "height";
    case ID_width:  return "width";
    case ID_xBias:  return "xBias";
    case ID_yBias:  return "yBias";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GaussianControlPoint::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
GaussianControlPoint::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_x:      return FieldType_float;
    case ID_height: return FieldType_float;
    case ID_width:  return FieldType_float;
    case ID_xBias:  return FieldType_float;
    case ID_yBias:  return FieldType_float;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: GaussianControlPoint::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
GaussianControlPoint::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_x:      return "float";
    case ID_height: return "float";
    case ID_width:  return "float";
    case ID_xBias:  return "float";
    case ID_yBias:  return "float";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GaussianControlPoint::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GaussianControlPoint::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const GaussianControlPoint &obj = *((const GaussianControlPoint*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_x:
        {  // new scope
        retval = (x == obj.x);
        }
        break;
    case ID_height:
        {  // new scope
        retval = (height == obj.height);
        }
        break;
    case ID_width:
        {  // new scope
        retval = (width == obj.width);
        }
        break;
    case ID_xBias:
        {  // new scope
        retval = (xBias == obj.xBias);
        }
        break;
    case ID_yBias:
        {  // new scope
        retval = (yBias == obj.yBias);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

