/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <FFTAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Init utility for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void FFTAttributes::Init()
{
    dummy = 0;

    FFTAttributes::SelectAll();
}

// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Copy utility for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void FFTAttributes::Copy(const FFTAttributes &obj)
{
    dummy = obj.dummy;

    FFTAttributes::SelectAll();
}

// Type map format string
const char *FFTAttributes::TypeMapFormatString = FFTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t FFTAttributes::TmfsStruct = {FFTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Default constructor for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes::FFTAttributes() : 
    AttributeSubject(FFTAttributes::TypeMapFormatString)
{
    FFTAttributes::Init();
}

// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Constructor for the derived classes of FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes::FFTAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    FFTAttributes::Init();
}

// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Copy constructor for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes::FFTAttributes(const FFTAttributes &obj) : 
    AttributeSubject(FFTAttributes::TypeMapFormatString)
{
    FFTAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FFTAttributes::FFTAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes::FFTAttributes(const FFTAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    FFTAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FFTAttributes::~FFTAttributes
//
// Purpose: 
//   Destructor for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes::~FFTAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: FFTAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FFTAttributes& 
FFTAttributes::operator = (const FFTAttributes &obj)
{
    if (this == &obj) return *this;

    FFTAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: FFTAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FFTAttributes::operator == (const FFTAttributes &obj) const
{
    // Create the return value
    return ((dummy == obj.dummy));
}

// ****************************************************************************
// Method: FFTAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FFTAttributes::operator != (const FFTAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: FFTAttributes::TypeName
//
// Purpose: 
//   Type name method for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
FFTAttributes::TypeName() const
{
    return "FFTAttributes";
}

// ****************************************************************************
// Method: FFTAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FFTAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const FFTAttributes *tmp = (const FFTAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: FFTAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
FFTAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new FFTAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: FFTAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the FFTAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
FFTAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new FFTAttributes(*this);
    else
        retval = new FFTAttributes;

    return retval;
}

// ****************************************************************************
// Method: FFTAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
FFTAttributes::SelectAll()
{
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FFTAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FFTAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    FFTAttributes defaultObject;
    bool addToParent = false;
    // Create a node for FFTAttributes.
    DataNode *node = new DataNode("FFTAttributes");

    if(completeSave || !FieldsEqual(ID_dummy, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dummy", dummy));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: FFTAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
FFTAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("FFTAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("dummy")) != 0)
        SetDummy(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
FFTAttributes::SetDummy(int dummy_)
{
    dummy = dummy_;
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
FFTAttributes::GetDummy() const
{
    return dummy;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FFTAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
FFTAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "dummy";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FFTAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
FFTAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dummy: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: FFTAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
FFTAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FFTAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FFTAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const FFTAttributes &obj = *((const FFTAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dummy:
        {  // new scope
        retval = (dummy == obj.dummy);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

