/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisReplicateWindow.h"

#include <ReplicateAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisReplicateWindow::QvisReplicateWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisReplicateWindow::QvisReplicateWindow(const int type,
                         ReplicateAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisReplicateWindow::~QvisReplicateWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisReplicateWindow::~QvisReplicateWindow()
{
}


// ****************************************************************************
// Method: QvisReplicateWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Jeremy Meredith, Thu Mar 22 13:34:20 EDT 2007
//    This is almost unchanged from the original xml2window code, with the
//    following exceptions: 1) the replicateUnitCellAtoms text was changed 
//    to two lines long and more descriptive, and 2) the checkboxes are
//    added using addMultiCellWidget so they can span columns 0 and 1.
//    If this file is regenerated, be mindful of these changes.
// 
//    Brad Whitlock, Thu Apr 24 16:48:54 PDT 2008
//    Added tr()'s
//
//    Cyrus Harrison, 
//    Qt4 Port- Autogen + replicated changes Jeremy outlined above.
//
//    Jeremy Meredith, Tue Jun  2 16:25:01 EDT 2009
//    Added support for shifting atoms to a new unit cell origin.
//
// ****************************************************************************

void
QvisReplicateWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    useUnitCellVectors = new QCheckBox(tr("Use provided unit cell vectors"), central);
    connect(useUnitCellVectors, SIGNAL(toggled(bool)),
            this, SLOT(useUnitCellVectorsChanged(bool)));
    mainLayout->addWidget(useUnitCellVectors, 0,0);

    xVectorLabel = new QLabel(tr("Vector for X"), central);
    mainLayout->addWidget(xVectorLabel,1,0);
    xVector = new QLineEdit(central);
    connect(xVector, SIGNAL(returnPressed()),
            this, SLOT(xVectorProcessText()));
    mainLayout->addWidget(xVector, 1,1);

    yVectorLabel = new QLabel(tr("Vector for Y"), central);
    mainLayout->addWidget(yVectorLabel,2,0);
    yVector = new QLineEdit(central);
    connect(yVector, SIGNAL(returnPressed()),
            this, SLOT(yVectorProcessText()));
    mainLayout->addWidget(yVector, 2,1);

    zVectorLabel = new QLabel(tr("Vector for Z"), central);
    mainLayout->addWidget(zVectorLabel,3,0);
    zVector = new QLineEdit(central);
    connect(zVector, SIGNAL(returnPressed()),
            this, SLOT(zVectorProcessText()));
    mainLayout->addWidget(zVector, 3,1);

    xReplicationsLabel = new QLabel(tr("Replications in X"), central);
    mainLayout->addWidget(xReplicationsLabel,4,0);
    xReplications = new QLineEdit(central);
    connect(xReplications, SIGNAL(returnPressed()),
            this, SLOT(xReplicationsProcessText()));
    mainLayout->addWidget(xReplications, 4,1);

    yReplicationsLabel = new QLabel(tr("Replications in Y"), central);
    mainLayout->addWidget(yReplicationsLabel,5,0);
    yReplications = new QLineEdit(central);
    connect(yReplications, SIGNAL(returnPressed()),
            this, SLOT(yReplicationsProcessText()));
    mainLayout->addWidget(yReplications, 5,1);

    zReplicationsLabel = new QLabel(tr("Replications in Z"), central);
    mainLayout->addWidget(zReplicationsLabel,6,0);
    zReplications = new QLineEdit(central);
    connect(zReplications, SIGNAL(returnPressed()),
            this, SLOT(zReplicationsProcessText()));
    mainLayout->addWidget(zReplications, 6,1);

    mergeResults = new QCheckBox(tr("Merge into one block when possible"), central);
    connect(mergeResults, SIGNAL(toggled(bool)),
            this, SLOT(mergeResultsChanged(bool)));
    mainLayout->addWidget(mergeResults, 7,0,1,2);

    replicateUnitCellAtoms = new QCheckBox(tr("For molecular data, periodically replicate\natoms at unit cell boundaries."), central);
    connect(replicateUnitCellAtoms, SIGNAL(toggled(bool)),
            this, SLOT(replicateUnitCellAtomsChanged(bool)));
    mainLayout->addWidget(replicateUnitCellAtoms, 8,0,1,2);

    shiftPeriodicAtomOrigin = new QCheckBox(tr("Shift atoms to new periodic origin"),
                                           central);
    connect(shiftPeriodicAtomOrigin, SIGNAL(toggled(bool)),
            this, SLOT(shiftPeriodicAtomOriginChanged(bool)));
    mainLayout->addWidget(shiftPeriodicAtomOrigin, 9,0, 1,2);

    newPeriodicOriginLabel = new QLabel(tr("New periodic atom origin"),
                                        central);
    mainLayout->addWidget(newPeriodicOriginLabel,10,0);
    newPeriodicOrigin = new QLineEdit(central);
    connect(newPeriodicOrigin, SIGNAL(returnPressed()),
            this, SLOT(newPeriodicOriginProcessText()));
    mainLayout->addWidget(newPeriodicOrigin, 10,1);

}


// ****************************************************************************
// Method: QvisReplicateWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Cyrus Harrison, 
//    Qt4 Port - replicateUnitCellAtoms does not have a label (text is 
//    integrated in the checkbox)
//
//    Jeremy Meredith, Tue Jun  2 16:25:01 EDT 2009
//    Added support for shifting atoms to a new unit cell origin.
//
// ****************************************************************************

void
QvisReplicateWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ReplicateAttributes::ID_useUnitCellVectors:
            if (atts->GetUseUnitCellVectors() == false)
            {
                xVector->setEnabled(true);
                if(xVectorLabel)
                    xVectorLabel->setEnabled(true);
            }
            else
            {
                xVector->setEnabled(false);
                if(xVectorLabel)
                    xVectorLabel->setEnabled(false);
            }
            if (atts->GetUseUnitCellVectors() == false)
            {
                yVector->setEnabled(true);
                if(yVectorLabel)
                    yVectorLabel->setEnabled(true);
            }
            else
            {
                yVector->setEnabled(false);
                if(yVectorLabel)
                    yVectorLabel->setEnabled(false);
            }
            if (atts->GetUseUnitCellVectors() == false)
            {
                zVector->setEnabled(true);
                if(zVectorLabel)
                    zVectorLabel->setEnabled(true);
            }
            else
            {
                zVector->setEnabled(false);
                if(zVectorLabel)
                    zVectorLabel->setEnabled(false);
            }
            useUnitCellVectors->blockSignals(true);
            useUnitCellVectors->setChecked(atts->GetUseUnitCellVectors());
            useUnitCellVectors->blockSignals(false);
            break;
          case ReplicateAttributes::ID_xVector:
            xVector->setText(DoublesToQString(atts->GetXVector(), 3));
            break;
          case ReplicateAttributes::ID_yVector:
            yVector->setText(DoublesToQString(atts->GetYVector(), 3));
            break;
          case ReplicateAttributes::ID_zVector:
            zVector->setText(DoublesToQString(atts->GetZVector(), 3));
            break;
          case ReplicateAttributes::ID_xReplications:
            xReplications->setText(IntToQString(atts->GetXReplications()));
            break;
          case ReplicateAttributes::ID_yReplications:
            yReplications->setText(IntToQString(atts->GetYReplications()));
            break;
          case ReplicateAttributes::ID_zReplications:
            zReplications->setText(IntToQString(atts->GetZReplications()));
            break;
          case ReplicateAttributes::ID_mergeResults:
            replicateUnitCellAtoms->setEnabled(atts->GetMergeResults());
            shiftPeriodicAtomOrigin->setEnabled(atts->GetMergeResults());
            newPeriodicOriginLabel->setEnabled(atts->GetMergeResults() &&
                                               atts->GetShiftPeriodicAtomOrigin());
            newPeriodicOrigin->setEnabled(atts->GetMergeResults() &&
                                          atts->GetShiftPeriodicAtomOrigin());
            mergeResults->blockSignals(true);
            mergeResults->setChecked(atts->GetMergeResults());
            mergeResults->blockSignals(false);
            break;
          case ReplicateAttributes::ID_replicateUnitCellAtoms:
            replicateUnitCellAtoms->blockSignals(true);
            replicateUnitCellAtoms->setChecked(atts->GetReplicateUnitCellAtoms());
            replicateUnitCellAtoms->blockSignals(false);
            break;
          case ReplicateAttributes::ID_shiftPeriodicAtomOrigin:
            shiftPeriodicAtomOrigin->blockSignals(true);
            shiftPeriodicAtomOrigin->setChecked(atts->GetShiftPeriodicAtomOrigin());
            shiftPeriodicAtomOrigin->blockSignals(false);
            newPeriodicOriginLabel->setEnabled(atts->GetMergeResults() &&
                                               atts->GetShiftPeriodicAtomOrigin());
            newPeriodicOrigin->setEnabled(atts->GetMergeResults() &&
                                          atts->GetShiftPeriodicAtomOrigin());
            break;
          case ReplicateAttributes::ID_newPeriodicOrigin:
            newPeriodicOrigin->setText(DoublesToQString(atts->GetNewPeriodicOrigin(), 3));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisReplicateWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Jeremy Meredith, Tue Jun  2 16:25:01 EDT 2009
//    Added support for shifting atoms to a new unit cell origin.
//
//   
// ****************************************************************************

void
QvisReplicateWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do xVector
    if(which_widget == ReplicateAttributes::ID_xVector || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(xVector, val, 3))
            atts->SetXVector(val);
        else
        {
            ResettingError(tr("Vector for X"),
                DoublesToQString(atts->GetXVector(),3));
            atts->SetXVector(atts->GetXVector());
        }
    }

    // Do yVector
    if(which_widget == ReplicateAttributes::ID_yVector || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(yVector, val, 3))
            atts->SetYVector(val);
        else
        {
            ResettingError(tr("Vector for Y"),
                DoublesToQString(atts->GetYVector(),3));
            atts->SetYVector(atts->GetYVector());
        }
    }

    // Do zVector
    if(which_widget == ReplicateAttributes::ID_zVector || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(zVector, val, 3))
            atts->SetZVector(val);
        else
        {
            ResettingError(tr("Vector for Z"),
                DoublesToQString(atts->GetZVector(),3));
            atts->SetZVector(atts->GetZVector());
        }
    }

    // Do xReplications
    if(which_widget == ReplicateAttributes::ID_xReplications || doAll)
    {
        int val;
        if(LineEditGetInt(xReplications, val))
            atts->SetXReplications(val);
        else
        {
            ResettingError(tr("Replications in X"),
                IntToQString(atts->GetXReplications()));
            atts->SetXReplications(atts->GetXReplications());
        }
    }

    // Do yReplications
    if(which_widget == ReplicateAttributes::ID_yReplications || doAll)
    {
        int val;
        if(LineEditGetInt(yReplications, val))
            atts->SetYReplications(val);
        else
        {
            ResettingError(tr("Replications in Y"),
                IntToQString(atts->GetYReplications()));
            atts->SetYReplications(atts->GetYReplications());
        }
    }

    // Do zReplications
    if(which_widget == ReplicateAttributes::ID_zReplications || doAll)
    {
        int val;
        if(LineEditGetInt(zReplications, val))
            atts->SetZReplications(val);
        else
        {
            ResettingError(tr("Replications in Z"),
                IntToQString(atts->GetZReplications()));
            atts->SetZReplications(atts->GetZReplications());
        }
    }

    // Do newPeriodicOrigin
    if(which_widget == ReplicateAttributes::ID_newPeriodicOrigin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(newPeriodicOrigin, val, 3))
            atts->SetNewPeriodicOrigin(val);
        else
        {
            ResettingError(tr("New periodic origin"),
                DoublesToQString(atts->GetNewPeriodicOrigin(),3));
            atts->SetNewPeriodicOrigin(atts->GetNewPeriodicOrigin());
        }
    }
}


//
// Qt Slot functions
//


void
QvisReplicateWindow::useUnitCellVectorsChanged(bool val)
{
    atts->SetUseUnitCellVectors(val);
    Apply();
}


void
QvisReplicateWindow::xVectorProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_xVector);
    Apply();
}


void
QvisReplicateWindow::yVectorProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_yVector);
    Apply();
}


void
QvisReplicateWindow::zVectorProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_zVector);
    Apply();
}


void
QvisReplicateWindow::xReplicationsProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_xReplications);
    Apply();
}


void
QvisReplicateWindow::yReplicationsProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_yReplications);
    Apply();
}


void
QvisReplicateWindow::zReplicationsProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_zReplications);
    Apply();
}


void
QvisReplicateWindow::mergeResultsChanged(bool val)
{
    atts->SetMergeResults(val);
    Apply();
}


void
QvisReplicateWindow::replicateUnitCellAtomsChanged(bool val)
{
    atts->SetReplicateUnitCellAtoms(val);
    SetUpdate(false);
    Apply();
}


void
QvisReplicateWindow::shiftPeriodicAtomOriginChanged(bool val)
{
    atts->SetShiftPeriodicAtomOrigin(val);
    Apply();
}


void
QvisReplicateWindow::newPeriodicOriginProcessText()
{
    GetCurrentValues(ReplicateAttributes::ID_newPeriodicOrigin);
    Apply();
}

