/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyExtractPointFunction2DAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyExtractPointFunction2DAttributes
//
// Purpose: 
//   Attributes for ExtractPointFunction2D
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ExtractPointFunction2DAttributes.
//
struct ExtractPointFunction2DAttributesObject
{
    PyObject_HEAD
    ExtractPointFunction2DAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewExtractPointFunction2DAttributes(int);

std::string
PyExtractPointFunction2DAttributes_ToString(const ExtractPointFunction2DAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const intVector &I = atts->GetI();
        SNPRINTF(tmpStr, 1000, "%sI = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < I.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", I[i]);
            str += tmpStr;
            if(i < I.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &J = atts->GetJ();
        SNPRINTF(tmpStr, 1000, "%sJ = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < J.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", J[i]);
            str += tmpStr;
            if(i < J.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ExtractPointFunction2DAttributes_Notify(PyObject *self, PyObject *args)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtractPointFunction2DAttributes_SetI(PyObject *self, PyObject *args)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)self;

    intVector  &vec = obj->data->GetI();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the I in the object as modified.
    obj->data->SelectI();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtractPointFunction2DAttributes_GetI(PyObject *self, PyObject *args)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the I.
    const intVector &I = obj->data->GetI();
    PyObject *retval = PyTuple_New(I.size());
    for(size_t i = 0; i < I.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(I[i])));
    return retval;
}

/*static*/ PyObject *
ExtractPointFunction2DAttributes_SetJ(PyObject *self, PyObject *args)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)self;

    intVector  &vec = obj->data->GetJ();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the J in the object as modified.
    obj->data->SelectJ();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtractPointFunction2DAttributes_GetJ(PyObject *self, PyObject *args)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the J.
    const intVector &J = obj->data->GetJ();
    PyObject *retval = PyTuple_New(J.size());
    for(size_t i = 0; i < J.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(J[i])));
    return retval;
}



PyMethodDef PyExtractPointFunction2DAttributes_methods[EXTRACTPOINTFUNCTION2DATTRIBUTES_NMETH] = {
    {"Notify", ExtractPointFunction2DAttributes_Notify, METH_VARARGS},
    {"SetI", ExtractPointFunction2DAttributes_SetI, METH_VARARGS},
    {"GetI", ExtractPointFunction2DAttributes_GetI, METH_VARARGS},
    {"SetJ", ExtractPointFunction2DAttributes_SetJ, METH_VARARGS},
    {"GetJ", ExtractPointFunction2DAttributes_GetJ, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ExtractPointFunction2DAttributes_dealloc(PyObject *v)
{
   ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ExtractPointFunction2DAttributes_compare(PyObject *v, PyObject *w)
{
    ExtractPointFunction2DAttributes *a = ((ExtractPointFunction2DAttributesObject *)v)->data;
    ExtractPointFunction2DAttributes *b = ((ExtractPointFunction2DAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyExtractPointFunction2DAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "I") == 0)
        return ExtractPointFunction2DAttributes_GetI(self, NULL);
    if(strcmp(name, "J") == 0)
        return ExtractPointFunction2DAttributes_GetJ(self, NULL);

    return Py_FindMethod(PyExtractPointFunction2DAttributes_methods, self, name);
}

int
PyExtractPointFunction2DAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "I") == 0)
        obj = ExtractPointFunction2DAttributes_SetI(self, tuple);
    else if(strcmp(name, "J") == 0)
        obj = ExtractPointFunction2DAttributes_SetJ(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ExtractPointFunction2DAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)v;
    fprintf(fp, "%s", PyExtractPointFunction2DAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ExtractPointFunction2DAttributes_str(PyObject *v)
{
    ExtractPointFunction2DAttributesObject *obj = (ExtractPointFunction2DAttributesObject *)v;
    return PyString_FromString(PyExtractPointFunction2DAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ExtractPointFunction2DAttributes_Purpose = "Attributes for ExtractPointFunction2D";
#else
static char *ExtractPointFunction2DAttributes_Purpose = "Attributes for ExtractPointFunction2D";
#endif

//
// The type description structure
//
static PyTypeObject ExtractPointFunction2DAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ExtractPointFunction2DAttributes",                    // tp_name
    sizeof(ExtractPointFunction2DAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ExtractPointFunction2DAttributes_dealloc,  // tp_dealloc
    (printfunc)ExtractPointFunction2DAttributes_print,     // tp_print
    (getattrfunc)PyExtractPointFunction2DAttributes_getattr, // tp_getattr
    (setattrfunc)PyExtractPointFunction2DAttributes_setattr, // tp_setattr
    (cmpfunc)ExtractPointFunction2DAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ExtractPointFunction2DAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ExtractPointFunction2DAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ExtractPointFunction2DAttributes *defaultAtts = 0;
static ExtractPointFunction2DAttributes *currentAtts = 0;

static PyObject *
NewExtractPointFunction2DAttributes(int useCurrent)
{
    ExtractPointFunction2DAttributesObject *newObject;
    newObject = PyObject_NEW(ExtractPointFunction2DAttributesObject, &ExtractPointFunction2DAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ExtractPointFunction2DAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ExtractPointFunction2DAttributes(*defaultAtts);
    else
        newObject->data = new ExtractPointFunction2DAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapExtractPointFunction2DAttributes(const ExtractPointFunction2DAttributes *attr)
{
    ExtractPointFunction2DAttributesObject *newObject;
    newObject = PyObject_NEW(ExtractPointFunction2DAttributesObject, &ExtractPointFunction2DAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ExtractPointFunction2DAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ExtractPointFunction2DAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewExtractPointFunction2DAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExtractPointFunction2DAttributesMethods[] = {
    {"ExtractPointFunction2DAttributes", ExtractPointFunction2DAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExtractPointFunction2DAttributesObserver = 0;

std::string
PyExtractPointFunction2DAttributes_GetLogString()
{
    std::string s("ExtractPointFunction2DAtts = ExtractPointFunction2DAttributes()\n");
    if(currentAtts != 0)
        s += PyExtractPointFunction2DAttributes_ToString(currentAtts, "ExtractPointFunction2DAtts.");
    return s;
}

static void
PyExtractPointFunction2DAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ExtractPointFunction2DAtts = ExtractPointFunction2DAttributes()\n");
        s += PyExtractPointFunction2DAttributes_ToString(currentAtts, "ExtractPointFunction2DAtts.");
        cb(s);
    }
}

void
PyExtractPointFunction2DAttributes_StartUp(ExtractPointFunction2DAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyExtractPointFunction2DAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExtractPointFunction2DAttributesObserver == 0)
    {
        ExtractPointFunction2DAttributesObserver = new ObserverToCallback(subj,
            PyExtractPointFunction2DAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyExtractPointFunction2DAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExtractPointFunction2DAttributesObserver;
    ExtractPointFunction2DAttributesObserver = 0;
}

PyMethodDef *
PyExtractPointFunction2DAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExtractPointFunction2DAttributesMethods;
}

bool
PyExtractPointFunction2DAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ExtractPointFunction2DAttributesType);
}

ExtractPointFunction2DAttributes *
PyExtractPointFunction2DAttributes_FromPyObject(PyObject *obj)
{
    ExtractPointFunction2DAttributesObject *obj2 = (ExtractPointFunction2DAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyExtractPointFunction2DAttributes_New()
{
    return NewExtractPointFunction2DAttributes(0);
}

PyObject *
PyExtractPointFunction2DAttributes_Wrap(const ExtractPointFunction2DAttributes *attr)
{
    return WrapExtractPointFunction2DAttributes(attr);
}

void
PyExtractPointFunction2DAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ExtractPointFunction2DAttributesObject *obj2 = (ExtractPointFunction2DAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyExtractPointFunction2DAttributes_SetDefaults(const ExtractPointFunction2DAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ExtractPointFunction2DAttributes(*atts);
}

