/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: AxisAlignedSlice4DCommonPluginInfo.C
// ************************************************************************* //

#include <AxisAlignedSlice4DPluginInfo.h>
#include <AxisAlignedSlice4DAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>
#include <avtSubsetsMetaData.h>
#include <avtScalarMetaData.h>
#include <avtVectorMetaData.h>
#include <avtTensorMetaData.h>
#include <avtSymmetricTensorMetaData.h>
#include <avtArrayMetaData.h>
#include <avtMaterialMetaData.h>
#include <avtSpeciesMetaData.h>
#include <avtCurveMetaData.h>
#include <avtLabelMetaData.h>

// ****************************************************************************
//  Method: AxisAlignedSlice4DCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DCommonPluginInfo::AllocAttributes()
{
    return new AxisAlignedSlice4DAttributes;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a AxisAlignedSlice4D attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void 
AxisAlignedSlice4DCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((AxisAlignedSlice4DAttributes *) to) = *((AxisAlignedSlice4DAttributes *) from);
}
ExpressionList *
AxisAlignedSlice4DCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024];
    char defn[1024];
    ExpressionList *el = new ExpressionList;

    for (int i = 0 ; i < md->GetNumArrays() ; i++)
    {
        avtArrayMetaData const &amd = md->GetArrays(i);

        if (amd.hideFromGUI || !amd.validVariable)
            continue;

        const char *array = amd.name.c_str();
        const char *mesh = amd.meshName.c_str();

        Expression e;
        sprintf(name, "operators/AxisAlignedSlice4D/%s", array);
        e.SetName(name);
        e.SetType(Expression::ScalarMeshVar);
        e.SetFromOperator(true);
        e.SetOperatorName("AxisAlignedSlice4D");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e.SetDefinition(defn);
        el->AddExpressions(e);
    }

    const ExpressionList &oldEL = md->GetExprList();
    for (int i = 0 ; i < oldEL.GetNumExpressions() ; i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::ArrayMeshVar)
        {
            {
                if (e.GetFromOperator() || e.GetAutoExpression())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/AxisAlignedSlice4D/%s", e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("AxisAlignedSlice4D");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }

    return el;
}

