/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
// avtBlueprintFileFormat.h
// ************************************************************************* //

#ifndef AVT_BLUEPRINT_FILE_FORMAT_H
#define AVT_BLUEPRINT_FILE_FORMAT_H

#include "avtSTMDFileFormat.h"

#include "conduit.hpp"

// ****************************************************************************
//  Class: avtBlueprintFileFormat
//
//  Purpose:
//      Reads in Blueprint files as a plugin to VisIt.
//
//  Programmer: harrison37 -- generated by xml2avt
//  Creation:   Wed Jun 15 16:25:28 PST 2016
//
// ****************************************************************************

class avtBlueprintTreeCache;

class avtBlueprintFileFormat : public avtSTMDFileFormat
{
  public:
                           avtBlueprintFileFormat(const char *);
    virtual               ~avtBlueprintFileFormat();

    virtual const char    *GetType(void) 
                                { return "Blueprint"; }

    // Standard Mesh Access
    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

    // VisIt can't cache for us b/c we need to implement LOD support. 
    virtual bool           CanCacheVariable(const char *var)
                                { return false; }

    // Used to enable support for avtResolutionSelection
    virtual void           RegisterDataSelections(
                                const std::vector<avtDataSelection_p> &selList,
                                std::vector<bool> *selectionsApplied);
    // cycle and time support
    virtual int            GetCycle(void);
    virtual double         GetTime(void);

    
    virtual void           FreeUpResources(void); 

  protected:

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    bool                   HasInvariantMetaData(void) const
                                { return false; }

    bool                   HasInvariantSIL(void) const
                                { return false; }

  private:

    void                   AddBlueprintMeshAndFieldMetadata(avtDatabaseMetaData *md,
                                                            std::string const &mesh_name, 
                                                            const conduit::Node &n_mesh_info);

    void                   ReadRootFile();

    void                   ReadBlueprintMesh(int domain,
                                             const std::string &abs_meshname,
                                             conduit::Node &out);

    void                   ReadBlueprintField(int domain,
                                              const std::string &abs_varname,
                                              conduit::Node &out);

    conduit::Node          m_root_node;
    
    std::string            m_protocol;
    
    avtBlueprintTreeCache  *m_tree_cache;
  
    int                    m_selected_lod;
    
    std::map<std::string,bool> m_mfem_mesh_map;

};


#endif
