/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySaveSubWindowAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySaveSubWindowAttributes
//
// Purpose: 
//   The attributes for saving a sub window
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SaveSubWindowAttributes.
//
struct SaveSubWindowAttributesObject
{
    PyObject_HEAD
    SaveSubWindowAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSaveSubWindowAttributes(int);

std::string
PySaveSubWindowAttributes_ToString(const SaveSubWindowAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const int *position = atts->GetPosition();
        SNPRINTF(tmpStr, 1000, "%sposition = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", position[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const int *size = atts->GetSize();
        SNPRINTF(tmpStr, 1000, "%ssize = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", size[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%slayer = %d\n", prefix, atts->GetLayer());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stransparency = %g\n", prefix, atts->GetTransparency());
    str += tmpStr;
    if(atts->GetOmitWindow())
        SNPRINTF(tmpStr, 1000, "%somitWindow = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%somitWindow = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SaveSubWindowAttributes_Notify(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_SetPosition(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;

    int *ivals = obj->data->GetPosition();
    if(!PyArg_ParseTuple(args, "ii", &ivals[0], &ivals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_GetPosition(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(2);
    const int *position = obj->data->GetPosition();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(position[i])));
    return retval;
}

/*static*/ PyObject *
SaveSubWindowAttributes_SetSize(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;

    int *ivals = obj->data->GetSize();
    if(!PyArg_ParseTuple(args, "ii", &ivals[0], &ivals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the size in the object as modified.
    obj->data->SelectSize();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_GetSize(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the size.
    PyObject *retval = PyTuple_New(2);
    const int *size = obj->data->GetSize();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(size[i])));
    return retval;
}

/*static*/ PyObject *
SaveSubWindowAttributes_SetLayer(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the layer in the object.
    obj->data->SetLayer((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_GetLayer(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLayer()));
    return retval;
}

/*static*/ PyObject *
SaveSubWindowAttributes_SetTransparency(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the transparency in the object.
    obj->data->SetTransparency(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_GetTransparency(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTransparency());
    return retval;
}

/*static*/ PyObject *
SaveSubWindowAttributes_SetOmitWindow(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the omitWindow in the object.
    obj->data->SetOmitWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowAttributes_GetOmitWindow(PyObject *self, PyObject *args)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOmitWindow()?1L:0L);
    return retval;
}



PyMethodDef PySaveSubWindowAttributes_methods[SAVESUBWINDOWATTRIBUTES_NMETH] = {
    {"Notify", SaveSubWindowAttributes_Notify, METH_VARARGS},
    {"SetPosition", SaveSubWindowAttributes_SetPosition, METH_VARARGS},
    {"GetPosition", SaveSubWindowAttributes_GetPosition, METH_VARARGS},
    {"SetSize", SaveSubWindowAttributes_SetSize, METH_VARARGS},
    {"GetSize", SaveSubWindowAttributes_GetSize, METH_VARARGS},
    {"SetLayer", SaveSubWindowAttributes_SetLayer, METH_VARARGS},
    {"GetLayer", SaveSubWindowAttributes_GetLayer, METH_VARARGS},
    {"SetTransparency", SaveSubWindowAttributes_SetTransparency, METH_VARARGS},
    {"GetTransparency", SaveSubWindowAttributes_GetTransparency, METH_VARARGS},
    {"SetOmitWindow", SaveSubWindowAttributes_SetOmitWindow, METH_VARARGS},
    {"GetOmitWindow", SaveSubWindowAttributes_GetOmitWindow, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SaveSubWindowAttributes_dealloc(PyObject *v)
{
   SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SaveSubWindowAttributes_compare(PyObject *v, PyObject *w)
{
    SaveSubWindowAttributes *a = ((SaveSubWindowAttributesObject *)v)->data;
    SaveSubWindowAttributes *b = ((SaveSubWindowAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySaveSubWindowAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "position") == 0)
        return SaveSubWindowAttributes_GetPosition(self, NULL);
    if(strcmp(name, "size") == 0)
        return SaveSubWindowAttributes_GetSize(self, NULL);
    if(strcmp(name, "layer") == 0)
        return SaveSubWindowAttributes_GetLayer(self, NULL);
    if(strcmp(name, "transparency") == 0)
        return SaveSubWindowAttributes_GetTransparency(self, NULL);
    if(strcmp(name, "omitWindow") == 0)
        return SaveSubWindowAttributes_GetOmitWindow(self, NULL);

    return Py_FindMethod(PySaveSubWindowAttributes_methods, self, name);
}

int
PySaveSubWindowAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "position") == 0)
        obj = SaveSubWindowAttributes_SetPosition(self, tuple);
    else if(strcmp(name, "size") == 0)
        obj = SaveSubWindowAttributes_SetSize(self, tuple);
    else if(strcmp(name, "layer") == 0)
        obj = SaveSubWindowAttributes_SetLayer(self, tuple);
    else if(strcmp(name, "transparency") == 0)
        obj = SaveSubWindowAttributes_SetTransparency(self, tuple);
    else if(strcmp(name, "omitWindow") == 0)
        obj = SaveSubWindowAttributes_SetOmitWindow(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SaveSubWindowAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)v;
    fprintf(fp, "%s", PySaveSubWindowAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SaveSubWindowAttributes_str(PyObject *v)
{
    SaveSubWindowAttributesObject *obj = (SaveSubWindowAttributesObject *)v;
    return PyString_FromString(PySaveSubWindowAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SaveSubWindowAttributes_Purpose = "The attributes for saving a sub window";
#else
static char *SaveSubWindowAttributes_Purpose = "The attributes for saving a sub window";
#endif

//
// The type description structure
//
static PyTypeObject SaveSubWindowAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SaveSubWindowAttributes",                    // tp_name
    sizeof(SaveSubWindowAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SaveSubWindowAttributes_dealloc,  // tp_dealloc
    (printfunc)SaveSubWindowAttributes_print,     // tp_print
    (getattrfunc)PySaveSubWindowAttributes_getattr, // tp_getattr
    (setattrfunc)PySaveSubWindowAttributes_setattr, // tp_setattr
    (cmpfunc)SaveSubWindowAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SaveSubWindowAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SaveSubWindowAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SaveSubWindowAttributes *defaultAtts = 0;
static SaveSubWindowAttributes *currentAtts = 0;

static PyObject *
NewSaveSubWindowAttributes(int useCurrent)
{
    SaveSubWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveSubWindowAttributesObject, &SaveSubWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SaveSubWindowAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SaveSubWindowAttributes(*defaultAtts);
    else
        newObject->data = new SaveSubWindowAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSaveSubWindowAttributes(const SaveSubWindowAttributes *attr)
{
    SaveSubWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveSubWindowAttributesObject, &SaveSubWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SaveSubWindowAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SaveSubWindowAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSaveSubWindowAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SaveSubWindowAttributesMethods[] = {
    {"SaveSubWindowAttributes", SaveSubWindowAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SaveSubWindowAttributesObserver = 0;

std::string
PySaveSubWindowAttributes_GetLogString()
{
    std::string s("SaveSubWindowAtts = SaveSubWindowAttributes()\n");
    if(currentAtts != 0)
        s += PySaveSubWindowAttributes_ToString(currentAtts, "SaveSubWindowAtts.");
    return s;
}

static void
PySaveSubWindowAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SaveSubWindowAtts = SaveSubWindowAttributes()\n");
        s += PySaveSubWindowAttributes_ToString(currentAtts, "SaveSubWindowAtts.");
        cb(s);
    }
}

void
PySaveSubWindowAttributes_StartUp(SaveSubWindowAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySaveSubWindowAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SaveSubWindowAttributesObserver == 0)
    {
        SaveSubWindowAttributesObserver = new ObserverToCallback(subj,
            PySaveSubWindowAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySaveSubWindowAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SaveSubWindowAttributesObserver;
    SaveSubWindowAttributesObserver = 0;
}

PyMethodDef *
PySaveSubWindowAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SaveSubWindowAttributesMethods;
}

bool
PySaveSubWindowAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SaveSubWindowAttributesType);
}

SaveSubWindowAttributes *
PySaveSubWindowAttributes_FromPyObject(PyObject *obj)
{
    SaveSubWindowAttributesObject *obj2 = (SaveSubWindowAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySaveSubWindowAttributes_New()
{
    return NewSaveSubWindowAttributes(0);
}

PyObject *
PySaveSubWindowAttributes_Wrap(const SaveSubWindowAttributes *attr)
{
    return WrapSaveSubWindowAttributes(attr);
}

void
PySaveSubWindowAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SaveSubWindowAttributesObject *obj2 = (SaveSubWindowAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySaveSubWindowAttributes_SetDefaults(const SaveSubWindowAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SaveSubWindowAttributes(*atts);
}

