/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMultiresControlAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyMultiresControlAttributes
//
// Purpose: 
//   
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MultiresControlAttributes.
//
struct MultiresControlAttributesObject
{
    PyObject_HEAD
    MultiresControlAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMultiresControlAttributes(int);

std::string
PyMultiresControlAttributes_ToString(const MultiresControlAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sresolution = %d\n", prefix, atts->GetResolution());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxResolution = %d\n", prefix, atts->GetMaxResolution());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sinfo = \"%s\"\n", prefix, atts->GetInfo().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
MultiresControlAttributes_Notify(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiresControlAttributes_SetResolution(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resolution in the object.
    obj->data->SetResolution((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiresControlAttributes_GetResolution(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetResolution()));
    return retval;
}

/*static*/ PyObject *
MultiresControlAttributes_SetMaxResolution(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxResolution in the object.
    obj->data->SetMaxResolution((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiresControlAttributes_GetMaxResolution(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxResolution()));
    return retval;
}

/*static*/ PyObject *
MultiresControlAttributes_SetInfo(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the info in the object.
    obj->data->SetInfo(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiresControlAttributes_GetInfo(PyObject *self, PyObject *args)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetInfo().c_str());
    return retval;
}



PyMethodDef PyMultiresControlAttributes_methods[MULTIRESCONTROLATTRIBUTES_NMETH] = {
    {"Notify", MultiresControlAttributes_Notify, METH_VARARGS},
    {"SetResolution", MultiresControlAttributes_SetResolution, METH_VARARGS},
    {"GetResolution", MultiresControlAttributes_GetResolution, METH_VARARGS},
    {"SetMaxResolution", MultiresControlAttributes_SetMaxResolution, METH_VARARGS},
    {"GetMaxResolution", MultiresControlAttributes_GetMaxResolution, METH_VARARGS},
    {"SetInfo", MultiresControlAttributes_SetInfo, METH_VARARGS},
    {"GetInfo", MultiresControlAttributes_GetInfo, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MultiresControlAttributes_dealloc(PyObject *v)
{
   MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MultiresControlAttributes_compare(PyObject *v, PyObject *w)
{
    MultiresControlAttributes *a = ((MultiresControlAttributesObject *)v)->data;
    MultiresControlAttributes *b = ((MultiresControlAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMultiresControlAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "resolution") == 0)
        return MultiresControlAttributes_GetResolution(self, NULL);
    if(strcmp(name, "maxResolution") == 0)
        return MultiresControlAttributes_GetMaxResolution(self, NULL);
    if(strcmp(name, "info") == 0)
        return MultiresControlAttributes_GetInfo(self, NULL);

    return Py_FindMethod(PyMultiresControlAttributes_methods, self, name);
}

int
PyMultiresControlAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "resolution") == 0)
        obj = MultiresControlAttributes_SetResolution(self, tuple);
    else if(strcmp(name, "maxResolution") == 0)
        obj = MultiresControlAttributes_SetMaxResolution(self, tuple);
    else if(strcmp(name, "info") == 0)
        obj = MultiresControlAttributes_SetInfo(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MultiresControlAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)v;
    fprintf(fp, "%s", PyMultiresControlAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MultiresControlAttributes_str(PyObject *v)
{
    MultiresControlAttributesObject *obj = (MultiresControlAttributesObject *)v;
    return PyString_FromString(PyMultiresControlAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MultiresControlAttributes_Purpose = "";
#else
static char *MultiresControlAttributes_Purpose = "";
#endif

//
// The type description structure
//
static PyTypeObject MultiresControlAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MultiresControlAttributes",                    // tp_name
    sizeof(MultiresControlAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MultiresControlAttributes_dealloc,  // tp_dealloc
    (printfunc)MultiresControlAttributes_print,     // tp_print
    (getattrfunc)PyMultiresControlAttributes_getattr, // tp_getattr
    (setattrfunc)PyMultiresControlAttributes_setattr, // tp_setattr
    (cmpfunc)MultiresControlAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MultiresControlAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MultiresControlAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MultiresControlAttributes *defaultAtts = 0;
static MultiresControlAttributes *currentAtts = 0;

static PyObject *
NewMultiresControlAttributes(int useCurrent)
{
    MultiresControlAttributesObject *newObject;
    newObject = PyObject_NEW(MultiresControlAttributesObject, &MultiresControlAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MultiresControlAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MultiresControlAttributes(*defaultAtts);
    else
        newObject->data = new MultiresControlAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMultiresControlAttributes(const MultiresControlAttributes *attr)
{
    MultiresControlAttributesObject *newObject;
    newObject = PyObject_NEW(MultiresControlAttributesObject, &MultiresControlAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MultiresControlAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MultiresControlAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMultiresControlAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MultiresControlAttributesMethods[] = {
    {"MultiresControlAttributes", MultiresControlAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MultiresControlAttributesObserver = 0;

std::string
PyMultiresControlAttributes_GetLogString()
{
    std::string s("MultiresControlAtts = MultiresControlAttributes()\n");
    if(currentAtts != 0)
        s += PyMultiresControlAttributes_ToString(currentAtts, "MultiresControlAtts.");
    return s;
}

static void
PyMultiresControlAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MultiresControlAtts = MultiresControlAttributes()\n");
        s += PyMultiresControlAttributes_ToString(currentAtts, "MultiresControlAtts.");
        cb(s);
    }
}

void
PyMultiresControlAttributes_StartUp(MultiresControlAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMultiresControlAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MultiresControlAttributesObserver == 0)
    {
        MultiresControlAttributesObserver = new ObserverToCallback(subj,
            PyMultiresControlAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMultiresControlAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MultiresControlAttributesObserver;
    MultiresControlAttributesObserver = 0;
}

PyMethodDef *
PyMultiresControlAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MultiresControlAttributesMethods;
}

bool
PyMultiresControlAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MultiresControlAttributesType);
}

MultiresControlAttributes *
PyMultiresControlAttributes_FromPyObject(PyObject *obj)
{
    MultiresControlAttributesObject *obj2 = (MultiresControlAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMultiresControlAttributes_New()
{
    return NewMultiresControlAttributes(0);
}

PyObject *
PyMultiresControlAttributes_Wrap(const MultiresControlAttributes *attr)
{
    return WrapMultiresControlAttributes(attr);
}

void
PyMultiresControlAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MultiresControlAttributesObject *obj2 = (MultiresControlAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMultiresControlAttributes_SetDefaults(const MultiresControlAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MultiresControlAttributes(*atts);
}

