/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyScatterAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <GlyphTypes.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyScatterAttributes
//
// Purpose: 
//   Attributes for the scatter plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ScatterAttributes.
//
struct ScatterAttributesObject
{
    PyObject_HEAD
    ScatterAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewScatterAttributes(int);

std::string
PyScatterAttributes_ToString(const ScatterAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%svar1 = \"%s\"\n", prefix, atts->GetVar1().c_str());
    str += tmpStr;
    const char *var1Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    switch (atts->GetVar1Role())
    {
      case ScatterAttributes::Coordinate0:
          SNPRINTF(tmpStr, 1000, "%svar1Role = %sCoordinate0  # %s\n", prefix, prefix, var1Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate1:
          SNPRINTF(tmpStr, 1000, "%svar1Role = %sCoordinate1  # %s\n", prefix, prefix, var1Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate2:
          SNPRINTF(tmpStr, 1000, "%svar1Role = %sCoordinate2  # %s\n", prefix, prefix, var1Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Color:
          SNPRINTF(tmpStr, 1000, "%svar1Role = %sColor  # %s\n", prefix, prefix, var1Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svar1Role = %sNone  # %s\n", prefix, prefix, var1Role_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetVar1MinFlag())
        SNPRINTF(tmpStr, 1000, "%svar1MinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar1MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar1MaxFlag())
        SNPRINTF(tmpStr, 1000, "%svar1MaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar1MaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar1Min = %g\n", prefix, atts->GetVar1Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar1Max = %g\n", prefix, atts->GetVar1Max());
    str += tmpStr;
    const char *var1Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar1Scaling())
    {
      case ScatterAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%svar1Scaling = %sLinear  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%svar1Scaling = %sLog  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%svar1Scaling = %sSkew  # %s\n", prefix, prefix, var1Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar1SkewFactor = %g\n", prefix, atts->GetVar1SkewFactor());
    str += tmpStr;
    const char *var2Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    switch (atts->GetVar2Role())
    {
      case ScatterAttributes::Coordinate0:
          SNPRINTF(tmpStr, 1000, "%svar2Role = %sCoordinate0  # %s\n", prefix, prefix, var2Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate1:
          SNPRINTF(tmpStr, 1000, "%svar2Role = %sCoordinate1  # %s\n", prefix, prefix, var2Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate2:
          SNPRINTF(tmpStr, 1000, "%svar2Role = %sCoordinate2  # %s\n", prefix, prefix, var2Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Color:
          SNPRINTF(tmpStr, 1000, "%svar2Role = %sColor  # %s\n", prefix, prefix, var2Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svar2Role = %sNone  # %s\n", prefix, prefix, var2Role_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar2 = \"%s\"\n", prefix, atts->GetVar2().c_str());
    str += tmpStr;
    if(atts->GetVar2MinFlag())
        SNPRINTF(tmpStr, 1000, "%svar2MinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar2MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar2MaxFlag())
        SNPRINTF(tmpStr, 1000, "%svar2MaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar2MaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar2Min = %g\n", prefix, atts->GetVar2Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar2Max = %g\n", prefix, atts->GetVar2Max());
    str += tmpStr;
    const char *var2Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar2Scaling())
    {
      case ScatterAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%svar2Scaling = %sLinear  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%svar2Scaling = %sLog  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%svar2Scaling = %sSkew  # %s\n", prefix, prefix, var2Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar2SkewFactor = %g\n", prefix, atts->GetVar2SkewFactor());
    str += tmpStr;
    const char *var3Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    switch (atts->GetVar3Role())
    {
      case ScatterAttributes::Coordinate0:
          SNPRINTF(tmpStr, 1000, "%svar3Role = %sCoordinate0  # %s\n", prefix, prefix, var3Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate1:
          SNPRINTF(tmpStr, 1000, "%svar3Role = %sCoordinate1  # %s\n", prefix, prefix, var3Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate2:
          SNPRINTF(tmpStr, 1000, "%svar3Role = %sCoordinate2  # %s\n", prefix, prefix, var3Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Color:
          SNPRINTF(tmpStr, 1000, "%svar3Role = %sColor  # %s\n", prefix, prefix, var3Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svar3Role = %sNone  # %s\n", prefix, prefix, var3Role_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar3 = \"%s\"\n", prefix, atts->GetVar3().c_str());
    str += tmpStr;
    if(atts->GetVar3MinFlag())
        SNPRINTF(tmpStr, 1000, "%svar3MinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar3MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar3MaxFlag())
        SNPRINTF(tmpStr, 1000, "%svar3MaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar3MaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar3Min = %g\n", prefix, atts->GetVar3Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar3Max = %g\n", prefix, atts->GetVar3Max());
    str += tmpStr;
    const char *var3Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar3Scaling())
    {
      case ScatterAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%svar3Scaling = %sLinear  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%svar3Scaling = %sLog  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%svar3Scaling = %sSkew  # %s\n", prefix, prefix, var3Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar3SkewFactor = %g\n", prefix, atts->GetVar3SkewFactor());
    str += tmpStr;
    const char *var4Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    switch (atts->GetVar4Role())
    {
      case ScatterAttributes::Coordinate0:
          SNPRINTF(tmpStr, 1000, "%svar4Role = %sCoordinate0  # %s\n", prefix, prefix, var4Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate1:
          SNPRINTF(tmpStr, 1000, "%svar4Role = %sCoordinate1  # %s\n", prefix, prefix, var4Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Coordinate2:
          SNPRINTF(tmpStr, 1000, "%svar4Role = %sCoordinate2  # %s\n", prefix, prefix, var4Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Color:
          SNPRINTF(tmpStr, 1000, "%svar4Role = %sColor  # %s\n", prefix, prefix, var4Role_names);
          str += tmpStr;
          break;
      case ScatterAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svar4Role = %sNone  # %s\n", prefix, prefix, var4Role_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar4 = \"%s\"\n", prefix, atts->GetVar4().c_str());
    str += tmpStr;
    if(atts->GetVar4MinFlag())
        SNPRINTF(tmpStr, 1000, "%svar4MinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar4MinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVar4MaxFlag())
        SNPRINTF(tmpStr, 1000, "%svar4MaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svar4MaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar4Min = %g\n", prefix, atts->GetVar4Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svar4Max = %g\n", prefix, atts->GetVar4Max());
    str += tmpStr;
    const char *var4Scaling_names = "Linear, Log, Skew";
    switch (atts->GetVar4Scaling())
    {
      case ScatterAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%svar4Scaling = %sLinear  # %s\n", prefix, prefix, var4Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%svar4Scaling = %sLog  # %s\n", prefix, prefix, var4Scaling_names);
          str += tmpStr;
          break;
      case ScatterAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%svar4Scaling = %sSkew  # %s\n", prefix, prefix, var4Scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svar4SkewFactor = %g\n", prefix, atts->GetVar4SkewFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
        "SphereGeometry, Point, Sphere";
    switch (atts->GetPointType())
    {
      case Box:
          SNPRINTF(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Axis:
          SNPRINTF(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Icosahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Octahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sOctahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Tetrahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sTetrahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case SphereGeometry:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphereGeometry  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Point:
          SNPRINTF(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Sphere:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetScaleCube())
        SNPRINTF(tmpStr, 1000, "%sscaleCube = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sscaleCube = 0\n", prefix);
    str += tmpStr;
    const char *colorType_names = "ColorByForegroundColor, ColorBySingleColor, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case ScatterAttributes::ColorByForegroundColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByForegroundColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case ScatterAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case ScatterAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ScatterAttributes_Notify(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var1 in the object.
    obj->data->SetVar1(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar1().c_str());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar1Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var1Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1Role()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MinFlag in the object.
    obj->data->SetVar1MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MaxFlag in the object.
    obj->data->SetVar1MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Min in the object.
    obj->data->SetVar1Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Min());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Max in the object.
    obj->data->SetVar1Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Max());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar1Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var1Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1Scaling()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar1SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1SkewFactor in the object.
    obj->data->SetVar1SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar1SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1SkewFactor());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar2Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var2Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2Role()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var2 in the object.
    obj->data->SetVar2(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar2().c_str());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MinFlag in the object.
    obj->data->SetVar2MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MaxFlag in the object.
    obj->data->SetVar2MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Min in the object.
    obj->data->SetVar2Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Min());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Max in the object.
    obj->data->SetVar2Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Max());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar2Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var2Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2Scaling()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar2SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2SkewFactor in the object.
    obj->data->SetVar2SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar2SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2SkewFactor());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar3Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var3Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3Role()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var3 in the object.
    obj->data->SetVar3(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar3().c_str());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MinFlag in the object.
    obj->data->SetVar3MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MaxFlag in the object.
    obj->data->SetVar3MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Min in the object.
    obj->data->SetVar3Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Min());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Max in the object.
    obj->data->SetVar3Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Max());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar3Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var3Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3Scaling()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar3SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3SkewFactor in the object.
    obj->data->SetVar3SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar3SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3SkewFactor());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar4Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var4Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar4Role()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var4 in the object.
    obj->data->SetVar4(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar4().c_str());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4MinFlag in the object.
    obj->data->SetVar4MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar4MinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4MaxFlag in the object.
    obj->data->SetVar4MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar4MaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4Min in the object.
    obj->data->SetVar4Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4Min());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4Max in the object.
    obj->data->SetVar4Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4Max());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar4Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var4Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar4Scaling()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetVar4SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4SkewFactor in the object.
    obj->data->SetVar4SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetVar4SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4SkewFactor());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetPointType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if(ival >= 0 && ival < 8)
    {
        obj->data->SetPointType(GlyphType(ival));
    }
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
                        "SphereGeometry, Point, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetPointType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetScaleCube(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleCube in the object.
    obj->data->SetScaleCube(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetScaleCube(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleCube()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetColorType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(ScatterAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorByForegroundColor, ColorBySingleColor, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetColorType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ScatterAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ScatterAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}



PyMethodDef PyScatterAttributes_methods[SCATTERATTRIBUTES_NMETH] = {
    {"Notify", ScatterAttributes_Notify, METH_VARARGS},
    {"SetVar1", ScatterAttributes_SetVar1, METH_VARARGS},
    {"GetVar1", ScatterAttributes_GetVar1, METH_VARARGS},
    {"SetVar1Role", ScatterAttributes_SetVar1Role, METH_VARARGS},
    {"GetVar1Role", ScatterAttributes_GetVar1Role, METH_VARARGS},
    {"SetVar1MinFlag", ScatterAttributes_SetVar1MinFlag, METH_VARARGS},
    {"GetVar1MinFlag", ScatterAttributes_GetVar1MinFlag, METH_VARARGS},
    {"SetVar1MaxFlag", ScatterAttributes_SetVar1MaxFlag, METH_VARARGS},
    {"GetVar1MaxFlag", ScatterAttributes_GetVar1MaxFlag, METH_VARARGS},
    {"SetVar1Min", ScatterAttributes_SetVar1Min, METH_VARARGS},
    {"GetVar1Min", ScatterAttributes_GetVar1Min, METH_VARARGS},
    {"SetVar1Max", ScatterAttributes_SetVar1Max, METH_VARARGS},
    {"GetVar1Max", ScatterAttributes_GetVar1Max, METH_VARARGS},
    {"SetVar1Scaling", ScatterAttributes_SetVar1Scaling, METH_VARARGS},
    {"GetVar1Scaling", ScatterAttributes_GetVar1Scaling, METH_VARARGS},
    {"SetVar1SkewFactor", ScatterAttributes_SetVar1SkewFactor, METH_VARARGS},
    {"GetVar1SkewFactor", ScatterAttributes_GetVar1SkewFactor, METH_VARARGS},
    {"SetVar2Role", ScatterAttributes_SetVar2Role, METH_VARARGS},
    {"GetVar2Role", ScatterAttributes_GetVar2Role, METH_VARARGS},
    {"SetVar2", ScatterAttributes_SetVar2, METH_VARARGS},
    {"GetVar2", ScatterAttributes_GetVar2, METH_VARARGS},
    {"SetVar2MinFlag", ScatterAttributes_SetVar2MinFlag, METH_VARARGS},
    {"GetVar2MinFlag", ScatterAttributes_GetVar2MinFlag, METH_VARARGS},
    {"SetVar2MaxFlag", ScatterAttributes_SetVar2MaxFlag, METH_VARARGS},
    {"GetVar2MaxFlag", ScatterAttributes_GetVar2MaxFlag, METH_VARARGS},
    {"SetVar2Min", ScatterAttributes_SetVar2Min, METH_VARARGS},
    {"GetVar2Min", ScatterAttributes_GetVar2Min, METH_VARARGS},
    {"SetVar2Max", ScatterAttributes_SetVar2Max, METH_VARARGS},
    {"GetVar2Max", ScatterAttributes_GetVar2Max, METH_VARARGS},
    {"SetVar2Scaling", ScatterAttributes_SetVar2Scaling, METH_VARARGS},
    {"GetVar2Scaling", ScatterAttributes_GetVar2Scaling, METH_VARARGS},
    {"SetVar2SkewFactor", ScatterAttributes_SetVar2SkewFactor, METH_VARARGS},
    {"GetVar2SkewFactor", ScatterAttributes_GetVar2SkewFactor, METH_VARARGS},
    {"SetVar3Role", ScatterAttributes_SetVar3Role, METH_VARARGS},
    {"GetVar3Role", ScatterAttributes_GetVar3Role, METH_VARARGS},
    {"SetVar3", ScatterAttributes_SetVar3, METH_VARARGS},
    {"GetVar3", ScatterAttributes_GetVar3, METH_VARARGS},
    {"SetVar3MinFlag", ScatterAttributes_SetVar3MinFlag, METH_VARARGS},
    {"GetVar3MinFlag", ScatterAttributes_GetVar3MinFlag, METH_VARARGS},
    {"SetVar3MaxFlag", ScatterAttributes_SetVar3MaxFlag, METH_VARARGS},
    {"GetVar3MaxFlag", ScatterAttributes_GetVar3MaxFlag, METH_VARARGS},
    {"SetVar3Min", ScatterAttributes_SetVar3Min, METH_VARARGS},
    {"GetVar3Min", ScatterAttributes_GetVar3Min, METH_VARARGS},
    {"SetVar3Max", ScatterAttributes_SetVar3Max, METH_VARARGS},
    {"GetVar3Max", ScatterAttributes_GetVar3Max, METH_VARARGS},
    {"SetVar3Scaling", ScatterAttributes_SetVar3Scaling, METH_VARARGS},
    {"GetVar3Scaling", ScatterAttributes_GetVar3Scaling, METH_VARARGS},
    {"SetVar3SkewFactor", ScatterAttributes_SetVar3SkewFactor, METH_VARARGS},
    {"GetVar3SkewFactor", ScatterAttributes_GetVar3SkewFactor, METH_VARARGS},
    {"SetVar4Role", ScatterAttributes_SetVar4Role, METH_VARARGS},
    {"GetVar4Role", ScatterAttributes_GetVar4Role, METH_VARARGS},
    {"SetVar4", ScatterAttributes_SetVar4, METH_VARARGS},
    {"GetVar4", ScatterAttributes_GetVar4, METH_VARARGS},
    {"SetVar4MinFlag", ScatterAttributes_SetVar4MinFlag, METH_VARARGS},
    {"GetVar4MinFlag", ScatterAttributes_GetVar4MinFlag, METH_VARARGS},
    {"SetVar4MaxFlag", ScatterAttributes_SetVar4MaxFlag, METH_VARARGS},
    {"GetVar4MaxFlag", ScatterAttributes_GetVar4MaxFlag, METH_VARARGS},
    {"SetVar4Min", ScatterAttributes_SetVar4Min, METH_VARARGS},
    {"GetVar4Min", ScatterAttributes_GetVar4Min, METH_VARARGS},
    {"SetVar4Max", ScatterAttributes_SetVar4Max, METH_VARARGS},
    {"GetVar4Max", ScatterAttributes_GetVar4Max, METH_VARARGS},
    {"SetVar4Scaling", ScatterAttributes_SetVar4Scaling, METH_VARARGS},
    {"GetVar4Scaling", ScatterAttributes_GetVar4Scaling, METH_VARARGS},
    {"SetVar4SkewFactor", ScatterAttributes_SetVar4SkewFactor, METH_VARARGS},
    {"GetVar4SkewFactor", ScatterAttributes_GetVar4SkewFactor, METH_VARARGS},
    {"SetPointSize", ScatterAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", ScatterAttributes_GetPointSize, METH_VARARGS},
    {"SetPointSizePixels", ScatterAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", ScatterAttributes_GetPointSizePixels, METH_VARARGS},
    {"SetPointType", ScatterAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", ScatterAttributes_GetPointType, METH_VARARGS},
    {"SetScaleCube", ScatterAttributes_SetScaleCube, METH_VARARGS},
    {"GetScaleCube", ScatterAttributes_GetScaleCube, METH_VARARGS},
    {"SetColorType", ScatterAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", ScatterAttributes_GetColorType, METH_VARARGS},
    {"SetSingleColor", ScatterAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", ScatterAttributes_GetSingleColor, METH_VARARGS},
    {"SetColorTableName", ScatterAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", ScatterAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", ScatterAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", ScatterAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetLegendFlag", ScatterAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", ScatterAttributes_GetLegendFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ScatterAttributes_dealloc(PyObject *v)
{
   ScatterAttributesObject *obj = (ScatterAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ScatterAttributes_compare(PyObject *v, PyObject *w)
{
    ScatterAttributes *a = ((ScatterAttributesObject *)v)->data;
    ScatterAttributes *b = ((ScatterAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyScatterAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "var1") == 0)
        return ScatterAttributes_GetVar1(self, NULL);
    if(strcmp(name, "var1Role") == 0)
        return ScatterAttributes_GetVar1Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var1MinFlag") == 0)
        return ScatterAttributes_GetVar1MinFlag(self, NULL);
    if(strcmp(name, "var1MaxFlag") == 0)
        return ScatterAttributes_GetVar1MaxFlag(self, NULL);
    if(strcmp(name, "var1Min") == 0)
        return ScatterAttributes_GetVar1Min(self, NULL);
    if(strcmp(name, "var1Max") == 0)
        return ScatterAttributes_GetVar1Max(self, NULL);
    if(strcmp(name, "var1Scaling") == 0)
        return ScatterAttributes_GetVar1Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var1SkewFactor") == 0)
        return ScatterAttributes_GetVar1SkewFactor(self, NULL);
    if(strcmp(name, "var2Role") == 0)
        return ScatterAttributes_GetVar2Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var2") == 0)
        return ScatterAttributes_GetVar2(self, NULL);
    if(strcmp(name, "var2MinFlag") == 0)
        return ScatterAttributes_GetVar2MinFlag(self, NULL);
    if(strcmp(name, "var2MaxFlag") == 0)
        return ScatterAttributes_GetVar2MaxFlag(self, NULL);
    if(strcmp(name, "var2Min") == 0)
        return ScatterAttributes_GetVar2Min(self, NULL);
    if(strcmp(name, "var2Max") == 0)
        return ScatterAttributes_GetVar2Max(self, NULL);
    if(strcmp(name, "var2Scaling") == 0)
        return ScatterAttributes_GetVar2Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var2SkewFactor") == 0)
        return ScatterAttributes_GetVar2SkewFactor(self, NULL);
    if(strcmp(name, "var3Role") == 0)
        return ScatterAttributes_GetVar3Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var3") == 0)
        return ScatterAttributes_GetVar3(self, NULL);
    if(strcmp(name, "var3MinFlag") == 0)
        return ScatterAttributes_GetVar3MinFlag(self, NULL);
    if(strcmp(name, "var3MaxFlag") == 0)
        return ScatterAttributes_GetVar3MaxFlag(self, NULL);
    if(strcmp(name, "var3Min") == 0)
        return ScatterAttributes_GetVar3Min(self, NULL);
    if(strcmp(name, "var3Max") == 0)
        return ScatterAttributes_GetVar3Max(self, NULL);
    if(strcmp(name, "var3Scaling") == 0)
        return ScatterAttributes_GetVar3Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var3SkewFactor") == 0)
        return ScatterAttributes_GetVar3SkewFactor(self, NULL);
    if(strcmp(name, "var4Role") == 0)
        return ScatterAttributes_GetVar4Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var4") == 0)
        return ScatterAttributes_GetVar4(self, NULL);
    if(strcmp(name, "var4MinFlag") == 0)
        return ScatterAttributes_GetVar4MinFlag(self, NULL);
    if(strcmp(name, "var4MaxFlag") == 0)
        return ScatterAttributes_GetVar4MaxFlag(self, NULL);
    if(strcmp(name, "var4Min") == 0)
        return ScatterAttributes_GetVar4Min(self, NULL);
    if(strcmp(name, "var4Max") == 0)
        return ScatterAttributes_GetVar4Max(self, NULL);
    if(strcmp(name, "var4Scaling") == 0)
        return ScatterAttributes_GetVar4Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var4SkewFactor") == 0)
        return ScatterAttributes_GetVar4SkewFactor(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return ScatterAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return ScatterAttributes_GetPointSizePixels(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return ScatterAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(Icosahedron));
    if(strcmp(name, "Octahedron") == 0)
        return PyInt_FromLong(long(Octahedron));
    if(strcmp(name, "Tetrahedron") == 0)
        return PyInt_FromLong(long(Tetrahedron));
    if(strcmp(name, "SphereGeometry") == 0)
        return PyInt_FromLong(long(SphereGeometry));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(Sphere));

    if(strcmp(name, "scaleCube") == 0)
        return ScatterAttributes_GetScaleCube(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return ScatterAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorByForegroundColor") == 0)
        return PyInt_FromLong(long(ScatterAttributes::ColorByForegroundColor));
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(ScatterAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(ScatterAttributes::ColorByColorTable));

    if(strcmp(name, "singleColor") == 0)
        return ScatterAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return ScatterAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return ScatterAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return ScatterAttributes_GetLegendFlag(self, NULL);

    // try to handle old attributes
    if(strcmp(name, "foregroundFlag") == 0)
    {
        if( ScatterAttributes_GetColorType(self, NULL) == PyInt_FromLong(0) )
        {
            PyObject *retval = PyInt_FromLong(1);
            return retval;
        }
        else //if( ScatterAttributes_GetColorType(self, NULL) == PyInt_FromLong(1) )
        {
            PyObject *retval = PyInt_FromLong(0);
            return retval;
        }
    }
    return Py_FindMethod(PyScatterAttributes_methods, self, name);
}

int
PyScatterAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "var1") == 0)
        obj = ScatterAttributes_SetVar1(self, tuple);
    else if(strcmp(name, "var1Role") == 0)
        obj = ScatterAttributes_SetVar1Role(self, tuple);
    else if(strcmp(name, "var1MinFlag") == 0)
        obj = ScatterAttributes_SetVar1MinFlag(self, tuple);
    else if(strcmp(name, "var1MaxFlag") == 0)
        obj = ScatterAttributes_SetVar1MaxFlag(self, tuple);
    else if(strcmp(name, "var1Min") == 0)
        obj = ScatterAttributes_SetVar1Min(self, tuple);
    else if(strcmp(name, "var1Max") == 0)
        obj = ScatterAttributes_SetVar1Max(self, tuple);
    else if(strcmp(name, "var1Scaling") == 0)
        obj = ScatterAttributes_SetVar1Scaling(self, tuple);
    else if(strcmp(name, "var1SkewFactor") == 0)
        obj = ScatterAttributes_SetVar1SkewFactor(self, tuple);
    else if(strcmp(name, "var2Role") == 0)
        obj = ScatterAttributes_SetVar2Role(self, tuple);
    else if(strcmp(name, "var2") == 0)
        obj = ScatterAttributes_SetVar2(self, tuple);
    else if(strcmp(name, "var2MinFlag") == 0)
        obj = ScatterAttributes_SetVar2MinFlag(self, tuple);
    else if(strcmp(name, "var2MaxFlag") == 0)
        obj = ScatterAttributes_SetVar2MaxFlag(self, tuple);
    else if(strcmp(name, "var2Min") == 0)
        obj = ScatterAttributes_SetVar2Min(self, tuple);
    else if(strcmp(name, "var2Max") == 0)
        obj = ScatterAttributes_SetVar2Max(self, tuple);
    else if(strcmp(name, "var2Scaling") == 0)
        obj = ScatterAttributes_SetVar2Scaling(self, tuple);
    else if(strcmp(name, "var2SkewFactor") == 0)
        obj = ScatterAttributes_SetVar2SkewFactor(self, tuple);
    else if(strcmp(name, "var3Role") == 0)
        obj = ScatterAttributes_SetVar3Role(self, tuple);
    else if(strcmp(name, "var3") == 0)
        obj = ScatterAttributes_SetVar3(self, tuple);
    else if(strcmp(name, "var3MinFlag") == 0)
        obj = ScatterAttributes_SetVar3MinFlag(self, tuple);
    else if(strcmp(name, "var3MaxFlag") == 0)
        obj = ScatterAttributes_SetVar3MaxFlag(self, tuple);
    else if(strcmp(name, "var3Min") == 0)
        obj = ScatterAttributes_SetVar3Min(self, tuple);
    else if(strcmp(name, "var3Max") == 0)
        obj = ScatterAttributes_SetVar3Max(self, tuple);
    else if(strcmp(name, "var3Scaling") == 0)
        obj = ScatterAttributes_SetVar3Scaling(self, tuple);
    else if(strcmp(name, "var3SkewFactor") == 0)
        obj = ScatterAttributes_SetVar3SkewFactor(self, tuple);
    else if(strcmp(name, "var4Role") == 0)
        obj = ScatterAttributes_SetVar4Role(self, tuple);
    else if(strcmp(name, "var4") == 0)
        obj = ScatterAttributes_SetVar4(self, tuple);
    else if(strcmp(name, "var4MinFlag") == 0)
        obj = ScatterAttributes_SetVar4MinFlag(self, tuple);
    else if(strcmp(name, "var4MaxFlag") == 0)
        obj = ScatterAttributes_SetVar4MaxFlag(self, tuple);
    else if(strcmp(name, "var4Min") == 0)
        obj = ScatterAttributes_SetVar4Min(self, tuple);
    else if(strcmp(name, "var4Max") == 0)
        obj = ScatterAttributes_SetVar4Max(self, tuple);
    else if(strcmp(name, "var4Scaling") == 0)
        obj = ScatterAttributes_SetVar4Scaling(self, tuple);
    else if(strcmp(name, "var4SkewFactor") == 0)
        obj = ScatterAttributes_SetVar4SkewFactor(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = ScatterAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = ScatterAttributes_SetPointSizePixels(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = ScatterAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "scaleCube") == 0)
        obj = ScatterAttributes_SetScaleCube(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = ScatterAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = ScatterAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = ScatterAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = ScatterAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = ScatterAttributes_SetLegendFlag(self, tuple);


    // try to handle old attributes
    if(strcmp(name, "foregroundFlag") == 0)
    {
        PyObject *new_args = NULL;

        // from the tuple get the foreground value
        int ival;
        if(!PyArg_ParseTuple(tuple, "i", &ival))
              new_args = Py_BuildValue("(i)", 0);

        // foreground is false so single color and color type is 1
        else if( ival == 0 )
        {
            new_args = Py_BuildValue("(i)", 1);
        }
        // foreground is true so foreground color and color type is 0
        else if( ival == 1 )
        {
            new_args = Py_BuildValue("(i)", 0);
        }

        if (new_args)
        {
            obj = ScatterAttributes_SetColorType(self, new_args);
     
            Py_DECREF(new_args);
        }
    }

    // If the user changes one of the roles and one of the roles is
    // "Color" then assume that they want to use the color table.

    // The above maintains backwards compatibility. Below allows new
    // foreward new capibility.

    // If they do not want to use the color table and want to use
    // either the foreground or a single color they must set it after
    // all variables (roles) have been set.
    if( strcmp(name, "var1Role") == 0 ||
        strcmp(name, "var2Role") == 0 ||
        strcmp(name, "var3Role") == 0 ||
        strcmp(name, "var4Role") == 0 )
    {
        // A color variable has been specified.
        if(ScatterAttributes_GetVar1Role(self, NULL) == PyInt_FromLong(3) ||
           ScatterAttributes_GetVar2Role(self, NULL) == PyInt_FromLong(3) ||
           ScatterAttributes_GetVar3Role(self, NULL) == PyInt_FromLong(3) ||
           ScatterAttributes_GetVar4Role(self, NULL) == PyInt_FromLong(3) )
        {
            PyObject *new_args = Py_BuildValue("(i)", 2);
            obj = ScatterAttributes_SetColorType(self, new_args);
            Py_DECREF(new_args);
        }

        // No color variable so use the foreground as a default.
        else
        {
            PyObject *new_args = Py_BuildValue("(i)", 0);
            obj = ScatterAttributes_SetColorType(self, new_args);
            Py_DECREF(new_args);
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ScatterAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)v;
    fprintf(fp, "%s", PyScatterAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ScatterAttributes_str(PyObject *v)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)v;
    return PyString_FromString(PyScatterAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ScatterAttributes_Purpose = "Attributes for the scatter plot";
#else
static char *ScatterAttributes_Purpose = "Attributes for the scatter plot";
#endif

//
// The type description structure
//
static PyTypeObject ScatterAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ScatterAttributes",                    // tp_name
    sizeof(ScatterAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ScatterAttributes_dealloc,  // tp_dealloc
    (printfunc)ScatterAttributes_print,     // tp_print
    (getattrfunc)PyScatterAttributes_getattr, // tp_getattr
    (setattrfunc)PyScatterAttributes_setattr, // tp_setattr
    (cmpfunc)ScatterAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ScatterAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ScatterAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ScatterAttributes *defaultAtts = 0;
static ScatterAttributes *currentAtts = 0;

static PyObject *
NewScatterAttributes(int useCurrent)
{
    ScatterAttributesObject *newObject;
    newObject = PyObject_NEW(ScatterAttributesObject, &ScatterAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ScatterAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ScatterAttributes(*defaultAtts);
    else
        newObject->data = new ScatterAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapScatterAttributes(const ScatterAttributes *attr)
{
    ScatterAttributesObject *newObject;
    newObject = PyObject_NEW(ScatterAttributesObject, &ScatterAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ScatterAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ScatterAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewScatterAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ScatterAttributesMethods[] = {
    {"ScatterAttributes", ScatterAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ScatterAttributesObserver = 0;

std::string
PyScatterAttributes_GetLogString()
{
    std::string s("ScatterAtts = ScatterAttributes()\n");
    if(currentAtts != 0)
        s += PyScatterAttributes_ToString(currentAtts, "ScatterAtts.");
    return s;
}

static void
PyScatterAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ScatterAtts = ScatterAttributes()\n");
        s += PyScatterAttributes_ToString(currentAtts, "ScatterAtts.");
        cb(s);
    }
}

void
PyScatterAttributes_StartUp(ScatterAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyScatterAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ScatterAttributesObserver == 0)
    {
        ScatterAttributesObserver = new ObserverToCallback(subj,
            PyScatterAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyScatterAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ScatterAttributesObserver;
    ScatterAttributesObserver = 0;
}

PyMethodDef *
PyScatterAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ScatterAttributesMethods;
}

bool
PyScatterAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ScatterAttributesType);
}

ScatterAttributes *
PyScatterAttributes_FromPyObject(PyObject *obj)
{
    ScatterAttributesObject *obj2 = (ScatterAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyScatterAttributes_New()
{
    return NewScatterAttributes(0);
}

PyObject *
PyScatterAttributes_Wrap(const ScatterAttributes *attr)
{
    return WrapScatterAttributes(attr);
}

void
PyScatterAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ScatterAttributesObject *obj2 = (ScatterAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyScatterAttributes_SetDefaults(const ScatterAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ScatterAttributes(*atts);
}

