/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPickAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyPickVarInfo.h>

// ****************************************************************************
// Module: PyPickAttributes
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PickAttributes.
//
struct PickAttributesObject
{
    PyObject_HEAD
    PickAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPickAttributes(int);

std::string
PyPickAttributes_ToString(const PickAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &variables = atts->GetVariables();
        SNPRINTF(tmpStr, 1000, "%svariables = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < variables.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", variables[i].c_str());
            str += tmpStr;
            if(i < variables.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetShowIncidentElements())
        SNPRINTF(tmpStr, 1000, "%sshowIncidentElements = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowIncidentElements = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodeId())
        SNPRINTF(tmpStr, 1000, "%sshowNodeId = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNodeId = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodeDomainLogicalCoords())
        SNPRINTF(tmpStr, 1000, "%sshowNodeDomainLogicalCoords = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNodeDomainLogicalCoords = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodeBlockLogicalCoords())
        SNPRINTF(tmpStr, 1000, "%sshowNodeBlockLogicalCoords = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNodeBlockLogicalCoords = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodePhysicalCoords())
        SNPRINTF(tmpStr, 1000, "%sshowNodePhysicalCoords = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNodePhysicalCoords = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowZoneId())
        SNPRINTF(tmpStr, 1000, "%sshowZoneId = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowZoneId = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowZoneDomainLogicalCoords())
        SNPRINTF(tmpStr, 1000, "%sshowZoneDomainLogicalCoords = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowZoneDomainLogicalCoords = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowZoneBlockLogicalCoords())
        SNPRINTF(tmpStr, 1000, "%sshowZoneBlockLogicalCoords = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowZoneBlockLogicalCoords = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDoTimeCurve())
        SNPRINTF(tmpStr, 1000, "%sdoTimeCurve = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoTimeCurve = 0\n", prefix);
    str += tmpStr;
    if(atts->GetConciseOutput())
        SNPRINTF(tmpStr, 1000, "%sconciseOutput = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sconciseOutput = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowTimeStep())
        SNPRINTF(tmpStr, 1000, "%sshowTimeStep = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowTimeStep = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowMeshName())
        SNPRINTF(tmpStr, 1000, "%sshowMeshName = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowMeshName = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sblockPieceName = \"%s\"\n", prefix, atts->GetBlockPieceName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sgroupPieceName = \"%s\"\n", prefix, atts->GetGroupPieceName().c_str());
    str += tmpStr;
    if(atts->GetShowGlobalIds())
        SNPRINTF(tmpStr, 1000, "%sshowGlobalIds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowGlobalIds = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowPickLetter())
        SNPRINTF(tmpStr, 1000, "%sshowPickLetter = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowPickLetter = 0\n", prefix);
    str += tmpStr;
    if(atts->GetReusePickLetter())
        SNPRINTF(tmpStr, 1000, "%sreusePickLetter = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sreusePickLetter = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowPickHighlight())
        SNPRINTF(tmpStr, 1000, "%sshowPickHighlight = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowPickHighlight = 0\n", prefix);
    str += tmpStr;
    if(atts->GetNotifyEnabled())
        SNPRINTF(tmpStr, 1000, "%snotifyEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snotifyEnabled = 0\n", prefix);
    str += tmpStr;
    const char *meshCoordType_names = "XY, RZ, ZR";
    switch (atts->GetMeshCoordType())
    {
      case PickAttributes::XY:
          SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sXY  # %s\n", prefix, prefix, meshCoordType_names);
          str += tmpStr;
          break;
      case PickAttributes::RZ:
          SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sRZ  # %s\n", prefix, prefix, meshCoordType_names);
          str += tmpStr;
          break;
      case PickAttributes::ZR:
          SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sZR  # %s\n", prefix, prefix, meshCoordType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetCreateSpreadsheet())
        SNPRINTF(tmpStr, 1000, "%screateSpreadsheet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateSpreadsheet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfloatFormat = \"%s\"\n", prefix, atts->GetFloatFormat().c_str());
    str += tmpStr;
    if(atts->GetTimePreserveCoord())
        SNPRINTF(tmpStr, 1000, "%stimePreserveCoord = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stimePreserveCoord = 0\n", prefix);
    str += tmpStr;
    const char *timeCurveType_names = "Single_Y_Axis, Multiple_Y_Axes";
    switch (atts->GetTimeCurveType())
    {
      case PickAttributes::Single_Y_Axis:
          SNPRINTF(tmpStr, 1000, "%stimeCurveType = %sSingle_Y_Axis  # %s\n", prefix, prefix, timeCurveType_names);
          str += tmpStr;
          break;
      case PickAttributes::Multiple_Y_Axes:
          SNPRINTF(tmpStr, 1000, "%stimeCurveType = %sMultiple_Y_Axes  # %s\n", prefix, prefix, timeCurveType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
PickAttributes_Notify(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_SetVariables(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    stringVector  &vec = obj->data->GetVariables();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the variables in the object as modified.
    obj->data->SelectVariables();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetVariables(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the variables.
    const stringVector &variables = obj->data->GetVariables();
    PyObject *retval = PyTuple_New(variables.size());
    for(size_t i = 0; i < variables.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(variables[i].c_str()));
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowIncidentElements(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showIncidentElements in the object.
    obj->data->SetShowIncidentElements(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowIncidentElements(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowIncidentElements()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowNodeId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeId in the object.
    obj->data->SetShowNodeId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowNodeId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeId()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowNodeDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeDomainLogicalCoords in the object.
    obj->data->SetShowNodeDomainLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowNodeDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeDomainLogicalCoords()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowNodeBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeBlockLogicalCoords in the object.
    obj->data->SetShowNodeBlockLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowNodeBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeBlockLogicalCoords()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowNodePhysicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodePhysicalCoords in the object.
    obj->data->SetShowNodePhysicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowNodePhysicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodePhysicalCoords()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowZoneId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneId in the object.
    obj->data->SetShowZoneId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowZoneId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneId()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowZoneDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneDomainLogicalCoords in the object.
    obj->data->SetShowZoneDomainLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowZoneDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneDomainLogicalCoords()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowZoneBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneBlockLogicalCoords in the object.
    obj->data->SetShowZoneBlockLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowZoneBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneBlockLogicalCoords()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetDoTimeCurve(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTimeCurve in the object.
    obj->data->SetDoTimeCurve(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetDoTimeCurve(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTimeCurve()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetConciseOutput(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the conciseOutput in the object.
    obj->data->SetConciseOutput(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetConciseOutput(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetConciseOutput()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowTimeStep(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showTimeStep in the object.
    obj->data->SetShowTimeStep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowTimeStep(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowTimeStep()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowMeshName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showMeshName in the object.
    obj->data->SetShowMeshName(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowMeshName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowMeshName()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetBlockPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the blockPieceName in the object.
    obj->data->SetBlockPieceName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetBlockPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetBlockPieceName().c_str());
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetGroupPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the groupPieceName in the object.
    obj->data->SetGroupPieceName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetGroupPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetGroupPieceName().c_str());
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowGlobalIds(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showGlobalIds in the object.
    obj->data->SetShowGlobalIds(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowGlobalIds(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowGlobalIds()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowPickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPickLetter in the object.
    obj->data->SetShowPickLetter(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowPickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPickLetter()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetReusePickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the reusePickLetter in the object.
    obj->data->SetReusePickLetter(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetReusePickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetReusePickLetter()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetShowPickHighlight(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPickHighlight in the object.
    obj->data->SetShowPickHighlight(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetShowPickHighlight(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPickHighlight()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetNotifyEnabled(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the notifyEnabled in the object.
    obj->data->SetNotifyEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetNotifyEnabled(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNotifyEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetMeshCoordType(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshCoordType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetMeshCoordType(PickAttributes::CoordinateType(ival));
    else
    {
        fprintf(stderr, "An invalid meshCoordType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "XY, RZ, ZR.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetMeshCoordType(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshCoordType()));
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetCreateSpreadsheet(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createSpreadsheet in the object.
    obj->data->SetCreateSpreadsheet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetCreateSpreadsheet(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateSpreadsheet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetFloatFormat(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the floatFormat in the object.
    obj->data->SetFloatFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetFloatFormat(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFloatFormat().c_str());
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetTimePreserveCoord(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timePreserveCoord in the object.
    obj->data->SetTimePreserveCoord(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetTimePreserveCoord(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTimePreserveCoord()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickAttributes_SetTimeCurveType(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeCurveType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTimeCurveType(PickAttributes::TimeCurveType(ival));
    else
    {
        fprintf(stderr, "An invalid timeCurveType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Single_Y_Axis, Multiple_Y_Axes.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickAttributes_GetTimeCurveType(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeCurveType()));
    return retval;
}



PyMethodDef PyPickAttributes_methods[PICKATTRIBUTES_NMETH] = {
    {"Notify", PickAttributes_Notify, METH_VARARGS},
    {"SetVariables", PickAttributes_SetVariables, METH_VARARGS},
    {"GetVariables", PickAttributes_GetVariables, METH_VARARGS},
    {"SetShowIncidentElements", PickAttributes_SetShowIncidentElements, METH_VARARGS},
    {"GetShowIncidentElements", PickAttributes_GetShowIncidentElements, METH_VARARGS},
    {"SetShowNodeId", PickAttributes_SetShowNodeId, METH_VARARGS},
    {"GetShowNodeId", PickAttributes_GetShowNodeId, METH_VARARGS},
    {"SetShowNodeDomainLogicalCoords", PickAttributes_SetShowNodeDomainLogicalCoords, METH_VARARGS},
    {"GetShowNodeDomainLogicalCoords", PickAttributes_GetShowNodeDomainLogicalCoords, METH_VARARGS},
    {"SetShowNodeBlockLogicalCoords", PickAttributes_SetShowNodeBlockLogicalCoords, METH_VARARGS},
    {"GetShowNodeBlockLogicalCoords", PickAttributes_GetShowNodeBlockLogicalCoords, METH_VARARGS},
    {"SetShowNodePhysicalCoords", PickAttributes_SetShowNodePhysicalCoords, METH_VARARGS},
    {"GetShowNodePhysicalCoords", PickAttributes_GetShowNodePhysicalCoords, METH_VARARGS},
    {"SetShowZoneId", PickAttributes_SetShowZoneId, METH_VARARGS},
    {"GetShowZoneId", PickAttributes_GetShowZoneId, METH_VARARGS},
    {"SetShowZoneDomainLogicalCoords", PickAttributes_SetShowZoneDomainLogicalCoords, METH_VARARGS},
    {"GetShowZoneDomainLogicalCoords", PickAttributes_GetShowZoneDomainLogicalCoords, METH_VARARGS},
    {"SetShowZoneBlockLogicalCoords", PickAttributes_SetShowZoneBlockLogicalCoords, METH_VARARGS},
    {"GetShowZoneBlockLogicalCoords", PickAttributes_GetShowZoneBlockLogicalCoords, METH_VARARGS},
    {"SetDoTimeCurve", PickAttributes_SetDoTimeCurve, METH_VARARGS},
    {"GetDoTimeCurve", PickAttributes_GetDoTimeCurve, METH_VARARGS},
    {"SetConciseOutput", PickAttributes_SetConciseOutput, METH_VARARGS},
    {"GetConciseOutput", PickAttributes_GetConciseOutput, METH_VARARGS},
    {"SetShowTimeStep", PickAttributes_SetShowTimeStep, METH_VARARGS},
    {"GetShowTimeStep", PickAttributes_GetShowTimeStep, METH_VARARGS},
    {"SetShowMeshName", PickAttributes_SetShowMeshName, METH_VARARGS},
    {"GetShowMeshName", PickAttributes_GetShowMeshName, METH_VARARGS},
    {"SetBlockPieceName", PickAttributes_SetBlockPieceName, METH_VARARGS},
    {"GetBlockPieceName", PickAttributes_GetBlockPieceName, METH_VARARGS},
    {"SetGroupPieceName", PickAttributes_SetGroupPieceName, METH_VARARGS},
    {"GetGroupPieceName", PickAttributes_GetGroupPieceName, METH_VARARGS},
    {"SetShowGlobalIds", PickAttributes_SetShowGlobalIds, METH_VARARGS},
    {"GetShowGlobalIds", PickAttributes_GetShowGlobalIds, METH_VARARGS},
    {"SetShowPickLetter", PickAttributes_SetShowPickLetter, METH_VARARGS},
    {"GetShowPickLetter", PickAttributes_GetShowPickLetter, METH_VARARGS},
    {"SetReusePickLetter", PickAttributes_SetReusePickLetter, METH_VARARGS},
    {"GetReusePickLetter", PickAttributes_GetReusePickLetter, METH_VARARGS},
    {"SetShowPickHighlight", PickAttributes_SetShowPickHighlight, METH_VARARGS},
    {"GetShowPickHighlight", PickAttributes_GetShowPickHighlight, METH_VARARGS},
    {"SetNotifyEnabled", PickAttributes_SetNotifyEnabled, METH_VARARGS},
    {"GetNotifyEnabled", PickAttributes_GetNotifyEnabled, METH_VARARGS},
    {"SetMeshCoordType", PickAttributes_SetMeshCoordType, METH_VARARGS},
    {"GetMeshCoordType", PickAttributes_GetMeshCoordType, METH_VARARGS},
    {"SetCreateSpreadsheet", PickAttributes_SetCreateSpreadsheet, METH_VARARGS},
    {"GetCreateSpreadsheet", PickAttributes_GetCreateSpreadsheet, METH_VARARGS},
    {"SetFloatFormat", PickAttributes_SetFloatFormat, METH_VARARGS},
    {"GetFloatFormat", PickAttributes_GetFloatFormat, METH_VARARGS},
    {"SetTimePreserveCoord", PickAttributes_SetTimePreserveCoord, METH_VARARGS},
    {"GetTimePreserveCoord", PickAttributes_GetTimePreserveCoord, METH_VARARGS},
    {"SetTimeCurveType", PickAttributes_SetTimeCurveType, METH_VARARGS},
    {"GetTimeCurveType", PickAttributes_GetTimeCurveType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PickAttributes_dealloc(PyObject *v)
{
   PickAttributesObject *obj = (PickAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PickAttributes_compare(PyObject *v, PyObject *w)
{
    PickAttributes *a = ((PickAttributesObject *)v)->data;
    PickAttributes *b = ((PickAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPickAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "variables") == 0)
        return PickAttributes_GetVariables(self, NULL);
    if(strcmp(name, "showIncidentElements") == 0)
        return PickAttributes_GetShowIncidentElements(self, NULL);
    if(strcmp(name, "showNodeId") == 0)
        return PickAttributes_GetShowNodeId(self, NULL);
    if(strcmp(name, "showNodeDomainLogicalCoords") == 0)
        return PickAttributes_GetShowNodeDomainLogicalCoords(self, NULL);
    if(strcmp(name, "showNodeBlockLogicalCoords") == 0)
        return PickAttributes_GetShowNodeBlockLogicalCoords(self, NULL);
    if(strcmp(name, "showNodePhysicalCoords") == 0)
        return PickAttributes_GetShowNodePhysicalCoords(self, NULL);
    if(strcmp(name, "showZoneId") == 0)
        return PickAttributes_GetShowZoneId(self, NULL);
    if(strcmp(name, "showZoneDomainLogicalCoords") == 0)
        return PickAttributes_GetShowZoneDomainLogicalCoords(self, NULL);
    if(strcmp(name, "showZoneBlockLogicalCoords") == 0)
        return PickAttributes_GetShowZoneBlockLogicalCoords(self, NULL);
    if(strcmp(name, "doTimeCurve") == 0)
        return PickAttributes_GetDoTimeCurve(self, NULL);
    if(strcmp(name, "conciseOutput") == 0)
        return PickAttributes_GetConciseOutput(self, NULL);
    if(strcmp(name, "showTimeStep") == 0)
        return PickAttributes_GetShowTimeStep(self, NULL);
    if(strcmp(name, "showMeshName") == 0)
        return PickAttributes_GetShowMeshName(self, NULL);
    if(strcmp(name, "blockPieceName") == 0)
        return PickAttributes_GetBlockPieceName(self, NULL);
    if(strcmp(name, "groupPieceName") == 0)
        return PickAttributes_GetGroupPieceName(self, NULL);
    if(strcmp(name, "showGlobalIds") == 0)
        return PickAttributes_GetShowGlobalIds(self, NULL);
    if(strcmp(name, "showPickLetter") == 0)
        return PickAttributes_GetShowPickLetter(self, NULL);
    if(strcmp(name, "reusePickLetter") == 0)
        return PickAttributes_GetReusePickLetter(self, NULL);
    if(strcmp(name, "showPickHighlight") == 0)
        return PickAttributes_GetShowPickHighlight(self, NULL);
    if(strcmp(name, "notifyEnabled") == 0)
        return PickAttributes_GetNotifyEnabled(self, NULL);
    if(strcmp(name, "meshCoordType") == 0)
        return PickAttributes_GetMeshCoordType(self, NULL);
    if(strcmp(name, "XY") == 0)
        return PyInt_FromLong(long(PickAttributes::XY));
    if(strcmp(name, "RZ") == 0)
        return PyInt_FromLong(long(PickAttributes::RZ));
    if(strcmp(name, "ZR") == 0)
        return PyInt_FromLong(long(PickAttributes::ZR));

    if(strcmp(name, "createSpreadsheet") == 0)
        return PickAttributes_GetCreateSpreadsheet(self, NULL);
    if(strcmp(name, "floatFormat") == 0)
        return PickAttributes_GetFloatFormat(self, NULL);
    if(strcmp(name, "timePreserveCoord") == 0)
        return PickAttributes_GetTimePreserveCoord(self, NULL);
    if(strcmp(name, "timeCurveType") == 0)
        return PickAttributes_GetTimeCurveType(self, NULL);
    if(strcmp(name, "Single_Y_Axis") == 0)
        return PyInt_FromLong(long(PickAttributes::Single_Y_Axis));
    if(strcmp(name, "Multiple_Y_Axes") == 0)
        return PyInt_FromLong(long(PickAttributes::Multiple_Y_Axes));


    return Py_FindMethod(PyPickAttributes_methods, self, name);
}

int
PyPickAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "variables") == 0)
        obj = PickAttributes_SetVariables(self, tuple);
    else if(strcmp(name, "showIncidentElements") == 0)
        obj = PickAttributes_SetShowIncidentElements(self, tuple);
    else if(strcmp(name, "showNodeId") == 0)
        obj = PickAttributes_SetShowNodeId(self, tuple);
    else if(strcmp(name, "showNodeDomainLogicalCoords") == 0)
        obj = PickAttributes_SetShowNodeDomainLogicalCoords(self, tuple);
    else if(strcmp(name, "showNodeBlockLogicalCoords") == 0)
        obj = PickAttributes_SetShowNodeBlockLogicalCoords(self, tuple);
    else if(strcmp(name, "showNodePhysicalCoords") == 0)
        obj = PickAttributes_SetShowNodePhysicalCoords(self, tuple);
    else if(strcmp(name, "showZoneId") == 0)
        obj = PickAttributes_SetShowZoneId(self, tuple);
    else if(strcmp(name, "showZoneDomainLogicalCoords") == 0)
        obj = PickAttributes_SetShowZoneDomainLogicalCoords(self, tuple);
    else if(strcmp(name, "showZoneBlockLogicalCoords") == 0)
        obj = PickAttributes_SetShowZoneBlockLogicalCoords(self, tuple);
    else if(strcmp(name, "doTimeCurve") == 0)
        obj = PickAttributes_SetDoTimeCurve(self, tuple);
    else if(strcmp(name, "conciseOutput") == 0)
        obj = PickAttributes_SetConciseOutput(self, tuple);
    else if(strcmp(name, "showTimeStep") == 0)
        obj = PickAttributes_SetShowTimeStep(self, tuple);
    else if(strcmp(name, "showMeshName") == 0)
        obj = PickAttributes_SetShowMeshName(self, tuple);
    else if(strcmp(name, "blockPieceName") == 0)
        obj = PickAttributes_SetBlockPieceName(self, tuple);
    else if(strcmp(name, "groupPieceName") == 0)
        obj = PickAttributes_SetGroupPieceName(self, tuple);
    else if(strcmp(name, "showGlobalIds") == 0)
        obj = PickAttributes_SetShowGlobalIds(self, tuple);
    else if(strcmp(name, "showPickLetter") == 0)
        obj = PickAttributes_SetShowPickLetter(self, tuple);
    else if(strcmp(name, "reusePickLetter") == 0)
        obj = PickAttributes_SetReusePickLetter(self, tuple);
    else if(strcmp(name, "showPickHighlight") == 0)
        obj = PickAttributes_SetShowPickHighlight(self, tuple);
    else if(strcmp(name, "notifyEnabled") == 0)
        obj = PickAttributes_SetNotifyEnabled(self, tuple);
    else if(strcmp(name, "meshCoordType") == 0)
        obj = PickAttributes_SetMeshCoordType(self, tuple);
    else if(strcmp(name, "createSpreadsheet") == 0)
        obj = PickAttributes_SetCreateSpreadsheet(self, tuple);
    else if(strcmp(name, "floatFormat") == 0)
        obj = PickAttributes_SetFloatFormat(self, tuple);
    else if(strcmp(name, "timePreserveCoord") == 0)
        obj = PickAttributes_SetTimePreserveCoord(self, tuple);
    else if(strcmp(name, "timeCurveType") == 0)
        obj = PickAttributes_SetTimeCurveType(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PickAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PickAttributesObject *obj = (PickAttributesObject *)v;
    fprintf(fp, "%s", PyPickAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PickAttributes_str(PyObject *v)
{
    PickAttributesObject *obj = (PickAttributesObject *)v;
    return PyString_FromString(PyPickAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PickAttributes_Purpose = "This class contains attributes used for pick.";
#else
static char *PickAttributes_Purpose = "This class contains attributes used for pick.";
#endif

//
// The type description structure
//
static PyTypeObject PickAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PickAttributes",                    // tp_name
    sizeof(PickAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PickAttributes_dealloc,  // tp_dealloc
    (printfunc)PickAttributes_print,     // tp_print
    (getattrfunc)PyPickAttributes_getattr, // tp_getattr
    (setattrfunc)PyPickAttributes_setattr, // tp_setattr
    (cmpfunc)PickAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PickAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PickAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PickAttributes *defaultAtts = 0;
static PickAttributes *currentAtts = 0;

static PyObject *
NewPickAttributes(int useCurrent)
{
    PickAttributesObject *newObject;
    newObject = PyObject_NEW(PickAttributesObject, &PickAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PickAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PickAttributes(*defaultAtts);
    else
        newObject->data = new PickAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPickAttributes(const PickAttributes *attr)
{
    PickAttributesObject *newObject;
    newObject = PyObject_NEW(PickAttributesObject, &PickAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PickAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PickAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPickAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PickAttributesMethods[] = {
    {"PickAttributes", PickAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PickAttributesObserver = 0;

std::string
PyPickAttributes_GetLogString()
{
    std::string s("PickAtts = GetPickAttributes()\n");
    if(currentAtts != 0)
        s += PyPickAttributes_ToString(currentAtts, "PickAtts.");
    return s;
}

static void
PyPickAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PickAtts = GetPickAttributes()\n");
        s += PyPickAttributes_ToString(currentAtts, "PickAtts.");
        cb(s);
    }
}

void
PyPickAttributes_StartUp(PickAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPickAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PickAttributesObserver == 0)
    {
        PickAttributesObserver = new ObserverToCallback(subj,
            PyPickAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPickAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PickAttributesObserver;
    PickAttributesObserver = 0;
}

PyMethodDef *
PyPickAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PickAttributesMethods;
}

bool
PyPickAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PickAttributesType);
}

PickAttributes *
PyPickAttributes_FromPyObject(PyObject *obj)
{
    PickAttributesObject *obj2 = (PickAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPickAttributes_New()
{
    return NewPickAttributes(0);
}

PyObject *
PyPickAttributes_Wrap(const PickAttributes *attr)
{
    return WrapPickAttributes(attr);
}

void
PyPickAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PickAttributesObject *obj2 = (PickAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPickAttributes_SetDefaults(const PickAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PickAttributes(*atts);
}

