/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AxisAlignedSlice4DAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Init utility for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AxisAlignedSlice4DAttributes::Init()
{

    AxisAlignedSlice4DAttributes::SelectAll();
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Copy utility for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AxisAlignedSlice4DAttributes::Copy(const AxisAlignedSlice4DAttributes &obj)
{
    I = obj.I;
    J = obj.J;
    K = obj.K;
    L = obj.L;

    AxisAlignedSlice4DAttributes::SelectAll();
}

// Type map format string
const char *AxisAlignedSlice4DAttributes::TypeMapFormatString = AXISALIGNEDSLICE4DATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t AxisAlignedSlice4DAttributes::TmfsStruct = {AXISALIGNEDSLICE4DATTRIBUTES_TMFS};


// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Default constructor for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes() : 
    AttributeSubject(AxisAlignedSlice4DAttributes::TypeMapFormatString)
{
    AxisAlignedSlice4DAttributes::Init();
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Constructor for the derived classes of AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AxisAlignedSlice4DAttributes::Init();
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Copy constructor for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes(const AxisAlignedSlice4DAttributes &obj) : 
    AttributeSubject(AxisAlignedSlice4DAttributes::TypeMapFormatString)
{
    AxisAlignedSlice4DAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes::AxisAlignedSlice4DAttributes(const AxisAlignedSlice4DAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AxisAlignedSlice4DAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::~AxisAlignedSlice4DAttributes
//
// Purpose: 
//   Destructor for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes::~AxisAlignedSlice4DAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisAlignedSlice4DAttributes& 
AxisAlignedSlice4DAttributes::operator = (const AxisAlignedSlice4DAttributes &obj)
{
    if (this == &obj) return *this;

    AxisAlignedSlice4DAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAlignedSlice4DAttributes::operator == (const AxisAlignedSlice4DAttributes &obj) const
{
    // Create the return value
    return ((I == obj.I) &&
            (J == obj.J) &&
            (K == obj.K) &&
            (L == obj.L));
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAlignedSlice4DAttributes::operator != (const AxisAlignedSlice4DAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::TypeName
//
// Purpose: 
//   Type name method for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AxisAlignedSlice4DAttributes::TypeName() const
{
    return "AxisAlignedSlice4DAttributes";
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAlignedSlice4DAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxisAlignedSlice4DAttributes *tmp = (const AxisAlignedSlice4DAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxisAlignedSlice4DAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AxisAlignedSlice4DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxisAlignedSlice4DAttributes(*this);
    else
        retval = new AxisAlignedSlice4DAttributes;

    return retval;
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisAlignedSlice4DAttributes::SelectAll()
{
    Select(ID_I, (void *)&I);
    Select(ID_J, (void *)&J);
    Select(ID_K, (void *)&K);
    Select(ID_L, (void *)&L);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAlignedSlice4DAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxisAlignedSlice4DAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AxisAlignedSlice4DAttributes.
    DataNode *node = new DataNode("AxisAlignedSlice4DAttributes");

    if(completeSave || !FieldsEqual(ID_I, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("I", I));
    }

    if(completeSave || !FieldsEqual(ID_J, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("J", J));
    }

    if(completeSave || !FieldsEqual(ID_K, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("K", K));
    }

    if(completeSave || !FieldsEqual(ID_L, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("L", L));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisAlignedSlice4DAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxisAlignedSlice4DAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("I")) != 0)
        SetI(node->AsIntVector());
    if((node = searchNode->GetNode("J")) != 0)
        SetJ(node->AsIntVector());
    if((node = searchNode->GetNode("K")) != 0)
        SetK(node->AsIntVector());
    if((node = searchNode->GetNode("L")) != 0)
        SetL(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisAlignedSlice4DAttributes::SetI(const intVector &I_)
{
    I = I_;
    Select(ID_I, (void *)&I);
}

void
AxisAlignedSlice4DAttributes::SetJ(const intVector &J_)
{
    J = J_;
    Select(ID_J, (void *)&J);
}

void
AxisAlignedSlice4DAttributes::SetK(const intVector &K_)
{
    K = K_;
    Select(ID_K, (void *)&K);
}

void
AxisAlignedSlice4DAttributes::SetL(const intVector &L_)
{
    L = L_;
    Select(ID_L, (void *)&L);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
AxisAlignedSlice4DAttributes::GetI() const
{
    return I;
}

intVector &
AxisAlignedSlice4DAttributes::GetI()
{
    return I;
}

const intVector &
AxisAlignedSlice4DAttributes::GetJ() const
{
    return J;
}

intVector &
AxisAlignedSlice4DAttributes::GetJ()
{
    return J;
}

const intVector &
AxisAlignedSlice4DAttributes::GetK() const
{
    return K;
}

intVector &
AxisAlignedSlice4DAttributes::GetK()
{
    return K;
}

const intVector &
AxisAlignedSlice4DAttributes::GetL() const
{
    return L;
}

intVector &
AxisAlignedSlice4DAttributes::GetL()
{
    return L;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisAlignedSlice4DAttributes::SelectI()
{
    Select(ID_I, (void *)&I);
}

void
AxisAlignedSlice4DAttributes::SelectJ()
{
    Select(ID_J, (void *)&J);
}

void
AxisAlignedSlice4DAttributes::SelectK()
{
    Select(ID_K, (void *)&K);
}

void
AxisAlignedSlice4DAttributes::SelectL()
{
    Select(ID_L, (void *)&L);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisAlignedSlice4DAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_I: return "I";
    case ID_J: return "J";
    case ID_K: return "K";
    case ID_L: return "L";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AxisAlignedSlice4DAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_I: return FieldType_intVector;
    case ID_J: return FieldType_intVector;
    case ID_K: return FieldType_intVector;
    case ID_L: return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisAlignedSlice4DAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_I: return "intVector";
    case ID_J: return "intVector";
    case ID_K: return "intVector";
    case ID_L: return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisAlignedSlice4DAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisAlignedSlice4DAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxisAlignedSlice4DAttributes &obj = *((const AxisAlignedSlice4DAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_I:
        {  // new scope
        retval = (I == obj.I);
        }
        break;
    case ID_J:
        {  // new scope
        retval = (J == obj.J);
        }
        break;
    case ID_K:
        {  // new scope
        retval = (K == obj.K);
        }
        break;
    case ID_L:
        {  // new scope
        retval = (L == obj.L);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

