/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             ViewerRPCObserver.h                           //
// ************************************************************************* //

#ifndef VIEWER_OBSERVER_TO_SIGNAL_H
#define VIEWER_OBSERVER_TO_SIGNAL_H
#include <viewer_exports.h>
#include <QObject>
#include <Observer.h>

// ****************************************************************************
//  Class: ViewerObserverToSignal
//
//  Purpose:
//    ViewerObserverToSignal observes state objects or RPC's and emits a Qt
//    signal when the subjects are updated.
//
//  Note:
//
//  Programmer: Eric Brugger
//  Creation:   August 11, 2000
//
//  Modifications:
//    Brad Whitlock, Fri Oct 27 14:39:39 PST 2000
//    I changed the code to emit a Qt signal instead of calling a callback.
//
//    Brad Whitlock, Mon Sep 17 11:14:12 PDT 2001
//    I generalized the object so it can observe other kinds of subjects.
//
//    Brad Whitlock, Wed Feb 14 10:58:34 PDT 2007
//    I renamed the class to ViewerObserverToSignal.
//
//    Brad Whitlock, Thu Apr 22 15:47:45 PST 2010
//    I made the destructor virtual.
//
// ****************************************************************************

class VIEWER_API ViewerObserverToSignal : public QObject, public Observer
{
    Q_OBJECT
public:
    ViewerObserverToSignal(Subject *);
    virtual ~ViewerObserverToSignal();
    virtual void Update(Subject *);
signals:
    void execute();
};

#endif
