/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SurfaceNormalAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfaceNormalAttributes::Centering
//

static const char *Centering_strings[] = {
"Point", "Cell"};

std::string
SurfaceNormalAttributes::Centering_ToString(SurfaceNormalAttributes::Centering t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Centering_strings[index];
}

std::string
SurfaceNormalAttributes::Centering_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Centering_strings[index];
}

bool
SurfaceNormalAttributes::Centering_FromString(const std::string &s, SurfaceNormalAttributes::Centering &val)
{
    val = SurfaceNormalAttributes::Point;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Centering_strings[i])
        {
            val = (Centering)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Init utility for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SurfaceNormalAttributes::Init()
{
    centering = Point;

    SurfaceNormalAttributes::SelectAll();
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Copy utility for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SurfaceNormalAttributes::Copy(const SurfaceNormalAttributes &obj)
{
    centering = obj.centering;

    SurfaceNormalAttributes::SelectAll();
}

// Type map format string
const char *SurfaceNormalAttributes::TypeMapFormatString = SURFACENORMALATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SurfaceNormalAttributes::TmfsStruct = {SURFACENORMALATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Default constructor for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes::SurfaceNormalAttributes() : 
    AttributeSubject(SurfaceNormalAttributes::TypeMapFormatString)
{
    SurfaceNormalAttributes::Init();
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Constructor for the derived classes of SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes::SurfaceNormalAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SurfaceNormalAttributes::Init();
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Copy constructor for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes::SurfaceNormalAttributes(const SurfaceNormalAttributes &obj) : 
    AttributeSubject(SurfaceNormalAttributes::TypeMapFormatString)
{
    SurfaceNormalAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SurfaceNormalAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes::SurfaceNormalAttributes(const SurfaceNormalAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SurfaceNormalAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::~SurfaceNormalAttributes
//
// Purpose: 
//   Destructor for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes::~SurfaceNormalAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfaceNormalAttributes& 
SurfaceNormalAttributes::operator = (const SurfaceNormalAttributes &obj)
{
    if (this == &obj) return *this;

    SurfaceNormalAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceNormalAttributes::operator == (const SurfaceNormalAttributes &obj) const
{
    // Create the return value
    return ((centering == obj.centering));
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceNormalAttributes::operator != (const SurfaceNormalAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::TypeName
//
// Purpose: 
//   Type name method for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SurfaceNormalAttributes::TypeName() const
{
    return "SurfaceNormalAttributes";
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceNormalAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfaceNormalAttributes *tmp = (const SurfaceNormalAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceNormalAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfaceNormalAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SurfaceNormalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceNormalAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfaceNormalAttributes(*this);
    else
        retval = new SurfaceNormalAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceNormalAttributes::SelectAll()
{
    Select(ID_centering, (void *)&centering);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceNormalAttributes::SetCentering(SurfaceNormalAttributes::Centering centering_)
{
    centering = centering_;
    Select(ID_centering, (void *)&centering);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SurfaceNormalAttributes::Centering
SurfaceNormalAttributes::GetCentering() const
{
    return Centering(centering);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceNormalAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceNormalAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_centering: return "centering";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SurfaceNormalAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_centering: return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceNormalAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_centering: return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceNormalAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceNormalAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfaceNormalAttributes &obj = *((const SurfaceNormalAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_centering:
        {  // new scope
        retval = (centering == obj.centering);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

