/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLabelAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyLabelAttributes
//
// Purpose: 
//   This class contains the fields that we need to set the attributes for the Label plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LabelAttributes.
//
struct LabelAttributesObject
{
    PyObject_HEAD
    LabelAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLabelAttributes(int);

std::string
PyLabelAttributes_ToString(const LabelAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodes())
        SNPRINTF(tmpStr, 1000, "%sshowNodes = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNodes = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowCells())
        SNPRINTF(tmpStr, 1000, "%sshowCells = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowCells = 0\n", prefix);
    str += tmpStr;
    if(atts->GetRestrictNumberOfLabels())
        SNPRINTF(tmpStr, 1000, "%srestrictNumberOfLabels = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%srestrictNumberOfLabels = 0\n", prefix);
    str += tmpStr;
    const char *drawLabelsFacing_names = "Front, Back, FrontAndBack";
    switch (atts->GetDrawLabelsFacing())
    {
      case LabelAttributes::Front:
          SNPRINTF(tmpStr, 1000, "%sdrawLabelsFacing = %sFront  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      case LabelAttributes::Back:
          SNPRINTF(tmpStr, 1000, "%sdrawLabelsFacing = %sBack  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      case LabelAttributes::FrontAndBack:
          SNPRINTF(tmpStr, 1000, "%sdrawLabelsFacing = %sFrontAndBack  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *labelDisplayFormat_names = "Natural, LogicalIndex, Index";
    switch (atts->GetLabelDisplayFormat())
    {
      case LabelAttributes::Natural:
          SNPRINTF(tmpStr, 1000, "%slabelDisplayFormat = %sNatural  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      case LabelAttributes::LogicalIndex:
          SNPRINTF(tmpStr, 1000, "%slabelDisplayFormat = %sLogicalIndex  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      case LabelAttributes::Index:
          SNPRINTF(tmpStr, 1000, "%slabelDisplayFormat = %sIndex  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%snumberOfLabels = %d\n", prefix, atts->GetNumberOfLabels());
    str += tmpStr;
    if(atts->GetSpecifyTextColor1())
        SNPRINTF(tmpStr, 1000, "%sspecifyTextColor1 = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sspecifyTextColor1 = 0\n", prefix);
    str += tmpStr;
    const unsigned char *textColor1 = atts->GetTextColor1().GetColor();
    SNPRINTF(tmpStr, 1000, "%stextColor1 = (%d, %d, %d, %d)\n", prefix, int(textColor1[0]), int(textColor1[1]), int(textColor1[2]), int(textColor1[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stextHeight1 = %g\n", prefix, atts->GetTextHeight1());
    str += tmpStr;
    if(atts->GetSpecifyTextColor2())
        SNPRINTF(tmpStr, 1000, "%sspecifyTextColor2 = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sspecifyTextColor2 = 0\n", prefix);
    str += tmpStr;
    const unsigned char *textColor2 = atts->GetTextColor2().GetColor();
    SNPRINTF(tmpStr, 1000, "%stextColor2 = (%d, %d, %d, %d)\n", prefix, int(textColor2[0]), int(textColor2[1]), int(textColor2[2]), int(textColor2[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stextHeight2 = %g\n", prefix, atts->GetTextHeight2());
    str += tmpStr;
    const char *horizontalJustification_names = "HCenter, Left, Right";
    switch (atts->GetHorizontalJustification())
    {
      case LabelAttributes::HCenter:
          SNPRINTF(tmpStr, 1000, "%shorizontalJustification = %sHCenter  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Left:
          SNPRINTF(tmpStr, 1000, "%shorizontalJustification = %sLeft  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Right:
          SNPRINTF(tmpStr, 1000, "%shorizontalJustification = %sRight  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *verticalJustification_names = "VCenter, Top, Bottom";
    switch (atts->GetVerticalJustification())
    {
      case LabelAttributes::VCenter:
          SNPRINTF(tmpStr, 1000, "%sverticalJustification = %sVCenter  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Top:
          SNPRINTF(tmpStr, 1000, "%sverticalJustification = %sTop  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Bottom:
          SNPRINTF(tmpStr, 1000, "%sverticalJustification = %sBottom  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *depthTestMode_names = "LABEL_DT_AUTO, LABEL_DT_ALWAYS, LABEL_DT_NEVER";
    switch (atts->GetDepthTestMode())
    {
      case LabelAttributes::LABEL_DT_AUTO:
          SNPRINTF(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_AUTO  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      case LabelAttributes::LABEL_DT_ALWAYS:
          SNPRINTF(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_ALWAYS  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      case LabelAttributes::LABEL_DT_NEVER:
          SNPRINTF(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_NEVER  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sformatTemplate = \"%s\"\n", prefix, atts->GetFormatTemplate().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
LabelAttributes_Notify(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodes in the object.
    obj->data->SetShowNodes(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodes()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCells in the object.
    obj->data->SetShowCells(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCells()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the restrictNumberOfLabels in the object.
    obj->data->SetRestrictNumberOfLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRestrictNumberOfLabels()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawLabelsFacing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawLabelsFacing(LabelAttributes::LabelDrawFacing(ival));
    else
    {
        fprintf(stderr, "An invalid drawLabelsFacing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Front, Back, FrontAndBack.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawLabelsFacing()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the labelDisplayFormat in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetLabelDisplayFormat(LabelAttributes::LabelIndexDisplay(ival));
    else
    {
        fprintf(stderr, "An invalid labelDisplayFormat value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, LogicalIndex, Index.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLabelDisplayFormat()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfLabels in the object.
    obj->data->SetNumberOfLabels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfLabels()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetSpecifyTextColor1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the specifyTextColor1 in the object.
    obj->data->SetSpecifyTextColor1(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetSpecifyTextColor1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpecifyTextColor1()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextColor1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the textColor1 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTextColor1(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextColor1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the textColor1.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *textColor1 = obj->data->GetTextColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(textColor1[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(textColor1[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(textColor1[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(textColor1[3])));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextHeight1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the textHeight1 in the object.
    obj->data->SetTextHeight1(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextHeight1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTextHeight1()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetSpecifyTextColor2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the specifyTextColor2 in the object.
    obj->data->SetSpecifyTextColor2(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetSpecifyTextColor2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpecifyTextColor2()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextColor2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the textColor2 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTextColor2(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextColor2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the textColor2.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *textColor2 = obj->data->GetTextColor2().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(textColor2[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(textColor2[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(textColor2[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(textColor2[3])));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextHeight2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the textHeight2 in the object.
    obj->data->SetTextHeight2(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextHeight2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTextHeight2()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the horizontalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetHorizontalJustification(LabelAttributes::LabelHorizontalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid horizontalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "HCenter, Left, Right.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHorizontalJustification()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the verticalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVerticalJustification(LabelAttributes::LabelVerticalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid verticalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "VCenter, Top, Bottom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVerticalJustification()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetDepthTestMode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthTestMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDepthTestMode(LabelAttributes::DepthTestMode(ival));
    else
    {
        fprintf(stderr, "An invalid depthTestMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "LABEL_DT_AUTO, LABEL_DT_ALWAYS, LABEL_DT_NEVER.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetDepthTestMode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDepthTestMode()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetFormatTemplate(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the formatTemplate in the object.
    obj->data->SetFormatTemplate(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetFormatTemplate(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFormatTemplate().c_str());
    return retval;
}



PyMethodDef PyLabelAttributes_methods[LABELATTRIBUTES_NMETH] = {
    {"Notify", LabelAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", LabelAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", LabelAttributes_GetLegendFlag, METH_VARARGS},
    {"SetShowNodes", LabelAttributes_SetShowNodes, METH_VARARGS},
    {"GetShowNodes", LabelAttributes_GetShowNodes, METH_VARARGS},
    {"SetShowCells", LabelAttributes_SetShowCells, METH_VARARGS},
    {"GetShowCells", LabelAttributes_GetShowCells, METH_VARARGS},
    {"SetRestrictNumberOfLabels", LabelAttributes_SetRestrictNumberOfLabels, METH_VARARGS},
    {"GetRestrictNumberOfLabels", LabelAttributes_GetRestrictNumberOfLabels, METH_VARARGS},
    {"SetDrawLabelsFacing", LabelAttributes_SetDrawLabelsFacing, METH_VARARGS},
    {"GetDrawLabelsFacing", LabelAttributes_GetDrawLabelsFacing, METH_VARARGS},
    {"SetLabelDisplayFormat", LabelAttributes_SetLabelDisplayFormat, METH_VARARGS},
    {"GetLabelDisplayFormat", LabelAttributes_GetLabelDisplayFormat, METH_VARARGS},
    {"SetNumberOfLabels", LabelAttributes_SetNumberOfLabels, METH_VARARGS},
    {"GetNumberOfLabels", LabelAttributes_GetNumberOfLabels, METH_VARARGS},
    {"SetSpecifyTextColor1", LabelAttributes_SetSpecifyTextColor1, METH_VARARGS},
    {"GetSpecifyTextColor1", LabelAttributes_GetSpecifyTextColor1, METH_VARARGS},
    {"SetTextColor1", LabelAttributes_SetTextColor1, METH_VARARGS},
    {"GetTextColor1", LabelAttributes_GetTextColor1, METH_VARARGS},
    {"SetTextHeight1", LabelAttributes_SetTextHeight1, METH_VARARGS},
    {"GetTextHeight1", LabelAttributes_GetTextHeight1, METH_VARARGS},
    {"SetSpecifyTextColor2", LabelAttributes_SetSpecifyTextColor2, METH_VARARGS},
    {"GetSpecifyTextColor2", LabelAttributes_GetSpecifyTextColor2, METH_VARARGS},
    {"SetTextColor2", LabelAttributes_SetTextColor2, METH_VARARGS},
    {"GetTextColor2", LabelAttributes_GetTextColor2, METH_VARARGS},
    {"SetTextHeight2", LabelAttributes_SetTextHeight2, METH_VARARGS},
    {"GetTextHeight2", LabelAttributes_GetTextHeight2, METH_VARARGS},
    {"SetHorizontalJustification", LabelAttributes_SetHorizontalJustification, METH_VARARGS},
    {"GetHorizontalJustification", LabelAttributes_GetHorizontalJustification, METH_VARARGS},
    {"SetVerticalJustification", LabelAttributes_SetVerticalJustification, METH_VARARGS},
    {"GetVerticalJustification", LabelAttributes_GetVerticalJustification, METH_VARARGS},
    {"SetDepthTestMode", LabelAttributes_SetDepthTestMode, METH_VARARGS},
    {"GetDepthTestMode", LabelAttributes_GetDepthTestMode, METH_VARARGS},
    {"SetFormatTemplate", LabelAttributes_SetFormatTemplate, METH_VARARGS},
    {"GetFormatTemplate", LabelAttributes_GetFormatTemplate, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LabelAttributes_dealloc(PyObject *v)
{
   LabelAttributesObject *obj = (LabelAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LabelAttributes_compare(PyObject *v, PyObject *w)
{
    LabelAttributes *a = ((LabelAttributesObject *)v)->data;
    LabelAttributes *b = ((LabelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLabelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return LabelAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "showNodes") == 0)
        return LabelAttributes_GetShowNodes(self, NULL);
    if(strcmp(name, "showCells") == 0)
        return LabelAttributes_GetShowCells(self, NULL);
    if(strcmp(name, "restrictNumberOfLabels") == 0)
        return LabelAttributes_GetRestrictNumberOfLabels(self, NULL);
    if(strcmp(name, "drawLabelsFacing") == 0)
        return LabelAttributes_GetDrawLabelsFacing(self, NULL);
    if(strcmp(name, "Front") == 0)
        return PyInt_FromLong(long(LabelAttributes::Front));
    if(strcmp(name, "Back") == 0)
        return PyInt_FromLong(long(LabelAttributes::Back));
    if(strcmp(name, "FrontAndBack") == 0)
        return PyInt_FromLong(long(LabelAttributes::FrontAndBack));

    if(strcmp(name, "labelDisplayFormat") == 0)
        return LabelAttributes_GetLabelDisplayFormat(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(LabelAttributes::Natural));
    if(strcmp(name, "LogicalIndex") == 0)
        return PyInt_FromLong(long(LabelAttributes::LogicalIndex));
    if(strcmp(name, "Index") == 0)
        return PyInt_FromLong(long(LabelAttributes::Index));

    if(strcmp(name, "numberOfLabels") == 0)
        return LabelAttributes_GetNumberOfLabels(self, NULL);
    if(strcmp(name, "specifyTextColor1") == 0)
        return LabelAttributes_GetSpecifyTextColor1(self, NULL);
    if(strcmp(name, "textColor1") == 0)
        return LabelAttributes_GetTextColor1(self, NULL);
    if(strcmp(name, "textHeight1") == 0)
        return LabelAttributes_GetTextHeight1(self, NULL);
    if(strcmp(name, "specifyTextColor2") == 0)
        return LabelAttributes_GetSpecifyTextColor2(self, NULL);
    if(strcmp(name, "textColor2") == 0)
        return LabelAttributes_GetTextColor2(self, NULL);
    if(strcmp(name, "textHeight2") == 0)
        return LabelAttributes_GetTextHeight2(self, NULL);
    if(strcmp(name, "horizontalJustification") == 0)
        return LabelAttributes_GetHorizontalJustification(self, NULL);
    if(strcmp(name, "HCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::HCenter));
    if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(LabelAttributes::Left));
    if(strcmp(name, "Right") == 0)
        return PyInt_FromLong(long(LabelAttributes::Right));

    if(strcmp(name, "verticalJustification") == 0)
        return LabelAttributes_GetVerticalJustification(self, NULL);
    if(strcmp(name, "VCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::VCenter));
    if(strcmp(name, "Top") == 0)
        return PyInt_FromLong(long(LabelAttributes::Top));
    if(strcmp(name, "Bottom") == 0)
        return PyInt_FromLong(long(LabelAttributes::Bottom));

    if(strcmp(name, "depthTestMode") == 0)
        return LabelAttributes_GetDepthTestMode(self, NULL);
    if(strcmp(name, "LABEL_DT_AUTO") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_AUTO));
    if(strcmp(name, "LABEL_DT_ALWAYS") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_ALWAYS));
    if(strcmp(name, "LABEL_DT_NEVER") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_NEVER));

    if(strcmp(name, "formatTemplate") == 0)
        return LabelAttributes_GetFormatTemplate(self, NULL);

    return Py_FindMethod(PyLabelAttributes_methods, self, name);
}

int
PyLabelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = LabelAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "showNodes") == 0)
        obj = LabelAttributes_SetShowNodes(self, tuple);
    else if(strcmp(name, "showCells") == 0)
        obj = LabelAttributes_SetShowCells(self, tuple);
    else if(strcmp(name, "restrictNumberOfLabels") == 0)
        obj = LabelAttributes_SetRestrictNumberOfLabels(self, tuple);
    else if(strcmp(name, "drawLabelsFacing") == 0)
        obj = LabelAttributes_SetDrawLabelsFacing(self, tuple);
    else if(strcmp(name, "labelDisplayFormat") == 0)
        obj = LabelAttributes_SetLabelDisplayFormat(self, tuple);
    else if(strcmp(name, "numberOfLabels") == 0)
        obj = LabelAttributes_SetNumberOfLabels(self, tuple);
    else if(strcmp(name, "specifyTextColor1") == 0)
        obj = LabelAttributes_SetSpecifyTextColor1(self, tuple);
    else if(strcmp(name, "textColor1") == 0)
        obj = LabelAttributes_SetTextColor1(self, tuple);
    else if(strcmp(name, "textHeight1") == 0)
        obj = LabelAttributes_SetTextHeight1(self, tuple);
    else if(strcmp(name, "specifyTextColor2") == 0)
        obj = LabelAttributes_SetSpecifyTextColor2(self, tuple);
    else if(strcmp(name, "textColor2") == 0)
        obj = LabelAttributes_SetTextColor2(self, tuple);
    else if(strcmp(name, "textHeight2") == 0)
        obj = LabelAttributes_SetTextHeight2(self, tuple);
    else if(strcmp(name, "horizontalJustification") == 0)
        obj = LabelAttributes_SetHorizontalJustification(self, tuple);
    else if(strcmp(name, "verticalJustification") == 0)
        obj = LabelAttributes_SetVerticalJustification(self, tuple);
    else if(strcmp(name, "depthTestMode") == 0)
        obj = LabelAttributes_SetDepthTestMode(self, tuple);
    else if(strcmp(name, "formatTemplate") == 0)
        obj = LabelAttributes_SetFormatTemplate(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LabelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;
    fprintf(fp, "%s", PyLabelAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LabelAttributes_str(PyObject *v)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;
    return PyString_FromString(PyLabelAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LabelAttributes_Purpose = "This class contains the fields that we need to set the attributes for the Label plot.";
#else
static char *LabelAttributes_Purpose = "This class contains the fields that we need to set the attributes for the Label plot.";
#endif

//
// The type description structure
//
static PyTypeObject LabelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LabelAttributes",                    // tp_name
    sizeof(LabelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LabelAttributes_dealloc,  // tp_dealloc
    (printfunc)LabelAttributes_print,     // tp_print
    (getattrfunc)PyLabelAttributes_getattr, // tp_getattr
    (setattrfunc)PyLabelAttributes_setattr, // tp_setattr
    (cmpfunc)LabelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LabelAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LabelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LabelAttributes *defaultAtts = 0;
static LabelAttributes *currentAtts = 0;

static PyObject *
NewLabelAttributes(int useCurrent)
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LabelAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LabelAttributes(*defaultAtts);
    else
        newObject->data = new LabelAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLabelAttributes(const LabelAttributes *attr)
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LabelAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LabelAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLabelAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LabelAttributesMethods[] = {
    {"LabelAttributes", LabelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LabelAttributesObserver = 0;

std::string
PyLabelAttributes_GetLogString()
{
    std::string s("LabelAtts = LabelAttributes()\n");
    if(currentAtts != 0)
        s += PyLabelAttributes_ToString(currentAtts, "LabelAtts.");
    return s;
}

static void
PyLabelAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LabelAtts = LabelAttributes()\n");
        s += PyLabelAttributes_ToString(currentAtts, "LabelAtts.");
        cb(s);
    }
}

void
PyLabelAttributes_StartUp(LabelAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLabelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LabelAttributesObserver == 0)
    {
        LabelAttributesObserver = new ObserverToCallback(subj,
            PyLabelAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLabelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LabelAttributesObserver;
    LabelAttributesObserver = 0;
}

PyMethodDef *
PyLabelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LabelAttributesMethods;
}

bool
PyLabelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LabelAttributesType);
}

LabelAttributes *
PyLabelAttributes_FromPyObject(PyObject *obj)
{
    LabelAttributesObject *obj2 = (LabelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLabelAttributes_New()
{
    return NewLabelAttributes(0);
}

PyObject *
PyLabelAttributes_Wrap(const LabelAttributes *attr)
{
    return WrapLabelAttributes(attr);
}

void
PyLabelAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LabelAttributesObject *obj2 = (LabelAttributesObject *)obj;
    obj2->parent = parent;
}

// ****************************************************************************
// Modifications:
//   Brad Whitlock, Thu Aug 4 14:35:00 PST 2005
//   Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************

void
PyLabelAttributes_SetDefaults(const LabelAttributes *atts)
{
    defaultAtts = const_cast<LabelAttributes*>(atts);
}

