/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <IndexSelectAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for IndexSelectAttributes::Dimension
//

static const char *Dimension_strings[] = {
"OneD", "TwoD", "ThreeD"
};

std::string
IndexSelectAttributes::Dimension_ToString(IndexSelectAttributes::Dimension t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Dimension_strings[index];
}

std::string
IndexSelectAttributes::Dimension_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Dimension_strings[index];
}

bool
IndexSelectAttributes::Dimension_FromString(const std::string &s, IndexSelectAttributes::Dimension &val)
{
    val = IndexSelectAttributes::OneD;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Dimension_strings[i])
        {
            val = (Dimension)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Init utility for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void IndexSelectAttributes::Init()
{
    maxDim = ThreeD;
    dim = TwoD;
    xAbsMax = -1;
    xMin = 0;
    xMax = -1;
    xIncr = 1;
    xWrap = false;
    yAbsMax = -1;
    yMin = 0;
    yMax = -1;
    yIncr = 1;
    yWrap = false;
    zAbsMax = -1;
    zMin = 0;
    zMax = -1;
    zIncr = 1;
    zWrap = false;
    useWholeCollection = true;
    categoryName = "Whole";
    subsetName = "Whole";

    IndexSelectAttributes::SelectAll();
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Copy utility for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void IndexSelectAttributes::Copy(const IndexSelectAttributes &obj)
{
    maxDim = obj.maxDim;
    dim = obj.dim;
    xAbsMax = obj.xAbsMax;
    xMin = obj.xMin;
    xMax = obj.xMax;
    xIncr = obj.xIncr;
    xWrap = obj.xWrap;
    yAbsMax = obj.yAbsMax;
    yMin = obj.yMin;
    yMax = obj.yMax;
    yIncr = obj.yIncr;
    yWrap = obj.yWrap;
    zAbsMax = obj.zAbsMax;
    zMin = obj.zMin;
    zMax = obj.zMax;
    zIncr = obj.zIncr;
    zWrap = obj.zWrap;
    useWholeCollection = obj.useWholeCollection;
    categoryName = obj.categoryName;
    subsetName = obj.subsetName;

    IndexSelectAttributes::SelectAll();
}

// Type map format string
const char *IndexSelectAttributes::TypeMapFormatString = INDEXSELECTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t IndexSelectAttributes::TmfsStruct = {INDEXSELECTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Default constructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes() : 
    AttributeSubject(IndexSelectAttributes::TypeMapFormatString)
{
    IndexSelectAttributes::Init();
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Constructor for the derived classes of IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    IndexSelectAttributes::Init();
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Copy constructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes(const IndexSelectAttributes &obj) : 
    AttributeSubject(IndexSelectAttributes::TypeMapFormatString)
{
    IndexSelectAttributes::Copy(obj);
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes(const IndexSelectAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    IndexSelectAttributes::Copy(obj);
}

// ****************************************************************************
// Method: IndexSelectAttributes::~IndexSelectAttributes
//
// Purpose: 
//   Destructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::~IndexSelectAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes& 
IndexSelectAttributes::operator = (const IndexSelectAttributes &obj)
{
    if (this == &obj) return *this;

    IndexSelectAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::operator == (const IndexSelectAttributes &obj) const
{
    // Create the return value
    return ((maxDim == obj.maxDim) &&
            (dim == obj.dim) &&
            (xAbsMax == obj.xAbsMax) &&
            (xMin == obj.xMin) &&
            (xMax == obj.xMax) &&
            (xIncr == obj.xIncr) &&
            (xWrap == obj.xWrap) &&
            (yAbsMax == obj.yAbsMax) &&
            (yMin == obj.yMin) &&
            (yMax == obj.yMax) &&
            (yIncr == obj.yIncr) &&
            (yWrap == obj.yWrap) &&
            (zAbsMax == obj.zAbsMax) &&
            (zMin == obj.zMin) &&
            (zMax == obj.zMax) &&
            (zIncr == obj.zIncr) &&
            (zWrap == obj.zWrap) &&
            (useWholeCollection == obj.useWholeCollection) &&
            (categoryName == obj.categoryName) &&
            (subsetName == obj.subsetName));
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::operator != (const IndexSelectAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: IndexSelectAttributes::TypeName
//
// Purpose: 
//   Type name method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
IndexSelectAttributes::TypeName() const
{
    return "IndexSelectAttributes";
}

// ****************************************************************************
// Method: IndexSelectAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const IndexSelectAttributes *tmp = (const IndexSelectAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: IndexSelectAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IndexSelectAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new IndexSelectAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: IndexSelectAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IndexSelectAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new IndexSelectAttributes(*this);
    else
        retval = new IndexSelectAttributes;

    return retval;
}

// ****************************************************************************
// Method: IndexSelectAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectAttributes::SelectAll()
{
    Select(ID_maxDim,             (void *)&maxDim);
    Select(ID_dim,                (void *)&dim);
    Select(ID_xAbsMax,            (void *)&xAbsMax);
    Select(ID_xMin,               (void *)&xMin);
    Select(ID_xMax,               (void *)&xMax);
    Select(ID_xIncr,              (void *)&xIncr);
    Select(ID_xWrap,              (void *)&xWrap);
    Select(ID_yAbsMax,            (void *)&yAbsMax);
    Select(ID_yMin,               (void *)&yMin);
    Select(ID_yMax,               (void *)&yMax);
    Select(ID_yIncr,              (void *)&yIncr);
    Select(ID_yWrap,              (void *)&yWrap);
    Select(ID_zAbsMax,            (void *)&zAbsMax);
    Select(ID_zMin,               (void *)&zMin);
    Select(ID_zMax,               (void *)&zMax);
    Select(ID_zIncr,              (void *)&zIncr);
    Select(ID_zWrap,              (void *)&zWrap);
    Select(ID_useWholeCollection, (void *)&useWholeCollection);
    Select(ID_categoryName,       (void *)&categoryName);
    Select(ID_subsetName,         (void *)&subsetName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IndexSelectAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    IndexSelectAttributes defaultObject;
    bool addToParent = false;
    // Create a node for IndexSelectAttributes.
    DataNode *node = new DataNode("IndexSelectAttributes");

    if(completeSave || !FieldsEqual(ID_maxDim, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxDim", Dimension_ToString(maxDim)));
    }

    if(completeSave || !FieldsEqual(ID_dim, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dim", Dimension_ToString(dim)));
    }

    if(completeSave || !FieldsEqual(ID_xAbsMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAbsMax", xAbsMax));
    }

    if(completeSave || !FieldsEqual(ID_xMin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMin", xMin));
    }

    if(completeSave || !FieldsEqual(ID_xMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMax", xMax));
    }

    if(completeSave || !FieldsEqual(ID_xIncr, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xIncr", xIncr));
    }

    if(completeSave || !FieldsEqual(ID_xWrap, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xWrap", xWrap));
    }

    if(completeSave || !FieldsEqual(ID_yAbsMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAbsMax", yAbsMax));
    }

    if(completeSave || !FieldsEqual(ID_yMin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMin", yMin));
    }

    if(completeSave || !FieldsEqual(ID_yMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMax", yMax));
    }

    if(completeSave || !FieldsEqual(ID_yIncr, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yIncr", yIncr));
    }

    if(completeSave || !FieldsEqual(ID_yWrap, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yWrap", yWrap));
    }

    if(completeSave || !FieldsEqual(ID_zAbsMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zAbsMax", zAbsMax));
    }

    if(completeSave || !FieldsEqual(ID_zMin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMin", zMin));
    }

    if(completeSave || !FieldsEqual(ID_zMax, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMax", zMax));
    }

    if(completeSave || !FieldsEqual(ID_zIncr, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zIncr", zIncr));
    }

    if(completeSave || !FieldsEqual(ID_zWrap, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zWrap", zWrap));
    }

    if(completeSave || !FieldsEqual(ID_useWholeCollection, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useWholeCollection", useWholeCollection));
    }

    if(completeSave || !FieldsEqual(ID_categoryName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("categoryName", categoryName));
    }

    if(completeSave || !FieldsEqual(ID_subsetName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("subsetName", subsetName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: IndexSelectAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("IndexSelectAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("maxDim")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetMaxDim(Dimension(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Dimension value;
            if(Dimension_FromString(node->AsString(), value))
                SetMaxDim(value);
        }
    }
    if((node = searchNode->GetNode("dim")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDim(Dimension(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Dimension value;
            if(Dimension_FromString(node->AsString(), value))
                SetDim(value);
        }
    }
    if((node = searchNode->GetNode("xAbsMax")) != 0)
        SetXAbsMax(node->AsInt());
    if((node = searchNode->GetNode("xMin")) != 0)
        SetXMin(node->AsInt());
    if((node = searchNode->GetNode("xMax")) != 0)
        SetXMax(node->AsInt());
    if((node = searchNode->GetNode("xIncr")) != 0)
        SetXIncr(node->AsInt());
    if((node = searchNode->GetNode("xWrap")) != 0)
        SetXWrap(node->AsBool());
    if((node = searchNode->GetNode("yAbsMax")) != 0)
        SetYAbsMax(node->AsInt());
    if((node = searchNode->GetNode("yMin")) != 0)
        SetYMin(node->AsInt());
    if((node = searchNode->GetNode("yMax")) != 0)
        SetYMax(node->AsInt());
    if((node = searchNode->GetNode("yIncr")) != 0)
        SetYIncr(node->AsInt());
    if((node = searchNode->GetNode("yWrap")) != 0)
        SetYWrap(node->AsBool());
    if((node = searchNode->GetNode("zAbsMax")) != 0)
        SetZAbsMax(node->AsInt());
    if((node = searchNode->GetNode("zMin")) != 0)
        SetZMin(node->AsInt());
    if((node = searchNode->GetNode("zMax")) != 0)
        SetZMax(node->AsInt());
    if((node = searchNode->GetNode("zIncr")) != 0)
        SetZIncr(node->AsInt());
    if((node = searchNode->GetNode("zWrap")) != 0)
        SetZWrap(node->AsBool());
    if((node = searchNode->GetNode("useWholeCollection")) != 0)
        SetUseWholeCollection(node->AsBool());
    if((node = searchNode->GetNode("categoryName")) != 0)
        SetCategoryName(node->AsString());
    if((node = searchNode->GetNode("subsetName")) != 0)
        SetSubsetName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
IndexSelectAttributes::SetMaxDim(IndexSelectAttributes::Dimension maxDim_)
{
    maxDim = maxDim_;
    Select(ID_maxDim, (void *)&maxDim);
}

void
IndexSelectAttributes::SetDim(IndexSelectAttributes::Dimension dim_)
{
    dim = dim_;
    Select(ID_dim, (void *)&dim);
}

void
IndexSelectAttributes::SetXAbsMax(int xAbsMax_)
{
    xAbsMax = xAbsMax_;
    Select(ID_xAbsMax, (void *)&xAbsMax);
}

void
IndexSelectAttributes::SetXMin(int xMin_)
{
    xMin = xMin_;
    Select(ID_xMin, (void *)&xMin);
}

void
IndexSelectAttributes::SetXMax(int xMax_)
{
    xMax = xMax_;
    Select(ID_xMax, (void *)&xMax);
}

void
IndexSelectAttributes::SetXIncr(int xIncr_)
{
    xIncr = xIncr_;
    Select(ID_xIncr, (void *)&xIncr);
}

void
IndexSelectAttributes::SetXWrap(bool xWrap_)
{
    xWrap = xWrap_;
    Select(ID_xWrap, (void *)&xWrap);
}

void
IndexSelectAttributes::SetYAbsMax(int yAbsMax_)
{
    yAbsMax = yAbsMax_;
    Select(ID_yAbsMax, (void *)&yAbsMax);
}

void
IndexSelectAttributes::SetYMin(int yMin_)
{
    yMin = yMin_;
    Select(ID_yMin, (void *)&yMin);
}

void
IndexSelectAttributes::SetYMax(int yMax_)
{
    yMax = yMax_;
    Select(ID_yMax, (void *)&yMax);
}

void
IndexSelectAttributes::SetYIncr(int yIncr_)
{
    yIncr = yIncr_;
    Select(ID_yIncr, (void *)&yIncr);
}

void
IndexSelectAttributes::SetYWrap(bool yWrap_)
{
    yWrap = yWrap_;
    Select(ID_yWrap, (void *)&yWrap);
}

void
IndexSelectAttributes::SetZAbsMax(int zAbsMax_)
{
    zAbsMax = zAbsMax_;
    Select(ID_zAbsMax, (void *)&zAbsMax);
}

void
IndexSelectAttributes::SetZMin(int zMin_)
{
    zMin = zMin_;
    Select(ID_zMin, (void *)&zMin);
}

void
IndexSelectAttributes::SetZMax(int zMax_)
{
    zMax = zMax_;
    Select(ID_zMax, (void *)&zMax);
}

void
IndexSelectAttributes::SetZIncr(int zIncr_)
{
    zIncr = zIncr_;
    Select(ID_zIncr, (void *)&zIncr);
}

void
IndexSelectAttributes::SetZWrap(bool zWrap_)
{
    zWrap = zWrap_;
    Select(ID_zWrap, (void *)&zWrap);
}

void
IndexSelectAttributes::SetUseWholeCollection(bool useWholeCollection_)
{
    useWholeCollection = useWholeCollection_;
    Select(ID_useWholeCollection, (void *)&useWholeCollection);
}

void
IndexSelectAttributes::SetCategoryName(const std::string &categoryName_)
{
    categoryName = categoryName_;
    Select(ID_categoryName, (void *)&categoryName);
}

void
IndexSelectAttributes::SetSubsetName(const std::string &subsetName_)
{
    subsetName = subsetName_;
    Select(ID_subsetName, (void *)&subsetName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

IndexSelectAttributes::Dimension
IndexSelectAttributes::GetMaxDim() const
{
    return Dimension(maxDim);
}

IndexSelectAttributes::Dimension
IndexSelectAttributes::GetDim() const
{
    return Dimension(dim);
}

int
IndexSelectAttributes::GetXAbsMax() const
{
    return xAbsMax;
}

int
IndexSelectAttributes::GetXMin() const
{
    return xMin;
}

int
IndexSelectAttributes::GetXMax() const
{
    return xMax;
}

int
IndexSelectAttributes::GetXIncr() const
{
    return xIncr;
}

bool
IndexSelectAttributes::GetXWrap() const
{
    return xWrap;
}

int
IndexSelectAttributes::GetYAbsMax() const
{
    return yAbsMax;
}

int
IndexSelectAttributes::GetYMin() const
{
    return yMin;
}

int
IndexSelectAttributes::GetYMax() const
{
    return yMax;
}

int
IndexSelectAttributes::GetYIncr() const
{
    return yIncr;
}

bool
IndexSelectAttributes::GetYWrap() const
{
    return yWrap;
}

int
IndexSelectAttributes::GetZAbsMax() const
{
    return zAbsMax;
}

int
IndexSelectAttributes::GetZMin() const
{
    return zMin;
}

int
IndexSelectAttributes::GetZMax() const
{
    return zMax;
}

int
IndexSelectAttributes::GetZIncr() const
{
    return zIncr;
}

bool
IndexSelectAttributes::GetZWrap() const
{
    return zWrap;
}

bool
IndexSelectAttributes::GetUseWholeCollection() const
{
    return useWholeCollection;
}

const std::string &
IndexSelectAttributes::GetCategoryName() const
{
    return categoryName;
}

std::string &
IndexSelectAttributes::GetCategoryName()
{
    return categoryName;
}

const std::string &
IndexSelectAttributes::GetSubsetName() const
{
    return subsetName;
}

std::string &
IndexSelectAttributes::GetSubsetName()
{
    return subsetName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
IndexSelectAttributes::SelectCategoryName()
{
    Select(ID_categoryName, (void *)&categoryName);
}

void
IndexSelectAttributes::SelectSubsetName()
{
    Select(ID_subsetName, (void *)&subsetName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
IndexSelectAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_maxDim:             return "maxDim";
    case ID_dim:                return "dim";
    case ID_xAbsMax:            return "xAbsMax";
    case ID_xMin:               return "xMin";
    case ID_xMax:               return "xMax";
    case ID_xIncr:              return "xIncr";
    case ID_xWrap:              return "xWrap";
    case ID_yAbsMax:            return "yAbsMax";
    case ID_yMin:               return "yMin";
    case ID_yMax:               return "yMax";
    case ID_yIncr:              return "yIncr";
    case ID_yWrap:              return "yWrap";
    case ID_zAbsMax:            return "zAbsMax";
    case ID_zMin:               return "zMin";
    case ID_zMax:               return "zMax";
    case ID_zIncr:              return "zIncr";
    case ID_zWrap:              return "zWrap";
    case ID_useWholeCollection: return "useWholeCollection";
    case ID_categoryName:       return "categoryName";
    case ID_subsetName:         return "subsetName";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
IndexSelectAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_maxDim:             return FieldType_enum;
    case ID_dim:                return FieldType_enum;
    case ID_xAbsMax:            return FieldType_int;
    case ID_xMin:               return FieldType_int;
    case ID_xMax:               return FieldType_int;
    case ID_xIncr:              return FieldType_int;
    case ID_xWrap:              return FieldType_bool;
    case ID_yAbsMax:            return FieldType_int;
    case ID_yMin:               return FieldType_int;
    case ID_yMax:               return FieldType_int;
    case ID_yIncr:              return FieldType_int;
    case ID_yWrap:              return FieldType_bool;
    case ID_zAbsMax:            return FieldType_int;
    case ID_zMin:               return FieldType_int;
    case ID_zMax:               return FieldType_int;
    case ID_zIncr:              return FieldType_int;
    case ID_zWrap:              return FieldType_bool;
    case ID_useWholeCollection: return FieldType_bool;
    case ID_categoryName:       return FieldType_string;
    case ID_subsetName:         return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
IndexSelectAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_maxDim:             return "enum";
    case ID_dim:                return "enum";
    case ID_xAbsMax:            return "int";
    case ID_xMin:               return "int";
    case ID_xMax:               return "int";
    case ID_xIncr:              return "int";
    case ID_xWrap:              return "bool";
    case ID_yAbsMax:            return "int";
    case ID_yMin:               return "int";
    case ID_yMax:               return "int";
    case ID_yIncr:              return "int";
    case ID_yWrap:              return "bool";
    case ID_zAbsMax:            return "int";
    case ID_zMin:               return "int";
    case ID_zMax:               return "int";
    case ID_zIncr:              return "int";
    case ID_zWrap:              return "bool";
    case ID_useWholeCollection: return "bool";
    case ID_categoryName:       return "string";
    case ID_subsetName:         return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const IndexSelectAttributes &obj = *((const IndexSelectAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_maxDim:
        {  // new scope
        retval = (maxDim == obj.maxDim);
        }
        break;
    case ID_dim:
        {  // new scope
        retval = (dim == obj.dim);
        }
        break;
    case ID_xAbsMax:
        {  // new scope
        retval = (xAbsMax == obj.xAbsMax);
        }
        break;
    case ID_xMin:
        {  // new scope
        retval = (xMin == obj.xMin);
        }
        break;
    case ID_xMax:
        {  // new scope
        retval = (xMax == obj.xMax);
        }
        break;
    case ID_xIncr:
        {  // new scope
        retval = (xIncr == obj.xIncr);
        }
        break;
    case ID_xWrap:
        {  // new scope
        retval = (xWrap == obj.xWrap);
        }
        break;
    case ID_yAbsMax:
        {  // new scope
        retval = (yAbsMax == obj.yAbsMax);
        }
        break;
    case ID_yMin:
        {  // new scope
        retval = (yMin == obj.yMin);
        }
        break;
    case ID_yMax:
        {  // new scope
        retval = (yMax == obj.yMax);
        }
        break;
    case ID_yIncr:
        {  // new scope
        retval = (yIncr == obj.yIncr);
        }
        break;
    case ID_yWrap:
        {  // new scope
        retval = (yWrap == obj.yWrap);
        }
        break;
    case ID_zAbsMax:
        {  // new scope
        retval = (zAbsMax == obj.zAbsMax);
        }
        break;
    case ID_zMin:
        {  // new scope
        retval = (zMin == obj.zMin);
        }
        break;
    case ID_zMax:
        {  // new scope
        retval = (zMax == obj.zMax);
        }
        break;
    case ID_zIncr:
        {  // new scope
        retval = (zIncr == obj.zIncr);
        }
        break;
    case ID_zWrap:
        {  // new scope
        retval = (zWrap == obj.zWrap);
        }
        break;
    case ID_useWholeCollection:
        {  // new scope
        retval = (useWholeCollection == obj.useWholeCollection);
        }
        break;
    case ID_categoryName:
        {  // new scope
        retval = (categoryName == obj.categoryName);
        }
        break;
    case ID_subsetName:
        {  // new scope
        retval = (subsetName == obj.subsetName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IndexSelectAttributes::ProcessOldVersions
//
// Purpose:
//   Updates the config settings in the data node to the current IndexSelect
//   opertor version.
//
// Arguments:
//   parentNode    : The data node that stores the IndexSelect attributes.
//   configVersion : The version of the config file from which the node
//                   was read.
//
// Programmer: Kathleen Bonnell 
// Creation:   Thu Jun  7 13:58:03 PDT 2007 
//
// Modifications:
//
// ****************************************************************************

void
IndexSelectAttributes::ProcessOldVersions(DataNode *parentNode,
    const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("IndexSelectAttributes");
    if(searchNode == 0)
        return;

    //
    // If the config file is less than version 1.6.1, remove old nodes. 
    //
    if(!VersionLessThan(configVersion, "1.6.1"))
        return;


    DataNode *oldNode = searchNode->GetNode("whichData");
    if (oldNode != 0)
         searchNode->RemoveNode("whichData");

    oldNode = searchNode->GetNode("domainIndex");
    if (oldNode != 0)
         searchNode->RemoveNode("domainIndex");

    oldNode = searchNode->GetNode("groupIndex");
    if (oldNode != 0)
         searchNode->RemoveNode("groupIndex");
}

