/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ViewerClientAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ViewerClientAttributes::RenderType
//

static const char *RenderType_strings[] = {
"None", "Image", "Data"
};

std::string
ViewerClientAttributes::RenderType_ToString(ViewerClientAttributes::RenderType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return RenderType_strings[index];
}

std::string
ViewerClientAttributes::RenderType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return RenderType_strings[index];
}

bool
ViewerClientAttributes::RenderType_FromString(const std::string &s, ViewerClientAttributes::RenderType &val)
{
    val = ViewerClientAttributes::None;
    for(int i = 0; i < 3; ++i)
    {
        if(s == RenderType_strings[i])
        {
            val = (RenderType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Init utility for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerClientAttributes::Init()
{
    renderingType = None;
    id = -1;
    title = "client";
    imageWidth = 300;
    imageHeight = 300;
    imageResolutionPcnt = 100;
    externalClient = false;

    ViewerClientAttributes::SelectAll();
}

// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Copy utility for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerClientAttributes::Copy(const ViewerClientAttributes &obj)
{
    renderingType = obj.renderingType;
    id = obj.id;
    title = obj.title;
    windowIds = obj.windowIds;
    imageWidth = obj.imageWidth;
    imageHeight = obj.imageHeight;
    imageResolutionPcnt = obj.imageResolutionPcnt;
    externalClient = obj.externalClient;
    renderingTypes = obj.renderingTypes;

    ViewerClientAttributes::SelectAll();
}

// Type map format string
const char *ViewerClientAttributes::TypeMapFormatString = VIEWERCLIENTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ViewerClientAttributes::TmfsStruct = {VIEWERCLIENTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Default constructor for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes::ViewerClientAttributes() : 
    AttributeSubject(ViewerClientAttributes::TypeMapFormatString)
{
    ViewerClientAttributes::Init();
}

// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Constructor for the derived classes of ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes::ViewerClientAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientAttributes::Init();
}

// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Copy constructor for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes::ViewerClientAttributes(const ViewerClientAttributes &obj) : 
    AttributeSubject(ViewerClientAttributes::TypeMapFormatString)
{
    ViewerClientAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientAttributes::ViewerClientAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes::ViewerClientAttributes(const ViewerClientAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientAttributes::~ViewerClientAttributes
//
// Purpose: 
//   Destructor for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes::~ViewerClientAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewerClientAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerClientAttributes& 
ViewerClientAttributes::operator = (const ViewerClientAttributes &obj)
{
    if (this == &obj) return *this;

    ViewerClientAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewerClientAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientAttributes::operator == (const ViewerClientAttributes &obj) const
{
    // Create the return value
    return ((renderingType == obj.renderingType) &&
            (id == obj.id) &&
            (title == obj.title) &&
            (windowIds == obj.windowIds) &&
            (imageWidth == obj.imageWidth) &&
            (imageHeight == obj.imageHeight) &&
            (imageResolutionPcnt == obj.imageResolutionPcnt) &&
            (externalClient == obj.externalClient) &&
            (renderingTypes == obj.renderingTypes));
}

// ****************************************************************************
// Method: ViewerClientAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientAttributes::operator != (const ViewerClientAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewerClientAttributes::TypeName
//
// Purpose: 
//   Type name method for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewerClientAttributes::TypeName() const
{
    return "ViewerClientAttributes";
}

// ****************************************************************************
// Method: ViewerClientAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewerClientAttributes *tmp = (const ViewerClientAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewerClientAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerClientAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewerClientAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewerClientAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewerClientAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerClientAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewerClientAttributes(*this);
    else
        retval = new ViewerClientAttributes;

    return retval;
}

// ****************************************************************************
// Method: ViewerClientAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewerClientAttributes::SelectAll()
{
    Select(ID_renderingType,       (void *)&renderingType);
    Select(ID_id,                  (void *)&id);
    Select(ID_title,               (void *)&title);
    Select(ID_windowIds,           (void *)&windowIds);
    Select(ID_imageWidth,          (void *)&imageWidth);
    Select(ID_imageHeight,         (void *)&imageHeight);
    Select(ID_imageResolutionPcnt, (void *)&imageResolutionPcnt);
    Select(ID_externalClient,      (void *)&externalClient);
    Select(ID_renderingTypes,      (void *)&renderingTypes);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewerClientAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ViewerClientAttributes.
    DataNode *node = new DataNode("ViewerClientAttributes");

    if(completeSave || !FieldsEqual(ID_renderingType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("renderingType", RenderType_ToString(renderingType)));
    }

    if(completeSave || !FieldsEqual(ID_id, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("id", id));
    }

    if(completeSave || !FieldsEqual(ID_title, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("title", title));
    }

    if(completeSave || !FieldsEqual(ID_windowIds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowIds", windowIds));
    }

    if(completeSave || !FieldsEqual(ID_imageWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageWidth", imageWidth));
    }

    if(completeSave || !FieldsEqual(ID_imageHeight, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageHeight", imageHeight));
    }

    if(completeSave || !FieldsEqual(ID_imageResolutionPcnt, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageResolutionPcnt", imageResolutionPcnt));
    }

    if(completeSave || !FieldsEqual(ID_externalClient, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("externalClient", externalClient));
    }

    if(completeSave || !FieldsEqual(ID_renderingTypes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("renderingTypes", renderingTypes));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewerClientAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewerClientAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewerClientAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("renderingType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetRenderingType(RenderType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            RenderType value;
            if(RenderType_FromString(node->AsString(), value))
                SetRenderingType(value);
        }
    }
    if((node = searchNode->GetNode("id")) != 0)
        SetId(node->AsInt());
    if((node = searchNode->GetNode("title")) != 0)
        SetTitle(node->AsString());
    if((node = searchNode->GetNode("windowIds")) != 0)
        SetWindowIds(node->AsIntVector());
    if((node = searchNode->GetNode("imageWidth")) != 0)
        SetImageWidth(node->AsInt());
    if((node = searchNode->GetNode("imageHeight")) != 0)
        SetImageHeight(node->AsInt());
    if((node = searchNode->GetNode("imageResolutionPcnt")) != 0)
        SetImageResolutionPcnt(node->AsDouble());
    if((node = searchNode->GetNode("externalClient")) != 0)
        SetExternalClient(node->AsBool());
    if((node = searchNode->GetNode("renderingTypes")) != 0)
        SetRenderingTypes(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientAttributes::SetRenderingType(ViewerClientAttributes::RenderType renderingType_)
{
    renderingType = renderingType_;
    Select(ID_renderingType, (void *)&renderingType);
}

void
ViewerClientAttributes::SetId(int id_)
{
    id = id_;
    Select(ID_id, (void *)&id);
}

void
ViewerClientAttributes::SetTitle(const std::string &title_)
{
    title = title_;
    Select(ID_title, (void *)&title);
}

void
ViewerClientAttributes::SetWindowIds(const intVector &windowIds_)
{
    windowIds = windowIds_;
    Select(ID_windowIds, (void *)&windowIds);
}

void
ViewerClientAttributes::SetImageWidth(int imageWidth_)
{
    imageWidth = imageWidth_;
    Select(ID_imageWidth, (void *)&imageWidth);
}

void
ViewerClientAttributes::SetImageHeight(int imageHeight_)
{
    imageHeight = imageHeight_;
    Select(ID_imageHeight, (void *)&imageHeight);
}

void
ViewerClientAttributes::SetImageResolutionPcnt(double imageResolutionPcnt_)
{
    imageResolutionPcnt = imageResolutionPcnt_;
    Select(ID_imageResolutionPcnt, (void *)&imageResolutionPcnt);
}

void
ViewerClientAttributes::SetExternalClient(bool externalClient_)
{
    externalClient = externalClient_;
    Select(ID_externalClient, (void *)&externalClient);
}

void
ViewerClientAttributes::SetRenderingTypes(const intVector &renderingTypes_)
{
    renderingTypes = renderingTypes_;
    Select(ID_renderingTypes, (void *)&renderingTypes);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ViewerClientAttributes::RenderType
ViewerClientAttributes::GetRenderingType() const
{
    return RenderType(renderingType);
}

int
ViewerClientAttributes::GetId() const
{
    return id;
}

const std::string &
ViewerClientAttributes::GetTitle() const
{
    return title;
}

std::string &
ViewerClientAttributes::GetTitle()
{
    return title;
}

const intVector &
ViewerClientAttributes::GetWindowIds() const
{
    return windowIds;
}

intVector &
ViewerClientAttributes::GetWindowIds()
{
    return windowIds;
}

int
ViewerClientAttributes::GetImageWidth() const
{
    return imageWidth;
}

int
ViewerClientAttributes::GetImageHeight() const
{
    return imageHeight;
}

double
ViewerClientAttributes::GetImageResolutionPcnt() const
{
    return imageResolutionPcnt;
}

bool
ViewerClientAttributes::GetExternalClient() const
{
    return externalClient;
}

const intVector &
ViewerClientAttributes::GetRenderingTypes() const
{
    return renderingTypes;
}

intVector &
ViewerClientAttributes::GetRenderingTypes()
{
    return renderingTypes;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientAttributes::SelectTitle()
{
    Select(ID_title, (void *)&title);
}

void
ViewerClientAttributes::SelectWindowIds()
{
    Select(ID_windowIds, (void *)&windowIds);
}

void
ViewerClientAttributes::SelectRenderingTypes()
{
    Select(ID_renderingTypes, (void *)&renderingTypes);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerClientAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_renderingType:       return "renderingType";
    case ID_id:                  return "id";
    case ID_title:               return "title";
    case ID_windowIds:           return "windowIds";
    case ID_imageWidth:          return "imageWidth";
    case ID_imageHeight:         return "imageHeight";
    case ID_imageResolutionPcnt: return "imageResolutionPcnt";
    case ID_externalClient:      return "externalClient";
    case ID_renderingTypes:      return "renderingTypes";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewerClientAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_renderingType:       return FieldType_enum;
    case ID_id:                  return FieldType_int;
    case ID_title:               return FieldType_string;
    case ID_windowIds:           return FieldType_intVector;
    case ID_imageWidth:          return FieldType_int;
    case ID_imageHeight:         return FieldType_int;
    case ID_imageResolutionPcnt: return FieldType_double;
    case ID_externalClient:      return FieldType_bool;
    case ID_renderingTypes:      return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewerClientAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerClientAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_renderingType:       return "enum";
    case ID_id:                  return "int";
    case ID_title:               return "string";
    case ID_windowIds:           return "intVector";
    case ID_imageWidth:          return "int";
    case ID_imageHeight:         return "int";
    case ID_imageResolutionPcnt: return "double";
    case ID_externalClient:      return "bool";
    case ID_renderingTypes:      return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerClientAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ViewerClientAttributes &obj = *((const ViewerClientAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_renderingType:
        {  // new scope
        retval = (renderingType == obj.renderingType);
        }
        break;
    case ID_id:
        {  // new scope
        retval = (id == obj.id);
        }
        break;
    case ID_title:
        {  // new scope
        retval = (title == obj.title);
        }
        break;
    case ID_windowIds:
        {  // new scope
        retval = (windowIds == obj.windowIds);
        }
        break;
    case ID_imageWidth:
        {  // new scope
        retval = (imageWidth == obj.imageWidth);
        }
        break;
    case ID_imageHeight:
        {  // new scope
        retval = (imageHeight == obj.imageHeight);
        }
        break;
    case ID_imageResolutionPcnt:
        {  // new scope
        retval = (imageResolutionPcnt == obj.imageResolutionPcnt);
        }
        break;
    case ID_externalClient:
        {  // new scope
        retval = (externalClient == obj.externalClient);
        }
        break;
    case ID_renderingTypes:
        {  // new scope
        retval = (renderingTypes == obj.renderingTypes);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

