/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPlot.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyPlot
//
// Purpose: 
//   This class is a plot element in a plot list.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a Plot.
//
struct PlotObject
{
    PyObject_HEAD
    Plot *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPlot(int);

std::string
PyPlot_ToString(const Plot *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *stateType_names = "NewlyCreated, Pending, Completed, Error";
    switch (atts->GetStateType())
    {
      case Plot::NewlyCreated:
          SNPRINTF(tmpStr, 1000, "%sstateType = %sNewlyCreated  # %s\n", prefix, prefix, stateType_names);
          str += tmpStr;
          break;
      case Plot::Pending:
          SNPRINTF(tmpStr, 1000, "%sstateType = %sPending  # %s\n", prefix, prefix, stateType_names);
          str += tmpStr;
          break;
      case Plot::Completed:
          SNPRINTF(tmpStr, 1000, "%sstateType = %sCompleted  # %s\n", prefix, prefix, stateType_names);
          str += tmpStr;
          break;
      case Plot::Error:
          SNPRINTF(tmpStr, 1000, "%sstateType = %sError  # %s\n", prefix, prefix, stateType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%splotType = %d\n", prefix, atts->GetPlotType());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%splotName = \"%s\"\n", prefix, atts->GetPlotName().c_str());
    str += tmpStr;
    if(atts->GetActiveFlag())
        SNPRINTF(tmpStr, 1000, "%sactiveFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sactiveFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetHiddenFlag())
        SNPRINTF(tmpStr, 1000, "%shiddenFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shiddenFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetExpandedFlag())
        SNPRINTF(tmpStr, 1000, "%sexpandedFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sexpandedFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%splotVar = \"%s\"\n", prefix, atts->GetPlotVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdatabaseName = \"%s\"\n", prefix, atts->GetDatabaseName().c_str());
    str += tmpStr;
    {   const intVector &operators = atts->GetOperators();
        SNPRINTF(tmpStr, 1000, "%soperators = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < operators.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", operators[i]);
            str += tmpStr;
            if(i < operators.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &operatorNames = atts->GetOperatorNames();
        SNPRINTF(tmpStr, 1000, "%soperatorNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < operatorNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", operatorNames[i].c_str());
            str += tmpStr;
            if(i < operatorNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sactiveOperator = %d\n", prefix, atts->GetActiveOperator());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sid = %d\n", prefix, atts->GetId());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sembeddedPlotId = %d\n", prefix, atts->GetEmbeddedPlotId());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sbeginFrame = %d\n", prefix, atts->GetBeginFrame());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendFrame = %d\n", prefix, atts->GetEndFrame());
    str += tmpStr;
    {   const intVector &keyframes = atts->GetKeyframes();
        SNPRINTF(tmpStr, 1000, "%skeyframes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < keyframes.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", keyframes[i]);
            str += tmpStr;
            if(i < keyframes.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &databaseKeyframes = atts->GetDatabaseKeyframes();
        SNPRINTF(tmpStr, 1000, "%sdatabaseKeyframes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < databaseKeyframes.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", databaseKeyframes[i]);
            str += tmpStr;
            if(i < databaseKeyframes.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetIsFromSimulation())
        SNPRINTF(tmpStr, 1000, "%sisFromSimulation = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisFromSimulation = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFollowsTime())
        SNPRINTF(tmpStr, 1000, "%sfollowsTime = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfollowsTime = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdescription = \"%s\"\n", prefix, atts->GetDescription().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sselection = \"%s\"\n", prefix, atts->GetSelection().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
Plot_Notify(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_SetStateType(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stateType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetStateType(Plot::StateType(ival));
    else
    {
        fprintf(stderr, "An invalid stateType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "NewlyCreated, Pending, Completed, Error.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetStateType(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStateType()));
    return retval;
}

/*static*/ PyObject *
Plot_SetPlotType(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plotType in the object.
    obj->data->SetPlotType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetPlotType(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPlotType()));
    return retval;
}

/*static*/ PyObject *
Plot_SetPlotName(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the plotName in the object.
    obj->data->SetPlotName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetPlotName(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPlotName().c_str());
    return retval;
}

/*static*/ PyObject *
Plot_SetActiveFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeFlag in the object.
    obj->data->SetActiveFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetActiveFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActiveFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Plot_SetHiddenFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hiddenFlag in the object.
    obj->data->SetHiddenFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetHiddenFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHiddenFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Plot_SetExpandedFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the expandedFlag in the object.
    obj->data->SetExpandedFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetExpandedFlag(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExpandedFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Plot_SetPlotVar(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the plotVar in the object.
    obj->data->SetPlotVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetPlotVar(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPlotVar().c_str());
    return retval;
}

/*static*/ PyObject *
Plot_SetDatabaseName(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the databaseName in the object.
    obj->data->SetDatabaseName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetDatabaseName(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDatabaseName().c_str());
    return retval;
}

/*static*/ PyObject *
Plot_SetOperators(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    intVector  &vec = obj->data->GetOperators();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the operators in the object as modified.
    obj->data->SelectOperators();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetOperators(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    // Allocate a tuple the with enough entries to hold the operators.
    const intVector &operators = obj->data->GetOperators();
    PyObject *retval = PyTuple_New(operators.size());
    for(size_t i = 0; i < operators.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(operators[i])));
    return retval;
}

/*static*/ PyObject *
Plot_SetOperatorNames(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    stringVector  &vec = obj->data->GetOperatorNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the operatorNames in the object as modified.
    obj->data->SelectOperatorNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetOperatorNames(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    // Allocate a tuple the with enough entries to hold the operatorNames.
    const stringVector &operatorNames = obj->data->GetOperatorNames();
    PyObject *retval = PyTuple_New(operatorNames.size());
    for(size_t i = 0; i < operatorNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(operatorNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
Plot_SetActiveOperator(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeOperator in the object.
    obj->data->SetActiveOperator((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetActiveOperator(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveOperator()));
    return retval;
}

/*static*/ PyObject *
Plot_SetId(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the id in the object.
    obj->data->SetId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetId(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetId()));
    return retval;
}

/*static*/ PyObject *
Plot_SetEmbeddedPlotId(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the embeddedPlotId in the object.
    obj->data->SetEmbeddedPlotId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetEmbeddedPlotId(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEmbeddedPlotId()));
    return retval;
}

/*static*/ PyObject *
Plot_SetBeginFrame(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the beginFrame in the object.
    obj->data->SetBeginFrame((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetBeginFrame(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBeginFrame()));
    return retval;
}

/*static*/ PyObject *
Plot_SetEndFrame(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endFrame in the object.
    obj->data->SetEndFrame((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetEndFrame(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndFrame()));
    return retval;
}

/*static*/ PyObject *
Plot_SetKeyframes(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    intVector  &vec = obj->data->GetKeyframes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the keyframes in the object as modified.
    obj->data->SelectKeyframes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetKeyframes(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    // Allocate a tuple the with enough entries to hold the keyframes.
    const intVector &keyframes = obj->data->GetKeyframes();
    PyObject *retval = PyTuple_New(keyframes.size());
    for(size_t i = 0; i < keyframes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(keyframes[i])));
    return retval;
}

/*static*/ PyObject *
Plot_SetDatabaseKeyframes(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    intVector  &vec = obj->data->GetDatabaseKeyframes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the databaseKeyframes in the object as modified.
    obj->data->SelectDatabaseKeyframes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetDatabaseKeyframes(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    // Allocate a tuple the with enough entries to hold the databaseKeyframes.
    const intVector &databaseKeyframes = obj->data->GetDatabaseKeyframes();
    PyObject *retval = PyTuple_New(databaseKeyframes.size());
    for(size_t i = 0; i < databaseKeyframes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(databaseKeyframes[i])));
    return retval;
}

/*static*/ PyObject *
Plot_SetIsFromSimulation(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isFromSimulation in the object.
    obj->data->SetIsFromSimulation(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetIsFromSimulation(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsFromSimulation()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Plot_SetFollowsTime(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the followsTime in the object.
    obj->data->SetFollowsTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetFollowsTime(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFollowsTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Plot_SetDescription(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the description in the object.
    obj->data->SetDescription(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetDescription(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDescription().c_str());
    return retval;
}

/*static*/ PyObject *
Plot_SetSelection(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the selection in the object.
    obj->data->SetSelection(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Plot_GetSelection(PyObject *self, PyObject *args)
{
    PlotObject *obj = (PlotObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSelection().c_str());
    return retval;
}



PyMethodDef PyPlot_methods[PLOT_NMETH] = {
    {"Notify", Plot_Notify, METH_VARARGS},
    {"SetStateType", Plot_SetStateType, METH_VARARGS},
    {"GetStateType", Plot_GetStateType, METH_VARARGS},
    {"SetPlotType", Plot_SetPlotType, METH_VARARGS},
    {"GetPlotType", Plot_GetPlotType, METH_VARARGS},
    {"SetPlotName", Plot_SetPlotName, METH_VARARGS},
    {"GetPlotName", Plot_GetPlotName, METH_VARARGS},
    {"SetActiveFlag", Plot_SetActiveFlag, METH_VARARGS},
    {"GetActiveFlag", Plot_GetActiveFlag, METH_VARARGS},
    {"SetHiddenFlag", Plot_SetHiddenFlag, METH_VARARGS},
    {"GetHiddenFlag", Plot_GetHiddenFlag, METH_VARARGS},
    {"SetExpandedFlag", Plot_SetExpandedFlag, METH_VARARGS},
    {"GetExpandedFlag", Plot_GetExpandedFlag, METH_VARARGS},
    {"SetPlotVar", Plot_SetPlotVar, METH_VARARGS},
    {"GetPlotVar", Plot_GetPlotVar, METH_VARARGS},
    {"SetDatabaseName", Plot_SetDatabaseName, METH_VARARGS},
    {"GetDatabaseName", Plot_GetDatabaseName, METH_VARARGS},
    {"SetOperators", Plot_SetOperators, METH_VARARGS},
    {"GetOperators", Plot_GetOperators, METH_VARARGS},
    {"SetOperatorNames", Plot_SetOperatorNames, METH_VARARGS},
    {"GetOperatorNames", Plot_GetOperatorNames, METH_VARARGS},
    {"SetActiveOperator", Plot_SetActiveOperator, METH_VARARGS},
    {"GetActiveOperator", Plot_GetActiveOperator, METH_VARARGS},
    {"SetId", Plot_SetId, METH_VARARGS},
    {"GetId", Plot_GetId, METH_VARARGS},
    {"SetEmbeddedPlotId", Plot_SetEmbeddedPlotId, METH_VARARGS},
    {"GetEmbeddedPlotId", Plot_GetEmbeddedPlotId, METH_VARARGS},
    {"SetBeginFrame", Plot_SetBeginFrame, METH_VARARGS},
    {"GetBeginFrame", Plot_GetBeginFrame, METH_VARARGS},
    {"SetEndFrame", Plot_SetEndFrame, METH_VARARGS},
    {"GetEndFrame", Plot_GetEndFrame, METH_VARARGS},
    {"SetKeyframes", Plot_SetKeyframes, METH_VARARGS},
    {"GetKeyframes", Plot_GetKeyframes, METH_VARARGS},
    {"SetDatabaseKeyframes", Plot_SetDatabaseKeyframes, METH_VARARGS},
    {"GetDatabaseKeyframes", Plot_GetDatabaseKeyframes, METH_VARARGS},
    {"SetIsFromSimulation", Plot_SetIsFromSimulation, METH_VARARGS},
    {"GetIsFromSimulation", Plot_GetIsFromSimulation, METH_VARARGS},
    {"SetFollowsTime", Plot_SetFollowsTime, METH_VARARGS},
    {"GetFollowsTime", Plot_GetFollowsTime, METH_VARARGS},
    {"SetDescription", Plot_SetDescription, METH_VARARGS},
    {"GetDescription", Plot_GetDescription, METH_VARARGS},
    {"SetSelection", Plot_SetSelection, METH_VARARGS},
    {"GetSelection", Plot_GetSelection, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
Plot_dealloc(PyObject *v)
{
   PlotObject *obj = (PlotObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
Plot_compare(PyObject *v, PyObject *w)
{
    Plot *a = ((PlotObject *)v)->data;
    Plot *b = ((PlotObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPlot_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "stateType") == 0)
        return Plot_GetStateType(self, NULL);
    if(strcmp(name, "NewlyCreated") == 0)
        return PyInt_FromLong(long(Plot::NewlyCreated));
    if(strcmp(name, "Pending") == 0)
        return PyInt_FromLong(long(Plot::Pending));
    if(strcmp(name, "Completed") == 0)
        return PyInt_FromLong(long(Plot::Completed));
    if(strcmp(name, "Error") == 0)
        return PyInt_FromLong(long(Plot::Error));

    if(strcmp(name, "plotType") == 0)
        return Plot_GetPlotType(self, NULL);
    if(strcmp(name, "plotName") == 0)
        return Plot_GetPlotName(self, NULL);
    if(strcmp(name, "activeFlag") == 0)
        return Plot_GetActiveFlag(self, NULL);
    if(strcmp(name, "hiddenFlag") == 0)
        return Plot_GetHiddenFlag(self, NULL);
    if(strcmp(name, "expandedFlag") == 0)
        return Plot_GetExpandedFlag(self, NULL);
    if(strcmp(name, "plotVar") == 0)
        return Plot_GetPlotVar(self, NULL);
    if(strcmp(name, "databaseName") == 0)
        return Plot_GetDatabaseName(self, NULL);
    if(strcmp(name, "operators") == 0)
        return Plot_GetOperators(self, NULL);
    if(strcmp(name, "operatorNames") == 0)
        return Plot_GetOperatorNames(self, NULL);
    if(strcmp(name, "activeOperator") == 0)
        return Plot_GetActiveOperator(self, NULL);
    if(strcmp(name, "id") == 0)
        return Plot_GetId(self, NULL);
    if(strcmp(name, "embeddedPlotId") == 0)
        return Plot_GetEmbeddedPlotId(self, NULL);
    if(strcmp(name, "beginFrame") == 0)
        return Plot_GetBeginFrame(self, NULL);
    if(strcmp(name, "endFrame") == 0)
        return Plot_GetEndFrame(self, NULL);
    if(strcmp(name, "keyframes") == 0)
        return Plot_GetKeyframes(self, NULL);
    if(strcmp(name, "databaseKeyframes") == 0)
        return Plot_GetDatabaseKeyframes(self, NULL);
    if(strcmp(name, "isFromSimulation") == 0)
        return Plot_GetIsFromSimulation(self, NULL);
    if(strcmp(name, "followsTime") == 0)
        return Plot_GetFollowsTime(self, NULL);
    if(strcmp(name, "description") == 0)
        return Plot_GetDescription(self, NULL);
    if(strcmp(name, "selection") == 0)
        return Plot_GetSelection(self, NULL);

    return Py_FindMethod(PyPlot_methods, self, name);
}

int
PyPlot_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "stateType") == 0)
        obj = Plot_SetStateType(self, tuple);
    else if(strcmp(name, "plotType") == 0)
        obj = Plot_SetPlotType(self, tuple);
    else if(strcmp(name, "plotName") == 0)
        obj = Plot_SetPlotName(self, tuple);
    else if(strcmp(name, "activeFlag") == 0)
        obj = Plot_SetActiveFlag(self, tuple);
    else if(strcmp(name, "hiddenFlag") == 0)
        obj = Plot_SetHiddenFlag(self, tuple);
    else if(strcmp(name, "expandedFlag") == 0)
        obj = Plot_SetExpandedFlag(self, tuple);
    else if(strcmp(name, "plotVar") == 0)
        obj = Plot_SetPlotVar(self, tuple);
    else if(strcmp(name, "databaseName") == 0)
        obj = Plot_SetDatabaseName(self, tuple);
    else if(strcmp(name, "operators") == 0)
        obj = Plot_SetOperators(self, tuple);
    else if(strcmp(name, "operatorNames") == 0)
        obj = Plot_SetOperatorNames(self, tuple);
    else if(strcmp(name, "activeOperator") == 0)
        obj = Plot_SetActiveOperator(self, tuple);
    else if(strcmp(name, "id") == 0)
        obj = Plot_SetId(self, tuple);
    else if(strcmp(name, "embeddedPlotId") == 0)
        obj = Plot_SetEmbeddedPlotId(self, tuple);
    else if(strcmp(name, "beginFrame") == 0)
        obj = Plot_SetBeginFrame(self, tuple);
    else if(strcmp(name, "endFrame") == 0)
        obj = Plot_SetEndFrame(self, tuple);
    else if(strcmp(name, "keyframes") == 0)
        obj = Plot_SetKeyframes(self, tuple);
    else if(strcmp(name, "databaseKeyframes") == 0)
        obj = Plot_SetDatabaseKeyframes(self, tuple);
    else if(strcmp(name, "isFromSimulation") == 0)
        obj = Plot_SetIsFromSimulation(self, tuple);
    else if(strcmp(name, "followsTime") == 0)
        obj = Plot_SetFollowsTime(self, tuple);
    else if(strcmp(name, "description") == 0)
        obj = Plot_SetDescription(self, tuple);
    else if(strcmp(name, "selection") == 0)
        obj = Plot_SetSelection(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
Plot_print(PyObject *v, FILE *fp, int flags)
{
    PlotObject *obj = (PlotObject *)v;
    fprintf(fp, "%s", PyPlot_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
Plot_str(PyObject *v)
{
    PlotObject *obj = (PlotObject *)v;
    return PyString_FromString(PyPlot_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *Plot_Purpose = "This class is a plot element in a plot list.";
#else
static char *Plot_Purpose = "This class is a plot element in a plot list.";
#endif

//
// The type description structure
//
static PyTypeObject PlotType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "Plot",                    // tp_name
    sizeof(PlotObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)Plot_dealloc,  // tp_dealloc
    (printfunc)Plot_print,     // tp_print
    (getattrfunc)PyPlot_getattr, // tp_getattr
    (setattrfunc)PyPlot_setattr, // tp_setattr
    (cmpfunc)Plot_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)Plot_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    Plot_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static Plot *defaultAtts = 0;
static Plot *currentAtts = 0;

static PyObject *
NewPlot(int useCurrent)
{
    PlotObject *newObject;
    newObject = PyObject_NEW(PlotObject, &PlotType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new Plot(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new Plot(*defaultAtts);
    else
        newObject->data = new Plot;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPlot(const Plot *attr)
{
    PlotObject *newObject;
    newObject = PyObject_NEW(PlotObject, &PlotType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (Plot *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
Plot_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPlot(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PlotMethods[] = {
    {"Plot", Plot_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PlotObserver = 0;

std::string
PyPlot_GetLogString()
{
    std::string s("Plot = Plot()\n");
    if(currentAtts != 0)
        s += PyPlot_ToString(currentAtts, "Plot.");
    return s;
}

static void
PyPlot_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("Plot = Plot()\n");
        s += PyPlot_ToString(currentAtts, "Plot.");
        cb(s);
    }
}

void
PyPlot_StartUp(Plot *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPlot_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PlotObserver == 0)
    {
        PlotObserver = new ObserverToCallback(subj,
            PyPlot_CallLogRoutine, (void *)data);
    }

}

void
PyPlot_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PlotObserver;
    PlotObserver = 0;
}

PyMethodDef *
PyPlot_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PlotMethods;
}

bool
PyPlot_Check(PyObject *obj)
{
    return (obj->ob_type == &PlotType);
}

Plot *
PyPlot_FromPyObject(PyObject *obj)
{
    PlotObject *obj2 = (PlotObject *)obj;
    return obj2->data;
}

PyObject *
PyPlot_New()
{
    return NewPlot(0);
}

PyObject *
PyPlot_Wrap(const Plot *attr)
{
    return WrapPlot(attr);
}

void
PyPlot_SetParent(PyObject *obj, PyObject *parent)
{
    PlotObject *obj2 = (PlotObject *)obj;
    obj2->parent = parent;
}

void
PyPlot_SetDefaults(const Plot *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new Plot(*atts);
}

