/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtCurveMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyavtCurveMetaData
//
// Purpose: 
//   Contains curve metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtCurveMetaData.
//
struct avtCurveMetaDataObject
{
    PyObject_HEAD
    avtCurveMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtCurveMetaData(int);

std::string
PyavtCurveMetaData_ToString(const avtCurveMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtVarMetaData_ToString(atts, prefix);

    SNPRINTF(tmpStr, 1000, "%sxUnits = \"%s\"\n", prefix, atts->xUnits.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxLabel = \"%s\"\n", prefix, atts->xLabel.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syUnits = \"%s\"\n", prefix, atts->yUnits.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syLabel = \"%s\"\n", prefix, atts->yLabel.c_str());
    str += tmpStr;
    if(atts->hasSpatialExtents)
        SNPRINTF(tmpStr, 1000, "%shasSpatialExtents = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasSpatialExtents = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminSpatialExtents = %g\n", prefix, atts->minSpatialExtents);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxSpatialExtents = %g\n", prefix, atts->maxSpatialExtents);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfrom1DScalarName = \"%s\"\n", prefix, atts->from1DScalarName.c_str());
    str += tmpStr;
    return str;
}

static PyObject *
avtCurveMetaData_Notify(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_SetXUnits(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xUnits in the object.
    obj->data->xUnits = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetXUnits(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->xUnits.c_str());
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetXLabel(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xLabel in the object.
    obj->data->xLabel = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetXLabel(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->xLabel.c_str());
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetYUnits(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yUnits in the object.
    obj->data->yUnits = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetYUnits(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->yUnits.c_str());
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetYLabel(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yLabel in the object.
    obj->data->yLabel = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetYLabel(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->yLabel.c_str());
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetHasSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasSpatialExtents in the object.
    obj->data->hasSpatialExtents = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetHasSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasSpatialExtents?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetMinSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minSpatialExtents in the object.
    obj->data->minSpatialExtents = dval;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetMinSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->minSpatialExtents);
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetMaxSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxSpatialExtents in the object.
    obj->data->maxSpatialExtents = dval;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetMaxSpatialExtents(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->maxSpatialExtents);
    return retval;
}

/*static*/ PyObject *
avtCurveMetaData_SetFrom1DScalarName(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the from1DScalarName in the object.
    obj->data->from1DScalarName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtCurveMetaData_GetFrom1DScalarName(PyObject *self, PyObject *args)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->from1DScalarName.c_str());
    return retval;
}



PyMethodDef PyavtCurveMetaData_methods[AVTCURVEMETADATA_NMETH] = {
    {"Notify", avtCurveMetaData_Notify, METH_VARARGS},
    {"SetXUnits", avtCurveMetaData_SetXUnits, METH_VARARGS},
    {"GetXUnits", avtCurveMetaData_GetXUnits, METH_VARARGS},
    {"SetXLabel", avtCurveMetaData_SetXLabel, METH_VARARGS},
    {"GetXLabel", avtCurveMetaData_GetXLabel, METH_VARARGS},
    {"SetYUnits", avtCurveMetaData_SetYUnits, METH_VARARGS},
    {"GetYUnits", avtCurveMetaData_GetYUnits, METH_VARARGS},
    {"SetYLabel", avtCurveMetaData_SetYLabel, METH_VARARGS},
    {"GetYLabel", avtCurveMetaData_GetYLabel, METH_VARARGS},
    {"SetHasSpatialExtents", avtCurveMetaData_SetHasSpatialExtents, METH_VARARGS},
    {"GetHasSpatialExtents", avtCurveMetaData_GetHasSpatialExtents, METH_VARARGS},
    {"SetMinSpatialExtents", avtCurveMetaData_SetMinSpatialExtents, METH_VARARGS},
    {"GetMinSpatialExtents", avtCurveMetaData_GetMinSpatialExtents, METH_VARARGS},
    {"SetMaxSpatialExtents", avtCurveMetaData_SetMaxSpatialExtents, METH_VARARGS},
    {"GetMaxSpatialExtents", avtCurveMetaData_GetMaxSpatialExtents, METH_VARARGS},
    {"SetFrom1DScalarName", avtCurveMetaData_SetFrom1DScalarName, METH_VARARGS},
    {"GetFrom1DScalarName", avtCurveMetaData_GetFrom1DScalarName, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtCurveMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtCurveMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtCurveMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtCurveMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtCurveMetaData_dealloc(PyObject *v)
{
   avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtCurveMetaData_compare(PyObject *v, PyObject *w)
{
    avtCurveMetaData *a = ((avtCurveMetaDataObject *)v)->data;
    avtCurveMetaData *b = ((avtCurveMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtCurveMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "xUnits") == 0)
        return avtCurveMetaData_GetXUnits(self, NULL);
    if(strcmp(name, "xLabel") == 0)
        return avtCurveMetaData_GetXLabel(self, NULL);
    if(strcmp(name, "yUnits") == 0)
        return avtCurveMetaData_GetYUnits(self, NULL);
    if(strcmp(name, "yLabel") == 0)
        return avtCurveMetaData_GetYLabel(self, NULL);
    if(strcmp(name, "hasSpatialExtents") == 0)
        return avtCurveMetaData_GetHasSpatialExtents(self, NULL);
    if(strcmp(name, "minSpatialExtents") == 0)
        return avtCurveMetaData_GetMinSpatialExtents(self, NULL);
    if(strcmp(name, "maxSpatialExtents") == 0)
        return avtCurveMetaData_GetMaxSpatialExtents(self, NULL);
    if(strcmp(name, "from1DScalarName") == 0)
        return avtCurveMetaData_GetFrom1DScalarName(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtCurveMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtCurveMetaData_methods, self, name);
}

int
PyavtCurveMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "xUnits") == 0)
        obj = avtCurveMetaData_SetXUnits(self, tuple);
    else if(strcmp(name, "xLabel") == 0)
        obj = avtCurveMetaData_SetXLabel(self, tuple);
    else if(strcmp(name, "yUnits") == 0)
        obj = avtCurveMetaData_SetYUnits(self, tuple);
    else if(strcmp(name, "yLabel") == 0)
        obj = avtCurveMetaData_SetYLabel(self, tuple);
    else if(strcmp(name, "hasSpatialExtents") == 0)
        obj = avtCurveMetaData_SetHasSpatialExtents(self, tuple);
    else if(strcmp(name, "minSpatialExtents") == 0)
        obj = avtCurveMetaData_SetMinSpatialExtents(self, tuple);
    else if(strcmp(name, "maxSpatialExtents") == 0)
        obj = avtCurveMetaData_SetMaxSpatialExtents(self, tuple);
    else if(strcmp(name, "from1DScalarName") == 0)
        obj = avtCurveMetaData_SetFrom1DScalarName(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtCurveMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)v;
    fprintf(fp, "%s", PyavtCurveMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtCurveMetaData_str(PyObject *v)
{
    avtCurveMetaDataObject *obj = (avtCurveMetaDataObject *)v;
    return PyString_FromString(PyavtCurveMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtCurveMetaData_Purpose = "Contains curve metadata attributes";
#else
static char *avtCurveMetaData_Purpose = "Contains curve metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtCurveMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtCurveMetaData",                    // tp_name
    sizeof(avtCurveMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtCurveMetaData_dealloc,  // tp_dealloc
    (printfunc)avtCurveMetaData_print,     // tp_print
    (getattrfunc)PyavtCurveMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtCurveMetaData_setattr, // tp_setattr
    (cmpfunc)avtCurveMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtCurveMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtCurveMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtCurveMetaData *defaultAtts = 0;
static avtCurveMetaData *currentAtts = 0;

static PyObject *
NewavtCurveMetaData(int useCurrent)
{
    avtCurveMetaDataObject *newObject;
    newObject = PyObject_NEW(avtCurveMetaDataObject, &avtCurveMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtCurveMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtCurveMetaData(*defaultAtts);
    else
        newObject->data = new avtCurveMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtCurveMetaData(const avtCurveMetaData *attr)
{
    avtCurveMetaDataObject *newObject;
    newObject = PyObject_NEW(avtCurveMetaDataObject, &avtCurveMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtCurveMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtCurveMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtCurveMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtCurveMetaDataMethods[] = {
    {"avtCurveMetaData", avtCurveMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtCurveMetaDataObserver = 0;

std::string
PyavtCurveMetaData_GetLogString()
{
    std::string s("avtCurveMetaData = avtCurveMetaData()\n");
    if(currentAtts != 0)
        s += PyavtCurveMetaData_ToString(currentAtts, "avtCurveMetaData.");
    return s;
}

static void
PyavtCurveMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtCurveMetaData = avtCurveMetaData()\n");
        s += PyavtCurveMetaData_ToString(currentAtts, "avtCurveMetaData.");
        cb(s);
    }
}

void
PyavtCurveMetaData_StartUp(avtCurveMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtCurveMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtCurveMetaDataObserver == 0)
    {
        avtCurveMetaDataObserver = new ObserverToCallback(subj,
            PyavtCurveMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtCurveMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtCurveMetaDataObserver;
    avtCurveMetaDataObserver = 0;
}

PyMethodDef *
PyavtCurveMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtCurveMetaDataMethods;
}

bool
PyavtCurveMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtCurveMetaDataType);
}

avtCurveMetaData *
PyavtCurveMetaData_FromPyObject(PyObject *obj)
{
    avtCurveMetaDataObject *obj2 = (avtCurveMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtCurveMetaData_New()
{
    return NewavtCurveMetaData(0);
}

PyObject *
PyavtCurveMetaData_Wrap(const avtCurveMetaData *attr)
{
    return WrapavtCurveMetaData(attr);
}

void
PyavtCurveMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtCurveMetaDataObject *obj2 = (avtCurveMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtCurveMetaData_SetDefaults(const avtCurveMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtCurveMetaData(*atts);
}

