/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyViewerClientInformationElement.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyViewerClientInformationElement
//
// Purpose: 
//   This class contains the raw element
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewerClientInformationElement.
//
struct ViewerClientInformationElementObject
{
    PyObject_HEAD
    ViewerClientInformationElement *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewViewerClientInformationElement(int);

std::string
PyViewerClientInformationElement_ToString(const ViewerClientInformationElement *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sdata = \"%s\"\n", prefix, atts->GetData().c_str());
    str += tmpStr;
    {   const unsignedCharVector &rawData = atts->GetRawData();
        SNPRINTF(tmpStr, 1000, "%srawData = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < rawData.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(rawData[i]));
            str += tmpStr;
            if(i < rawData.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sformat = %d\n", prefix, atts->GetFormat());
    str += tmpStr;
    if(atts->GetIsRaw())
        SNPRINTF(tmpStr, 1000, "%sisRaw = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisRaw = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowId = %d\n", prefix, atts->GetWindowId());
    str += tmpStr;
    return str;
}

static PyObject *
ViewerClientInformationElement_Notify(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_SetData(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the data in the object.
    obj->data->SetData(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_GetData(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetData().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerClientInformationElement_SetRawData(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;

    unsignedCharVector  &vec = obj->data->GetRawData();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the rawData in the object as modified.
    obj->data->SelectRawData();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_GetRawData(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    // Allocate a tuple the with enough entries to hold the rawData.
    const unsignedCharVector &rawData = obj->data->GetRawData();
    PyObject *retval = PyTuple_New(rawData.size());
    for(size_t i = 0; i < rawData.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(rawData[i])));
    return retval;
}

/*static*/ PyObject *
ViewerClientInformationElement_SetFormat(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the format in the object.
    obj->data->SetFormat((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_GetFormat(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFormat()));
    return retval;
}

/*static*/ PyObject *
ViewerClientInformationElement_SetIsRaw(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isRaw in the object.
    obj->data->SetIsRaw(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_GetIsRaw(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsRaw()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ViewerClientInformationElement_SetWindowId(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientInformationElement_GetWindowId(PyObject *self, PyObject *args)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}



PyMethodDef PyViewerClientInformationElement_methods[VIEWERCLIENTINFORMATIONELEMENT_NMETH] = {
    {"Notify", ViewerClientInformationElement_Notify, METH_VARARGS},
    {"SetData", ViewerClientInformationElement_SetData, METH_VARARGS},
    {"GetData", ViewerClientInformationElement_GetData, METH_VARARGS},
    {"SetRawData", ViewerClientInformationElement_SetRawData, METH_VARARGS},
    {"GetRawData", ViewerClientInformationElement_GetRawData, METH_VARARGS},
    {"SetFormat", ViewerClientInformationElement_SetFormat, METH_VARARGS},
    {"GetFormat", ViewerClientInformationElement_GetFormat, METH_VARARGS},
    {"SetIsRaw", ViewerClientInformationElement_SetIsRaw, METH_VARARGS},
    {"GetIsRaw", ViewerClientInformationElement_GetIsRaw, METH_VARARGS},
    {"SetWindowId", ViewerClientInformationElement_SetWindowId, METH_VARARGS},
    {"GetWindowId", ViewerClientInformationElement_GetWindowId, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewerClientInformationElement_dealloc(PyObject *v)
{
   ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ViewerClientInformationElement_compare(PyObject *v, PyObject *w)
{
    ViewerClientInformationElement *a = ((ViewerClientInformationElementObject *)v)->data;
    ViewerClientInformationElement *b = ((ViewerClientInformationElementObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyViewerClientInformationElement_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "data") == 0)
        return ViewerClientInformationElement_GetData(self, NULL);
    if(strcmp(name, "rawData") == 0)
        return ViewerClientInformationElement_GetRawData(self, NULL);
    if(strcmp(name, "format") == 0)
        return ViewerClientInformationElement_GetFormat(self, NULL);
    if(strcmp(name, "isRaw") == 0)
        return ViewerClientInformationElement_GetIsRaw(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return ViewerClientInformationElement_GetWindowId(self, NULL);

    return Py_FindMethod(PyViewerClientInformationElement_methods, self, name);
}

int
PyViewerClientInformationElement_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "data") == 0)
        obj = ViewerClientInformationElement_SetData(self, tuple);
    else if(strcmp(name, "rawData") == 0)
        obj = ViewerClientInformationElement_SetRawData(self, tuple);
    else if(strcmp(name, "format") == 0)
        obj = ViewerClientInformationElement_SetFormat(self, tuple);
    else if(strcmp(name, "isRaw") == 0)
        obj = ViewerClientInformationElement_SetIsRaw(self, tuple);
    else if(strcmp(name, "windowId") == 0)
        obj = ViewerClientInformationElement_SetWindowId(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ViewerClientInformationElement_print(PyObject *v, FILE *fp, int flags)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)v;
    fprintf(fp, "%s", PyViewerClientInformationElement_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ViewerClientInformationElement_str(PyObject *v)
{
    ViewerClientInformationElementObject *obj = (ViewerClientInformationElementObject *)v;
    return PyString_FromString(PyViewerClientInformationElement_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ViewerClientInformationElement_Purpose = "This class contains the raw element";
#else
static char *ViewerClientInformationElement_Purpose = "This class contains the raw element";
#endif

//
// The type description structure
//
static PyTypeObject ViewerClientInformationElementType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewerClientInformationElement",                    // tp_name
    sizeof(ViewerClientInformationElementObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewerClientInformationElement_dealloc,  // tp_dealloc
    (printfunc)ViewerClientInformationElement_print,     // tp_print
    (getattrfunc)PyViewerClientInformationElement_getattr, // tp_getattr
    (setattrfunc)PyViewerClientInformationElement_setattr, // tp_setattr
    (cmpfunc)ViewerClientInformationElement_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ViewerClientInformationElement_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewerClientInformationElement_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewerClientInformationElement *defaultAtts = 0;
static ViewerClientInformationElement *currentAtts = 0;

static PyObject *
NewViewerClientInformationElement(int useCurrent)
{
    ViewerClientInformationElementObject *newObject;
    newObject = PyObject_NEW(ViewerClientInformationElementObject, &ViewerClientInformationElementType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ViewerClientInformationElement(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ViewerClientInformationElement(*defaultAtts);
    else
        newObject->data = new ViewerClientInformationElement;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewerClientInformationElement(const ViewerClientInformationElement *attr)
{
    ViewerClientInformationElementObject *newObject;
    newObject = PyObject_NEW(ViewerClientInformationElementObject, &ViewerClientInformationElementType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewerClientInformationElement *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewerClientInformationElement_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewViewerClientInformationElement(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewerClientInformationElementMethods[] = {
    {"ViewerClientInformationElement", ViewerClientInformationElement_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewerClientInformationElementObserver = 0;

std::string
PyViewerClientInformationElement_GetLogString()
{
    std::string s("ViewerClientInformationElement = ViewerClientInformationElement()\n");
    if(currentAtts != 0)
        s += PyViewerClientInformationElement_ToString(currentAtts, "ViewerClientInformationElement.");
    return s;
}

static void
PyViewerClientInformationElement_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ViewerClientInformationElement = ViewerClientInformationElement()\n");
        s += PyViewerClientInformationElement_ToString(currentAtts, "ViewerClientInformationElement.");
        cb(s);
    }
}

void
PyViewerClientInformationElement_StartUp(ViewerClientInformationElement *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyViewerClientInformationElement_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewerClientInformationElementObserver == 0)
    {
        ViewerClientInformationElementObserver = new ObserverToCallback(subj,
            PyViewerClientInformationElement_CallLogRoutine, (void *)data);
    }

}

void
PyViewerClientInformationElement_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewerClientInformationElementObserver;
    ViewerClientInformationElementObserver = 0;
}

PyMethodDef *
PyViewerClientInformationElement_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewerClientInformationElementMethods;
}

bool
PyViewerClientInformationElement_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewerClientInformationElementType);
}

ViewerClientInformationElement *
PyViewerClientInformationElement_FromPyObject(PyObject *obj)
{
    ViewerClientInformationElementObject *obj2 = (ViewerClientInformationElementObject *)obj;
    return obj2->data;
}

PyObject *
PyViewerClientInformationElement_New()
{
    return NewViewerClientInformationElement(0);
}

PyObject *
PyViewerClientInformationElement_Wrap(const ViewerClientInformationElement *attr)
{
    return WrapViewerClientInformationElement(attr);
}

void
PyViewerClientInformationElement_SetParent(PyObject *obj, PyObject *parent)
{
    ViewerClientInformationElementObject *obj2 = (ViewerClientInformationElementObject *)obj;
    obj2->parent = parent;
}

void
PyViewerClientInformationElement_SetDefaults(const ViewerClientInformationElement *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewerClientInformationElement(*atts);
}

