/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyNameschemeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyNameschemeAttributes
//
// Purpose: 
//   Information and methods to manage nameschemes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a NameschemeAttributes.
//
struct NameschemeAttributesObject
{
    PyObject_HEAD
    NameschemeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewNameschemeAttributes(int);

std::string
PyNameschemeAttributes_ToString(const NameschemeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%snamescheme = \"%s\"\n", prefix, atts->GetNamescheme().c_str());
    str += tmpStr;
    {   const stringVector &externalArrayNames = atts->GetExternalArrayNames();
        SNPRINTF(tmpStr, 1000, "%sexternalArrayNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < externalArrayNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", externalArrayNames[i].c_str());
            str += tmpStr;
            if(i < externalArrayNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &externalArrayOffsets = atts->GetExternalArrayOffsets();
        SNPRINTF(tmpStr, 1000, "%sexternalArrayOffsets = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < externalArrayOffsets.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", externalArrayOffsets[i]);
            str += tmpStr;
            if(i < externalArrayOffsets.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &externalArrayData = atts->GetExternalArrayData();
        SNPRINTF(tmpStr, 1000, "%sexternalArrayData = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < externalArrayData.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", externalArrayData[i]);
            str += tmpStr;
            if(i < externalArrayData.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &allExplicitNames = atts->GetAllExplicitNames();
        SNPRINTF(tmpStr, 1000, "%sallExplicitNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < allExplicitNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", allExplicitNames[i].c_str());
            str += tmpStr;
            if(i < allExplicitNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &explicitIds = atts->GetExplicitIds();
        SNPRINTF(tmpStr, 1000, "%sexplicitIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < explicitIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", explicitIds[i]);
            str += tmpStr;
            if(i < explicitIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &explicitNames = atts->GetExplicitNames();
        SNPRINTF(tmpStr, 1000, "%sexplicitNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < explicitNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", explicitNames[i].c_str());
            str += tmpStr;
            if(i < explicitNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
NameschemeAttributes_Notify(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_SetNamescheme(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the namescheme in the object.
    obj->data->SetNamescheme(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetNamescheme(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetNamescheme().c_str());
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetExternalArrayNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    stringVector  &vec = obj->data->GetExternalArrayNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the externalArrayNames in the object as modified.
    obj->data->SelectExternalArrayNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetExternalArrayNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the externalArrayNames.
    const stringVector &externalArrayNames = obj->data->GetExternalArrayNames();
    PyObject *retval = PyTuple_New(externalArrayNames.size());
    for(size_t i = 0; i < externalArrayNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(externalArrayNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetExternalArrayOffsets(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    intVector  &vec = obj->data->GetExternalArrayOffsets();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the externalArrayOffsets in the object as modified.
    obj->data->SelectExternalArrayOffsets();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetExternalArrayOffsets(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the externalArrayOffsets.
    const intVector &externalArrayOffsets = obj->data->GetExternalArrayOffsets();
    PyObject *retval = PyTuple_New(externalArrayOffsets.size());
    for(size_t i = 0; i < externalArrayOffsets.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(externalArrayOffsets[i])));
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetExternalArrayData(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    intVector  &vec = obj->data->GetExternalArrayData();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the externalArrayData in the object as modified.
    obj->data->SelectExternalArrayData();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetExternalArrayData(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the externalArrayData.
    const intVector &externalArrayData = obj->data->GetExternalArrayData();
    PyObject *retval = PyTuple_New(externalArrayData.size());
    for(size_t i = 0; i < externalArrayData.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(externalArrayData[i])));
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetAllExplicitNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    stringVector  &vec = obj->data->GetAllExplicitNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the allExplicitNames in the object as modified.
    obj->data->SelectAllExplicitNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetAllExplicitNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the allExplicitNames.
    const stringVector &allExplicitNames = obj->data->GetAllExplicitNames();
    PyObject *retval = PyTuple_New(allExplicitNames.size());
    for(size_t i = 0; i < allExplicitNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(allExplicitNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetExplicitIds(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    intVector  &vec = obj->data->GetExplicitIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the explicitIds in the object as modified.
    obj->data->SelectExplicitIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetExplicitIds(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the explicitIds.
    const intVector &explicitIds = obj->data->GetExplicitIds();
    PyObject *retval = PyTuple_New(explicitIds.size());
    for(size_t i = 0; i < explicitIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(explicitIds[i])));
    return retval;
}

/*static*/ PyObject *
NameschemeAttributes_SetExplicitNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;

    stringVector  &vec = obj->data->GetExplicitNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the explicitNames in the object as modified.
    obj->data->SelectExplicitNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
NameschemeAttributes_GetExplicitNames(PyObject *self, PyObject *args)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the explicitNames.
    const stringVector &explicitNames = obj->data->GetExplicitNames();
    PyObject *retval = PyTuple_New(explicitNames.size());
    for(size_t i = 0; i < explicitNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(explicitNames[i].c_str()));
    return retval;
}



PyMethodDef PyNameschemeAttributes_methods[NAMESCHEMEATTRIBUTES_NMETH] = {
    {"Notify", NameschemeAttributes_Notify, METH_VARARGS},
    {"SetNamescheme", NameschemeAttributes_SetNamescheme, METH_VARARGS},
    {"GetNamescheme", NameschemeAttributes_GetNamescheme, METH_VARARGS},
    {"SetExternalArrayNames", NameschemeAttributes_SetExternalArrayNames, METH_VARARGS},
    {"GetExternalArrayNames", NameschemeAttributes_GetExternalArrayNames, METH_VARARGS},
    {"SetExternalArrayOffsets", NameschemeAttributes_SetExternalArrayOffsets, METH_VARARGS},
    {"GetExternalArrayOffsets", NameschemeAttributes_GetExternalArrayOffsets, METH_VARARGS},
    {"SetExternalArrayData", NameschemeAttributes_SetExternalArrayData, METH_VARARGS},
    {"GetExternalArrayData", NameschemeAttributes_GetExternalArrayData, METH_VARARGS},
    {"SetAllExplicitNames", NameschemeAttributes_SetAllExplicitNames, METH_VARARGS},
    {"GetAllExplicitNames", NameschemeAttributes_GetAllExplicitNames, METH_VARARGS},
    {"SetExplicitIds", NameschemeAttributes_SetExplicitIds, METH_VARARGS},
    {"GetExplicitIds", NameschemeAttributes_GetExplicitIds, METH_VARARGS},
    {"SetExplicitNames", NameschemeAttributes_SetExplicitNames, METH_VARARGS},
    {"GetExplicitNames", NameschemeAttributes_GetExplicitNames, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
NameschemeAttributes_dealloc(PyObject *v)
{
   NameschemeAttributesObject *obj = (NameschemeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
NameschemeAttributes_compare(PyObject *v, PyObject *w)
{
    NameschemeAttributes *a = ((NameschemeAttributesObject *)v)->data;
    NameschemeAttributes *b = ((NameschemeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyNameschemeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "namescheme") == 0)
        return NameschemeAttributes_GetNamescheme(self, NULL);
    if(strcmp(name, "externalArrayNames") == 0)
        return NameschemeAttributes_GetExternalArrayNames(self, NULL);
    if(strcmp(name, "externalArrayOffsets") == 0)
        return NameschemeAttributes_GetExternalArrayOffsets(self, NULL);
    if(strcmp(name, "externalArrayData") == 0)
        return NameschemeAttributes_GetExternalArrayData(self, NULL);
    if(strcmp(name, "allExplicitNames") == 0)
        return NameschemeAttributes_GetAllExplicitNames(self, NULL);
    if(strcmp(name, "explicitIds") == 0)
        return NameschemeAttributes_GetExplicitIds(self, NULL);
    if(strcmp(name, "explicitNames") == 0)
        return NameschemeAttributes_GetExplicitNames(self, NULL);

    return Py_FindMethod(PyNameschemeAttributes_methods, self, name);
}

int
PyNameschemeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "namescheme") == 0)
        obj = NameschemeAttributes_SetNamescheme(self, tuple);
    else if(strcmp(name, "externalArrayNames") == 0)
        obj = NameschemeAttributes_SetExternalArrayNames(self, tuple);
    else if(strcmp(name, "externalArrayOffsets") == 0)
        obj = NameschemeAttributes_SetExternalArrayOffsets(self, tuple);
    else if(strcmp(name, "externalArrayData") == 0)
        obj = NameschemeAttributes_SetExternalArrayData(self, tuple);
    else if(strcmp(name, "allExplicitNames") == 0)
        obj = NameschemeAttributes_SetAllExplicitNames(self, tuple);
    else if(strcmp(name, "explicitIds") == 0)
        obj = NameschemeAttributes_SetExplicitIds(self, tuple);
    else if(strcmp(name, "explicitNames") == 0)
        obj = NameschemeAttributes_SetExplicitNames(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
NameschemeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)v;
    fprintf(fp, "%s", PyNameschemeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
NameschemeAttributes_str(PyObject *v)
{
    NameschemeAttributesObject *obj = (NameschemeAttributesObject *)v;
    return PyString_FromString(PyNameschemeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *NameschemeAttributes_Purpose = "Information and methods to manage nameschemes";
#else
static char *NameschemeAttributes_Purpose = "Information and methods to manage nameschemes";
#endif

//
// The type description structure
//
static PyTypeObject NameschemeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "NameschemeAttributes",                    // tp_name
    sizeof(NameschemeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)NameschemeAttributes_dealloc,  // tp_dealloc
    (printfunc)NameschemeAttributes_print,     // tp_print
    (getattrfunc)PyNameschemeAttributes_getattr, // tp_getattr
    (setattrfunc)PyNameschemeAttributes_setattr, // tp_setattr
    (cmpfunc)NameschemeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)NameschemeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    NameschemeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static NameschemeAttributes *defaultAtts = 0;
static NameschemeAttributes *currentAtts = 0;

static PyObject *
NewNameschemeAttributes(int useCurrent)
{
    NameschemeAttributesObject *newObject;
    newObject = PyObject_NEW(NameschemeAttributesObject, &NameschemeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new NameschemeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new NameschemeAttributes(*defaultAtts);
    else
        newObject->data = new NameschemeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapNameschemeAttributes(const NameschemeAttributes *attr)
{
    NameschemeAttributesObject *newObject;
    newObject = PyObject_NEW(NameschemeAttributesObject, &NameschemeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (NameschemeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
NameschemeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewNameschemeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef NameschemeAttributesMethods[] = {
    {"NameschemeAttributes", NameschemeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *NameschemeAttributesObserver = 0;

std::string
PyNameschemeAttributes_GetLogString()
{
    std::string s("NameschemeAtts = NameschemeAttributes()\n");
    if(currentAtts != 0)
        s += PyNameschemeAttributes_ToString(currentAtts, "NameschemeAtts.");
    return s;
}

static void
PyNameschemeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("NameschemeAtts = NameschemeAttributes()\n");
        s += PyNameschemeAttributes_ToString(currentAtts, "NameschemeAtts.");
        cb(s);
    }
}

void
PyNameschemeAttributes_StartUp(NameschemeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyNameschemeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(NameschemeAttributesObserver == 0)
    {
        NameschemeAttributesObserver = new ObserverToCallback(subj,
            PyNameschemeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyNameschemeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete NameschemeAttributesObserver;
    NameschemeAttributesObserver = 0;
}

PyMethodDef *
PyNameschemeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return NameschemeAttributesMethods;
}

bool
PyNameschemeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &NameschemeAttributesType);
}

NameschemeAttributes *
PyNameschemeAttributes_FromPyObject(PyObject *obj)
{
    NameschemeAttributesObject *obj2 = (NameschemeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyNameschemeAttributes_New()
{
    return NewNameschemeAttributes(0);
}

PyObject *
PyNameschemeAttributes_Wrap(const NameschemeAttributes *attr)
{
    return WrapNameschemeAttributes(attr);
}

void
PyNameschemeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    NameschemeAttributesObject *obj2 = (NameschemeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyNameschemeAttributes_SetDefaults(const NameschemeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new NameschemeAttributes(*atts);
}

