/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLaunchProfile.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyLaunchProfile
//
// Purpose: 
//   This class contains information needed to launch a VisIt engine.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LaunchProfile.
//
struct LaunchProfileObject
{
    PyObject_HEAD
    LaunchProfile *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLaunchProfile(int);

std::string
PyLaunchProfile_ToString(const LaunchProfile *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sprofileName = \"%s\"\n", prefix, atts->GetProfileName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeout = %d\n", prefix, atts->GetTimeout());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumProcessors = %d\n", prefix, atts->GetNumProcessors());
    str += tmpStr;
    if(atts->GetNumNodesSet())
        SNPRINTF(tmpStr, 1000, "%snumNodesSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snumNodesSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumNodes = %d\n", prefix, atts->GetNumNodes());
    str += tmpStr;
    if(atts->GetPartitionSet())
        SNPRINTF(tmpStr, 1000, "%spartitionSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spartitionSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spartition = \"%s\"\n", prefix, atts->GetPartition().c_str());
    str += tmpStr;
    if(atts->GetBankSet())
        SNPRINTF(tmpStr, 1000, "%sbankSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sbankSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sbank = \"%s\"\n", prefix, atts->GetBank().c_str());
    str += tmpStr;
    if(atts->GetTimeLimitSet())
        SNPRINTF(tmpStr, 1000, "%stimeLimitSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stimeLimitSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeLimit = \"%s\"\n", prefix, atts->GetTimeLimit().c_str());
    str += tmpStr;
    if(atts->GetLaunchMethodSet())
        SNPRINTF(tmpStr, 1000, "%slaunchMethodSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slaunchMethodSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slaunchMethod = \"%s\"\n", prefix, atts->GetLaunchMethod().c_str());
    str += tmpStr;
    if(atts->GetForceStatic())
        SNPRINTF(tmpStr, 1000, "%sforceStatic = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sforceStatic = 0\n", prefix);
    str += tmpStr;
    if(atts->GetForceDynamic())
        SNPRINTF(tmpStr, 1000, "%sforceDynamic = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sforceDynamic = 0\n", prefix);
    str += tmpStr;
    if(atts->GetActive())
        SNPRINTF(tmpStr, 1000, "%sactive = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sactive = 0\n", prefix);
    str += tmpStr;
    {   const stringVector &arguments = atts->GetArguments();
        SNPRINTF(tmpStr, 1000, "%sarguments = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < arguments.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", arguments[i].c_str());
            str += tmpStr;
            if(i < arguments.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetParallel())
        SNPRINTF(tmpStr, 1000, "%sparallel = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sparallel = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLaunchArgsSet())
        SNPRINTF(tmpStr, 1000, "%slaunchArgsSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slaunchArgsSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slaunchArgs = \"%s\"\n", prefix, atts->GetLaunchArgs().c_str());
    str += tmpStr;
    if(atts->GetSublaunchArgsSet())
        SNPRINTF(tmpStr, 1000, "%ssublaunchArgsSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssublaunchArgsSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssublaunchArgs = \"%s\"\n", prefix, atts->GetSublaunchArgs().c_str());
    str += tmpStr;
    if(atts->GetSublaunchPreCmdSet())
        SNPRINTF(tmpStr, 1000, "%ssublaunchPreCmdSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssublaunchPreCmdSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssublaunchPreCmd = \"%s\"\n", prefix, atts->GetSublaunchPreCmd().c_str());
    str += tmpStr;
    if(atts->GetSublaunchPostCmdSet())
        SNPRINTF(tmpStr, 1000, "%ssublaunchPostCmdSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssublaunchPostCmdSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssublaunchPostCmd = \"%s\"\n", prefix, atts->GetSublaunchPostCmd().c_str());
    str += tmpStr;
    if(atts->GetMachinefileSet())
        SNPRINTF(tmpStr, 1000, "%smachinefileSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smachinefileSet = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smachinefile = \"%s\"\n", prefix, atts->GetMachinefile().c_str());
    str += tmpStr;
    if(atts->GetVisitSetsUpEnv())
        SNPRINTF(tmpStr, 1000, "%svisitSetsUpEnv = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svisitSetsUpEnv = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCanDoHWAccel())
        SNPRINTF(tmpStr, 1000, "%scanDoHWAccel = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scanDoHWAccel = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sGPUsPerNode = %d\n", prefix, atts->GetGPUsPerNode());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sXArguments = \"%s\"\n", prefix, atts->GetXArguments().c_str());
    str += tmpStr;
    if(atts->GetLaunchXServers())
        SNPRINTF(tmpStr, 1000, "%slaunchXServers = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slaunchXServers = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sXDisplay = \"%s\"\n", prefix, atts->GetXDisplay().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumThreads = %d\n", prefix, atts->GetNumThreads());
    str += tmpStr;
    if(atts->GetConstrainNodeProcs())
        SNPRINTF(tmpStr, 1000, "%sconstrainNodeProcs = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sconstrainNodeProcs = 0\n", prefix);
    str += tmpStr;
    {   const intVector &allowableNodes = atts->GetAllowableNodes();
        SNPRINTF(tmpStr, 1000, "%sallowableNodes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < allowableNodes.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", allowableNodes[i]);
            str += tmpStr;
            if(i < allowableNodes.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &allowableProcs = atts->GetAllowableProcs();
        SNPRINTF(tmpStr, 1000, "%sallowableProcs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < allowableProcs.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", allowableProcs[i]);
            str += tmpStr;
            if(i < allowableProcs.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
LaunchProfile_Notify(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_SetProfileName(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the profileName in the object.
    obj->data->SetProfileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetProfileName(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetProfileName().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetTimeout(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeout in the object.
    obj->data->SetTimeout((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetTimeout(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeout()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetNumProcessors(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numProcessors in the object.
    obj->data->SetNumProcessors((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetNumProcessors(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumProcessors()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetNumNodesSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numNodesSet in the object.
    obj->data->SetNumNodesSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetNumNodesSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNumNodesSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetNumNodes(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numNodes in the object.
    obj->data->SetNumNodes((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetNumNodes(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumNodes()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetPartitionSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the partitionSet in the object.
    obj->data->SetPartitionSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetPartitionSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPartitionSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetPartition(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the partition in the object.
    obj->data->SetPartition(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetPartition(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPartition().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetBankSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bankSet in the object.
    obj->data->SetBankSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetBankSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBankSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetBank(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the bank in the object.
    obj->data->SetBank(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetBank(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetBank().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetTimeLimitSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeLimitSet in the object.
    obj->data->SetTimeLimitSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetTimeLimitSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTimeLimitSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetTimeLimit(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the timeLimit in the object.
    obj->data->SetTimeLimit(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetTimeLimit(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTimeLimit().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetLaunchMethodSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the launchMethodSet in the object.
    obj->data->SetLaunchMethodSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetLaunchMethodSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLaunchMethodSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetLaunchMethod(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the launchMethod in the object.
    obj->data->SetLaunchMethod(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetLaunchMethod(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetLaunchMethod().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetForceStatic(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceStatic in the object.
    obj->data->SetForceStatic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetForceStatic(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceStatic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetForceDynamic(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceDynamic in the object.
    obj->data->SetForceDynamic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetForceDynamic(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceDynamic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetActive(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetActive(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetArguments(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    stringVector  &vec = obj->data->GetArguments();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the arguments in the object as modified.
    obj->data->SelectArguments();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetArguments(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    // Allocate a tuple the with enough entries to hold the arguments.
    const stringVector &arguments = obj->data->GetArguments();
    PyObject *retval = PyTuple_New(arguments.size());
    for(size_t i = 0; i < arguments.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(arguments[i].c_str()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetParallel(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallel in the object.
    obj->data->SetParallel(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetParallel(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetParallel()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetLaunchArgsSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the launchArgsSet in the object.
    obj->data->SetLaunchArgsSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetLaunchArgsSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLaunchArgsSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetLaunchArgs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the launchArgs in the object.
    obj->data->SetLaunchArgs(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetLaunchArgs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetLaunchArgs().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchArgsSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sublaunchArgsSet in the object.
    obj->data->SetSublaunchArgsSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchArgsSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSublaunchArgsSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchArgs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sublaunchArgs in the object.
    obj->data->SetSublaunchArgs(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchArgs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSublaunchArgs().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchPreCmdSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sublaunchPreCmdSet in the object.
    obj->data->SetSublaunchPreCmdSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchPreCmdSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSublaunchPreCmdSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchPreCmd(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sublaunchPreCmd in the object.
    obj->data->SetSublaunchPreCmd(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchPreCmd(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSublaunchPreCmd().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchPostCmdSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sublaunchPostCmdSet in the object.
    obj->data->SetSublaunchPostCmdSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchPostCmdSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSublaunchPostCmdSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetSublaunchPostCmd(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sublaunchPostCmd in the object.
    obj->data->SetSublaunchPostCmd(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetSublaunchPostCmd(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSublaunchPostCmd().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetMachinefileSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the machinefileSet in the object.
    obj->data->SetMachinefileSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetMachinefileSet(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMachinefileSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetMachinefile(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the machinefile in the object.
    obj->data->SetMachinefile(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetMachinefile(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMachinefile().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetVisitSetsUpEnv(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visitSetsUpEnv in the object.
    obj->data->SetVisitSetsUpEnv(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetVisitSetsUpEnv(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisitSetsUpEnv()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetCanDoHWAccel(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the canDoHWAccel in the object.
    obj->data->SetCanDoHWAccel(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetCanDoHWAccel(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCanDoHWAccel()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetGPUsPerNode(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the GPUsPerNode in the object.
    obj->data->SetGPUsPerNode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetGPUsPerNode(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGPUsPerNode()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetXArguments(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the XArguments in the object.
    obj->data->SetXArguments(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetXArguments(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXArguments().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetLaunchXServers(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the launchXServers in the object.
    obj->data->SetLaunchXServers(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetLaunchXServers(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLaunchXServers()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetXDisplay(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the XDisplay in the object.
    obj->data->SetXDisplay(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetXDisplay(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXDisplay().c_str());
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetNumThreads(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numThreads in the object.
    obj->data->SetNumThreads((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetNumThreads(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumThreads()));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetConstrainNodeProcs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the constrainNodeProcs in the object.
    obj->data->SetConstrainNodeProcs(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetConstrainNodeProcs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetConstrainNodeProcs()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetAllowableNodes(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    intVector  &vec = obj->data->GetAllowableNodes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the allowableNodes in the object as modified.
    obj->data->SelectAllowableNodes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetAllowableNodes(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    // Allocate a tuple the with enough entries to hold the allowableNodes.
    const intVector &allowableNodes = obj->data->GetAllowableNodes();
    PyObject *retval = PyTuple_New(allowableNodes.size());
    for(size_t i = 0; i < allowableNodes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(allowableNodes[i])));
    return retval;
}

/*static*/ PyObject *
LaunchProfile_SetAllowableProcs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;

    intVector  &vec = obj->data->GetAllowableProcs();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the allowableProcs in the object as modified.
    obj->data->SelectAllowableProcs();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LaunchProfile_GetAllowableProcs(PyObject *self, PyObject *args)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)self;
    // Allocate a tuple the with enough entries to hold the allowableProcs.
    const intVector &allowableProcs = obj->data->GetAllowableProcs();
    PyObject *retval = PyTuple_New(allowableProcs.size());
    for(size_t i = 0; i < allowableProcs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(allowableProcs[i])));
    return retval;
}



PyMethodDef PyLaunchProfile_methods[LAUNCHPROFILE_NMETH] = {
    {"Notify", LaunchProfile_Notify, METH_VARARGS},
    {"SetProfileName", LaunchProfile_SetProfileName, METH_VARARGS},
    {"GetProfileName", LaunchProfile_GetProfileName, METH_VARARGS},
    {"SetTimeout", LaunchProfile_SetTimeout, METH_VARARGS},
    {"GetTimeout", LaunchProfile_GetTimeout, METH_VARARGS},
    {"SetNumProcessors", LaunchProfile_SetNumProcessors, METH_VARARGS},
    {"GetNumProcessors", LaunchProfile_GetNumProcessors, METH_VARARGS},
    {"SetNumNodesSet", LaunchProfile_SetNumNodesSet, METH_VARARGS},
    {"GetNumNodesSet", LaunchProfile_GetNumNodesSet, METH_VARARGS},
    {"SetNumNodes", LaunchProfile_SetNumNodes, METH_VARARGS},
    {"GetNumNodes", LaunchProfile_GetNumNodes, METH_VARARGS},
    {"SetPartitionSet", LaunchProfile_SetPartitionSet, METH_VARARGS},
    {"GetPartitionSet", LaunchProfile_GetPartitionSet, METH_VARARGS},
    {"SetPartition", LaunchProfile_SetPartition, METH_VARARGS},
    {"GetPartition", LaunchProfile_GetPartition, METH_VARARGS},
    {"SetBankSet", LaunchProfile_SetBankSet, METH_VARARGS},
    {"GetBankSet", LaunchProfile_GetBankSet, METH_VARARGS},
    {"SetBank", LaunchProfile_SetBank, METH_VARARGS},
    {"GetBank", LaunchProfile_GetBank, METH_VARARGS},
    {"SetTimeLimitSet", LaunchProfile_SetTimeLimitSet, METH_VARARGS},
    {"GetTimeLimitSet", LaunchProfile_GetTimeLimitSet, METH_VARARGS},
    {"SetTimeLimit", LaunchProfile_SetTimeLimit, METH_VARARGS},
    {"GetTimeLimit", LaunchProfile_GetTimeLimit, METH_VARARGS},
    {"SetLaunchMethodSet", LaunchProfile_SetLaunchMethodSet, METH_VARARGS},
    {"GetLaunchMethodSet", LaunchProfile_GetLaunchMethodSet, METH_VARARGS},
    {"SetLaunchMethod", LaunchProfile_SetLaunchMethod, METH_VARARGS},
    {"GetLaunchMethod", LaunchProfile_GetLaunchMethod, METH_VARARGS},
    {"SetForceStatic", LaunchProfile_SetForceStatic, METH_VARARGS},
    {"GetForceStatic", LaunchProfile_GetForceStatic, METH_VARARGS},
    {"SetForceDynamic", LaunchProfile_SetForceDynamic, METH_VARARGS},
    {"GetForceDynamic", LaunchProfile_GetForceDynamic, METH_VARARGS},
    {"SetActive", LaunchProfile_SetActive, METH_VARARGS},
    {"GetActive", LaunchProfile_GetActive, METH_VARARGS},
    {"SetArguments", LaunchProfile_SetArguments, METH_VARARGS},
    {"GetArguments", LaunchProfile_GetArguments, METH_VARARGS},
    {"SetParallel", LaunchProfile_SetParallel, METH_VARARGS},
    {"GetParallel", LaunchProfile_GetParallel, METH_VARARGS},
    {"SetLaunchArgsSet", LaunchProfile_SetLaunchArgsSet, METH_VARARGS},
    {"GetLaunchArgsSet", LaunchProfile_GetLaunchArgsSet, METH_VARARGS},
    {"SetLaunchArgs", LaunchProfile_SetLaunchArgs, METH_VARARGS},
    {"GetLaunchArgs", LaunchProfile_GetLaunchArgs, METH_VARARGS},
    {"SetSublaunchArgsSet", LaunchProfile_SetSublaunchArgsSet, METH_VARARGS},
    {"GetSublaunchArgsSet", LaunchProfile_GetSublaunchArgsSet, METH_VARARGS},
    {"SetSublaunchArgs", LaunchProfile_SetSublaunchArgs, METH_VARARGS},
    {"GetSublaunchArgs", LaunchProfile_GetSublaunchArgs, METH_VARARGS},
    {"SetSublaunchPreCmdSet", LaunchProfile_SetSublaunchPreCmdSet, METH_VARARGS},
    {"GetSublaunchPreCmdSet", LaunchProfile_GetSublaunchPreCmdSet, METH_VARARGS},
    {"SetSublaunchPreCmd", LaunchProfile_SetSublaunchPreCmd, METH_VARARGS},
    {"GetSublaunchPreCmd", LaunchProfile_GetSublaunchPreCmd, METH_VARARGS},
    {"SetSublaunchPostCmdSet", LaunchProfile_SetSublaunchPostCmdSet, METH_VARARGS},
    {"GetSublaunchPostCmdSet", LaunchProfile_GetSublaunchPostCmdSet, METH_VARARGS},
    {"SetSublaunchPostCmd", LaunchProfile_SetSublaunchPostCmd, METH_VARARGS},
    {"GetSublaunchPostCmd", LaunchProfile_GetSublaunchPostCmd, METH_VARARGS},
    {"SetMachinefileSet", LaunchProfile_SetMachinefileSet, METH_VARARGS},
    {"GetMachinefileSet", LaunchProfile_GetMachinefileSet, METH_VARARGS},
    {"SetMachinefile", LaunchProfile_SetMachinefile, METH_VARARGS},
    {"GetMachinefile", LaunchProfile_GetMachinefile, METH_VARARGS},
    {"SetVisitSetsUpEnv", LaunchProfile_SetVisitSetsUpEnv, METH_VARARGS},
    {"GetVisitSetsUpEnv", LaunchProfile_GetVisitSetsUpEnv, METH_VARARGS},
    {"SetCanDoHWAccel", LaunchProfile_SetCanDoHWAccel, METH_VARARGS},
    {"GetCanDoHWAccel", LaunchProfile_GetCanDoHWAccel, METH_VARARGS},
    {"SetGPUsPerNode", LaunchProfile_SetGPUsPerNode, METH_VARARGS},
    {"GetGPUsPerNode", LaunchProfile_GetGPUsPerNode, METH_VARARGS},
    {"SetXArguments", LaunchProfile_SetXArguments, METH_VARARGS},
    {"GetXArguments", LaunchProfile_GetXArguments, METH_VARARGS},
    {"SetLaunchXServers", LaunchProfile_SetLaunchXServers, METH_VARARGS},
    {"GetLaunchXServers", LaunchProfile_GetLaunchXServers, METH_VARARGS},
    {"SetXDisplay", LaunchProfile_SetXDisplay, METH_VARARGS},
    {"GetXDisplay", LaunchProfile_GetXDisplay, METH_VARARGS},
    {"SetNumThreads", LaunchProfile_SetNumThreads, METH_VARARGS},
    {"GetNumThreads", LaunchProfile_GetNumThreads, METH_VARARGS},
    {"SetConstrainNodeProcs", LaunchProfile_SetConstrainNodeProcs, METH_VARARGS},
    {"GetConstrainNodeProcs", LaunchProfile_GetConstrainNodeProcs, METH_VARARGS},
    {"SetAllowableNodes", LaunchProfile_SetAllowableNodes, METH_VARARGS},
    {"GetAllowableNodes", LaunchProfile_GetAllowableNodes, METH_VARARGS},
    {"SetAllowableProcs", LaunchProfile_SetAllowableProcs, METH_VARARGS},
    {"GetAllowableProcs", LaunchProfile_GetAllowableProcs, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LaunchProfile_dealloc(PyObject *v)
{
   LaunchProfileObject *obj = (LaunchProfileObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LaunchProfile_compare(PyObject *v, PyObject *w)
{
    LaunchProfile *a = ((LaunchProfileObject *)v)->data;
    LaunchProfile *b = ((LaunchProfileObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLaunchProfile_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "profileName") == 0)
        return LaunchProfile_GetProfileName(self, NULL);
    if(strcmp(name, "timeout") == 0)
        return LaunchProfile_GetTimeout(self, NULL);
    if(strcmp(name, "numProcessors") == 0)
        return LaunchProfile_GetNumProcessors(self, NULL);
    if(strcmp(name, "numNodesSet") == 0)
        return LaunchProfile_GetNumNodesSet(self, NULL);
    if(strcmp(name, "numNodes") == 0)
        return LaunchProfile_GetNumNodes(self, NULL);
    if(strcmp(name, "partitionSet") == 0)
        return LaunchProfile_GetPartitionSet(self, NULL);
    if(strcmp(name, "partition") == 0)
        return LaunchProfile_GetPartition(self, NULL);
    if(strcmp(name, "bankSet") == 0)
        return LaunchProfile_GetBankSet(self, NULL);
    if(strcmp(name, "bank") == 0)
        return LaunchProfile_GetBank(self, NULL);
    if(strcmp(name, "timeLimitSet") == 0)
        return LaunchProfile_GetTimeLimitSet(self, NULL);
    if(strcmp(name, "timeLimit") == 0)
        return LaunchProfile_GetTimeLimit(self, NULL);
    if(strcmp(name, "launchMethodSet") == 0)
        return LaunchProfile_GetLaunchMethodSet(self, NULL);
    if(strcmp(name, "launchMethod") == 0)
        return LaunchProfile_GetLaunchMethod(self, NULL);
    if(strcmp(name, "forceStatic") == 0)
        return LaunchProfile_GetForceStatic(self, NULL);
    if(strcmp(name, "forceDynamic") == 0)
        return LaunchProfile_GetForceDynamic(self, NULL);
    if(strcmp(name, "active") == 0)
        return LaunchProfile_GetActive(self, NULL);
    if(strcmp(name, "arguments") == 0)
        return LaunchProfile_GetArguments(self, NULL);
    if(strcmp(name, "parallel") == 0)
        return LaunchProfile_GetParallel(self, NULL);
    if(strcmp(name, "launchArgsSet") == 0)
        return LaunchProfile_GetLaunchArgsSet(self, NULL);
    if(strcmp(name, "launchArgs") == 0)
        return LaunchProfile_GetLaunchArgs(self, NULL);
    if(strcmp(name, "sublaunchArgsSet") == 0)
        return LaunchProfile_GetSublaunchArgsSet(self, NULL);
    if(strcmp(name, "sublaunchArgs") == 0)
        return LaunchProfile_GetSublaunchArgs(self, NULL);
    if(strcmp(name, "sublaunchPreCmdSet") == 0)
        return LaunchProfile_GetSublaunchPreCmdSet(self, NULL);
    if(strcmp(name, "sublaunchPreCmd") == 0)
        return LaunchProfile_GetSublaunchPreCmd(self, NULL);
    if(strcmp(name, "sublaunchPostCmdSet") == 0)
        return LaunchProfile_GetSublaunchPostCmdSet(self, NULL);
    if(strcmp(name, "sublaunchPostCmd") == 0)
        return LaunchProfile_GetSublaunchPostCmd(self, NULL);
    if(strcmp(name, "machinefileSet") == 0)
        return LaunchProfile_GetMachinefileSet(self, NULL);
    if(strcmp(name, "machinefile") == 0)
        return LaunchProfile_GetMachinefile(self, NULL);
    if(strcmp(name, "visitSetsUpEnv") == 0)
        return LaunchProfile_GetVisitSetsUpEnv(self, NULL);
    if(strcmp(name, "canDoHWAccel") == 0)
        return LaunchProfile_GetCanDoHWAccel(self, NULL);
    if(strcmp(name, "GPUsPerNode") == 0)
        return LaunchProfile_GetGPUsPerNode(self, NULL);
    if(strcmp(name, "XArguments") == 0)
        return LaunchProfile_GetXArguments(self, NULL);
    if(strcmp(name, "launchXServers") == 0)
        return LaunchProfile_GetLaunchXServers(self, NULL);
    if(strcmp(name, "XDisplay") == 0)
        return LaunchProfile_GetXDisplay(self, NULL);
    if(strcmp(name, "numThreads") == 0)
        return LaunchProfile_GetNumThreads(self, NULL);
    if(strcmp(name, "constrainNodeProcs") == 0)
        return LaunchProfile_GetConstrainNodeProcs(self, NULL);
    if(strcmp(name, "allowableNodes") == 0)
        return LaunchProfile_GetAllowableNodes(self, NULL);
    if(strcmp(name, "allowableProcs") == 0)
        return LaunchProfile_GetAllowableProcs(self, NULL);

    return Py_FindMethod(PyLaunchProfile_methods, self, name);
}

int
PyLaunchProfile_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "profileName") == 0)
        obj = LaunchProfile_SetProfileName(self, tuple);
    else if(strcmp(name, "timeout") == 0)
        obj = LaunchProfile_SetTimeout(self, tuple);
    else if(strcmp(name, "numProcessors") == 0)
        obj = LaunchProfile_SetNumProcessors(self, tuple);
    else if(strcmp(name, "numNodesSet") == 0)
        obj = LaunchProfile_SetNumNodesSet(self, tuple);
    else if(strcmp(name, "numNodes") == 0)
        obj = LaunchProfile_SetNumNodes(self, tuple);
    else if(strcmp(name, "partitionSet") == 0)
        obj = LaunchProfile_SetPartitionSet(self, tuple);
    else if(strcmp(name, "partition") == 0)
        obj = LaunchProfile_SetPartition(self, tuple);
    else if(strcmp(name, "bankSet") == 0)
        obj = LaunchProfile_SetBankSet(self, tuple);
    else if(strcmp(name, "bank") == 0)
        obj = LaunchProfile_SetBank(self, tuple);
    else if(strcmp(name, "timeLimitSet") == 0)
        obj = LaunchProfile_SetTimeLimitSet(self, tuple);
    else if(strcmp(name, "timeLimit") == 0)
        obj = LaunchProfile_SetTimeLimit(self, tuple);
    else if(strcmp(name, "launchMethodSet") == 0)
        obj = LaunchProfile_SetLaunchMethodSet(self, tuple);
    else if(strcmp(name, "launchMethod") == 0)
        obj = LaunchProfile_SetLaunchMethod(self, tuple);
    else if(strcmp(name, "forceStatic") == 0)
        obj = LaunchProfile_SetForceStatic(self, tuple);
    else if(strcmp(name, "forceDynamic") == 0)
        obj = LaunchProfile_SetForceDynamic(self, tuple);
    else if(strcmp(name, "active") == 0)
        obj = LaunchProfile_SetActive(self, tuple);
    else if(strcmp(name, "arguments") == 0)
        obj = LaunchProfile_SetArguments(self, tuple);
    else if(strcmp(name, "parallel") == 0)
        obj = LaunchProfile_SetParallel(self, tuple);
    else if(strcmp(name, "launchArgsSet") == 0)
        obj = LaunchProfile_SetLaunchArgsSet(self, tuple);
    else if(strcmp(name, "launchArgs") == 0)
        obj = LaunchProfile_SetLaunchArgs(self, tuple);
    else if(strcmp(name, "sublaunchArgsSet") == 0)
        obj = LaunchProfile_SetSublaunchArgsSet(self, tuple);
    else if(strcmp(name, "sublaunchArgs") == 0)
        obj = LaunchProfile_SetSublaunchArgs(self, tuple);
    else if(strcmp(name, "sublaunchPreCmdSet") == 0)
        obj = LaunchProfile_SetSublaunchPreCmdSet(self, tuple);
    else if(strcmp(name, "sublaunchPreCmd") == 0)
        obj = LaunchProfile_SetSublaunchPreCmd(self, tuple);
    else if(strcmp(name, "sublaunchPostCmdSet") == 0)
        obj = LaunchProfile_SetSublaunchPostCmdSet(self, tuple);
    else if(strcmp(name, "sublaunchPostCmd") == 0)
        obj = LaunchProfile_SetSublaunchPostCmd(self, tuple);
    else if(strcmp(name, "machinefileSet") == 0)
        obj = LaunchProfile_SetMachinefileSet(self, tuple);
    else if(strcmp(name, "machinefile") == 0)
        obj = LaunchProfile_SetMachinefile(self, tuple);
    else if(strcmp(name, "visitSetsUpEnv") == 0)
        obj = LaunchProfile_SetVisitSetsUpEnv(self, tuple);
    else if(strcmp(name, "canDoHWAccel") == 0)
        obj = LaunchProfile_SetCanDoHWAccel(self, tuple);
    else if(strcmp(name, "GPUsPerNode") == 0)
        obj = LaunchProfile_SetGPUsPerNode(self, tuple);
    else if(strcmp(name, "XArguments") == 0)
        obj = LaunchProfile_SetXArguments(self, tuple);
    else if(strcmp(name, "launchXServers") == 0)
        obj = LaunchProfile_SetLaunchXServers(self, tuple);
    else if(strcmp(name, "XDisplay") == 0)
        obj = LaunchProfile_SetXDisplay(self, tuple);
    else if(strcmp(name, "numThreads") == 0)
        obj = LaunchProfile_SetNumThreads(self, tuple);
    else if(strcmp(name, "constrainNodeProcs") == 0)
        obj = LaunchProfile_SetConstrainNodeProcs(self, tuple);
    else if(strcmp(name, "allowableNodes") == 0)
        obj = LaunchProfile_SetAllowableNodes(self, tuple);
    else if(strcmp(name, "allowableProcs") == 0)
        obj = LaunchProfile_SetAllowableProcs(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LaunchProfile_print(PyObject *v, FILE *fp, int flags)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)v;
    fprintf(fp, "%s", PyLaunchProfile_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LaunchProfile_str(PyObject *v)
{
    LaunchProfileObject *obj = (LaunchProfileObject *)v;
    return PyString_FromString(PyLaunchProfile_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LaunchProfile_Purpose = "This class contains information needed to launch a VisIt engine.";
#else
static char *LaunchProfile_Purpose = "This class contains information needed to launch a VisIt engine.";
#endif

//
// The type description structure
//
static PyTypeObject LaunchProfileType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LaunchProfile",                    // tp_name
    sizeof(LaunchProfileObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LaunchProfile_dealloc,  // tp_dealloc
    (printfunc)LaunchProfile_print,     // tp_print
    (getattrfunc)PyLaunchProfile_getattr, // tp_getattr
    (setattrfunc)PyLaunchProfile_setattr, // tp_setattr
    (cmpfunc)LaunchProfile_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LaunchProfile_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LaunchProfile_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LaunchProfile *defaultAtts = 0;
static LaunchProfile *currentAtts = 0;

static PyObject *
NewLaunchProfile(int useCurrent)
{
    LaunchProfileObject *newObject;
    newObject = PyObject_NEW(LaunchProfileObject, &LaunchProfileType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LaunchProfile(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LaunchProfile(*defaultAtts);
    else
        newObject->data = new LaunchProfile;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLaunchProfile(const LaunchProfile *attr)
{
    LaunchProfileObject *newObject;
    newObject = PyObject_NEW(LaunchProfileObject, &LaunchProfileType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LaunchProfile *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LaunchProfile_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLaunchProfile(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LaunchProfileMethods[] = {
    {"LaunchProfile", LaunchProfile_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LaunchProfileObserver = 0;

std::string
PyLaunchProfile_GetLogString()
{
    std::string s("LaunchProfile = LaunchProfile()\n");
    if(currentAtts != 0)
        s += PyLaunchProfile_ToString(currentAtts, "LaunchProfile.");
    return s;
}

static void
PyLaunchProfile_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LaunchProfile = LaunchProfile()\n");
        s += PyLaunchProfile_ToString(currentAtts, "LaunchProfile.");
        cb(s);
    }
}

void
PyLaunchProfile_StartUp(LaunchProfile *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLaunchProfile_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LaunchProfileObserver == 0)
    {
        LaunchProfileObserver = new ObserverToCallback(subj,
            PyLaunchProfile_CallLogRoutine, (void *)data);
    }

}

void
PyLaunchProfile_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LaunchProfileObserver;
    LaunchProfileObserver = 0;
}

PyMethodDef *
PyLaunchProfile_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LaunchProfileMethods;
}

bool
PyLaunchProfile_Check(PyObject *obj)
{
    return (obj->ob_type == &LaunchProfileType);
}

LaunchProfile *
PyLaunchProfile_FromPyObject(PyObject *obj)
{
    LaunchProfileObject *obj2 = (LaunchProfileObject *)obj;
    return obj2->data;
}

PyObject *
PyLaunchProfile_New()
{
    return NewLaunchProfile(0);
}

PyObject *
PyLaunchProfile_Wrap(const LaunchProfile *attr)
{
    return WrapLaunchProfile(attr);
}

void
PyLaunchProfile_SetParent(PyObject *obj, PyObject *parent)
{
    LaunchProfileObject *obj2 = (LaunchProfileObject *)obj;
    obj2->parent = parent;
}

void
PyLaunchProfile_SetDefaults(const LaunchProfile *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LaunchProfile(*atts);
}

