/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyInteractorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyInteractorAttributes
//
// Purpose: 
//   This class contains attributes associated with the main window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a InteractorAttributes.
//
struct InteractorAttributesObject
{
    PyObject_HEAD
    InteractorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewInteractorAttributes(int);

std::string
PyInteractorAttributes_ToString(const InteractorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetShowGuidelines())
        SNPRINTF(tmpStr, 1000, "%sshowGuidelines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowGuidelines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetClampSquare())
        SNPRINTF(tmpStr, 1000, "%sclampSquare = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sclampSquare = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFillViewportOnZoom())
        SNPRINTF(tmpStr, 1000, "%sfillViewportOnZoom = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfillViewportOnZoom = 0\n", prefix);
    str += tmpStr;
    const char *navigationMode_names = "Trackball, Dolly, Flythrough";
    switch (atts->GetNavigationMode())
    {
      case InteractorAttributes::Trackball:
          SNPRINTF(tmpStr, 1000, "%snavigationMode = %sTrackball  # %s\n", prefix, prefix, navigationMode_names);
          str += tmpStr;
          break;
      case InteractorAttributes::Dolly:
          SNPRINTF(tmpStr, 1000, "%snavigationMode = %sDolly  # %s\n", prefix, prefix, navigationMode_names);
          str += tmpStr;
          break;
      case InteractorAttributes::Flythrough:
          SNPRINTF(tmpStr, 1000, "%snavigationMode = %sFlythrough  # %s\n", prefix, prefix, navigationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetAxisArraySnap())
        SNPRINTF(tmpStr, 1000, "%saxisArraySnap = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%saxisArraySnap = 0\n", prefix);
    str += tmpStr;
    const char *boundingBoxMode_names = "Always, Never, Auto";
    switch (atts->GetBoundingBoxMode())
    {
      case InteractorAttributes::Always:
          SNPRINTF(tmpStr, 1000, "%sboundingBoxMode = %sAlways  # %s\n", prefix, prefix, boundingBoxMode_names);
          str += tmpStr;
          break;
      case InteractorAttributes::Never:
          SNPRINTF(tmpStr, 1000, "%sboundingBoxMode = %sNever  # %s\n", prefix, prefix, boundingBoxMode_names);
          str += tmpStr;
          break;
      case InteractorAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%sboundingBoxMode = %sAuto  # %s\n", prefix, prefix, boundingBoxMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
InteractorAttributes_Notify(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_SetShowGuidelines(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showGuidelines in the object.
    obj->data->SetShowGuidelines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetShowGuidelines(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowGuidelines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InteractorAttributes_SetClampSquare(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clampSquare in the object.
    obj->data->SetClampSquare(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetClampSquare(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetClampSquare()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InteractorAttributes_SetFillViewportOnZoom(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fillViewportOnZoom in the object.
    obj->data->SetFillViewportOnZoom(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetFillViewportOnZoom(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFillViewportOnZoom()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InteractorAttributes_SetNavigationMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the navigationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNavigationMode(InteractorAttributes::NavigationMode(ival));
    else
    {
        fprintf(stderr, "An invalid navigationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Trackball, Dolly, Flythrough.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetNavigationMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNavigationMode()));
    return retval;
}

/*static*/ PyObject *
InteractorAttributes_SetAxisArraySnap(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axisArraySnap in the object.
    obj->data->SetAxisArraySnap(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetAxisArraySnap(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxisArraySnap()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InteractorAttributes_SetBoundingBoxMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundingBoxMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetBoundingBoxMode(InteractorAttributes::BoundingBoxMode(ival));
    else
    {
        fprintf(stderr, "An invalid boundingBoxMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Always, Never, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InteractorAttributes_GetBoundingBoxMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundingBoxMode()));
    return retval;
}



PyMethodDef PyInteractorAttributes_methods[INTERACTORATTRIBUTES_NMETH] = {
    {"Notify", InteractorAttributes_Notify, METH_VARARGS},
    {"SetShowGuidelines", InteractorAttributes_SetShowGuidelines, METH_VARARGS},
    {"GetShowGuidelines", InteractorAttributes_GetShowGuidelines, METH_VARARGS},
    {"SetClampSquare", InteractorAttributes_SetClampSquare, METH_VARARGS},
    {"GetClampSquare", InteractorAttributes_GetClampSquare, METH_VARARGS},
    {"SetFillViewportOnZoom", InteractorAttributes_SetFillViewportOnZoom, METH_VARARGS},
    {"GetFillViewportOnZoom", InteractorAttributes_GetFillViewportOnZoom, METH_VARARGS},
    {"SetNavigationMode", InteractorAttributes_SetNavigationMode, METH_VARARGS},
    {"GetNavigationMode", InteractorAttributes_GetNavigationMode, METH_VARARGS},
    {"SetAxisArraySnap", InteractorAttributes_SetAxisArraySnap, METH_VARARGS},
    {"GetAxisArraySnap", InteractorAttributes_GetAxisArraySnap, METH_VARARGS},
    {"SetBoundingBoxMode", InteractorAttributes_SetBoundingBoxMode, METH_VARARGS},
    {"GetBoundingBoxMode", InteractorAttributes_GetBoundingBoxMode, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
InteractorAttributes_dealloc(PyObject *v)
{
   InteractorAttributesObject *obj = (InteractorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
InteractorAttributes_compare(PyObject *v, PyObject *w)
{
    InteractorAttributes *a = ((InteractorAttributesObject *)v)->data;
    InteractorAttributes *b = ((InteractorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyInteractorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "showGuidelines") == 0)
        return InteractorAttributes_GetShowGuidelines(self, NULL);
    if(strcmp(name, "clampSquare") == 0)
        return InteractorAttributes_GetClampSquare(self, NULL);
    if(strcmp(name, "fillViewportOnZoom") == 0)
        return InteractorAttributes_GetFillViewportOnZoom(self, NULL);
    if(strcmp(name, "navigationMode") == 0)
        return InteractorAttributes_GetNavigationMode(self, NULL);
    if(strcmp(name, "Trackball") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Trackball));
    if(strcmp(name, "Dolly") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Dolly));
    if(strcmp(name, "Flythrough") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Flythrough));

    if(strcmp(name, "axisArraySnap") == 0)
        return InteractorAttributes_GetAxisArraySnap(self, NULL);
    if(strcmp(name, "boundingBoxMode") == 0)
        return InteractorAttributes_GetBoundingBoxMode(self, NULL);
    if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Always));
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Never));
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Auto));


    return Py_FindMethod(PyInteractorAttributes_methods, self, name);
}

int
PyInteractorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "showGuidelines") == 0)
        obj = InteractorAttributes_SetShowGuidelines(self, tuple);
    else if(strcmp(name, "clampSquare") == 0)
        obj = InteractorAttributes_SetClampSquare(self, tuple);
    else if(strcmp(name, "fillViewportOnZoom") == 0)
        obj = InteractorAttributes_SetFillViewportOnZoom(self, tuple);
    else if(strcmp(name, "navigationMode") == 0)
        obj = InteractorAttributes_SetNavigationMode(self, tuple);
    else if(strcmp(name, "axisArraySnap") == 0)
        obj = InteractorAttributes_SetAxisArraySnap(self, tuple);
    else if(strcmp(name, "boundingBoxMode") == 0)
        obj = InteractorAttributes_SetBoundingBoxMode(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
InteractorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)v;
    fprintf(fp, "%s", PyInteractorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
InteractorAttributes_str(PyObject *v)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)v;
    return PyString_FromString(PyInteractorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *InteractorAttributes_Purpose = "This class contains attributes associated with the main window.";
#else
static char *InteractorAttributes_Purpose = "This class contains attributes associated with the main window.";
#endif

//
// The type description structure
//
static PyTypeObject InteractorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "InteractorAttributes",                    // tp_name
    sizeof(InteractorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)InteractorAttributes_dealloc,  // tp_dealloc
    (printfunc)InteractorAttributes_print,     // tp_print
    (getattrfunc)PyInteractorAttributes_getattr, // tp_getattr
    (setattrfunc)PyInteractorAttributes_setattr, // tp_setattr
    (cmpfunc)InteractorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)InteractorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    InteractorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static InteractorAttributes *defaultAtts = 0;
static InteractorAttributes *currentAtts = 0;

static PyObject *
NewInteractorAttributes(int useCurrent)
{
    InteractorAttributesObject *newObject;
    newObject = PyObject_NEW(InteractorAttributesObject, &InteractorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new InteractorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new InteractorAttributes(*defaultAtts);
    else
        newObject->data = new InteractorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapInteractorAttributes(const InteractorAttributes *attr)
{
    InteractorAttributesObject *newObject;
    newObject = PyObject_NEW(InteractorAttributesObject, &InteractorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (InteractorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
InteractorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewInteractorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef InteractorAttributesMethods[] = {
    {"InteractorAttributes", InteractorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *InteractorAttributesObserver = 0;

std::string
PyInteractorAttributes_GetLogString()
{
    std::string s("InteractorAtts = InteractorAttributes()\n");
    if(currentAtts != 0)
        s += PyInteractorAttributes_ToString(currentAtts, "InteractorAtts.");
    return s;
}

static void
PyInteractorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("InteractorAtts = InteractorAttributes()\n");
        s += PyInteractorAttributes_ToString(currentAtts, "InteractorAtts.");
        cb(s);
    }
}

void
PyInteractorAttributes_StartUp(InteractorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyInteractorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(InteractorAttributesObserver == 0)
    {
        InteractorAttributesObserver = new ObserverToCallback(subj,
            PyInteractorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyInteractorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete InteractorAttributesObserver;
    InteractorAttributesObserver = 0;
}

PyMethodDef *
PyInteractorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return InteractorAttributesMethods;
}

bool
PyInteractorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &InteractorAttributesType);
}

InteractorAttributes *
PyInteractorAttributes_FromPyObject(PyObject *obj)
{
    InteractorAttributesObject *obj2 = (InteractorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyInteractorAttributes_New()
{
    return NewInteractorAttributes(0);
}

PyObject *
PyInteractorAttributes_Wrap(const InteractorAttributes *attr)
{
    return WrapInteractorAttributes(attr);
}

void
PyInteractorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    InteractorAttributesObject *obj2 = (InteractorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyInteractorAttributes_SetDefaults(const InteractorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new InteractorAttributes(*atts);
}

