/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyDatabaseCorrelation.h>
#include <ObserverToCallback.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyDatabaseCorrelation
//
// Purpose: 
//   This class encapsulates a database correlation, which is a mapping of one or more databases to a set of indices that go from 0 to N.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Mar 15 10:34:33 PDT 2007
//
// ****************************************************************************

//
// This struct contains the Python type information and a DatabaseCorrelation.
//
struct DatabaseCorrelationObject
{
    PyObject_HEAD
    DatabaseCorrelation *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDatabaseCorrelation(int);

std::string
PyDatabaseCorrelation_ToString(const DatabaseCorrelation *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    // Make a reference.
    const DatabaseCorrelation &correlation = *atts;

    SNPRINTF(tmpStr, 1000, "name = \"%s\"\n", atts->GetName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "numStates = %d\n", atts->GetNumStates());
    str += tmpStr;
    const char *method_names = "IndexForIndexCorrelation, StretchedIndexCorrelation, TimeCorrelation, CycleCorrelation, UserDefinedCorrelation";
    if(atts->GetMethod() == DatabaseCorrelation::IndexForIndexCorrelation)
        {
             SNPRINTF(tmpStr, 1000, "method = IndexForIndexCorrelation  # %s\n", method_names);
             str += tmpStr;
        }
    else if(atts->GetMethod() == DatabaseCorrelation::StretchedIndexCorrelation)
        {
             SNPRINTF(tmpStr, 1000, "method = StretchedIndexCorrelation  # %s\n", method_names);
             str += tmpStr;
        }
    else if(atts->GetMethod() == DatabaseCorrelation::TimeCorrelation)
        {
             SNPRINTF(tmpStr, 1000, "method = TimeCorrelation  # %s\n", method_names);
             str += tmpStr;
        }
    else if(atts->GetMethod() == DatabaseCorrelation::CycleCorrelation)
        {
             SNPRINTF(tmpStr, 1000, "method = CycleCorrelation  # %s\n", method_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "method = UserDefinedCorrelation  # %s\n", method_names);
             str += tmpStr;
        }

    size_t i, j, index = 0;
    const stringVector &databaseNames = correlation.GetDatabaseNames();
    for(i = 0; i < databaseNames.size(); ++i)
    {
        SNPRINTF(tmpStr, 1000, "database[%ld]=%s\n", i, databaseNames[i].c_str());
        str += tmpStr;
        SNPRINTF(tmpStr, 1000, "    numStates=%d\n", correlation.GetDatabaseNStates()[i]);
        str += tmpStr;
        str += "    times={";
        for(j = 0; j < (size_t)correlation.GetDatabaseNStates()[i]; ++j)
        {
            SNPRINTF(tmpStr, 1000, "%g, ", correlation.GetDatabaseTimes()[index+j]);
            str += tmpStr;
        }
        str += "}\n";
        str += "    cycles={";
        for(j = 0; j < (size_t)correlation.GetDatabaseNStates()[i]; ++j)
        {
            SNPRINTF(tmpStr, 1000, "%d, ", correlation.GetDatabaseCycles()[index+j]);
            str += tmpStr;
        }
        str += "}\n";

        index += correlation.GetDatabaseNStates()[i];

        str += "    indices={";
        for(j = 0; j < (size_t)correlation.GetNumStates(); ++j)
        {
            SNPRINTF(tmpStr, 1000, "%d, ", correlation.GetIndices()[i*correlation.GetNumStates() + j]);
            str += tmpStr;
        }
        str += "}\n";
    }

    {   const doubleVector &condensedTimes = atts->GetCondensedTimes();
        SNPRINTF(tmpStr, 1000, "condensedTimes = (");
        str += tmpStr;
        for(i = 0; i < condensedTimes.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", condensedTimes[i]);
            str += tmpStr;
            if(i < condensedTimes.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &condensedCycles = atts->GetCondensedCycles();
        SNPRINTF(tmpStr, 1000, "condensedCycles = (");
        str += tmpStr;
        for(i = 0; i < condensedCycles.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", condensedCycles[i]);
            str += tmpStr;
            if(i < condensedCycles.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
DatabaseCorrelation_GetName(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

static PyObject *
DatabaseCorrelation_GetNumStates(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumStates()));
    return retval;
}

static PyObject *
DatabaseCorrelation_GetMethod(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMethod()));
    return retval;
}

static PyObject *
DatabaseCorrelation_GetDatabaseNames(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    // Allocate a tuple the with enough entries to hold the databaseNames.
    const stringVector &databaseNames = obj->data->GetDatabaseNames();
    PyObject *retval = PyTuple_New(databaseNames.size());
    for(size_t i = 0; i < databaseNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(databaseNames[i].c_str()));
    return retval;
}

static PyObject *
DatabaseCorrelation_GetDatabaseNStates(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    // Allocate a tuple the with enough entries to hold the databaseNStates.
    const intVector &databaseNStates = obj->data->GetDatabaseNStates();
    PyObject *retval = PyTuple_New(databaseNStates.size());
    for(size_t i = 0; i < databaseNStates.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(databaseNStates[i])));
    return retval;
}

////////////////////////////////////////////////////////////////////////////////
/// NOTE THAT ALL SET METHODS AND MANY GET METHODS WERE REMOVED
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
/// BEGIN WRAPPED USER-DEFINED DATABASECORRELATION METHODS.
////////////////////////////////////////////////////////////////////////////////

static PyObject *
DatabaseCorrelation_GetCorrelatedTimeStates(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;

    int state = 0;
    if (!PyArg_ParseTuple(args, "i", &state))
        return NULL;

    PyObject *retval = 0;
    intVector states;
    if(obj->data->GetCorrelatedTimeStates(state, states))
    {
        // Allocate a tuple the with enough entries to hold the correlated
        // time states.
        retval = PyTuple_New(states.size());
        for(size_t i = 0; i < states.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyLong_FromLong(states[i]));
    }
    else
        retval = PyTuple_New(0);

    return retval;
}

static PyObject *
DatabaseCorrelation_UsesDatabase(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    char *name = 0;
    if (!PyArg_ParseTuple(args, "s", &name))
        return NULL;

    bool val = obj->data->UsesDatabase(name);
    return PyLong_FromLong(long(val ? 1 : 0));
}

static PyObject *
DatabaseCorrelation_GetNumDatabases(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    return PyLong_FromLong(long(obj->data->GetNumDatabases()));
}

static PyObject *
DatabaseCorrelation_GetCorrelatedTimeState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    char *db = 0;
    int state = 0;
    if (!PyArg_ParseTuple(args, "si", &db, &state))
        return NULL;

    return PyLong_FromLong(long(obj->data->GetCorrelatedTimeState(db, state)));
}

static PyObject *
DatabaseCorrelation_GetInverseCorrelatedTimeState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    char *db = 0;
    int state = 0;
    if (!PyArg_ParseTuple(args, "si", &db, &state))
        return NULL;

    return PyLong_FromLong(long(obj->data->GetInverseCorrelatedTimeState(db, state)));
}

static PyObject *
DatabaseCorrelation_GetDatabaseCycleForState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    char *db = 0;
    int state = 0;
    if (!PyArg_ParseTuple(args, "si", &db, &state))
        return NULL;

    const intVector &cycles = obj->data->GetDatabaseCycles();
    const stringVector &databaseNames = obj->data->GetDatabaseNames();
    const intVector &nStates = obj->data->GetDatabaseNStates();
    int retval = -1;
    int index = 0;
    if(state >= 0)
    {
        for(size_t i = 0; i < databaseNames.size(); ++i)
        {
            if(databaseNames[i] == db)
            {
                if(state < nStates[i])
                    retval = cycles[index + state];
                break;
            }
            index += nStates[i];
        }
    }

    return PyLong_FromLong(long(retval));
}

static PyObject *
DatabaseCorrelation_GetDatabaseTimeForState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    char *db = 0;
    int state = 0;
    if (!PyArg_ParseTuple(args, "si", &db, &state))
        return NULL;

    const doubleVector &times = obj->data->GetDatabaseTimes();
    const stringVector &databaseNames = obj->data->GetDatabaseNames();
    const intVector &nStates = obj->data->GetDatabaseNStates();
    double retval = 0.;
    int index = 0;
    if(state >= 0)
    {
        for(size_t i = 0; i < databaseNames.size(); ++i)
        {
            if(databaseNames[i] == db)
            {
                if(state < nStates[i])
                    retval = times[index + state];
                break;
            }
            index += nStates[i];
        }
    }

    return PyFloat_FromDouble(retval);
}

static PyObject *
DatabaseCorrelation_GetCondensedCycleForState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    int state = 0;
    if (!PyArg_ParseTuple(args, "i", &state))
        return NULL;

    return PyLong_FromLong(long(obj->data->GetCondensedCycleForState(state)));
}

static PyObject *
DatabaseCorrelation_GetCondensedTimeForState(PyObject *self, PyObject *args)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)self;
    int state = 0;
    if (!PyArg_ParseTuple(args, "i", &state))
        return NULL;

    return PyFloat_FromDouble(obj->data->GetCondensedTimeForState(state));
}

////////////////////////////////////////////////////////////////////////////////
/// END WRAPPED USER-DEFINED DATABASECORRELATION METHODS.
////////////////////////////////////////////////////////////////////////////////


static struct PyMethodDef DatabaseCorrelation_methods[] = {
    {"GetName", DatabaseCorrelation_GetName, METH_VARARGS},
    {"GetNumStates", DatabaseCorrelation_GetNumStates, METH_VARARGS},
    {"GetMethod", DatabaseCorrelation_GetMethod, METH_VARARGS},
    {"GetDatabaseNames", DatabaseCorrelation_GetDatabaseNames, METH_VARARGS},
    {"GetDatabaseNStates", DatabaseCorrelation_GetDatabaseNStates, METH_VARARGS},

    //
    // User-defined functions that we've wrapped.
    //
    {"GetCorrelatedTimeStates", DatabaseCorrelation_GetCorrelatedTimeStates, METH_VARARGS},
    {"UsesDatabase", DatabaseCorrelation_UsesDatabase, METH_VARARGS},
    {"GetNumDatabases", DatabaseCorrelation_GetNumDatabases, METH_VARARGS},
    {"GetCorrelatedTimeState", DatabaseCorrelation_GetCorrelatedTimeState, METH_VARARGS},
    {"GetInverseCorrelatedTimeState", DatabaseCorrelation_GetInverseCorrelatedTimeState, METH_VARARGS},
    {"GetDatabaseCycleForState", DatabaseCorrelation_GetDatabaseCycleForState, METH_VARARGS},
    {"GetDatabaseTimeForState", DatabaseCorrelation_GetDatabaseTimeForState, METH_VARARGS},
    {"GetCondensedCycleForState", DatabaseCorrelation_GetCondensedCycleForState, METH_VARARGS},
    {"GetCondensedTimeForState", DatabaseCorrelation_GetCondensedTimeForState, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DatabaseCorrelation_dealloc(PyObject *v)
{
   DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DatabaseCorrelation_compare(PyObject *v, PyObject *w)
{
    DatabaseCorrelation *a = ((DatabaseCorrelationObject *)v)->data;
    DatabaseCorrelation *b = ((DatabaseCorrelationObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
DatabaseCorrelation_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return DatabaseCorrelation_GetName(self, NULL);
    if(strcmp(name, "numStates") == 0)
        return DatabaseCorrelation_GetNumStates(self, NULL);
    if(strcmp(name, "method") == 0)
        return DatabaseCorrelation_GetMethod(self, NULL);
    if(strcmp(name, "IndexForIndexCorrelation") == 0)
        return PyInt_FromLong(long(DatabaseCorrelation::IndexForIndexCorrelation));
    else if(strcmp(name, "StretchedIndexCorrelation") == 0)
        return PyInt_FromLong(long(DatabaseCorrelation::StretchedIndexCorrelation));
    else if(strcmp(name, "TimeCorrelation") == 0)
        return PyInt_FromLong(long(DatabaseCorrelation::TimeCorrelation));
    else if(strcmp(name, "CycleCorrelation") == 0)
        return PyInt_FromLong(long(DatabaseCorrelation::CycleCorrelation));
    else if(strcmp(name, "UserDefinedCorrelation") == 0)
        return PyInt_FromLong(long(DatabaseCorrelation::UserDefinedCorrelation));

    if(strcmp(name, "databaseNames") == 0)
        return DatabaseCorrelation_GetDatabaseNames(self, NULL);
    if(strcmp(name, "databaseNStates") == 0)
        return DatabaseCorrelation_GetDatabaseNStates(self, NULL);

    return Py_FindMethod(DatabaseCorrelation_methods, self, name);
}

static int
DatabaseCorrelation_setattr(PyObject *self, char *name, PyObject *args)
{
    return -1;
}

static int
DatabaseCorrelation_print(PyObject *v, FILE *fp, int flags)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)v;
    fprintf(fp, "%s", PyDatabaseCorrelation_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DatabaseCorrelation_str(PyObject *v)
{
    DatabaseCorrelationObject *obj = (DatabaseCorrelationObject *)v;
    return PyString_FromString(PyDatabaseCorrelation_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DatabaseCorrelation_Purpose = "This class encapsulates a database correlation, which is a mapping of one or more databases to a set of indices that go from 0 to N.";
#else
static char *DatabaseCorrelation_Purpose = "This class encapsulates a database correlation, which is a mapping of one or more databases to a set of indices that go from 0 to N.";
#endif

//
// The type description structure
//
static PyTypeObject DatabaseCorrelationType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DatabaseCorrelation",                    // tp_name
    sizeof(DatabaseCorrelationObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DatabaseCorrelation_dealloc,  // tp_dealloc
    (printfunc)DatabaseCorrelation_print,     // tp_print
    (getattrfunc)DatabaseCorrelation_getattr, // tp_getattr
    (setattrfunc)DatabaseCorrelation_setattr, // tp_setattr
    (cmpfunc)DatabaseCorrelation_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DatabaseCorrelation_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DatabaseCorrelation_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DatabaseCorrelation *defaultAtts = 0;
static DatabaseCorrelation *currentAtts = 0;

static PyObject *
NewDatabaseCorrelation(int useCurrent)
{
    DatabaseCorrelationObject *newObject;
    newObject = PyObject_NEW(DatabaseCorrelationObject, &DatabaseCorrelationType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DatabaseCorrelation(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DatabaseCorrelation(*defaultAtts);
    else
        newObject->data = new DatabaseCorrelation;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDatabaseCorrelation(const DatabaseCorrelation *attr)
{
    DatabaseCorrelationObject *newObject;
    newObject = PyObject_NEW(DatabaseCorrelationObject, &DatabaseCorrelationType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DatabaseCorrelation *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DatabaseCorrelation_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDatabaseCorrelation(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DatabaseCorrelationMethods[] = {
    {"DatabaseCorrelation", DatabaseCorrelation_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DatabaseCorrelationObserver = 0;

std::string
PyDatabaseCorrelation_GetLogString()
{
    std::string s("DatabaseCorrelation = DatabaseCorrelation()\n");
    if(currentAtts != 0)
        s += PyDatabaseCorrelation_ToString(currentAtts, "DatabaseCorrelation.");
    return s;
}

static void
PyDatabaseCorrelation_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DatabaseCorrelation = DatabaseCorrelation()\n");
        s += PyDatabaseCorrelation_ToString(currentAtts, "DatabaseCorrelation.");
        cb(s);
    }
}

void
PyDatabaseCorrelation_StartUp(DatabaseCorrelation *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDatabaseCorrelation_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DatabaseCorrelationObserver == 0)
    {
        DatabaseCorrelationObserver = new ObserverToCallback(subj,
            PyDatabaseCorrelation_CallLogRoutine, (void *)data);
    }

}

void
PyDatabaseCorrelation_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DatabaseCorrelationObserver;
    DatabaseCorrelationObserver = 0;
}

PyMethodDef *
PyDatabaseCorrelation_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DatabaseCorrelationMethods;
}

bool
PyDatabaseCorrelation_Check(PyObject *obj)
{
    return (obj->ob_type == &DatabaseCorrelationType);
}

DatabaseCorrelation *
PyDatabaseCorrelation_FromPyObject(PyObject *obj)
{
    DatabaseCorrelationObject *obj2 = (DatabaseCorrelationObject *)obj;
    return obj2->data;
}

PyObject *
PyDatabaseCorrelation_New()
{
    return NewDatabaseCorrelation(0);
}

PyObject *
PyDatabaseCorrelation_Wrap(const DatabaseCorrelation *attr)
{
    return WrapDatabaseCorrelation(attr);
}

void
PyDatabaseCorrelation_SetParent(PyObject *obj, PyObject *parent)
{
    DatabaseCorrelationObject *obj2 = (DatabaseCorrelationObject *)obj;
    obj2->parent = parent;
}

void
PyDatabaseCorrelation_SetDefaults(const DatabaseCorrelation *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DatabaseCorrelation(*atts);
}

