/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAxisLabels.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyFontAttributes.h>

// ****************************************************************************
// Module: PyAxisLabels
//
// Purpose: 
//   Contains the label properties for one axis.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AxisLabels.
//
struct AxisLabelsObject
{
    PyObject_HEAD
    AxisLabels *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxisLabels(int);

std::string
PyAxisLabels_ToString(const AxisLabels *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetVisible())
        SNPRINTF(tmpStr, 1000, "%svisible = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svisible = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "font.";
        str += PyFontAttributes_ToString(&atts->GetFont(), objPrefix.c_str());
    }
    SNPRINTF(tmpStr, 1000, "%sscaling = %d\n", prefix, atts->GetScaling());
    str += tmpStr;
    return str;
}

static PyObject *
AxisLabels_Notify(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisLabels_SetVisible(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisLabels_GetVisible(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AxisLabels_SetFont(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The font field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetFont(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisLabels_GetFont(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetFont());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AxisLabels_SetScaling(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    obj->data->SetScaling((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisLabels_GetScaling(PyObject *self, PyObject *args)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}



PyMethodDef PyAxisLabels_methods[AXISLABELS_NMETH] = {
    {"Notify", AxisLabels_Notify, METH_VARARGS},
    {"SetVisible", AxisLabels_SetVisible, METH_VARARGS},
    {"GetVisible", AxisLabels_GetVisible, METH_VARARGS},
    {"SetFont", AxisLabels_SetFont, METH_VARARGS},
    {"GetFont", AxisLabels_GetFont, METH_VARARGS},
    {"SetScaling", AxisLabels_SetScaling, METH_VARARGS},
    {"GetScaling", AxisLabels_GetScaling, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AxisLabels_dealloc(PyObject *v)
{
   AxisLabelsObject *obj = (AxisLabelsObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AxisLabels_compare(PyObject *v, PyObject *w)
{
    AxisLabels *a = ((AxisLabelsObject *)v)->data;
    AxisLabels *b = ((AxisLabelsObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAxisLabels_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return AxisLabels_GetVisible(self, NULL);
    if(strcmp(name, "font") == 0)
        return AxisLabels_GetFont(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return AxisLabels_GetScaling(self, NULL);

    return Py_FindMethod(PyAxisLabels_methods, self, name);
}

int
PyAxisLabels_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "visible") == 0)
        obj = AxisLabels_SetVisible(self, tuple);
    else if(strcmp(name, "font") == 0)
        obj = AxisLabels_SetFont(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = AxisLabels_SetScaling(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AxisLabels_print(PyObject *v, FILE *fp, int flags)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)v;
    fprintf(fp, "%s", PyAxisLabels_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AxisLabels_str(PyObject *v)
{
    AxisLabelsObject *obj = (AxisLabelsObject *)v;
    return PyString_FromString(PyAxisLabels_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AxisLabels_Purpose = "Contains the label properties for one axis.";
#else
static char *AxisLabels_Purpose = "Contains the label properties for one axis.";
#endif

//
// The type description structure
//
static PyTypeObject AxisLabelsType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AxisLabels",                    // tp_name
    sizeof(AxisLabelsObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AxisLabels_dealloc,  // tp_dealloc
    (printfunc)AxisLabels_print,     // tp_print
    (getattrfunc)PyAxisLabels_getattr, // tp_getattr
    (setattrfunc)PyAxisLabels_setattr, // tp_setattr
    (cmpfunc)AxisLabels_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AxisLabels_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AxisLabels_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AxisLabels *defaultAtts = 0;
static AxisLabels *currentAtts = 0;

static PyObject *
NewAxisLabels(int useCurrent)
{
    AxisLabelsObject *newObject;
    newObject = PyObject_NEW(AxisLabelsObject, &AxisLabelsType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AxisLabels(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AxisLabels(*defaultAtts);
    else
        newObject->data = new AxisLabels;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxisLabels(const AxisLabels *attr)
{
    AxisLabelsObject *newObject;
    newObject = PyObject_NEW(AxisLabelsObject, &AxisLabelsType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AxisLabels *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AxisLabels_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxisLabels(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AxisLabelsMethods[] = {
    {"AxisLabels", AxisLabels_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AxisLabelsObserver = 0;

std::string
PyAxisLabels_GetLogString()
{
    std::string s("AxisLabels = AxisLabels()\n");
    if(currentAtts != 0)
        s += PyAxisLabels_ToString(currentAtts, "AxisLabels.");
    return s;
}

static void
PyAxisLabels_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AxisLabels = AxisLabels()\n");
        s += PyAxisLabels_ToString(currentAtts, "AxisLabels.");
        cb(s);
    }
}

void
PyAxisLabels_StartUp(AxisLabels *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxisLabels_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AxisLabelsObserver == 0)
    {
        AxisLabelsObserver = new ObserverToCallback(subj,
            PyAxisLabels_CallLogRoutine, (void *)data);
    }

}

void
PyAxisLabels_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AxisLabelsObserver;
    AxisLabelsObserver = 0;
}

PyMethodDef *
PyAxisLabels_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AxisLabelsMethods;
}

bool
PyAxisLabels_Check(PyObject *obj)
{
    return (obj->ob_type == &AxisLabelsType);
}

AxisLabels *
PyAxisLabels_FromPyObject(PyObject *obj)
{
    AxisLabelsObject *obj2 = (AxisLabelsObject *)obj;
    return obj2->data;
}

PyObject *
PyAxisLabels_New()
{
    return NewAxisLabels(0);
}

PyObject *
PyAxisLabels_Wrap(const AxisLabels *attr)
{
    return WrapAxisLabels(attr);
}

void
PyAxisLabels_SetParent(PyObject *obj, PyObject *parent)
{
    AxisLabelsObject *obj2 = (AxisLabelsObject *)obj;
    obj2->parent = parent;
}

void
PyAxisLabels_SetDefaults(const AxisLabels *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AxisLabels(*atts);
}

