/*
   For more information, please see: http://software.sci.utah.edu

   The MIT License

   Copyright (c) 2008 Scientific Computing and Imaging Institute,
   University of Utah.


   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
   THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
   DEALINGS IN THE SOFTWARE.
*/

/**
  \file    GLFrameCapture.h
  \author  Jens Krueger
           SCI Institute
           University of Utah
  \date    November 2008
*/

#pragma once

#ifndef GLFRAMECAPTURE_H
#define GLFRAMECAPTURE_H

#include "../../StdTuvokDefines.h"
#include <vector>
#include "../FrameCapture.h"

class GLFrameCapture : public FrameCapture {
  public:
    GLFrameCapture() : FrameCapture() {}
    virtual ~GLFrameCapture() {}

    virtual bool CaptureSingleFrame(const std::string& strFilename,
                                    bool bPreserveTransparency) const;
    /// Read the image into an in-memory buffer.  Image data is 32bpp RGBA.
    /// @arg image fill this buffer; existing data is overwritten.
    virtual void CaptureSingleFrame(std::vector<unsigned char>& image) const;
};

#endif // GLFRAMECAPTURE_H
