/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: WellBoreViewerEnginePluginInfo.C
// ************************************************************************* //

#include <WellBorePluginInfo.h>
#include <avtWellBorePlot.h>
#include <WellBoreAttributes.h>

//
// Storage for static data elements.
//
WellBoreAttributes *WellBoreViewerEnginePluginInfo::clientAtts = NULL;
WellBoreAttributes *WellBoreViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
// Method:  WellBoreViewerEnginePluginInfo::InitializeGlobalObjects
//
// Purpose:
//   Initialize the plot atts.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************
void
WellBoreViewerEnginePluginInfo::InitializeGlobalObjects()
{
    WellBoreViewerEnginePluginInfo::clientAtts  = new WellBoreAttributes;
    WellBoreViewerEnginePluginInfo::defaultAtts = new WellBoreAttributes;

    InitializeDefaultPalette(clientAtts);
    InitializeDefaultPalette(defaultAtts);
}


// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
WellBoreViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
WellBoreViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(WellBoreAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(WellBoreAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
WellBoreViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtWellBorePlot;
}

// ****************************************************************************
// Method: WellBoreViewerEnginePluginInfo::InitializePlotAtts
//
// Purpose:
//   Initialize the plot attributes to the default attributes.
//
// Arguments:
//   atts       The attribute subject to initialize.
//   plot       The viewer plot whose attributes are getting initialized.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    WellBoreAttributes *wellBore = (WellBoreAttributes *)atts;
    *wellBore = *defaultAtts;

    // Set the defaultPalette for the plot.
    InitializeDefaultPalette(wellBore);
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WellBoreViewerEnginePluginInfo::GetMenuName() const
{
    return "Well Bore";
}

// ****************************************************************************
// Method: WellBoreViewerEnginePluginInfo::InitializeDefaultPalette
//
// Purpose:
//   Initializes the default palette in the wellBore attributes using the
//   default discrete color table.
//
// Arguments:
//   wellBore   The WellBoreAttributes to initialize.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************
#include <avtColorTables.h>
#include <ColorTableAttributes.h>
void
WellBoreViewerEnginePluginInfo::InitializeDefaultPalette(
    WellBoreAttributes *wellBore)
{
    // Copy over the wellBore's defaultPalette with the default discrete
    // color table from avtColorTable.
    if(wellBore->GetColorType() != WellBoreAttributes::ColorByMultipleColors ||
       wellBore->GetDefaultPalette().GetNumControlPoints() < 1)
    {
        avtColorTables *ct = avtColorTables::Instance();
        ColorTableAttributes *ctAtts = ct->GetColorTables();
        int i = ctAtts->GetColorTableIndex(ct->GetDefaultDiscreteColorTable());
        if(i != -1)
        {
            wellBore->SetDefaultPalette(ctAtts->operator[](i));
        }
    }
}

