/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisMultiCurvePlotWindow.h"

#include <MultiCurveAttributes.h>
#include <ViewerProxy.h>

#include <QButtonGroup>
#include <QCheckBox>
#include <QGroupBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QRadioButton>

#include <QvisColorButton.h>
#include <QvisColorManagerWidget.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisOpacitySlider.h>


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::QvisMultiCurvePlotWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMultiCurvePlotWindow::QvisMultiCurvePlotWindow(const int type,
                         MultiCurveAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisPostableWindowObserver(subj, caption, shortName, notepad)
{
    plotType = type;
    atts = subj;
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::~QvisMultiCurvePlotWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMultiCurvePlotWindow::~QvisMultiCurvePlotWindow()
{
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Eric Brugger, Wed Jan 21 08:24:14 PST 2009
//   I added yAxisTitleFormat, useYAxisRange, and yAxisRange.  I changed
//   markerVariable from a variable button to a text field.
//   
//   Eric Brugger, Wed Feb 18 07:57:54 PST 2009
//   I added displayIds and idVariable.
//
//   Eric Brugger, Fri Feb 20 16:14:50 PST 2009
//   I added displayLegend.
//
//   Eric Brugger, Thu Mar  5 17:48:42 PST 2009
//   I replaced useYAxisRange and yAxisRange with useYAxisTickSpacing and
//   yAxisTickSpacing.
//
//   Eric Brugger, Fri Feb 15 16:36:01 PST 2013
//   I added markerScale and markerLineWidth.
//
// ****************************************************************************

void
QvisMultiCurvePlotWindow::CreateWindowContents()
{
    // Create the curve color group box.
    curveColorGroup = new QGroupBox(central);
    curveColorGroup->setTitle(tr("Curve colors"));
    topLayout->addWidget(curveColorGroup);

    // Create the mode buttons that determine if the window is in single
    // or multiple color mode.
    colorModeButtons = new QButtonGroup(0);
    connect(colorModeButtons, SIGNAL(buttonClicked(int)),
            this, SLOT(colorModeChanged(int)));
    QGridLayout *colorLayout = new QGridLayout(curveColorGroup);
    colorLayout->setSpacing(10);
    colorLayout->setColumnStretch(2, 1000);

    QRadioButton *rb = new QRadioButton(tr("Single"), curveColorGroup);
    colorModeButtons->addButton(rb, 0);
    colorLayout->addWidget(rb, 0, 0);
    rb = new QRadioButton(tr("Multiple"), curveColorGroup);
    colorModeButtons->addButton(rb, 1);
    colorLayout->addWidget(rb, 1, 0);

    // Create the single color button.
    singleColor = new QvisColorButton(curveColorGroup);
    singleColor->setButtonColor(QColor(255, 0, 0));
    connect(singleColor, SIGNAL(selectedColor(const QColor &)),
            this, SLOT(singleColorChanged(const QColor &)));
    colorLayout->addWidget(singleColor, 0, 1);
    // Create the single color opacity.
    singleColorOpacity = new QvisOpacitySlider(0,255,64,0,curveColorGroup);
    connect(singleColorOpacity, SIGNAL(valueChanged(int)),
            this, SLOT(singleColorOpacityChanged(int)));
    colorLayout->addWidget(singleColorOpacity, 0, 2);

    // Add the multiple colors widget.
    multipleColors = new QvisColorManagerWidget(curveColorGroup);
    multipleColors->setNameLabelText(tr("Curve"));
    connect(multipleColors, SIGNAL(colorChanged(const QColor &, int)),
            this, SLOT(multipleColorChanged(const QColor &, int)));
    connect(multipleColors, SIGNAL(opacityChanged(int, int)),
            this, SLOT(opacityChanged(int, int)));
    colorLayout->addWidget(multipleColors, 2, 0, 1, 3);

    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    lineStyleLabel = new QLabel(tr("Line Style"), central);
    mainLayout->addWidget(lineStyleLabel,0,0);
    lineStyle = new QvisLineStyleWidget(0, central);
    connect(lineStyle, SIGNAL(lineStyleChanged(int)),
            this, SLOT(lineStyleChanged(int)));
    mainLayout->addWidget(lineStyle, 0,1);

    lineWidthLabel = new QLabel(tr("Line Width"), central);
    mainLayout->addWidget(lineWidthLabel,1,0);
    lineWidth = new QvisLineWidthWidget(0, central);
    connect(lineWidth, SIGNAL(lineWidthChanged(int)),
            this, SLOT(lineWidthChanged(int)));
    mainLayout->addWidget(lineWidth, 1,1);

    yAxisTitleFormatLabel = new QLabel(tr("Y-Axis title format"), central);
    mainLayout->addWidget(yAxisTitleFormatLabel,2,0);
    yAxisTitleFormat = new QLineEdit(central);
    connect(yAxisTitleFormat, SIGNAL(returnPressed()),
            this, SLOT(yAxisTitleFormatProcessText()));
    mainLayout->addWidget(yAxisTitleFormat, 2,1);

    useYAxisTickSpacing = new QCheckBox(tr("Y-Axis tick spacing"), central);
    connect(useYAxisTickSpacing, SIGNAL(toggled(bool)),
            this, SLOT(useYAxisTickSpacingChanged(bool)));
    mainLayout->addWidget(useYAxisTickSpacing, 3,0);

    yAxisTickSpacing = new QLineEdit(central);
    connect(yAxisTickSpacing, SIGNAL(returnPressed()),
            this, SLOT(yAxisTickSpacingProcessText()));
    mainLayout->addWidget(yAxisTickSpacing, 3,1);

    displayMarkers = new QCheckBox(tr("Display markers"), central);
    connect(displayMarkers, SIGNAL(toggled(bool)),
            this, SLOT(displayMarkersChanged(bool)));
    mainLayout->addWidget(displayMarkers, 4,0);

    markerLineWidthLabel = new QLabel(tr("Marker line width"), central);
    mainLayout->addWidget(markerLineWidthLabel,5,0);
    markerLineWidth = new QvisLineWidthWidget(0, central);
    connect(markerLineWidth, SIGNAL(lineWidthChanged(int)),
            this, SLOT(markerLineWidthChanged(int)));
    mainLayout->addWidget(markerLineWidth, 5,1);

    markerScaleLabel = new QLabel(tr("Marker scale"), central);
    mainLayout->addWidget(markerScaleLabel,6,0);
    markerScale = new QLineEdit(central);
    connect(markerScale, SIGNAL(returnPressed()),
            this, SLOT(markerScaleProcessText()));
    mainLayout->addWidget(markerScale, 6,1);

    markerVariableLabel = new QLabel(tr("Marker variable"), central);
    mainLayout->addWidget(markerVariableLabel,7,0);
    markerVariable = new QLineEdit(central);
    connect(markerVariable, SIGNAL(returnPressed()),
            this, SLOT(markerVariableProcessText()));
    mainLayout->addWidget(markerVariable, 7,1);

    displayIds = new QCheckBox(tr("Display ids"), central);
    connect(displayIds, SIGNAL(toggled(bool)),
            this, SLOT(displayIdsChanged(bool)));
    mainLayout->addWidget(displayIds, 8,0);

    idVariableLabel = new QLabel(tr("Id variable"), central);
    mainLayout->addWidget(idVariableLabel,9,0);
    idVariable = new QLineEdit(central);
    connect(idVariable, SIGNAL(returnPressed()),
            this, SLOT(idVariableProcessText()));
    mainLayout->addWidget(idVariable, 9,1);

    displayLegend = new QCheckBox(tr("Legend"), central);
    connect(displayLegend, SIGNAL(toggled(bool)),
            this, SLOT(displayLegendChanged(bool)));
    topLayout->addWidget(displayLegend, 10,0);
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Eric Brugger, Wed Jan 21 08:24:14 PST 2009
//   I added yAxisTitleFormat, useYAxisRange, and yAxisRange.  I changed
//   markerVariable from a variable button to a text field.
//   
//   Eric Brugger, Wed Feb 18 07:57:54 PST 2009
//   I added displayIds and idVariable.
//
//   Eric Brugger, Fri Feb 20 16:14:50 PST 2009
//   I added displayLegend.
//
//   Eric Brugger, Thu Mar  5 17:48:42 PST 2009
//   I replaced useYAxisRange and yAxisRange with useYAxisTickSpacing and
//   yAxisTickSpacing.
//
//   Eric Brugger, Fri Feb 15 16:36:01 PST 2013
//   I added markerScale and markerLineWidth.
//
//   Kathleen Biagas, Thu Apr 9 07:19:54 MST 2015
//   Use helper function DoubleToQString for consistency in formatting across
//   all windows.
//
// ****************************************************************************

void
QvisMultiCurvePlotWindow::UpdateWindow(bool doAll)
{
    int    index;

    bool updateColors = false;

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        QColor tempColor;
        switch(i)
        {
          case MultiCurveAttributes::ID_colorType:
            colorModeButtons->blockSignals(true);
            if(atts->GetColorType() == MultiCurveAttributes::ColorBySingleColor)
                index = 0;
            else
                index = 1;
            colorModeButtons->button(index)->setChecked(true);
            colorModeButtons->blockSignals(false);

            singleColor->setEnabled(index == 0);
            singleColorOpacity->setEnabled(index == 0);
            break;
          case MultiCurveAttributes::ID_singleColor:
            tempColor = QColor(atts->GetSingleColor().Red(),
                               atts->GetSingleColor().Green(),
                               atts->GetSingleColor().Blue());
            singleColor->blockSignals(true);
            singleColor->setButtonColor(tempColor);
            singleColor->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_multiColor:
            updateColors = true;
            break;
          case MultiCurveAttributes::ID_lineStyle:
            lineStyle->blockSignals(true);
            lineStyle->SetLineStyle(atts->GetLineStyle());
            lineStyle->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_lineWidth:
            lineWidth->blockSignals(true);
            lineWidth->SetLineWidth(atts->GetLineWidth());
            lineWidth->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_yAxisTitleFormat:
            yAxisTitleFormat->setText(QString(atts->GetYAxisTitleFormat().c_str()));
            break;
          case MultiCurveAttributes::ID_useYAxisTickSpacing:
            if (atts->GetUseYAxisTickSpacing() == true)
            {
                yAxisTickSpacing->setEnabled(true);
            }
            else
            {
                yAxisTickSpacing->setEnabled(false);
            }
            useYAxisTickSpacing->blockSignals(true);
            useYAxisTickSpacing->setChecked(atts->GetUseYAxisTickSpacing());
            useYAxisTickSpacing->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_yAxisTickSpacing:
            yAxisTickSpacing->setText(DoubleToQString(atts->GetYAxisTickSpacing()));
            break;
          case MultiCurveAttributes::ID_displayMarkers:
            displayMarkers->blockSignals(true);
            displayMarkers->setChecked(atts->GetDisplayMarkers());
            displayMarkers->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_markerScale:
            markerScale->setText(DoubleToQString(atts->GetMarkerScale()));
            break;
          case MultiCurveAttributes::ID_markerLineWidth:
            markerLineWidth->blockSignals(true);
            markerLineWidth->SetLineWidth(atts->GetMarkerLineWidth());
            markerLineWidth->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_markerVariable:
            markerVariable->setText(QString(atts->GetMarkerVariable().c_str()));
            break;
          case MultiCurveAttributes::ID_displayIds:
            displayIds->blockSignals(true);
            displayIds->setChecked(atts->GetDisplayIds());
            displayIds->blockSignals(false);
            break;
          case MultiCurveAttributes::ID_idVariable:
            idVariable->setText(QString(atts->GetIdVariable().c_str()));
            break;
          case MultiCurveAttributes::ID_legendFlag:
            displayLegend->blockSignals(true);
            displayLegend->setChecked(atts->GetLegendFlag());
            displayLegend->blockSignals(false);
            break;
        }
    }

    //
    // If we need to update the colors, update them now. This ensures that it
    // is only done one time no matter what combination of attributes was
    // selected.
    //
    bool multiEnabled = (atts->GetColorType() ==
        MultiCurveAttributes::ColorByMultipleColors);
    if(updateColors)
        multiEnabled &= UpdateMultipleAreaColors();

    //
    // Set the enabled state for the multiple color widget.
    //
    multipleColors->setEnabled(multiEnabled);
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::UpdateMultipleAreaColors
//
// Purpose:
//   This method updates the multipleColors widget with the list of curve
//   colors.
//
// Programmer: Eric Brugger
// Creation:   December 12, 2008
//
// Modifications:
//
// ****************************************************************************

bool
QvisMultiCurvePlotWindow::UpdateMultipleAreaColors()
{
    int   nEntries = 16;
    atts->EnlargeMultiColor(nEntries);

    const ColorAttributeList &multiCurveColors = atts->GetMultiColor();

    // Block the signals from the multipleColors widget.
    multipleColors->blockSignals(true);

    if(nEntries == multipleColors->numEntries())
    {
        for(int i = 0; i < nEntries; ++i)
        {
            QColor temp(multiCurveColors[i].Red(), multiCurveColors[i].Green(),
                        multiCurveColors[i].Blue());

            multipleColors->setColor(i, temp);
            multipleColors->setOpacity(i, multiCurveColors[i].Alpha());
        }
    }
    else if(nEntries > multipleColors->numEntries())
    {
        // Set all of the existing colors.
        for(int i = 0; i < multipleColors->numEntries(); ++i)
        {
            QColor temp(multiCurveColors[i].Red(), multiCurveColors[i].Green(),
                        multiCurveColors[i].Blue());

            multipleColors->setColor(i, temp);
            multipleColors->setOpacity(i, multiCurveColors[i].Alpha());
        }

        // Add new entries
        for(int i = multipleColors->numEntries(); i < nEntries; ++i)
        {
            QColor temp(multiCurveColors[i].Red(), multiCurveColors[i].Green(),
                        multiCurveColors[i].Blue());

            multipleColors->addEntry(QString(""), temp,
                                     multiCurveColors[i].Alpha());
        }
    }
    else // nEntries < multipleColors->numEntries()
    {
        // Set all of the existing names.
        for(int i = 0; i < nEntries; ++i)
        {
            QColor temp(multiCurveColors[i].Red(), multiCurveColors[i].Green(),
                        multiCurveColors[i].Blue());

            multipleColors->setColor(i, temp);
            multipleColors->setOpacity(i, multiCurveColors[i].Alpha());
        }

        // Remove excess entries
        int numEntries = multipleColors->numEntries();
        for(int i = nEntries;
            i < numEntries; ++i)
        {
            multipleColors->removeLastEntry();
        }
    }

    // Unblock the signals from the multipleColors widget.
    multipleColors->blockSignals(false);

    return (nEntries > 0);
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Eric Brugger, Wed Jan 21 08:24:14 PST 2009
//   I added yAxisTitleFormat, useYAxisRange, and yAxisRange.  I changed
//   markerVariable from a variable button to a text field.
//   
//   Eric Brugger, Wed Feb 18 07:57:54 PST 2009
//   I added displayIds and idVariable.
//
//   Eric Brugger, Thu Mar  5 17:48:42 PST 2009
//   I replaced useYAxisRange and yAxisRange with useYAxisTickSpacing and
//   yAxisTickSpacing.
//
//   Eric Brugger, Fri Feb 15 16:36:01 PST 2013
//   I added markerScale and markerLineWidth.
//
// ****************************************************************************

void
QvisMultiCurvePlotWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do yAxisTitleFormat
    if(which_widget == MultiCurveAttributes::ID_yAxisTitleFormat || doAll)
    {
        QString temp = yAxisTitleFormat->displayText();
        if(!temp.isEmpty())
            atts->SetYAxisTitleFormat(temp.toStdString());
        else
        {
            ResettingError(tr("Y-Axis title format"),
                QString(atts->GetYAxisTitleFormat().c_str()));
            atts->SetYAxisTitleFormat(atts->GetYAxisTitleFormat());
        }
    }

    // Do yAxisTickSpacing
    if(which_widget == MultiCurveAttributes::ID_yAxisTickSpacing || doAll)
    {
        double val;
        if(LineEditGetDouble(yAxisTickSpacing, val))
            atts->SetYAxisTickSpacing(val);
        else
        {
            ResettingError(tr("Y-Axis tick spacing"),
                DoubleToQString(atts->GetYAxisTickSpacing()));
            atts->SetYAxisTickSpacing(atts->GetYAxisTickSpacing());
        }
    }

    // Do markerScale
    if(which_widget == MultiCurveAttributes::ID_markerScale || doAll)
    {
        double val;
        if(LineEditGetDouble(markerScale, val))
            atts->SetMarkerScale(val);
        else
        {
            ResettingError(tr("Marker scale"), DoubleToQString(atts->GetMarkerScale()));
            atts->SetMarkerScale(atts->GetMarkerScale());
        }
    }

    // Do markerVariable
    if(which_widget == MultiCurveAttributes::ID_markerVariable || doAll)
    {
        QString temp = markerVariable->displayText();
        if(!temp.isEmpty())
            atts->SetMarkerVariable(temp.toStdString());
        else
        {
            ResettingError(tr("Marker variable"),
                QString(atts->GetMarkerVariable().c_str()));
            atts->SetMarkerVariable(atts->GetMarkerVariable());
        }
    }

    // Do idVariable
    if(which_widget == MultiCurveAttributes::ID_idVariable || doAll)
    {
        QString temp = idVariable->displayText();
        if(!temp.isEmpty())
            atts->SetIdVariable(temp.toStdString());
        else
        {
            ResettingError(tr("Id variable"),
                QString(atts->GetIdVariable().c_str()));
            atts->SetIdVariable(atts->GetIdVariable());
        }
    }
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::Apply
//
// Purpose: 
//   Called to apply changes in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMultiCurvePlotWindow::Apply(bool ignore)
{
    if(AutoUpdate() || ignore)
    {
        GetCurrentValues(-1);
        atts->Notify();

        GetViewerMethods()->SetPlotOptions(plotType);
    }
    else
        atts->Notify();
}


//
// Qt Slot functions
//


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::apply
//
// Purpose: 
//   Qt slot function called when apply button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMultiCurvePlotWindow::apply()
{
    Apply(true);
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::makeDefault
//
// Purpose: 
//   Qt slot function called when "Make default" button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMultiCurvePlotWindow::makeDefault()
{
    GetCurrentValues(-1);
    atts->Notify();
    GetViewerMethods()->SetDefaultPlotOptions(plotType);
}


// ****************************************************************************
// Method: QvisMultiCurvePlotWindow::reset
//
// Purpose: 
//   Qt slot function called when reset button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMultiCurvePlotWindow::reset()
{
    GetViewerMethods()->ResetPlotOptions(plotType);
}


void
QvisMultiCurvePlotWindow::colorModeChanged(int index)
{
    if(index == 0)
        atts->SetColorType(MultiCurveAttributes::ColorBySingleColor);
    else
        atts->SetColorType(MultiCurveAttributes::ColorByMultipleColors);
    Apply();
}


void
QvisMultiCurvePlotWindow::singleColorChanged(const QColor &color)
{
    ColorAttribute temp(color.red(), color.green(), color.blue());
    atts->SetSingleColor(temp);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::singleColorOpacityChanged(int opacity)
{
    atts->GetSingleColor().SetAlpha(opacity);
    atts->SelectSingleColor();
    Apply();
}


void
QvisMultiCurvePlotWindow::multipleColorChanged(const QColor &color, int index)
{
    if(index >= 0 &&
       index < atts->GetMultiColor().GetNumColors())
    {
        atts->GetMultiColor()[index].SetRgb(color.red(), color.green(),
                                                   color.blue());
        atts->SelectMultiColor();
        atts->MarkColorAsChanged(index);

        Apply();
    }
}


void
QvisMultiCurvePlotWindow::opacityChanged(int opacity, int index)
{
    if(index >= 0 &&
       index < atts->GetMultiColor().GetNumColors())
    {
        atts->GetMultiColor()[index].SetAlpha(opacity);
        atts->SelectMultiColor();
        atts->MarkColorAsChanged(index);

        Apply();
    }
}


void
QvisMultiCurvePlotWindow::lineStyleChanged(int style)
{
    atts->SetLineStyle(style);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::lineWidthChanged(int style)
{
    atts->SetLineWidth(style);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::yAxisTitleFormatProcessText()
{
    GetCurrentValues(MultiCurveAttributes::ID_yAxisTitleFormat);
    Apply();
}


void
QvisMultiCurvePlotWindow::useYAxisTickSpacingChanged(bool val)
{
    atts->SetUseYAxisTickSpacing(val);
    Apply();
}


void
QvisMultiCurvePlotWindow::yAxisTickSpacingProcessText()
{
    GetCurrentValues(MultiCurveAttributes::ID_yAxisTickSpacing);
    Apply();
}


void
QvisMultiCurvePlotWindow::displayMarkersChanged(bool val)
{
    atts->SetDisplayMarkers(val);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::markerScaleProcessText()
{
    GetCurrentValues(MultiCurveAttributes::ID_markerScale);
    Apply();
}


void
QvisMultiCurvePlotWindow::markerLineWidthChanged(int style)
{
    atts->SetMarkerLineWidth(style);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::markerVariableProcessText()
{
    GetCurrentValues(MultiCurveAttributes::ID_markerVariable);
    Apply();
}


void
QvisMultiCurvePlotWindow::displayIdsChanged(bool val)
{
    atts->SetDisplayIds(val);
    SetUpdate(false);
    Apply();
}


void
QvisMultiCurvePlotWindow::idVariableProcessText()
{
    GetCurrentValues(MultiCurveAttributes::ID_idVariable);
    Apply();
}


void
QvisMultiCurvePlotWindow::displayLegendChanged(bool val)
{
    atts->SetLegendFlag(val);
    SetUpdate(false);
    Apply();
}


