/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMeshAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <GlyphTypes.h>

// ****************************************************************************
// Module: PyMeshAttributes
//
// Purpose: 
//   Attributes for the mesh plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MeshAttributes.
//
struct MeshAttributesObject
{
    PyObject_HEAD
    MeshAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMeshAttributes(int);

std::string
PyMeshAttributes_ToString(const MeshAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *meshColor = atts->GetMeshColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%smeshColor = (%d, %d, %d, %d)\n", prefix, int(meshColor[0]), int(meshColor[1]), int(meshColor[2]), int(meshColor[3]));
    str += tmpStr;
    const char *meshColorSource_names = "Foreground, MeshCustom";
    switch (atts->GetMeshColorSource())
    {
      case MeshAttributes::Foreground:
          SNPRINTF(tmpStr, 1000, "%smeshColorSource = %sForeground  # %s\n", prefix, prefix, meshColorSource_names);
          str += tmpStr;
          break;
      case MeshAttributes::MeshCustom:
          SNPRINTF(tmpStr, 1000, "%smeshColorSource = %sMeshCustom  # %s\n", prefix, prefix, meshColorSource_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *opaqueColorSource_names = "Background, OpaqueCustom";
    switch (atts->GetOpaqueColorSource())
    {
      case MeshAttributes::Background:
          SNPRINTF(tmpStr, 1000, "%sopaqueColorSource = %sBackground  # %s\n", prefix, prefix, opaqueColorSource_names);
          str += tmpStr;
          break;
      case MeshAttributes::OpaqueCustom:
          SNPRINTF(tmpStr, 1000, "%sopaqueColorSource = %sOpaqueCustom  # %s\n", prefix, prefix, opaqueColorSource_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *opaqueMode_names = "Auto, On, Off";
    switch (atts->GetOpaqueMode())
    {
      case MeshAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%sopaqueMode = %sAuto  # %s\n", prefix, prefix, opaqueMode_names);
          str += tmpStr;
          break;
      case MeshAttributes::On:
          SNPRINTF(tmpStr, 1000, "%sopaqueMode = %sOn  # %s\n", prefix, prefix, opaqueMode_names);
          str += tmpStr;
          break;
      case MeshAttributes::Off:
          SNPRINTF(tmpStr, 1000, "%sopaqueMode = %sOff  # %s\n", prefix, prefix, opaqueMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const unsigned char *opaqueColor = atts->GetOpaqueColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%sopaqueColor = (%d, %d, %d, %d)\n", prefix, int(opaqueColor[0]), int(opaqueColor[1]), int(opaqueColor[2]), int(opaqueColor[3]));
    str += tmpStr;
    const char *smoothingLevel_names = "None, Fast, High";
    switch (atts->GetSmoothingLevel())
    {
      case MeshAttributes::None:
          SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %sNone  # %s\n", prefix, prefix, smoothingLevel_names);
          str += tmpStr;
          break;
      case MeshAttributes::Fast:
          SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %sFast  # %s\n", prefix, prefix, smoothingLevel_names);
          str += tmpStr;
          break;
      case MeshAttributes::High:
          SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %sHigh  # %s\n", prefix, prefix, smoothingLevel_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizeVar = \"%s\"\n", prefix, atts->GetPointSizeVar().c_str());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
        "SphereGeometry, Point, Sphere";
    switch (atts->GetPointType())
    {
      case Box:
          SNPRINTF(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Axis:
          SNPRINTF(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Icosahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Octahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sOctahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Tetrahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sTetrahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case SphereGeometry:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphereGeometry  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Point:
          SNPRINTF(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Sphere:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetShowInternal())
        SNPRINTF(tmpStr, 1000, "%sshowInternal = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowInternal = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    return str;
}

static PyObject *
MeshAttributes_Notify(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetMeshColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the meshColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetMeshColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetMeshColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the meshColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *meshColor = obj->data->GetMeshColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(meshColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(meshColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(meshColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(meshColor[3])));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetMeshColorSource(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshColorSource in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetMeshColorSource(MeshAttributes::MeshColor(ival));
    else
    {
        fprintf(stderr, "An invalid meshColorSource value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Foreground, MeshCustom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetMeshColorSource(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshColorSource()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetOpaqueColorSource(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opaqueColorSource in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOpaqueColorSource(MeshAttributes::OpaqueColor(ival));
    else
    {
        fprintf(stderr, "An invalid opaqueColorSource value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Background, OpaqueCustom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetOpaqueColorSource(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpaqueColorSource()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetOpaqueMode(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opaqueMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOpaqueMode(MeshAttributes::OpaqueMode(ival));
    else
    {
        fprintf(stderr, "An invalid opaqueMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Auto, On, Off.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetOpaqueMode(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpaqueMode()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetOpaqueColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the opaqueColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetOpaqueColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetOpaqueColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the opaqueColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *opaqueColor = obj->data->GetOpaqueColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(opaqueColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(opaqueColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(opaqueColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(opaqueColor[3])));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSmoothingLevel(MeshAttributes::SmoothingLevel(ival));
    else
    {
        fprintf(stderr, "An invalid smoothingLevel value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Fast, High.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetPointType(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if(ival >= 0 && ival < 8)
    {
        obj->data->SetPointType(GlyphType(ival));
    }
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
                        "SphereGeometry, Point, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetPointType(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetShowInternal(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showInternal in the object.
    obj->data->SetShowInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetShowInternal(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowInternal()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}

/*static*/ PyObject *
MeshAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MeshAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}



PyMethodDef PyMeshAttributes_methods[MESHATTRIBUTES_NMETH] = {
    {"Notify", MeshAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", MeshAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", MeshAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", MeshAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", MeshAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", MeshAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", MeshAttributes_GetLineWidth, METH_VARARGS},
    {"SetMeshColor", MeshAttributes_SetMeshColor, METH_VARARGS},
    {"GetMeshColor", MeshAttributes_GetMeshColor, METH_VARARGS},
    {"SetMeshColorSource", MeshAttributes_SetMeshColorSource, METH_VARARGS},
    {"GetMeshColorSource", MeshAttributes_GetMeshColorSource, METH_VARARGS},
    {"SetOpaqueColorSource", MeshAttributes_SetOpaqueColorSource, METH_VARARGS},
    {"GetOpaqueColorSource", MeshAttributes_GetOpaqueColorSource, METH_VARARGS},
    {"SetOpaqueMode", MeshAttributes_SetOpaqueMode, METH_VARARGS},
    {"GetOpaqueMode", MeshAttributes_GetOpaqueMode, METH_VARARGS},
    {"SetPointSize", MeshAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", MeshAttributes_GetPointSize, METH_VARARGS},
    {"SetOpaqueColor", MeshAttributes_SetOpaqueColor, METH_VARARGS},
    {"GetOpaqueColor", MeshAttributes_GetOpaqueColor, METH_VARARGS},
    {"SetSmoothingLevel", MeshAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", MeshAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSizeVarEnabled", MeshAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", MeshAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", MeshAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", MeshAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointType", MeshAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", MeshAttributes_GetPointType, METH_VARARGS},
    {"SetShowInternal", MeshAttributes_SetShowInternal, METH_VARARGS},
    {"GetShowInternal", MeshAttributes_GetShowInternal, METH_VARARGS},
    {"SetPointSizePixels", MeshAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", MeshAttributes_GetPointSizePixels, METH_VARARGS},
    {"SetOpacity", MeshAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", MeshAttributes_GetOpacity, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MeshAttributes_dealloc(PyObject *v)
{
   MeshAttributesObject *obj = (MeshAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MeshAttributes_compare(PyObject *v, PyObject *w)
{
    MeshAttributes *a = ((MeshAttributesObject *)v)->data;
    MeshAttributes *b = ((MeshAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMeshAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return MeshAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return MeshAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return MeshAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "meshColor") == 0)
        return MeshAttributes_GetMeshColor(self, NULL);
    if(strcmp(name, "meshColorSource") == 0)
        return MeshAttributes_GetMeshColorSource(self, NULL);
    if(strcmp(name, "Foreground") == 0)
        return PyInt_FromLong(long(MeshAttributes::Foreground));
    if(strcmp(name, "MeshCustom") == 0)
        return PyInt_FromLong(long(MeshAttributes::MeshCustom));

    if(strcmp(name, "opaqueColorSource") == 0)
        return MeshAttributes_GetOpaqueColorSource(self, NULL);
    if(strcmp(name, "Background") == 0)
        return PyInt_FromLong(long(MeshAttributes::Background));
    if(strcmp(name, "OpaqueCustom") == 0)
        return PyInt_FromLong(long(MeshAttributes::OpaqueCustom));

    if(strcmp(name, "opaqueMode") == 0)
        return MeshAttributes_GetOpaqueMode(self, NULL);
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(MeshAttributes::Auto));
    if(strcmp(name, "On") == 0)
        return PyInt_FromLong(long(MeshAttributes::On));
    if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(MeshAttributes::Off));

    if(strcmp(name, "pointSize") == 0)
        return MeshAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "opaqueColor") == 0)
        return MeshAttributes_GetOpaqueColor(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return MeshAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(MeshAttributes::None));
    if(strcmp(name, "Fast") == 0)
        return PyInt_FromLong(long(MeshAttributes::Fast));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(MeshAttributes::High));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return MeshAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return MeshAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return MeshAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(Icosahedron));
    if(strcmp(name, "Octahedron") == 0)
        return PyInt_FromLong(long(Octahedron));
    if(strcmp(name, "Tetrahedron") == 0)
        return PyInt_FromLong(long(Tetrahedron));
    if(strcmp(name, "SphereGeometry") == 0)
        return PyInt_FromLong(long(SphereGeometry));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(Sphere));

    if(strcmp(name, "showInternal") == 0)
        return MeshAttributes_GetShowInternal(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return MeshAttributes_GetPointSizePixels(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return MeshAttributes_GetOpacity(self, NULL);

    // Try and handle legacy fields in MeshAttributes
    if(strcmp(name, "backgroundFlag") == 0)
    {
        MeshAttributesObject *meshObj = (MeshAttributesObject *)self;
        bool backgroundFlag = meshObj->data->GetOpaqueColorSource() == MeshAttributes::Background;
        return PyInt_FromLong(backgroundFlag?1L:0L);
    }
    else if(strcmp(name, "foregroundFlag") == 0)
    {
        MeshAttributesObject *meshObj = (MeshAttributesObject *)self;
        bool foregroundFlag = meshObj->data->GetMeshColorSource() == MeshAttributes::Foreground;
        return PyInt_FromLong(foregroundFlag?1L:0L);
    }
    return Py_FindMethod(PyMeshAttributes_methods, self, name);
}

int
PyMeshAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = MeshAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lineStyle") == 0)
        obj = MeshAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = MeshAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "meshColor") == 0)
        obj = MeshAttributes_SetMeshColor(self, tuple);
    else if(strcmp(name, "meshColorSource") == 0)
        obj = MeshAttributes_SetMeshColorSource(self, tuple);
    else if(strcmp(name, "opaqueColorSource") == 0)
        obj = MeshAttributes_SetOpaqueColorSource(self, tuple);
    else if(strcmp(name, "opaqueMode") == 0)
        obj = MeshAttributes_SetOpaqueMode(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = MeshAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "opaqueColor") == 0)
        obj = MeshAttributes_SetOpaqueColor(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = MeshAttributes_SetSmoothingLevel(self, tuple);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        obj = MeshAttributes_SetPointSizeVarEnabled(self, tuple);
    else if(strcmp(name, "pointSizeVar") == 0)
        obj = MeshAttributes_SetPointSizeVar(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = MeshAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "showInternal") == 0)
        obj = MeshAttributes_SetShowInternal(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = MeshAttributes_SetPointSizePixels(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = MeshAttributes_SetOpacity(self, tuple);

    // Try and handle legacy fields in MeshAttributes
    if(obj == NULL)
    {
        MeshAttributesObject *meshObj = (MeshAttributesObject *)self;
        if(strcmp(name, "backgroundFlag") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                meshObj->data->SetOpaqueColorSource(MeshAttributes::OpaqueCustom);
            else
                meshObj->data->SetOpaqueColorSource(MeshAttributes::Background);
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "foregroundFlag") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                meshObj->data->SetMeshColorSource(MeshAttributes::MeshCustom);
            else
                meshObj->data->SetMeshColorSource(MeshAttributes::Foreground);
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MeshAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)v;
    fprintf(fp, "%s", PyMeshAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MeshAttributes_str(PyObject *v)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)v;
    return PyString_FromString(PyMeshAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MeshAttributes_Purpose = "Attributes for the mesh plot";
#else
static char *MeshAttributes_Purpose = "Attributes for the mesh plot";
#endif

//
// The type description structure
//
static PyTypeObject MeshAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MeshAttributes",                    // tp_name
    sizeof(MeshAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MeshAttributes_dealloc,  // tp_dealloc
    (printfunc)MeshAttributes_print,     // tp_print
    (getattrfunc)PyMeshAttributes_getattr, // tp_getattr
    (setattrfunc)PyMeshAttributes_setattr, // tp_setattr
    (cmpfunc)MeshAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MeshAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MeshAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MeshAttributes *defaultAtts = 0;
static MeshAttributes *currentAtts = 0;

static PyObject *
NewMeshAttributes(int useCurrent)
{
    MeshAttributesObject *newObject;
    newObject = PyObject_NEW(MeshAttributesObject, &MeshAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MeshAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MeshAttributes(*defaultAtts);
    else
        newObject->data = new MeshAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMeshAttributes(const MeshAttributes *attr)
{
    MeshAttributesObject *newObject;
    newObject = PyObject_NEW(MeshAttributesObject, &MeshAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MeshAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MeshAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMeshAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MeshAttributesMethods[] = {
    {"MeshAttributes", MeshAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MeshAttributesObserver = 0;

std::string
PyMeshAttributes_GetLogString()
{
    std::string s("MeshAtts = MeshAttributes()\n");
    if(currentAtts != 0)
        s += PyMeshAttributes_ToString(currentAtts, "MeshAtts.");
    return s;
}

static void
PyMeshAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MeshAtts = MeshAttributes()\n");
        s += PyMeshAttributes_ToString(currentAtts, "MeshAtts.");
        cb(s);
    }
}

void
PyMeshAttributes_StartUp(MeshAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMeshAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MeshAttributesObserver == 0)
    {
        MeshAttributesObserver = new ObserverToCallback(subj,
            PyMeshAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMeshAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MeshAttributesObserver;
    MeshAttributesObserver = 0;
}

PyMethodDef *
PyMeshAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MeshAttributesMethods;
}

bool
PyMeshAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MeshAttributesType);
}

MeshAttributes *
PyMeshAttributes_FromPyObject(PyObject *obj)
{
    MeshAttributesObject *obj2 = (MeshAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMeshAttributes_New()
{
    return NewMeshAttributes(0);
}

PyObject *
PyMeshAttributes_Wrap(const MeshAttributes *attr)
{
    return WrapMeshAttributes(attr);
}

void
PyMeshAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MeshAttributesObject *obj2 = (MeshAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMeshAttributes_SetDefaults(const MeshAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MeshAttributes(*atts);
}

